#include "tbs.defines.h"

bool classnow()
/*
 * Is a class booked now?
 */
{
	extern long		lseek();
	extern long		time();
	extern char		*ttyname();
	extern long		timezone;
	extern struct tm	*localtime();

	struct tm		*tim;
	long			systime;
	termtype		aterm;
	int			now;

	static int		bookfd, term;
	static bool		doneinit;


	systime = time((long *)0);
	tim = localtime(systime);
	systime -= timezone;
	if(tim->tm_isdst)
		systime += 3600;		/* one hour */
	now = systime / SECSINPERIOD % NUMPERIODS;
	if(not doneinit)
	{
		char		*cp;
		terminfo	*tp;
		header		head;

		doneinit = true;
		ulimit(2, TBULIMIT);
		bookfd = open(bookingfile, READ);
		readlock(bookfd);
		lseek(bookfd, longoffset(b_header), 0);
		read(bookfd, &head, sizeof head);
		cp = ttyname(ERROROUT);
		if(strncmp(cp, "/dev/", 5) == 0)
			cp += 5;
		tp = &head.tinfo[0];
		term = 0;
		while(strncmp(cp, tp->t_name, sizeof tp->t_name) && tp < &head.tinfo[NUMTERMS])
			tp++, term++;
		if(term == NUMTERMS)
			term = 0;
	} else
		readlock(bookfd);
	lseek(bookfd, longoffset(b_period.days[tim->tm_wday].times[now].terms[term]), 0);
	read(bookfd, &aterm, sizeof aterm);
	unlock(bookfd);
	return(aterm.bits.t_booked && aterm.bits.t_class);
}
