#include <a.out.h>
#include <signal.h>

char	*tname;
char	*mktemp();
struct exec head;
int	tf;

main(argc, argv)
char *argv[];
{
	register i;

	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	tname = mktemp("/tmp/sXXXXXX");
	close(creat(tname, 0600));
	tf = open(tname, 2);
	unlink(tname);
	if (tf == -1)
	{
		perror("temp file");
		exit(2);
	}
	for (i = 1; i < argc; i++)
		strip(argv[i]);
	exit(0);
}

strip(name)
char *name;
{
	register f, i;
	long size;

	f = open(name, 0);
	if (f == -1)
	{
		perror(name);
		exit(1);
	}
	read(f, (char *)&head, sizeof(head));
	i = head.a_magic;
	if (i != A_MAGIC1 && i != A_MAGIC2 && i != A_MAGIC3)
	{
		printf("%s not in a.out format\n", name);
		exit(1);
	}
	if (head.a_syms == 0 && (head.a_flag & 1) != 0)
	{
		printf("%s already stripped\n", name);
		close(f);
		return;
	}
	size = (long)head.a_text + head.a_data;
	head.a_syms = 0;
	head.a_flag |= 1;
	lseek(tf, (long)0, 0);
	write(tf, (char *)&head, sizeof(head));
	if (copy(name, f, tf, size))
		exit(1);
	size += sizeof(head);
	close(f);
	f = creat(name, 0);	/* mode ignored as file still present */
	if (f == -1)
	{
		perror(name);
		exit(1);
	}
	lseek(tf, (long)0, 0);
	if (copy(name, tf, f, size))
		exit(2);
	close(f);
}

copy(name, fr, to, size)
char *name;
long size;
{
	register s, n;
	char buf[512];

	while (size != 0)
	{
		s = 512;
		if (size < 512)
			s = size;
		n = read(fr, buf, s);
		if (n != s)
		{
			if (n == -1)
				perror(name);
			else
				printf("%s unexpected eof\n", name);
			return(1);
		}
		n = write(to, buf, s);
		if (n != s)
		{
			if (n == -1)
				perror(name);
			else
				printf("%s unexpected write eof\n", name);
			return(1);
		}
		size -= s;
	}
	return(0);
}
