h27665
s 00001/00000/00457
d D 1.5 81/07/22 21:07:23 root 5 4
c HZ now in param.h, not local-system
e
s 00002/00002/00455
d D 1.4 81/03/12 11:50:39 root 4 3
c removed the use of _sobuf. hardly standard to assume
c that an io package has this mythical buffer lying round in it
e
s 00001/00001/00456
d D 1.3 81/03/04 14:34:45 root 3 2
c made it know about new time arg, long not &long
e
s 00002/00002/00455
d D 1.2 81/01/18 12:31:38 root 2 1
c original from elecvax 18/1/81, commented out gtotshare call until implemented
e
s 00457/00000/00000
d D 1.1 81/01/18 12:05:58 root 1 0
e
u
U
t
T
I 1
/*
**	A program to print the contents of a users password entry
**	and his limits structure if active.
*/ 

#include	<local-system>
#include	<passwd.h>
#include	<stdio.h>
I 5
#include	<param.h>
E 5

struct	pwent	pe;
char		tbuf[8];
char		*buf;
short		bufs;
short		uflag;
char		*pflag;
float		Totshare;

char		*numbers[4] =
{
	"No", "One", "Two", "Three"
};




/*
**	MAIN
*/ 

main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register char *	s;
D 2
	extern float	gtotshare();
E 2
I 2
/*	extern float	gtotshare();*/
E 2
D 4
	extern char	_sobuf[];
E 4
I 4
	char	outbuf[BUFSIZ];
E 4

D 4
	setbuf(stdout, _sobuf);
E 4
I 4
	setbuf(stdout, outbuf);
E 4
D 2
	Totshare = gtotshare();
E 2
I 2
/*	Totshare = gtotshare();*/
E 2

	while((argc >= 2) && (*argv[1] == '-'))
	{
		s = *++argv;
		argc--;
		while(*++s)
		{
			switch(*s)
			{
			case 'u':
				uflag++;
				break;
			case 'p':
				pflag = ++s;
				while(*s)
					s++;
				--s;
				pwfile(pflag);
				break;
			default:
				printf("Usage: pp [-pfile] [lnames|-u uids]\n");
				return 1;
			}
		}
	}
	if(argc > 1)
	{
		argc--;
		argv++;
		/* some specific requests */ 
		while(argc-- > 0)
		{
			printu(*argv++);
		}
	}
	else
	{
		if(getlogin(getuid()))
		{
			pe.pw_gid = getgid();
			pent();
		}
	}

	return 0;
}

/*
**	Print user details
*/ 

pent()
{
	extern long	time();
	static char	tabs[]	= "\t\t";

	printf("Login name: %16s", pe.pw_strings[LNAME]);
	printf(tabs);
	printf("Uid: %5u", pe.pw_limits.l_uid);
	printf("        Gid: %5u", pe.pw_gid);
	putchar( '\n' );
	putchar( '\n' );
	printf("Disk Limit: %16u", pe.pw_limits.l_dlimit);
	printf(tabs);
	printf("Memory Limit: %14u", pe.pw_limits.l_mlimit);
	putchar( '\n' );
	printf("Disk Overshoot: %12u", pe.pw_limits.l_doverflw);
	printf(tabs);
	printf("Memory/process: %12u", pe.pw_limits.l_mplimit);
	putchar( '\n' );
	printf("Disk Usage: %16u", pe.pw_limits.l_duse);
	printf(tabs);
	printf("Memory used: %15u", pe.pw_limits.l_muse);
	putchar( '\n' );
	if ( pe.pw_warn )
		printf("\t%s Warning%s", pe.pw_warn <= 3 ? numbers[pe.pw_warn] : "Many", pe.pw_warn == 1 ? "" : "s");
	putchar( '\n' );
	printf("Process Limit: %13u", pe.pw_limits.l_plimit);
	printf(tabs);
	printf("Processes: %17u", pe.pw_limits.l_refcount);
	putchar( '\n' );
	printf("Booking Session max: %7u", pe.pw_tblim&0377);
	printf(tabs);
	printf("Booking Period Rate: %7u", pe.pw_tbrate&0377);
	putchar( '\n' );
	printf("Printer Units Limit: %7u", pe.pw_pages);
	printf(tabs);
	printf("Printer Units used: %8u", pe.pw_pgused);
	putchar( '\n' );
	putchar( '\n' );
	printf("Shares: %20u", pe.pw_limits.l_shares);
	printf(tabs);
	if ( pe.pw_limits.l_usage == 0 || Totshare == 0 )
		printf("Share: %21.2f%%", 100.0);
	else
		printf("Share: %21.2f%%", 100. * (pe.pw_limits.l_shares/pe.pw_limits.l_usage)/Totshare);
	putchar( '\n' );
	printf("Usage: %21.0f", pe.pw_limits.l_usage);
	printf(tabs);
	printf("Nice: %22d", pe.pw_limits.l_nice);
	putchar( '\n' );
	putchar( '\n' );
	printf("Time Connected:      %s", ptime(pe.pw_contime, tbuf));
	printf(tabs);
	printf("Encrypted Password: \"%.*s\"", CRYPTLEN, pe.pw_pword);
	putchar('\n');
	printf("Total CPU Time:      %s", ptime(pe.pw_cputime/HZ, tbuf));
	printf(tabs);
	if ( pe.pw_age )
		printtime("Password changed: ", pe.pw_age);
	putchar('\n');
	if(pe.pw_extime)
		printtime("Last used: ", pe.pw_extime);
	else
		printf("Account has not been used.");
	printf(tabs);
	printtrm();
	putchar( '\n' );
	putchar( '\n' );
	if ( printclasses() | printflags() )
		putchar('\n');
	printf("Directory: %s\n", pe.pw_strings[DIRPATH]);
	if(*pe.pw_strings[SHELLPATH] != 0)
	{
		printf("Initial shell: %s\n", pe.pw_strings[SHELLPATH]);
	}
	printf("Names:\t%s %s\n", pe.pw_strings[FIRSTNAME], pe.pw_strings[LASTNAME]);
	if(*(pe.pw_strings[OTHER]))
	{
		printf("Other:");
		printother(pe.pw_strings[OTHER]);
	}

	fflush(stdout);
}

/*
**	Get the relevant entries from passwords and lnodes
*/ 

printu(p)
	register char *	p;
{
	if(uflag)
	{
		/* have asked to treat arg as uid */ 
		if(getlogin(atoi(p)))
			pent();
		if(buf != NULL)
		{
			free(buf);
			buf = NULL;
		}
	}
	else
	{
		/* have an arg to try as login name */ 
		if(getuserid(p))
			pent();
		if(buf != NULL)
		{
			free(buf);
			buf = NULL;
		}
	}
}

printtrm()
{
	register tmask_t	t = pe.pw_tmask;
	register		i;

	if ( t == 0 )
		printf("Account may not use any terminal");
	else
	if ( t == (tmask_t)(~0) )
		printf("Account may use any terminal");
	else
	{
		printf("Valid terminal groups: ");
		for(i = 0; i < ((sizeof t)*BITSINBYTE); i++)
		{
			if(t&01)
				putchar('a'+i);
			t >>= 1;
		}
	}
}


/*
**	Print user limit flags
*/

ushort	flags;
ushort	xflags;

struct
{
	ushort	pf_flag;
	char *	pf_name;
	ushort *pf_flgp;
}
	pwflags[] =
{
	 {NOLOGIN,	"NO-login",	&flags}
	,{DLIMIT,	"Disk-limit",	&flags}
	,{DAWARN,	"Warned",	&flags}
	,{ASYNCKILL,	"Async-kill",	&flags}
	,{ONCELOGIN,	"One-login",	&flags}
	,{LOGGEDIN,	"Logged-in",	&flags}
	,{CLASSACC,	"Class-a/c",	&flags}
	,{CURCLASS,	"Current-class",	&flags}
	,{NOEVICT,	"No-evict",	&flags}
	,{USELOG,	"Use-log",	&flags}
	,{TUTOR,	"Tutor",	&flags}
	,{ADMIN,	"Admin",	&flags}
	,{GROUPACC,	"Group-a/c",	&flags}
	,{NEWPASSWD,	"New-password",	&flags}
	,{CONNECTLIM,	"Connect-limit",	&flags}
	,{TTYOPTS,	"Tty-options",	&flags}
	,{NONEWGRP,	"No-newgrp",	&xflags}
	,{NOPASSWD,	"No-password",	&xflags}
	,{USENET,	"Use-net",	&xflags}
};
#define	NFLAGS	((sizeof pwflags)/(sizeof pwflags[0]))
#define	NOLOGN	0	/* index for NOLOGIN flag */

int
printflags()
{
	register	i, j;

	if ( (flags = pe.pw_limits.l_flags) | (xflags = pe.pw_xflags) )
	{
		printf("Flags:\t");

		for ( i = 0, j = 0 ; i < NFLAGS ; i++ )
			if ( *pwflags[i].pf_flgp & pwflags[i].pf_flag )
			{
				if ( j )
				{
					if ( (j%7) == 0 )
						putchar('\t');
					else
						putchar(',');
				}

				printf("%s", pwflags[i].pf_name);

				if ( ((++j)%7) == 0 )
					putchar('\n');
			}

		if ( j%7 )
			putchar('\n');

		return 1;
	}
	else
		return 0;
}

/*
**	Get login name
*/ 

getlogin(uid)
	register 	uid;
{
	pe.pw_limits.l_uid = uid;
	if(getpwlog(&pe, (char *)0, 0) == 0)
	{
		put();
		return(1);
	}
	else
	{
		printf("Uid does not exist !?!\n");
		return(0);
	}
}

/*
**	Set up user limits and strings
*/ 

put()
{
	extern char *	malloc();

	if ( (buf = malloc(bufs = sum())) != NULL )
	{
		getpwlog(&pe, buf, bufs);
		limits(&pe.pw_limits, L_OTHLIM);
	}
	else
	{
		printf("No memory!\n");
		exit(1);
	}
}

/*
**	Get user user-id
*/ 

getuserid(s)
	register char *s;
{
	pe.pw_strings[LNAME] = s;
	if(getpwuid(&pe, (char *)0, 0) == 0)
	{
		put();
		return(1);
	}
	else
	{
		printf("Login name does not exist !?!\n");
		return(0);
	}
}

/*
**	Add up string lengths for password entry
*/ 

sum()
{
	register int i;
	register int s;

	s = 0;
	for(i = 0; i < PWSLENCNT; i++)
	{
		s += (int)pe.pw_strings[i];
	}
	return(s);
}



#include	<class.h>


int
printclasses()
{
	register struct centry	*p;
	register		j, k;

	for ( j = k = 0, p = classes ; p < &classes[NCLASS] && p->c_name != NULL ; p++ )
	{
		if ( pe.pw_limits.l_cmask[p->c_index] & p->c_mask )
		{
			if ( j == 0 && k != 0 )
				putchar('\t');
			else
			if ( k++ == 0 )
				printf( "Classes: " );
			else
				putchar(',');
			printf("%s", p->c_name);
			if ( ++j == 7 )
			{
				j = 0;
				putchar('\n');
			}
		}
	}

	if ( j != 0 )
	{
		putchar('\n');
		return 1;
	}
	else
		return 0;
}



printother(s)
	register char *s;
{
	register char *r;

	do
	{
		r = s;
		while(*s && *s != '\n')
			s++;
		if(*s != 0)
			*s++ = 0;
		printf("\t%s\n", r);
	}
	while(*s);
}


/*
**	Print a time
*/

printtime(s, t)
	char *		s;
	long		t;
{
	register char *	p;
	extern char *	ctime();

	printf(s);
D 3
	p = ctime(&t);
E 3
I 3
	p = ctime(t);
E 3
	if(t < time((long *)0) - 1555200l)
		printf("%12.12s %4.4s", p+4, p+20);
	else
		printf("%16.16s", p);
}
E 1
