/*
 *	ppi -- prints out just a little bit more than ps
 *		for given processes
 */

#include	<local-system>
#include	<param.h>
#include	<proc.h>
#include	<inode.h>
#include	<text.h>
#include	<file.h>
#include	<fcntl.h>
#include	<stat.h>
#include	<dir.h>
#include	<signal.h>
#include	<user.h>
#include	<table.h>
#include	<stdio.h>
#include	<setjmp.h>
#include	<passwd.h>

char devdir[] = "/dev";
char kmem[] = "kmem";
int kmemfd;
char mem[] = "mem";
int memfd;
char swap[] = "swap";
int swapfd;

struct user u;
struct proc proc[NPROC];
jmp_buf env;
struct pwent pe;
char pwbuf[SSIZ];
struct table table[3];
#define	TPROC	0
#define	TINODE	1
#define	TFILE	2

char chk[] = "/bin/ncheck";
#define	ARGS	88	/* max. nr args to chk */
char argb[512];		/* args to chk */

char recompile[] "\007Warning: recompile\n";
char inconsistent[] "Inconsistent %s: retrying...\n";

/*
 * o_flag and o_ip in the next structure must have similar
 * positions to those in a file structure
 */
struct ofile
{
	char o_flag;		/* R, W etc. */
	char o_lockf;		/* lock info */
	unsigned o_ip;		/* inode pointer */
	unsigned o_dev;		/* dev, inum & mode contiguous as per inode.h */
	unsigned o_inum;
	unsigned o_mode;
	unsigned o_uid;
}
	ofile[NOFILE];

struct
{
	unsigned ox_ip;		/* inode pointer */
	unsigned ox_dev;	/* dev & inum contiguous as per inode.h */
	unsigned ox_inum;
	unsigned ox_uid;
}
	otext, ocdir;

struct chk
{
	unsigned c_dev;
	unsigned c_inum;
}
	*chkhd, *chklst, *chktail;

#define	CHKINCR	128	/* this many more per mouthful */

char *devs[]		/* assume skip first char to get block dev name */
{
	"rhp03",
	"rhp01",
	"rhp11",
	"rhp00",
	"rhp04",
	"rhp10",
	0
};

unsigned inodeuplim, fileuplim;

main(c, v)
char **v;
{
	register n;
	register struct proc *p;
	char *cp;
	char outbuf[BUFSIZ];

	if (c < 2)
	{
		printf("Usage: ppi pid ...\n");
		exit(1);
	}
	if (chdir(cp = devdir) == -1 ||
		((memfd = open(cp = mem, 0)) == -1) ||
		((kmemfd = open(cp = kmem, 0)) == -1) ||
		((swapfd = open(cp = swap, 0)) == -1))
	{
		printf("Can't find %s\n", cp);
		exit(1);
	}
	if (getaddr(G_PROC, &table[TPROC]) == -1 ||
	    getaddr(G_INODE, &table[TINODE]) == -1 ||
	    getaddr(G_FILE, &table[TFILE]) == -1)
	{
		printf("Getaddr failed\n");
		exit(1);
	}
	if (table[TPROC].tb_num != NPROC ||
	    table[TPROC].tb_size != sizeof(struct proc) ||
	    table[TINODE].tb_num != NINODE ||
	    table[TINODE].tb_size != sizeof(struct inode) ||
	    table[TFILE].tb_num != NFILE ||
	    table[TFILE].tb_size != sizeof(struct file))
	{
		printf(recompile);
		exit(1);
	}
	inodeuplim = table[TINODE].tb_addr + NINODE * sizeof(struct inode);
	fileuplim = table[TFILE].tb_addr + NFILE * sizeof(struct file);
	chkhd = chklst = chktail = sbrk(0);
	pe.pw_uid = -1;
	setbuf(stdout, outbuf);

	nice(-20);	/* get some service */

	while (--c)
	{
		v++;
		cp = *v;
		n = 0;
		while (*cp >= '0' && *cp <= '9')
			n = n * 10 + *cp++ - '0';
		if (*cp)
		{
			printf("invalid process id %s\n", *v);
			continue;
		}
		setjmp(env);	/* if inconsistency detected */
		lseek(kmemfd, (long)table[TPROC].tb_addr, 0);
		if (read(kmemfd, proc, sizeof proc) != sizeof proc)
		{
			printf("Can't read proc\n");
			exit(1);
		}
		for (p = proc; p < &proc[NPROC]; p++)
			if (p->p_stat != NULL && p->p_pid == n)
			{
				examine(p);
				break;
			}
		if (p == &proc[NPROC])
			printf("proc %u not found\n", n);
	}
	nice(10);	/* come back to earth */
	close(memfd);
	close(kmemfd);
	close(swapfd);
	pwclose();
	fflush(stdout);
	callchk();
	exit(0);
}

examine(p)
register struct proc *p;
{
	register struct ofile *op;
	register unsigned offset;

	if (p->p_stat == SZOMB)
	{
		printf("process %u is dead\n", p->p_pid);
		return;
	}
	readuser(p);

	/*
	 *	at this point, have valid inode pointers as follows:
	 *
	 *	text segment (if any) in otext structure;
	 *	cdir in ocdir structure;
	 *	files in ofile[0 to NOFILE]
	 */

	offset = (unsigned)ocdir.ox_ip;
	offset += (unsigned)&(0->i_dev);
	lseek(kmemfd, (long)offset, 0);
	read(kmemfd, &ocdir.ox_dev, 4);		/* get dev and inumber */
	addlist(ocdir.ox_dev, ocdir.ox_inum);
	offset = (unsigned)ocdir.ox_ip;
	offset += (unsigned)&(0->i_uid);
	lseek(kmemfd, (long)offset, 0);
	read(kmemfd, &ocdir.ox_uid, sizeof ocdir.ox_uid);

	if (otext.ox_ip)
	{
		offset = (unsigned)otext.ox_ip;
		offset += (unsigned)&(0->i_dev);
		lseek(kmemfd, (long)offset, 0);
		read(kmemfd, &otext.ox_dev, 4);	/* get dev and inumber */
		addlist(otext.ox_dev, otext.ox_inum);
		offset = (unsigned)otext.ox_ip;
		offset += (unsigned)&(0->i_uid);
		lseek(kmemfd, (long)offset, 0);
		read(kmemfd, &otext.ox_uid, sizeof otext.ox_uid);
	}

	for (op = ofile; op < &ofile[NOFILE]; op++)
	{
		if (op->o_ip == NULL)
			continue;
		offset = (unsigned)op->o_ip;
		offset += (unsigned)&(0->i_dev);
		lseek(kmemfd, (long)offset, 0);
		read(kmemfd, &op->o_dev, 6);	/* get dev, inumber and mode */
		if ((op->o_mode & IFMT) != IFIFO)
			addlist(op->o_dev, op->o_inum);
		offset = (unsigned)op->o_ip;
		offset += (unsigned)&(0->i_uid);
		lseek(kmemfd, (long)offset, 0);
		read(kmemfd, &op->o_uid, sizeof op->o_uid);
		offset = (unsigned)op->o_ip;
		offset += (unsigned)&(0->i_lockf);
		lseek(kmemfd, (long)offset, 0);
		read(kmemfd, &op->o_lockf, sizeof op->o_lockf);
	}

	printout(p);
}

readuser(p)
register struct proc *p;
{
	register struct ofile *op;
	register unsigned *up;
	long offset;

	if (p->p_flag & SLOAD)
	{
		long paddr;

		paddr = (long)p->p_addr;
		paddr = paddr << 6;
		offset = paddr + (long)&(0->u_cdir);
		lseek(memfd, offset, 0);
		read(memfd, &u.u_cdir, sizeof u.u_cdir);
		offset = paddr + (long)&(0->u_ofile[0]);
		lseek(memfd, offset, 0);
		read(memfd, &u.u_ofile[0], sizeof u.u_ofile);
		offset = paddr + (long)&(0->u_signal[0]);
		lseek(memfd, offset, 0);
		read(memfd, &u.u_signal[0], sizeof u.u_signal);
		offset = paddr + (long)&(0->u_comm[0]);
		lseek(memfd, offset, 0);
		read(memfd, &u.u_comm[0], sizeof u.u_comm);
	}
	else
	{
		offset = p->p_addr;
		offset--;		/* really + swplo */
		offset = offset << 9;
		lseek(swapfd, offset, 0);
		read(swapfd, &u, sizeof u);
	}

	/*
	 * now know cdir (-> inode),
	 * files (-> file structure -> inode),
	 * and text (if any) (-> text structure -> inode)
	 */

	ocdir.ox_ip = u.u_cdir;
	if ((unsigned)ocdir.ox_ip < table[TINODE].tb_addr ||
	    (unsigned)ocdir.ox_ip >= inodeuplim)
	{
		printf(inconsistent, "cdir");
		longjmp(env, 1);
	}

	for (up = &u.u_ofile[0], op = &ofile[0]; op < &ofile[NOFILE]; up++, op++)
	{
		if ((op->o_ip = (*up & ~01)) == NULL)
			continue;
		if ((unsigned)op->o_ip < table[TFILE].tb_addr ||
		    (unsigned)op->o_ip >= fileuplim)
		{
			printf(inconsistent, "file");
			longjmp(env, 1);
		}
		lseek(kmemfd, (long)op->o_ip, 0);
		read(kmemfd, op, 4);	/* read file structure */
	}

	if ((otext.ox_ip = p->p_textp) == NULL)
		return;
	offset = (long)p->p_textp;
	offset += (long)&(0->x_iptr);
	lseek(kmemfd, offset, 0);
	read(kmemfd, &(otext.ox_ip), sizeof otext.ox_ip);
	if ((unsigned)otext.ox_ip < table[TINODE].tb_addr ||
	    (unsigned)otext.ox_ip >= inodeuplim)
	{
		printf(inconsistent, "text");
		longjmp(env, 1);
	}
}

printout(p)
struct proc *p;
{
	register i, j;
	register struct ofile *op;

	printf("Process %u Name %-8.8s uid %u ", p->p_pid, u.u_comm, p->p_uid);
	printname(p->p_uid);
	printf("Signals: catch:");
	for (i = 0; i < NSIG; i++)
		if ((j = u.u_signal[i]) != 0 && (j & 01) == 0)
			printf(" %d", i);
	printf("\n\tignore:");
	for (i = 0; i < NSIG; i++)
		if ((u.u_signal[i] & 01) != 0)
			printf(" %d", i);
	printf("\nInodes:   dev   inum mode  type lock uid [name]\n");
	printf(" cdir  : %2u/%2u %5u\t\t    %4u ",
		major(ocdir.ox_dev), minor(ocdir.ox_dev),
		ocdir.ox_inum, ocdir.ox_uid);
	printname(ocdir.ox_uid);
	if (otext.ox_ip)
	{
		printf(" text  : %2u/%2u %5u\t\t    %4u ",
			major(otext.ox_dev), minor(otext.ox_dev),
			otext.ox_inum, otext.ox_uid);
		printname(otext.ox_uid);
	}
	for (i = 0, op = ofile; i < NOFILE; op++, i++)
	{
		if (op->o_ip == NULL)
			continue;
		printf(" file%2u: %2u/%2u %5u ",
			i, major(op->o_dev), minor(op->o_dev), op->o_inum);
		prmode(op->o_flag, (unsigned)u.u_ofile[i] & 01);
		printf(" %c    %c ", type(op->o_mode), prlock(op->o_lockf));
		printf("%4u ", op->o_uid);
		printname(op->o_uid);
	}
}

printname(uid)
{
	register i;

	if (uid != pe.pw_uid)
	{
		pe.pw_uid = uid;
		i = getpwlog(&pe, pwbuf, sizeof pwbuf);
		if (i < 0 || i == sizeof pwbuf)
		{
			if (i == sizeof pwbuf)
				printf("pwbuf too small");
			printf("<phantom>\n");
			return;
		}
	}
	printf("(%s)\n", pe.pw_strings[LNAME]);
}

prmode(flag, exclos)
register flag;
{
	register char *cp;

	cp = argb;
	if (exclos)			/* close on exec */
		*cp++ = 'C';
	if (flag & O_NDELAY)		/* no delay */
		*cp++ = 'N';
	if (flag & O_APPEND)		/* append */
		*cp++ = 'A';
	if (flag & O_FREE)		/* free */
		*cp++ = 'F';
	if (flag & O_EXCL)		/* exclusive use */
		*cp++ = 'E';
	if (flag & FREAD)		/* read */
		*cp++ = 'R';
	if (flag & FWRITE)		/* write */
		*cp++ = 'W';
	while (cp < &argb[7])
		*cp++ = ' ';
	*cp = 0;
	printf(argb);
}

type(mode)
{
	switch(mode & IFMT)
	{
    case IFBLK:	return('b');
    case IFCHR:	return('c');
    case IFDIR:	return('d');
    case IFIFO:	return('p');
    case IFLOK:	return('l');
    case IFALK:	return('a');
    case IFREG:	return('-');
    default:	return('?');
	}
}

prlock(lockf)
{
	switch(lockf)
	{
    case L_PHLOK:	return('P');
    case L_RLOCK:	return('R');
    case L_WLOCK:	return('W');
    default:		return(' ');
	}
}

addlist(dev, inum)
{
	register struct chk *cp;
	static nomore = 0;

	if (nomore)
		return;
	for (cp = chkhd; cp != chklst; cp++)
		if (cp->c_dev == dev && cp->c_inum == inum)
			return;
	if (chklst == chktail)
	{
		if (sbrk(CHKINCR * sizeof *chklst) == -1)
		{
			printf("Out of core\n");
			nomore++;
		}
		chktail =+ CHKINCR;
	}
	chklst->c_dev = dev;
	chklst->c_inum = inum;
	chklst++;
}

callchk()
{
	register char *cp;
	register char **dp;
	register dev;
	int n;
	char *arglist[ARGS + 4];

	arglist[0] = "ncheck";
	arglist[1] = "-i";
	for (dp = devs; *dp; dp++)
	{
		if (stat(&dp[0][1], argb) == -1)	/* block dev */
			continue;
		dev = ((struct stat *)argb)->st_rdev;
		n = 2;
		cp = argb;
		for (chktail = chkhd; chktail != chklst && n < ARGS; chktail++)
			if (chktail->c_dev == dev)
			{
				arglist[n++] = cp;
				cp = itoa(cp, chktail->c_inum);
			}
		if (n == 2)
			continue;
		arglist[n++] = *dp;
		arglist[n++] = 0;
		n--;
		for (dev = 0; dev < n; dev++)
			printf(" %s", arglist[dev]);
		putchar('\n');
		fflush(stdout);
		if ((dev = fork()) == -1)
		{
			printf("Can't fork\n");
			fflush(stdout);
		}
		if (dev == 0)
		{
			execv(chk, arglist);
			printf("Can't exec\n");
			exit(1);
		}
		wait(0);
	}
}

itoa(p, n)
char *p;
register unsigned n;
{
	register char *sp, *rp;
	char stack[6];

	rp = p;
	sp = stack;
	*sp++ = 0;
	while (n)
	{
		*sp++ = n % 10 + '0';
		n /= 10;
	}
	while (*rp++ = *--sp)
		if (rp >= &argb[sizeof argb])
			return(p);
	return(rp);
}
