/*
** newgrp [group]
**
** rules
**	if no arg, group id in password file is used
**	else if group id == id in password file
**	else if login name is in member list
**	else if ".group" file exists in home directory of group and
**		login name is in member list
**	else if password is present and user knows it
**	else too bad
*/

#include	<local-system>
#include	<sys/types.h>
#include	<sys/dir.h>
#include	<passwd.h>
#include	<sgtty.h>
#include	<stdio.h>

#define		SHELL		"/bin/sh"
#define		GROUPMASK	0007
#define		GROUPFN		".group"

char		NG[] 		= "Sorry";
char		PD[] 		= "Permission denied";
char		UG[] 		= "Unknown group";
char		NS[] 		= "You have no shell";

extern char *	crypt();
extern char *	strrchr();
extern char *	strcat();
extern char *	strncpy();
extern char *	malloc();


main(argc,argv)
	char *		argv[];
{
	char		buf[SSIZ];
	struct pwent	pe;
	extern uid_t	chkgrp();

#ifdef	DEBUG
	chroot(".");
#endif
	pe.pw_limits.l_uid = getuid();
	if ( getpwlog(&pe, buf, sizeof buf) == PWERROR )
		error(NG);
	if ( pe.pw_xflags & NONEWGRP )
		error(PD);
	if (argc > 1)
		pe.pw_gid = chkgrp(argv[1], &pe);
	if (setgid(pe.pw_gid) == SYSERROR || setuid(getuid()) == SYSERROR)
		error(NG);
	if (!*pe.pw_strings[SHELLPATH])
		pe.pw_strings[SHELLPATH] = SHELL;

	pwclose();
	umask(GROUPMASK);

	execl(pe.pw_strings[SHELLPATH], strrchr(pe.pw_strings[SHELLPATH], '/')+1, NULL);
	error(NS);
}

warn(s)
char *s;
{
	fprintf(stderr, "%s\n", s);
}

error(s)
char *s;
{
	warn(s);
	exit(1);
}

uid_t
chkgrp(gname, p)
	char *		gname;
	struct pwent *	p;
{
	struct pwent	pe;
	register int	size;
	register int	i;
	char *		pesbuf;

	pe.pw_strings[LNAME] = gname;
	if ( getpwuid(&pe, (char *)0, 0) == PWERROR )
	{
		warn(UG);
		return getgid();
	}

	/*
	**	Own group?
	*/
	if (p->pw_gid == pe.pw_gid || getuid() == 0)
		return pe.pw_gid;

	for ( i = 0, size = 0 ; i < PWSLENCNT ; i++ )
		size += (int)pe.pw_strings[i];

	if ( (pesbuf = malloc(size)) != (char *)0 )
	{
		getpwlog(&pe, pesbuf, size);

		/*
		**	Group account member?
		*/
		if ( pe.pw_limits.l_flags & GROUPACC )
		{
			register char *	cp1;
			register char *	cp2;
			register	finished;

			for ( cp1 = cp2 = pe.pw_strings[OTHER], finished = 0 ; ; cp1++ )
				if ( *cp1 == ':' || (*cp1 == '\0' && ++finished) )
				{
					*cp1 = '\0';
					if ( strcmp(p->pw_strings[LNAME], cp2) == 0 )
						return pe.pw_gid;
					if ( finished )
						break;
					cp2 = cp1+1;
				}
		}

		/*
		**	HOME/GROUPFN member?
		*/
		{
			register FILE *	fd;
			char		groupfn[128];

			strcat(strcat(strncpy(groupfn, pe.pw_strings[DIRPATH], sizeof groupfn - (DIRSIZ+2)), "/"), GROUPFN);

			if ( (fd = fopen(groupfn, "r")) != NULL )
			{
				char		buf[133];
				register char *	cp = buf;
				register	c;

				while ( (c = getc(fd)) != EOF )
					switch ( c )
					{
					 case ':':
					 case '\n':
						if ( cp != buf )
						{
							*cp = '\0';
							if ( strcmp(p->pw_strings[LNAME], buf) == 0 )
							{
								fclose(fd);
								return pe.pw_gid;
							}
							cp = buf;
						}
						break;

					 default:
						*cp++ = c;
						break;
					}

				fclose(fd);
			}
		}
	}

	/*
	**	Know password of account?
	*/
	if (*pe.pw_pword) {
		if (!isatty(fileno(stdin)))
			error(PD);
		if (strcmp(pe.pw_pword, crypt(getpass(), pe.pw_pword)) == 0)
			return pe.pw_gid;
	}

	/*
	**	Too bad
	*/
	warn(NG);
	return getgid();
}

getpass()
{
	register n;
	struct sgttyb ttyb;
	static char pwbuf[PASSWDZ];

	gtty(0, &ttyb);
	n = ttyb.sg_flags;
	ttyb.sg_flags &= ~ECHO;
	stty(0, &ttyb);
	ttyb.sg_flags = n;
	printf("Password: ");
	n = read(0, pwbuf, sizeof pwbuf);
	if (n <= 0)
		n = 1;
	pwbuf[n - 1] = 0;
	stty(0, &ttyb);
	printf("\n");
	return(pwbuf);
}
