/*
**	mail [ person ]
**	mail -f file
**
**	Added #if for choice of mail file. Either
**	/usr/mail/name or $HOME/.mail
**				Chrism Aug80
*/

#include	<local-system>
#include	<types.h>
#include	<stat.h>
#include	<passwd.h>
#include	<signal.h>
#include	<setjmp.h>
#include	<stdio.h>
#include	<fcntl.h>

/*copylet flags */
#define	REMOTE		1		/* remote mail, add rmtmsg */
#define ORDINARY	2
#define ZAP		3		/* zap header and trailing empty line */
#define FORWARD		4
#define	LSIZE		256
#define	MAXLET		300		/* maximum number of letters */
#define	MFMODE		0600		/* create mode for maildir files */
#define	illegalc(c)	((c<' '&&(c<'\07'||c>'\r'))||c>=0177)

struct	let	{
	long	adr;
	char	change;
} let[MAXLET];

int	caught[] = {
		SIGHUP,
		SIGINT,
		SIGQUIT,
		SIGPIPE,
		SIGTERM,
		SIGALRM,
		SIGCPUTL,
		0		};

struct pwent	mypwe;
struct pwent	rootpwe;

char	lettmp[] = "/tmp/maXXXXX";
char	from[] = "From ";
#ifdef	USR_MAIL
char	maildir[] = "/usr/mail/";
#else
char	mailname[] = "/.mail";
#endif	USR_MAIL
char	sendto[256];
char	*mailfile;
char	mail_lock[] = ".lock";
char	deadf[] = "/dead.letter";
char	rmtbuf[] = "/tmp/marXXXXXX";
char	*rmtmsg = " netmail from %s\n";
char	*forwmsg = " forwarded by %s\n";
char	frwrd [] = "Forward to ";
char	subject[] = "Subject: ";
char	*thissys;
char	mbox[] = "/mbox";
char	curlock[50];
char *	locked;
char	line[LSIZE];
char	resp[LSIZE];
char	*hmbox;
char	*home;
char	*my_name;
char	*getlogin();
char	*malloc();
char	lfil[50];
char	*ctime();
char	*getenv();
char	*strrchr();

FILE	*tmpf;
FILE	*malf;
FILE	*rmtf;

int	error;
int	nlet	= 0;
int	changed;
int	forward = 1;	/* print in fifo by default - 'r' for lifo */
int	delete();
int	flgf = 0;
int	flgp = 0;
int	delflg = 1;
uid_t	gid;
int	savdead();
int	(*saveint)();
int	(*setsig())();

long	ftell();
time_t	now;

jmp_buf	sjbuf;

unsigned umsave;

main(argc, argv)
char **argv;
{
	register i;
	char outbuf[BUFSIZ];

	umsave = umask(7);
	setbuf(stdout, outbuf);
	thissys = NETID;
	my_name = getlogin();
	gid = getegid();
	setgid(mypwe.pw_gid);	/* in case of newgrp */
	if(setjmp(sjbuf)) done();
	for (i=0; caught[i]; i++)
		setsig(caught[i], delete);
	if ((i = open(mktemp(lettmp), O_RDWR|O_CREAT|O_TRUNC|O_FREE, 0600)) == -1)
	{
		fprintf(stderr, "mail: cannot open %s for writing\n", lettmp);
		error = 2;
		done();		/* no return */
	}
	tmpf = fdopen(i, "w+");
	unlink(lettmp);
	if (argv[0][0] != 'r' &&	/* no favors for rmail */
	   (argc == 1 || argv[1][0] == '-' || argv[1][0] == '+'))
		printmail(argc, argv);
	else
		sendmail(argc, argv);
	done();		/* no return */
}

int (*setsig(i, f))()
int i;
int (*f)();
{
	register int (*rc)();

	if((rc=signal(i, SIG_IGN))!=SIG_IGN)
		signal(i, f);
	return(rc);
}

printmail(argc, argv)
char **argv;
{
	int	flg, i, j, print, aret, stret, goerr = 0;
	register char	*p;
	char	frwrdbuf[256];
	struct	stat stbuf;
	char *getarg();

	argc--;
	argv++;
	if (argc && **argv == '+') {
		forward = 1;
		argc--;
		argv++;
	}
	while(argc > 0)
	{
		p = *argv++;
		argc--;
		while (*p)
		{
			switch(*p++)
			{
			case 'f':
				flgf = 1;
				if(*p)
				{
					mailfile = p;
					p = "";
				}
				else if (argc)
				{
					mailfile = *argv++;
					argc--;
				}
				else
					goerr++;
				break;
			case 'p':
				flgp++;
			case 'q':
				delflg = 0;
			case 'i':
				break;
			case 'r':
				forward = 0;
				break;
			case '-':
				break;
			default:
				goerr++;
			}
		}
	}
	if(goerr) {
		fprintf(stderr, "Usage: mail [-rpq] [-f file] [persons]\n");
		error = 2;
		done();		/* no return */
	}
	home = mypwe.pw_strings[DIRPATH];
	if((home == NULL) || (strlen(home) == 0))
		home = ".";
	hmbox = malloc(strlen(home) + strlen(mbox) + 1);
	cat(hmbox, home, mbox);
	if(!flgf) {
#ifdef	USR_MAIL
		mailfile = malloc(strlen(maildir) + strlen(my_name) + 1);
		cat(mailfile, maildir, my_name);
#else
		mailfile = malloc(strlen(home) + strlen(mailname) + 1);
		cat(mailfile, home, mailname);
#endif	USR_MAIL
	}
	stret = stat(mailfile, &stbuf);
	if((aret=access(mailfile, 4)) == 0)
		malf = fopen(mailfile, "r");
	if (!stret && aret) {
		fprintf(stderr, "mail: permission denied!\n");
		return;
	}
	if (flgf && (aret || (malf == NULL))) {
		fprintf(stderr, "mail: cannot open %s\n", mailfile);
		return;
	}
	if(aret || (malf == NULL) || (stbuf.st_size == 0))
	{
		fprintf(stdout, "No mail.\n");
		return;
	}
	llock(mailfile);
	if(areforwarding(mailfile)) {
		printf("Your mail is being forwarded to ");
		fseek(malf, (long)(sizeof(frwrd) - 1), 0);
		fgets(frwrdbuf, sizeof(frwrdbuf), malf);
		printf("%s", frwrdbuf);
		if(getc(malf) != EOF)
			printf("and your mailbox contains extra stuff\n");
		unllock();
		return;
	}
	copymt(malf, tmpf);
	fclose(malf);
	rewind(tmpf);
	unllock();
	changed = 0;
	print = 1;
	for (i = 0; i < nlet; ) {
		j = forward ? i : nlet - i - 1;
		if(setjmp(sjbuf)) {
			print=0;
		} else {
			if ( print )
			{
				copylet(j, stdout, ORDINARY);
			}
			print = 1;
		}
		if(flgp) {
			i++;
			continue;
		}
		setjmp(sjbuf);
		fprintf(stdout, "? ");
		fflush(stdout);
		if (fgets(resp, LSIZE, stdin) == NULL)
			break;
		switch (resp[0]) {

		default:
			fprintf(stderr, "usage\n");
		case '?':
			print = 0;
			fprintf(stderr, "q\t\tquit\n");
			fprintf(stderr, "x\t\texit without changing mail\n");
			fprintf(stderr, "p\t\tprint\n");
			fprintf(stderr, "s [file]\tsave (default mbox)\n");
			fprintf(stderr, "w [file]\tsame without header\n");
			fprintf(stderr, "-\t\tprint previous\n");
			fprintf(stderr, "d\t\tdelete\n");
			fprintf(stderr, "+\t\tnext (no delete)\n");
			fprintf(stderr, "m [user]\tmail to user\n");
			fprintf(stderr, "! cmd\t\texecute cmd\n");
			break;

		case '+':
		case 'n':
		case '\n':
			i++;
			break;
		case 'x':
			changed = 0;
		case 'q':
			goto donep;
		case 'p':
			break;
		case '^':
		case '-':
			if (--i < 0)
				i = 0;
			break;
		case 'y':
		case 'w':
		case 's':
			flg = 0;
			if (resp[1] == '\n' || resp[1] == '\0')
				cat(resp+1, hmbox, "");
			else if(resp[1] != ' ') {
				printf("invalid command\n");
				flg++;
				print = 0;
				continue;
			}
			umask(umsave);
			for (p = resp+1; (p = getarg(lfil, p)) != NULL; ) {
				if((aret=legal(lfil)))
					malf = fopen(lfil, "a");
				if ((malf == NULL) || (aret == 0)) {
					fprintf(stdout, "mail: cannot append to %s\n", lfil);
					flg++;
					continue;
				}
				if(aret==2)
					chown(lfil, mypwe.pw_limits.l_uid, mypwe.pw_limits.l_uid);
				copylet(j, malf, resp[0]=='w'? ZAP: ORDINARY);
				fclose(malf);
			}
			umask(7);
			if (flg)
				print = 0;
			else {
				let[j].change = 'd';
				changed++;
				i++;
			}
			break;
		case 'm':
			flg = 0;
			if (resp[1] == '\n' || resp[1] == '\0') {
				i++;
				continue;
			}
			if (resp[1] != ' ') {
				printf("invalid command\n");
				flg++;
				print = 0;
				continue;
			}
			for (p = resp+1; (p = getarg(lfil, p)) != NULL; )
				if (!sendrmt(j, lfil))	/* couldn't send it */
					flg++;
			if (flg)
				print = 0;
			else {
				let[j].change = 'd';
				changed++;
				i++;
			}
			break;
		case '!':
			system(resp+1);
			printf("!\n");
			print = 0;
			break;
		case 'd':
			let[j].change = 'd';
			changed++;
			i++;
			if (resp[1] == 'q')
				goto donep;
			break;
		}
	}
   donep:
	if (changed)
		copyback();
}

copyback()	/* copy temp or whatever back to /usr/mail */
{
	register i, n, c;
	int new = 0, aret;
	struct stat stbuf;
	long stsize;

	signal(SIGINT, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	llock(mailfile);
	stat(mailfile, &stbuf);
	stsize = stbuf.st_size;
	if (stsize != let[nlet].adr) {	/* new mail has arrived */
		malf = fopen(mailfile, "r");
		if (malf == NULL) {
			fprintf(stdout, "mail: can't re-read %s\n", mailfile);
			error = 2;
			done();
		}
		fseek(malf, let[nlet].adr, 0);
		fseek(tmpf, let[nlet].adr, 0);
		while ((c = fgetc(malf)) != EOF)
			fputc(c, tmpf);
		fclose(malf);
		rewind(tmpf);
		let[++nlet].adr = stsize;
		new = 1;
	}
	if((aret=access(mailfile, 2)) == 0)
		n = open(mailfile, O_WRITE | O_CREAT | O_TRUNC | O_FREE, 0600);
	if ((n == -1) || (aret)) {
		fprintf(stderr, "mail: can't rewrite %s\n", mailfile);
		error = 2;
		done();
	}
	fdopen(n, "w");
	n = 0;
	for (i = 0; i < nlet; i++)
		if (let[i].change != 'd') {
			copylet(i, malf, ORDINARY);
			n++;
		}
	fclose(malf);
	if ((n == 0) && ((stbuf.st_mode & 0777)== MFMODE)) /* empty mailbox */
		unlink(mailfile);
	if (new && !flgf)
		fprintf(stdout, "new mail arrived\n");
	unllock();
}

copymt(f1, f2)	/* copy mail (f1) to temp (f2) */
FILE *f1, *f2;
{
	long nextadr;

	nlet = nextadr = 0;
	let[0].adr = 0;
	while (fgets(line, LSIZE, f1) != NULL) {
		if (isfrom(line))
			let[nlet++].adr = nextadr;
		nextadr += strlen(line);
		fputs(line, f2);
	}
	let[nlet].adr = nextadr;	/* last plus 1 */
}

areforwarding(s) char *s;
{	FILE *fd;
	char fbuf[256], *p;
	int c;
	fd = fopen(s, "r");
	if(fd == NULL)
		return(0);
	fread(fbuf, sizeof(frwrd) - 1, 1, fd);
	if(strncmp(fbuf, frwrd, sizeof(frwrd) - 1) == 0) {
		for(p = sendto; (c = getc(fd)) != EOF && c != '\n';)
			if(c != ' ') *p++ = c;
		*p = 0;
		fclose(fd);
		return(1);
	}
	fclose(fd);
	return(0);
}

copylet(n, f, type) FILE *f;
{
	register int ch;
	register long k;
	long taddr;

	fseek(tmpf, let[n].adr, 0);
	taddr = let[n+1].adr - let[n].adr;
	k = taddr;
	while(k-- > 1 && (ch=fgetc(tmpf))!='\n')
		if(type!=ZAP)
		{
			if ( illegalc(ch) )
				ch = '?';
			fputc(ch,f);
		}
	if(type==REMOTE)
		fprintf(f, rmtmsg, thissys);
	else if(type==FORWARD)
		fprintf(f, forwmsg, my_name);
	else if(type==ORDINARY)
		fputc(ch,f);
	while(k-->1)
	{
		ch = fgetc(tmpf);
		if ( illegalc(ch) )
			ch = '?';
		fputc(ch, f);
	}
	if(type!=ZAP || ch!= '\n')
		fputc(fgetc(tmpf), f);
}

isfrom(lp)
register char *lp;
{
	register char *p;

	for (p = from; *p; )
		if (*lp++ != *p++)
			return(0);
	return(1);
}

sendmail(argc, argv)
char **argv;
{
	int	aret;
	extern long time();

	now = time((long *)0);
	if (argv[0][0] != 'r')	/* don't add header if network mail */
	{
		fprintf(tmpf, "%s%s %s", from, my_name, ctime(now));
		if (isatty(fileno(stdin)))
		{
			fprintf(tmpf, subject);
			printf(subject);
			fflush(stdout);
		}
	}
	flgf = 1;
	saveint = setsig(SIGINT, savdead);
	while (fgets(line, LSIZE, stdin) != NULL) {
		if (line[0] == '.' && line[1] == '\n')
			break;
		/* pass first "From" if network mail */
		if (argv[0][0] != 'r' || flgf == 0)
			if (isfrom(line))
				fputs(">", tmpf);
		fputs(line, tmpf);
		if (flgf == 1)
		{
			if (isatty(fileno(stdin)))
				fputs("\n", tmpf);	/* extra blank line after header */
			flgf = 0;
		}
	}
	setsig(SIGINT, saveint);
	fputs("\n", tmpf);
	nlet = 1;
	let[0].adr = 0;
	let[1].adr = ftell(tmpf);
	rewind(tmpf);
	if (flgf)
		return;
	if (error == 0)
		while (--argc > 0)
			if (!send(0, *++argv, 0))	/* couldn't send to him */
				error++;
	if (error)
	{
		char *	dead;

		dead = malloc(strlen(mypwe.pw_strings[DIRPATH]) + strlen(deadf) + 1);
		cat(dead, mypwe.pw_strings[DIRPATH], deadf);
		umask(umsave);
		if ( (aret=legal(dead)) )
			malf = fopen(dead, "w");
		if ((malf == NULL) || (aret == 0)) {
			fprintf(stdout, "mail: cannot create %s\n", dead);
			error = 2;
			umask(7);
			return;
		}
		chown(dead, mypwe.pw_limits.l_uid, mypwe.pw_limits.l_uid);
		umask(7);
		copylet(0, malf, ZAP);
		fclose(malf);
		fprintf(stdout, "Mail saved in %s\n", dead);
	}
}

savdead()
{
	setsig(SIGINT, saveint);
	error++;
}

uid_t	puid;
uid_t	pgid;
char fname[20];

sendrmt(n, name)
char *name;
{
	FILE *rmf, *popen();
	register char *p;
	char rname[64], *rsys, cmd[64];
	register local;

	if ((p = strrchr(name, ':')) != (char *)0)
	{
		local = 0;
		rsys = p + 1;
		strncpy(rname, name, p - name);
		rname[p - name] = '\0';
	}
	else
		local++;
	if ((!local && *rsys=='\0') || (local && *name=='\0')) {
		fprintf(stdout, "null name\n");
		return(0);
	}
	if (local)
		sprintf(cmd, "mail %s", name);
	else 
		sprintf(cmd, "net -h%s -n%s", rsys, rname);
	if (!local && !netok())
	{
		printf("%s: not authorised to use net\n", fname);
		return(0);
	}
	if ((rmf=popen(cmd, "w")) == NULL)
		return(0);
	copylet(n, rmf, local? FORWARD: REMOTE);
	return(pclose(rmf)==0 ? 1 : 0);
}

netok()
{
	struct pwent fpwe;

	if (fname[0] == 0)	/* eh? */
		return(1);
	fpwe.pw_strings[LNAME] = fname;
	if (getpwuid(&fpwe, (char *)0, 0) == PWERROR)
	{
		printf("mail: cannot send to %s\n", fname);
		return(0);
	}
	if (fpwe.pw_flags & USELOG)
	{
		puid = fpwe.pw_limits.l_uid;
		pgid = fpwe.pw_gid;
	}
	return(1);
}

send(n, name, level)	/* send letter n to name */
int n;
char *name;
{
	int fd;
	char	file[100], *p;
	struct pwent	otherpwe;
#ifndef	USR_MAIL
	char		sbuf[SSIZ];
#endif	USR_MAIL
	struct stat	stbuf;

	if(level > 20) {
		fprintf(stdout, "unbounded forwarding\n");
		return(0);
	}
	if (strcmp(name, "-") == 0)
		return(1);
	for(p=name; *p!=':' &&*p!='\0'; p++)
		;
	if (*p == ':')
		return(sendrmt(n, name));
#ifndef	USR_MAIL
	otherpwe.pw_strings[LNAME] = name;
	if ( getpwuid(&otherpwe, sbuf, SSIZ) == PWERROR )
	{
perm:
		fprintf(stdout, "mail: can't send to %s\n", name);
		return(0);
	}
	cat(file, otherpwe.pw_strings[DIRPATH], mailname);
	if(areforwarding(file))
	{
		strncpy(fname, name, 20);
		return(send(n, sendto, level+1));
	}
#else	USR_MAIL
	cat(file, maildir, name);
	if(areforwarding(file))
	{
		strncpy(fname, name, 20);
		return(send(n, sendto, level+1));
	}
	otherpwe.pw_strings[LNAME] = name;
	if ( getpwuid(&otherpwe, (char *)0, 0) == PWERROR )
	{
perm:
		fprintf(stdout, "mail: can't send to %s\n", name);
		return(0);
	}
#endif	USR_MAIL
	llock(file);
	if(stat(file, &stbuf) == SYSERROR)
	{
		close(open(file, O_RDWR|O_CREAT|O_FREE, MFMODE));
		chown(file, otherpwe.pw_limits.l_uid, otherpwe.pw_limits.l_uid);
	}
	else if ((stbuf.st_mode & 0200) == 0 ||	/* no write permission */
	    (stbuf.st_nlink != 1) ||		/* linked somewhere else */
	    (otherpwe.pw_limits.l_uid != stbuf.st_uid))	/* not owner */
		goto perm;
	fd = open(file, O_WRITE|O_APPEND|O_FREE);
	if (fd == -1) {
		fprintf(stdout, "mail: cannot append to %s\n", file);
		unllock();
		return(0);
	}
	malf = fdopen(fd, "a");
	copylet(n, malf, ORDINARY);
	fclose(malf);
	unllock();
	return(1);
}

delete(i)
{
	setsig(i, delete);
	fprintf(stderr, "\n");
	if(delflg)
		longjmp(sjbuf, 1);
	done();
}

done()
{
	unllock();
	unlink(rmtbuf);
	exit(error);
}

llock(file)
char *file;
{
	int i;

	if (locked)
		if ( strcmp(locked, curlock) == 0 )
			return;
		else
		{
			fprintf(stderr, "mail: %s already locked!\n", curlock);
			error = 3;
			done();
		}
	cat(curlock, file, mail_lock);
	for (i=0; i<10; i++)
	{
		if(access(curlock, 0) == SYSERROR)
		{
			close(creat(curlock, 0));
			locked = curlock;
			return;
		}
		sleep(2);
	}
	fprintf(stderr, "mail: %s not creatable after %d tries\n", curlock, i);
	error = 2;
	done();
}

unllock()
{
	unlink(curlock);
	locked = (char *)0;
}

cat(to, from1, from2)
char *to, *from1, *from2;
{
	int i, j;

	j = 0;
	for (i=0; from1[i]; i++)
		to[j++] = from1[i];
	for (i=0; from2[i]; i++)
		to[j++] = from2[i];
	to[j] = 0;
}

char *
getarg(s, p)	/* copy p... into s, update p */
register char *s, *p;
{
	while (*p == ' ' || *p == '\t')
		p++;
	if (*p == '\n' || *p == '\0')
		return(NULL);
	while (*p != ' ' && *p != '\t' && *p != '\n' && *p != '\0')
		*s++ = *p++;
	*s = '\0';
	return(p);
}

legal(file)
char *file;
{
	char	*sp, dfile[100];
	if(!access(file, 0))
		if(!access(file, 2))
			return(1);
		else	return(0);
	else {
		if((sp=strrchr(file, '/')) == NULL)
			cat(dfile, ".", "");
		else {
			strncpy(dfile, file, sp - file);
			dfile[sp - file] = '\0';
		}
		if(access(dfile, 2)) return(0);
		return(2);
	}
}

system(s)
char *s;
{
	int status, pid, w;
	register int (*istat)(), (*qstat)();

	if ((pid = fork()) == 0) {
		setuid(mypwe.pw_limits.l_uid);
		setgid(gid);
		execl("/bin/sh", "sh", "-c", s, 0);
		_exit(127);
	}
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return(status);
}



/*
**	Own version of "getlogin()" to set up pwent
*/

char *
getlogin()
{
	register	i, size;

	mypwe.pw_limits.l_uid = getuid();
	if ( getpwlog(&mypwe, (char *)0, 0) == PWERROR )
	{
		error = 1;
		fprintf(stderr, "Who are you?\n");
		done();
	}

	for ( i = size = 0 ; i < PWSLENCNT ; i++ )
		size += (int)mypwe.pw_strings[i];

	getpwlog(&mypwe, malloc(size), size);

	return(mypwe.pw_strings[LNAME]);
}

/*LINTLIBRARY*/
#include <stdio.h>
#include <signal.h>
#define	tst(a,b)	(*mode == 'r'? (b) : (a))
#define	RDR	0
#define	WTR	1
static	int	popen_pid[20];

FILE *
popen(cmd,mode)
char	*cmd;
char	*mode;
{
	int p[2];
	register myside, yourside, pid;

	if(pipe(p) < 0)
		return NULL;
	myside = tst(p[WTR], p[RDR]);
	yourside = tst(p[RDR], p[WTR]);
	if((pid = fork()) == 0) {
		/* myside and yourside reverse roles in child */
		int	stdio;

		stdio = tst(0, 1);
		close(myside);
		close(stdio);
		fcntl(yourside, 0, stdio);
		close(yourside);
		setgid(pgid);
		setuid(puid);
		execl("/bin/sh", "sh", "-c", cmd, 0);
		_exit(1);
	}
	if(pid == -1)
		return NULL;
	popen_pid[myside] = pid;
	close(yourside);
	return(fdopen(myside, mode));
}


pclose(ptr)
FILE *ptr;
{
	register f, r, (*hstat)(), (*istat)(), (*qstat)();
	int status;

	f = fileno(ptr);
	fclose(ptr);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	hstat = signal(SIGHUP, SIG_IGN);
	while((r = wait(&status)) != popen_pid[f] && r != -1)
		;
	if(r == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	signal(SIGHUP, hstat);
	return(status);
}
