#include "draw.h"

print(arg1)
char *arg1;
{
	clr();
	print1(arg1);
}

print1(arg1)
char *arg1;
{

	register struct symbol *p;

	/* print module */

	if((p = lookup(arg1)) == NULL)
	{
		warn("unknown module\n");
		return;
	}

	tempreadin(p);
	p->def |= PRINT;
	p->mlevel = draw(0.0, 0.0, p->list->mod.up);
	p->def |= LEVEL;
	p->def &= ~PRINT;
	cleanout();
}

draw(x, y, p)
float x;
float y;
union unit *p;
{

	register union unit *q;
	register struct symbol *r;
	int	level;
	float	saver[4];
	float	savescale;
	float	xx, yy;


	q = p;
	level = 0;

	for(;q != NULL;q = q->mod.up)
	{
		if(q->mod.op != MODULE)
		{
			level |= q->l.level;
			if( !(q->l.level & levelmask))
				continue; /* do not draw */
			drawspecial(x, y, q);
		}
		else
		{
			r = &symtab[q->mod.modnum];
			if(((r->def & LEVEL) == 0) || r->mlevel & levelmask)
			{
				xx = q->mod.x/100.0;
				yy = q->mod.y/100.0;
				rotate(&xx, &yy);
				savescale = scale;
				tempreadin(r);
				r->def |= PRINT;
				scale = scale * ((float)q->mod.mscale / 1000.0);
				if(q->mod.mrot == 0)
					r->mlevel = draw(x+xx, y+yy, r->list->mod.up);
				else
				{
					nrotate(q->mod.mrot, saver);
					r->mlevel = draw(x+xx, y+yy, r->list->mod.up);
					restore(saver);
				}
				r->def |= LEVEL;
				r->def &= ~PRINT;
				scale = savescale;
			}
			level |= r->mlevel;
		}
	}
	return level;
}

drawspecial(x, y, p)
float x;
float y;
union unit *p;
{
	register i;
	register char *s;

	float	saver[4];
	float	x1, y1;
	float	x2, y2;
	float	x3, y3;

	x1 = p->mod.x/100.0;
	y1 = p->mod.y/100.0;


	rotate(&x1, &y1);

	switch(p->mod.op)
	{
	case LINE:
			umovea(x+x1, y+y1);
			for(i = 0;i < p->l.nsegs;i++)
			{
				switch(p->l.ls[i].a.dmode)
				{
				case DELTAX:
					x1 = extend(p->l.ls[i].a.delta)/100.0;
					y1 = 0.0;
					break;
				case DELTAY:
					y1 = extend(p->l.ls[i].a.delta)/100.0;
					x1 = 0.0;
					break;
				case DELTAXY:
					y1 = extend(p->l.ls[i].a.delta)/100.0;
					x1 = p->l.ls[i+1].b.delta1/100.0;
					i++;
					break;
				case	SDELTAXY:
					y1 = sextend(p->l.ls[i].c.deltay1)/100.0;
					x1 = sextend(p->l.ls[i].c.deltax1)/100.0;
					break;
				}
				rotate(&x1, &y1);
				udrawr(x1, y1);
			}
			break;
	case CIRCLE:
			uucircle(x+x1, y+y1, (p->cir.rad/1000.0) * scale);
			break;
	case ARC:
			x2 = p->arc.x1/100.0;
			y2 = p->arc.y1/100.0;
			rotate(&x2, &y2);

			x3 = p->arc.cx/100.0;
			y3 = p->arc.cy/100.0;
			rotate(&x3, &y3);
			uuarc(x+x1, y+y1, x+x2, y+y2, x+x3, y+y3);
			break;
	case STRING:
			xsiz = ysiz = (float)(p->str.sscale) / 2000.0;
			if(p->str.srot != 0)
				nrotate(p->str.srot, saver);
			umovea(x+x1, y+y1);
			for(s = p->str.sp, i = 0;i < p->str.cnt;i++, s++)
				lchar(*s);
			if(p->str.srot != 0)
				restore(saver);
			break;
	default:
			warn("unknown primative\n");
			break;
	}
}

/* rotation matrix set to 0 degrees */
float baser[4] =
	{
		1.0, 0.0,
		0.0, 1.0
	};
float scale = 1.0;
nrotate(angle, saver)
int angle;
float * saver;
{

	register i;
	float baser1[4];

	float cosa = cos((float) angle * (3.141592654/180.0));
	float sina = sin((float) angle * (3.141592654/180.0));

	for(i = 0; i < 4; i++)
		saver[i] = baser[i];

	baser1[0] = baser[0] * cosa - baser[2] * sina;
	baser1[1] = baser[1] * cosa - baser[3] * sina;
	baser1[2] = baser[0] * sina + baser[2] * cosa;
	baser1[3] = baser[1] * sina + baser[3] * cosa;

	for(i = 0;i < 4;i++)
		baser[i] = baser1[i];

}

restore(saver)
float *saver;
{

	register i;

	for(i = 0; i < 4; i++)
		baser[i] = saver[i];

}

rotate(xp, yp)
float *xp, *yp;
{
	float x;

	*xp = ((x = *xp) * baser[0] + *yp * baser[1]) * scale;
	*yp = (x * baser[2] + *yp * baser[3]) * scale;
}

extend(x)
{
	if(x & 020000)	/* bit 13 */
		return x | 0140000;
	else
		return x & 037777;
}

sextend(x)
{
	if(x & 0100) /* bit 6 */
		return x | 0177700;
	else
		return x & 0177;
}
