/*
**	chgrp name|gid file ...
*/

#include	<local-system>
#include	<types.h>
#include	<stat.h>
#include	<passwd.h>
#include	<stdio.h>
#include	<ctype.h>


main(argc, argv)
char *argv[];
{
	register	c;
	struct pwent	pwe;
	struct stat	stbuf;
	uid_t		gid;
	int		status;

	if(argc < 3) {
		fprintf(stderr, "usage: %s name|gid file ...\n", argv[0]);
		return 4;
	}
	if ( !isnumber(argv[1]) || (gid = atoi(argv[1])) >= NGROUPS )
	{
		pwe.pw_strings[LNAME] = argv[1];
		if(getpwuid(&pwe, (char *)0, 0) == PWERROR) {
			fprintf(stderr, "%s: unknown group: %s\n", argv[0], argv[1]);
			return 4;
		}
		gid = pwe.pw_gid;
	}
	status = 0;
	for(c=2; c<argc; c++) {
		stat(argv[c], &stbuf);
		if(chown(argv[c], stbuf.st_uid, gid) < 0) {
			perror(argv[c]);
			status = 1;
		}
	}
	return status;
}

isnumber(s)
char *s;
{
	register c;

	while(c = *s++)
		if(!isdigit(c))
			return(0);
	return(1);
}
