/*
 *	slp - set printer/plotter modes
 *
 *	slp [-[0-9]] [flags]
 *
 *	digit - /dev/lp?
 *	default - /dev/lp0
 */

#include	<signal.h>
#include	<sgtty.h>	/* for XTABS, B2400, EVENP */
#include	<printers.h>
#include	<lp.h>
struct lpdlock lpdlock;
struct lpiocb lpiocb;
char lock[] = "lock0";
#define	LKPOSN	4

struct
{
	char	*string;
	short	set, reset;
}
modes[] =
{
	"flush",	FLSH, 0,
	"-flush",	0, FLSH,
	0
};

char	*arg;
int	fd;
char	*lp =	"/dev/lp0";
#define	LPPOSN	7

main(argc, argv)
char *argv[];
{
	register i;
	register struct printer *prp;
	char	c;

	c = argv[1][0];
	if (argc > 1 && c == '-' &&
	    (c = argv[1][1]) >= '0' && c <= '9' && argv[1][2] == 0)
	{
		for (prp = printer; prp < &printer[NPRINTERS]; prp++)
			if (prp->ident == c)
				break;
		if (prp == &printer[NPRINTERS])
		{
			printf("Illegal printer number\n");
			exit(1);
		}
		lock[LKPOSN] = lp[LPPOSN] = c;
		argc--;
		argv++;
	}
	else
	{
		printf("Usage: slp -[0-9] [flags]\n");
		exit(1);
	}
	if (chdir(LPDDIR) == 0)
	{
		if ((i = open(lock, 0)) == -1 ||
		    read(i, &lpdlock, sizeof lpdlock) != sizeof lpdlock ||
		    kill(lpdlock.lpd_pid, 0) == -1)
			printf("Daemon dead\n");
		else
		{
			switch (lpdlock.lpd_state)
			{
		    case IDLE:	arg = "idle"; break;
		    case PR_OP:	arg = "trying to open printer"; break;
		    case PRINT:	arg = "printing"; break;
		    case CLDN:	arg = "closing down"; break;
		    default:	arg = "in unknown state"; break;
			}
			close(i);
			printf("Daemon %s (pid %d) (pages %d)\n",
				arg, lpdlock.lpd_pid, lpdlock.lpd_pages);
		}
	}
	if (prp->baudrate != PARALLEL)		/* probably la180 */
	{
		printf("Width=%d cols Length=%d lines 6lpi\n",
			prp->pagewidth, prp->pagelength);
		exit(0);
	}
	if ((fd = open(lp, 0)) == -1)	/* open for READING */
	{
		perror(lp);
		exit(1);
	}
	if (ioctl(fd, LPGET, &lpiocb) < 0)
	{
		perror("ioctl");
		exit(1);
	}
	if (getuid() == 0 && argc != 1)
	{
		while (--argc > 0)
		{
			arg = *++argv;
	
			for (i = 0; modes[i].string != 0; i++)
				if (eq(modes[i].string))
				{
					lpiocb.lp_flag &= ~modes[i].reset;
					lpiocb.lp_flag |= modes[i].set;
				}
	
			if (arg != 0)
				printf("Unknown mode: %s\n", arg);
		}
	
		if (ioctl(fd, LPSET, &lpiocb) < 0)
		{
			perror("ioctl");
			exit(1);
		}
		ioctl(fd, LPGET, &lpiocb);
	}
	prmodes(prp);
	exit(0);
}

eq(string)
char *string;
{
	register int	i;
	register char	*s;

	if (arg == 0)
		return(0);

	s = string;
	i = 0;
	do
	{
		if (arg[i] != s[i])
			return(0);
	} while (arg[i++] != '\0');

	arg = 0;
	return(1);
}

prmodes(prp)
register struct printer *prp;
{
	register m;

	printf("Width=%d cols Length=%d lines\n",
		prp->pagewidth, prp->pagelength);
	printf("State: ");
	switch(lpiocb.lp_state)
	{
    case OPEN:
		printf("open\n");
		break;
    case CLOSED:
		printf("closed\n");
		break;
    case CLOSING:
		printf("closing\n");
		break;
    default:
		printf("unknown!\n");
		break;
	}
	m = lpiocb.lp_flag;
	printf("Flags:");
	if (m & ASLP)
	{
		m &= ~ASLP;
		printf(" asleep");
	}
	if (m & POFF)
	{
		m &= ~POFF;
		printf(" poff");
	}
	if (m & ERR)
	{
		m &= ~ERR;
		printf(" err");
	}
	if (m & FLSH)
	{
		m &= ~FLSH;
		printf(" flush");
	}
	if (m)
		printf(" + junk\n");
	else
		printf("\n");
}
