/
/	general structure
/	-----------------
/
/	this program is a translator for a version of the snobol4
/	programming language. language details are contained in
/	the appropriate spitbol manual. in general the language
/	is identical to that implemented by the btl translator
/	(r. e. griswold et al.) with the following exceptions.
/
/	1)   redefinition of standard system functions and
/	operators is not permitted.
/
/	2)   the value function is not provided.
/
/	3)   access tracing is provided in addition to the
/	other standard trace modes.
/
/	4)   the keyword stfcount is not provided.
/
/	5)   the keyword fullscan is not provided and all pattern
/	matching takes place in fullscan mode (i.e. with no
/	heuristics applied).
/
/	6)   a series of expressions separated by commas may
/	be grouped within parentheses to provide a selection
/	capability. the semantics are that the selection
/	assumes the value of the first expression within it
/	which succeeds as they are evaluated from the left.
/	if no expression succeeds the entire statement fails
/
/	7)   an explicit pattern matching operator is provided.
/	this is the binary query (see gimpel sigplan oct 74)
/
/	8)   the assignment operator is introduced as in the
/	gimpel reference.
/
/	9)   the exit function is provided for generating load
/	modules - cf. gimpels sitbol.
/
/
/	the method used in this program is to translate the
/	source code into an internal pseudo-code (see following
/	section). an interpretor is then used to execute this
/	generated pseudo-code. the nature of the snobol4 language
/	is such that the latter task is much more complex than
/	the actual translation phase. accordingly, nearly all the
/	code in the program section is concerned with the actual
/	execution of the snobol4 program.
/
/	interpretive code format
/	------------------------
/
/	the interpretive pseudo-code consists of a series of
/	address pointers. the exact format of the code is
/	described in connection with the cdblk format. the
/	purpose of this section is to give general insight into
/	the interpretive approach involved.
/
/	the basic form of the code is related to reverse polish.
/	in other words, the operands precede the operators which
/	are zero address operators. there are some exceptions to
/	these rules, notably the unary not operator and the
/	selection construction which clearly require advance
/	knowledge of the operator involved.
/
/	the operands are moved to the top of the main stack and
/	the operators are applied to the top stack entries. like
/	other versions of spitbol, this processor depends on
/	knowing whether operands are required by name or by value
/	and moves the appropriate object to the stack. thus no
/	name/value checks are included in the operator circuits.
/
/	the actual pointers in the code point to a block whose
/	first word is the address of the interpretor routine
/	to be executed for the code word.
/
/	in the case of operators, the pointer is to a word which
/	contains the address of the operator to be executed. in
/	the case of operands such as constants, the pointer is to
/	the operand itself. accordingly, all operands contain
/	a field which points to the routine to load the value of
/	the operand onto the stack. in the case of a variable,
/	there are three such pointers. one to load the value,
/	one to store the value and a third to jump to the label.
/
/	the handling of failure returns deserves special comment.
/	the location flptr contains the pointer to the location
/	on the main stack which contains the failure return
/	which is in the form of a byte offset in the current
/	code block (cdblk or exblk). when a failure occurs, the
/	stack is popped as indicated by the setting of flptr and
/	control is passed to the appropriate location in the
/	current code block with the stack pointer pointing to the
/	failure offset on the stack and flptr unchanged.
/
/	internal data representations
/	-----------------------------
/
/	representation of values
/
/	a value is represented by a pointer to a block which
/	describes the type and particulars of the data value.
/	in general, a variable is a location containing such a
/	pointer (although in the case of trace associations this
/	is modified, see description of trblk).
/
/	the following is a list of possible datatypes showing the
/	type of block used to hold the value. the details of
/	each block format are given later.
/
/	datatype	block type
/	--------	----------
/
/
/	array		arblk or vcblk
/
/	code		cdblk
/
/	expression	exblk or seblk
/
/	integer		icblk
/
/	name		nmblk
/
/	pattern		p0blk or p1blk or p2blk
/
/	real		rcblk
/
/	string		scblk
/
/	table		tbblk
/
/	program datatype      pdblk
/
/	representation of variables
/	---------------------------
/
/	during the course of evaluating expressions, it is
/	necessary to generate names of variables (for example
/	on the left side of a binary equals operator). these are
/	not to be confused with objects of datatype name which
/	are in fact values.
/
/	from a logical point of view, such names could be simply
/	represented by a pointer to the appropriate value cell.
/	however in the case of arrays and program defined
/	datatypes, this would violate the rule that there must be
/	no pointers into the middle of a block in dynamic store.
/	accordingly, a name is always represented by a base and
/	offset. the base points to the start of the block
/	containing the variable value and the offset is the
/	offset within this block in bytes. thus the address
/	of the actual variable is determined by adding the base
/	and offset values.
/
/	the following are the instances of variables represented
/	in this manner.
/
/	1)   natural variable base is ptr to vrblk
/			offset is *vrval
/
/	2)   table element    base is ptr to teblk
/			offset is *teval
/
/	3)   array element    base is ptr to arblk
/			offset is offset to element
/
/	4)   vector element   base is ptr to vcblk
/			offset is offset to element
/
/	5)   prog def dtp     base is ptr to pdblk
/			offset is offset to field value
/
/	in addition there are two cases of objects which are
/	like variables but cannot be handled in this manner.
/	these are called pseudo-variables and are represented
/	with a special base pointer as follows=
/
/	expression variable   ptr to evblk (see evblk)
/
/	keyword variable      ptr to kvblk (see kvblk)
/
/	pseudo-variables are handled as special cases by the
/	access procedure (acess) and the assignment procedure
/	(asign). see these two procedures for details.
/
/	organization of data area
/	-------------------------
/
/
/	the data area is divided into two regions.
/
/	static area
/
/	the static area builds up from the bottom and contains
/	data areas which are allocated dynamically but are never
/	deleted or moved around. the macro-program itself
/	uses the static area for the following.
/
/	1)   all variable blocks (vrblk).
/
/	2)   the hash table for variable blocks.
/
/	3)   miscellaneous buffers and work areas (see program
/	initialization section).
/
/	in addition, the system procedures may use this area for
/	input/output buffers, external functions etc. space in
/	the static region is allocated by calling procedure alost
/
/	the following global variables define the current
/	location and size of the static area.
/
/	statb		address of start of static area
/	state		address+1 of last word in area.
/
/	the minimum size of static is given approximately by
/	12 + =ezhnb + *ezsts + space for alphabet string
/	and standard print buffer.
/
/	dynamic area
/
/	the dynamic area is built upwards in memory after the
/	static region. data in this area must all be in standard
/	block formats so that it can be processed by the garbage
/	collector (procedure gbcol). gbcol compacts blocks down
/	in this region as required by space exhaustion and can
/	also move all blocks up to allow for expansion of the
/	static region.
/
/	garbage collection is fundamental to the allocation of
/	space for values. spitbol uses a very efficient garbage
/	collector which insists that pointers into dynamic store
/	should be identifiable without use of bit tables,
/	marker bits etc. to satisfy this requirement, dynamic
/	memory must not start at too low an address and lengths
/	of arrays, tables, strings, code and expression blocks
/	may not exceed the numerical value of the lowest dynamic
/	address. to avoid either penalizing users with modest
/	requirements or restricting those with greater needs on
/	host systems where dynamic memory is allocated in low
/	addresses, the minimum dynamic address may be specified
/	sufficiently high to permit arbitrarily large spitbol
/	objects to be created ( with the possibility in extreme
/	cases of wasting large amounts of memory below the
/	start address). this minimum value is placed in wc
/	before entry to spitbol. alternatively, if wc contains
/	zero, a default may be used in which dynamic is placed
/	at the lowest possible address following static.
/
/	the following global work cells define the location and
/	length of the dynamic area.
/
/	dnamb		start of dynamic area
/	dnamp		next available location
/	dname		last available location + 1
/
/	dnamb is always higher than state since the alost
/	procedure maintains some expansion space above state.
/
/	space in the dynamic region is allocated by the alloc
/	procedure. the dynamic region may be used by system
/	procedures provided that all the rules are obeyed.
/
/	register usage
/	--------------
/
/	(cp)		code pointer register. used to
/			hold a pointer to the current
/			location in the interpretive pseudo
/			code (i.e. ptr into a cdblk).
/
/	(xl,xr)		general index registers. usually
/			used to hold pointers to blocks in
/			dynamic storage. an important
/			restriction is that the values in
/			xr and xl must be collectable for
/			a garbage collect call. a value
/			is collectable if it either points
/			outside the dynamic area, or if it
/			points to the start of a block in
/			the dynamic area.
/
/	(sp)		stack pointer. used to point to
/			the lowest location used so far on
/			the execution stack. this stack
/			builds down in memory and is used
/			to stack subroutine return points
/			and other recursively saved data.
/
/	(wa,wb,wc)	general work registers. cannot be
/			used for indexing, but may hold
/			various types of data.
/
/	(ia)		used for all signed integer
/			arithmetic, both that used by the
/			translator and that arising from
/			use of snobol4 arithmetic operators
/
/	(ra)		real accumulator. used for all
/			floating point arithmetic.
/
/	this section contains descriptions of the operating
/	system dependent procedures which are used by the spitbol
/	translator. all such procedures have five letter names
/	beginning with sys. they are listed in alphabetical
/	order.
/
	/sec			/ start of system proc section
/
/	sysbx -- before execution
/
	.globl	sysbx		/ define external entry point
/
/	sysbx is called after the initial compilation and before
/	commencing execution in case the operating system needs
/	to assign files or perform other necessary services.
/
/	jsr	pc,sysbx      call before execution starts
/
/	sysdc -- date check
/
	.globl	sysdc		/ define external entry point
/
/	sysdc is called to check that the expiry date for a trial
/	version is unexpired.
/
/	jsr	pc,sysdc      call to check date
/	return only if date is ok
/
/	sysdm  -- dump core
/
	.globl	sysdm		/ define external entry point
/
/	sysdm is called by a spitbol program call of dump(n) with
/	n ge 3. its purpose is to provide a core dump.
/	n could hold an encoding of the start adrs for dump and
/	amount to be dumped e.g.  n = 256*a + s , s = start adrs
/	in kilowords,  a = kilowords to dump
/
/	(xr)		parameter n of call dump(n)
/	jsr	pc,sysdm      call to enter routine
/
/	sysdt -- get current date
/
	.globl	sysdt		/ define external entry point
/
/	sysdt is used to obtain the current date. the date is
/	returned as a character string in any format appropriate
/	to the operating system in use. it may also contain the
/	current time of day. sysdt is used to implement the
/	snobol4 function date.
/
/	jsr	pc,sysdt      call to get date
/	(xl)		pointer to block containing date
/
/	the format of the block is like an scblk except that
/	the first word need not be set. the result is copied
/	into spitbol dynamic memory on return.
/
/	sysej -- end of job
/
	.globl	sysej		/ define external entry point
/
/	sysej is called once at the end of execution to
/	terminate the run. the significance of the abend and
/	code values is system dependent. in general, the code
/	value should be made available for testing, and the
/	abend value should cause some post-mortem action such as
/	a dump. note that sysej does not return to its caller.
/
/	(wa)		value of abend keyword
/	(wb)		value of code keyword
/	jsr	pc,sysej      call to end job
/
/	note that the special value of 999 is used for the code
/	value if execution is suppressed.
/
/	sysef -- eject file
/
	.globl	sysef		/ define external entry point
/
/	sysef is used to write a page eject to a named file. it
/	may only be used for files where this concept makes
/	sense. note that sysef is not normally used for the
/	stadard output file (see sysep).
/
/	(wa)		ptr to fcblk or zero
/	(xr)		ptr to file arg1
/	jsr	pc,sysef      call to eject file
/	.word	loc	return here if file does not exist
/	.word	loc	return here if innappropriate file
/	.word	loc	return here if i/o error
/	(xl,xr)		destroyed
/
/	sysem -- get error message text
/
	.globl	sysem		/ define external entry point
/
/	sysem is used to obtain the text of an err call in the
/	source program given the error code number. it is allowed
/	to return a null string if this facility is unavailable.
/
/	(wa)		error code number
/	jsr	pc,sysem      call to get text
/	(xr)		text of message
/
/	the returned value is a pointer to a block in scblk
/	format except that the first word need not be set. the
/	string is copied into dynamic memory on return.
/	if the null string is returned either because sysem does
/	not provide error message texts or because wa is out of
/	range, spitbol will print the string stored in errtext
/	(initially null).
/
/	sysen -- endfile
/
	.globl	sysen		/ define external entry point
/
/	sysen is used to implement the snobol4 function endfile.
/	the meaning is system dependent. in general, endfile
/	implies that no further i/o operations will be performed,
/	but does not guarantee this to be the case. the file
/	should be closed after the call, and a subsequent read
/	or write will reopen the file at the start.
/
/	(wa)		ptr to fcblk or zero
/	(xr)		ptr to file arg1
/	jsr	pc,sysen      call to endfile
/	.word	loc	return here if file does not exist
/	.word	loc	return here if endfile not allowed
/	.word	loc	return here if i/o error
/	(xr,wa,wb)	destroyed
/
/	the second error return is used for files for which
/	endfile is not permitted. for example, it may be expected
/	that the standard input and output files are in this
/	category.
/
/	sysep -- eject printer page
/
	.globl	sysep		/ define external entry point
/
/	sysep is called to perform a page eject on the standard
/	printer output file (corresponding to syspr output).
/
/	jsr	pc,sysep      call to eject printer output
/
/	sysex -- call external function
/
	.globl	sysex		/ define external entry point
/
/	sysex is called to pass control to an external function
/	previously loaded with a call to sysld.
/
/	(sp)		pointer to arguments on stack
/	(xl)		pointer to control block (efblk)
/	jsr	pc,sysex      call to pass control to function
/	.word	loc	return here if function call fails
/	(sp)		popped past arguments
/	(xr)		result returned
/
/	the arguments are stored on the stack building down as
/	usual. thus the last argument is at 0(sp). on return, sp
/	is popped past the arguments.
/
/	the form of the arguments as passed is that used in the
/	spitbol translator (see definitions and data structures
/	section). the control block format is also described
/	(under efblk) in this section.
/
/	there are two ways of returning a result.
/
/	1)   return a pointer to a block in dynamic storage. this
/	block must be in exactly correct format, including
/	the first word. only functions written with intimate
/	knowledge of the system will return in this way.
/	this method must be used for unconverted results.
/
/	2)   string integer and real results may be returned by
/	pointing to a pseudo-block outside dynamic memory.
/	this block is in icblk, rcblk or scblk format except
/	that the first word is ignored. such a result is
/	copied into main storage before proceeding.
/
/	sysfc -- file control block routine
/
	.globl	sysfc		/ define external entry point
/
/	see also sysio
/	routine called when a vbl is input or output
/	associated to report whether an fcblk (file control
/	block) is necessary and if so what size it should be.
/	this makes it possible for spitbol rather than osint to
/	allocate such a block in dynamic memory if required.
/	the significance of an fcblk , if one is requested, is
/	entirely up to the system interface. the only restriction
/	is that if the fcblk should appear to lie in dynamic
/	memory , pointers to it should be proper pointers to
/	the start of a recognisable and garbage collectable
/	block (this condition will be met if sysfc requests
/	spitbol to provide an fcblk).
/	an option is provided for osint to return a pointer in
/	xl to an fcblk which it privately allocated. this ptr
/	will be made available when i/o occurs later. spitbol
/	places an xnblk or xrblk code in its first field for
/	recognition purposes and this must be allowed for.
/	in the case of an fcblk being requested, the size asked
/	for should allow a 2 byte overhead for block type and
/	length fields. information subsequently stored in the
/	remaining bytes should be collectable (i.e. any
/	apparent pointers into dynamic should be genuine block
/	pointers). these restrictions do not apply if an fcblk
/	is allocated outside dynamic or is not allocated at all.
/	if an fcblk is requested, its fields will be initialised
/	to zero before entry to sysio with the exception of
/	bytes 0 and 1 in which the block type and length
/	fields are placed.
/	in this version if an fcblk is needed it is allocated
/	as an xnblk or xrblk so care may be needed if other uses
/	of such blocks are made. if such a blk is allocated it is
/	pointed to by a trblk chained to the vrblk of the
/	file arg1 (second arg of input or output)
/	of the input() or output() call so that it can
/	subsequently be found for endfile() ,other associations
/	etc. sysfc is passed file arg1 and file arg2 so that it
/	can if desired perform checks on them before deciding
/	whether to request an fcblk. if an fcblk was earlier
/	allocated and pointed to via file arg1, sysfc is also
/	passed a pointer to this fcblk.
/
/	(xl)		ptr to file arg2
/	(xr)		ptr to file arg1
/	(wa)		existing file arg1 fcblk ptr or 0
/	(wb)		0/3 for input/output assocn
/	jsr	pc,sysfc      call to check need for fcblk
/	.word	loc	invalid file argument
/	(wa non zero)	byte size of fcblk to be provided
/	(wa=0,xl non zero)    private fcblk ptr in xl
/	(wa=xl=0)	no fcblk wanted, no private fcblk
/	(wc)		0/1 to request alloc of xrblk/xnblk
/	(wb)		destroyed
/
/	syshs -- give access to host computer features
/
	.globl	syshs		/ define external entry point
/
/	provides means for implementing special features
/	on different host computers. the only defined entry is
/	that where all arguments are null in which case syshs
/	returns an scblk containing name of computer,
/	name of operating system and name of site separated by
/	colons. the scblk need not have a correct first field
/
/	(wa)		argument 1
/	(xl)		argument 2
/	(xr)		argument 3
/	jsr	pc,syshs      call to get host information
/	(xl)		scblk pointer or 0 if unavailable
/
/	sysio -- input/output file association
/
	.globl	sysio		/ define external entry point
/
/	see also sysfc.
/	called in response to snobol4 input or output function
/	call. it is always called after sysfc and jointly with
/	this routine should ensure checking of file arg1 and arg2
/	input and output have 3 arguments referred to as shown
/	input(variable name,file arg1,file arg2)
/	output(variable name,file arg1,file arg2)
/	the exact significance of the two arguments relating to
/	the file is implementation dependent. the scheme used in
/	the earliest implementation is as follows.
/	file arg1 is used as a channel name and file arg2 as an
/	actual file name. a particular file may be attached to a
/	channel either by a job control command or by using a
/	non-null file arg2. once a file has been opened on a
/	channel, further variable names may be associated to it
/	by referring only to the channel name (file arg1).
/	if subsequent associated accesses to the file need an
/	fcblk, a ptr to it is returned in xl.
/
/	(xl)		ptr to file arg2 (3rd arg)
/	(xr)		ptr to file arg1 (2nd arg)
/	(wa)		fcblk ptr (0 if none)
/	(wb)		0 for input, 3 for output
/	jsr	pc,sysio      call to associate file
/	.word	loc	return here if file does not exist
/	.word	loc	return if input/output not allowed
/	(xl)		fcblk pointer
/	(wa,wb,wc)	destroyed
/
/	the second error return is used if the file named exists
/	but input/output from the file is not allowed. for
/	example, the standard output file may be in this category
/	as regards input association.
/
/	sysil -- get input record length
/
	.globl	sysil		/ define external entry point
/
/	sysil is used to get the length of the next input record
/	from a file previously input associated with a sysif
/	call. the length returned is used to establish a buffer
/	for a subsequent sysin call.
/
/	(wa)		ptr to fcblk or zero
/	jsr	pc,sysil      call to get record length
/	(wa)		length or zero if file closed
/
/	no harm is done if the value returned is too long since
/	unused space will be reclaimed after the sysin call.
/
/	note that it is the sysil call (not the sysif call) which
/	causes the file to be opened as required for the first
/	record input from the file.
/
/	sysin -- read input record
/
	.globl	sysin		/ define external entry point
/
/	sysin is used to read a record from the file which was
/	referenced in a prior call to sysil (i.e. these calls
/	always occur in pairs). the buffer provided is an
/	scblk for a string of length set from the sysil call.
/	if the actual length read is less than this, the length
/	field of the scblk must be modified before returning.
/
/	(wa)		ptr to fcblk or zero
/	(xr)		pointer to buffer (scblk ptr)
/	jsr	pc,sysin      call to read record
/	.word	loc	return here if end of file
/	.word	loc	return here if i/o error
/	.word	loc	return here if record format error
/	(wa,wb,wc)	destroyed
/
/	sysld -- load external function
/
	.globl	sysld		/ define external entry point
/
/	sysld is called in response to the use of the snobol4
/	load function. the named function is loaded (whatever
/	this means), and a pointer is returned. the pointer will
/	be used on subsequent calls to the function (see sysex).
/
/	(xr)		pointer to function name (scblk)
/	(xl)		pointer to library name (scblk)
/	jsr	pc,sysld      call to load function
/	.word	loc	return here if func does not exist
/	.word	loc	return here if i/o error
/	(xr)		pointer to loaded code
/
/	the significance of the pointer returned is up to the
/	system interface routine. the only restriction is that
/	if the pointer is within dynamic storage, it must be
/	a proper block pointer.
/
/	sysmb -- move words backwards
/
	.globl	sysmb		/ define external entry point
/
/	sysmb is called to copy an area of memory to a
/	higher address by the mwb instruction if no suitable
/	hardware move instruction is available
/
/	(xl)		pointer past source words
/	(xr)		pointer past target words
/	(wa)		number of words to move
/	jsr	pc,sysmb      call to move words backwards
/	(xl)		updated to point before source
/	(xr)		updated to point before target
/	(wa)		destroyed
/
/	sysmc -- move characters
/
	.globl	sysmc		/ define external entry point
/
/	sysmc is called to move characters in memory by the mvc
/	instruction if there is no suitable hardware instruction.
/
/	(xl)		source characters pointer
/	(xr)		target characters pointer
/	(wa)		number of characters to move
/	jsr	pc,sysmc      call to move characters
/	(xl)		updated past source
/	(xr)		updated past target
/	(wa)		destroyed
/
/	sysmm -- get more memory
/
	.globl	sysmm		/ define external entry point
/
/	sysmm is called in an attempt to allocate more dynamic
/	memory. this memory must be allocated contiguously with
/	the current dynamic data area.
/
/	the amount allocated is up to the system to decide. any
/	value is acceptable including zero if allocation is
/	impossible.
/
/	jsr	pc,sysmm      call to get more memory
/	(xr)		number of additional words obtained
/
/	sysmw -- move words
/
	.globl	sysmw		/ define external entry point
/
/	sysmw is called to move words down in memory by the mvw
/	instruction if there is no suitable hardware instruction.
/
/	(xl)		source words pointer
/	(xr)		target words pointer
/	(wa)		number of words to move
/	jsr	pc,sysmw      call to move words
/	(xl)		updated past source
/	(xr)		updated past target
/	(wa)		destroyed
/
/	sysmx -- get maximum object size
/
	.globl	sysmx		/ define external entry point
/
/	sysmx is called to obtain the maximum size of objects created
/	by spitbol. all created objects must be less than this value.
/
/
/	jsr	pc,sysmx       call to get maximum size of objects
/	(wc)		maximum size
/
/	sysou -- output record
/
	.globl	sysou		/ define external entry point
/
/	sysou is used to write a record to a file previously
/	associated with a sysof call.
/
/	(wa)		ptr to fcblk or zero
/	(xr)		record to be written (scblk)
/	jsr	pc,sysou      call to output record
/	.word	loc	return here if file is full
/	.word	loc	return here if i/o error
/	(wa,wb,wc)	destroyed
/
/	note that it is the sysou call (not the sysof call) which
/	causes the file to be opened as required for the first
/	record output to the file.
/
/	syspi -- print on interactive channel
/
	.globl	syspi		/ define external entry point
/
/	if spitbol is run from an online terminal, osint can
/	request that messages such as copies of compilation
/	errors be sent to the terminal (see syspp). if the approp
/	reply was made by syspp then syspi is called to send such
/	messages to the interactive channel.
/
/	(xr)		ptr to line buffer (scblk)
/	(wa)		line length
/	jsr	pc,syspi      call to print line
/	.word	loc	failure return
/	(xr,wa,wb)	destroyed
/
/	syspp -- obtain print parameters
/
	.globl	syspp		/ define external entry point
/
/	syspp is called once at the start of execution to obtain
/	parameters required for correct printed output format
/	and to select other options. the information given is
/	1.   line length in chars for standard print channel
/	2.   no of lines/page. 0 is preferable for a non-paged
/	device (e.g. online terminal) in which case listing
/	page throws are suppressed and page headers
/	resulting from -title,-stitl lines are kept short.
/	3.   an initial -nolist option to suppress listing unless
/	the program contains an explicit -list.
/	4.   options to suppress listing of compilation and/or
/	execution stats (useful for established programs) -
/	combined with 3. gives possibility of listing
/	file never being opened.
/	5.   option to have copies of errors sent to an
/	interactive channel in addition to standard printer.
/	6.   option to keep page headers short (e.g. if listing
/	to an online terminal).
/	7.   an option to choose extended or compact listing
/	format. in the former a page eject and in the latter
/	a few line feeds precede the printing of each
/	of-- listing, compilation statistics, execution
/	output and execution statistics.
/
/	jsr	pc,syspp      call to get print parameters
/	(wa)		print line length in chars
/	(wb)		number of lines/page
/	(wc)		bits value ....fedcba where
/			a = 1 to send error copy to int.ch.
/			b = 1 means std printer is int. ch.
/			c = 1 for -nolist option
/			d = 1 to suppress compiln. stats
/			e = 1 to suppress execn. stats
/			f = 1 for extended listing format.
/			g = 1 for -noexecute
/
/	syspr -- print line on standard output file
/
	.globl	syspr		/ define external entry point
/
/	syspr is used to print a single line on the standard
/	output file.
/
/	(xr)		pointer to line buffer (scblk)
/	(wa)		line length
/	jsr	pc,syspr      call to print line
/	.word	loc	return here if print limit exceeded
/	(xr,wa,wb)	destroyed
/
/	the buffer pointed to is the length obtained from the
/	syspp call and is filled out with trailing blanks. the
/	value in wa is the actual line length which may be less
/	than the maximum line length possible. there is no space
/	control associated with the line, all lines are printed
/	single spaced. note that null lines (wa=0) are possible.
/
/	the error exit is used for systems which limit the amount
/	of printed output. if possible, printing should be
/	permitted after this condition has been signalled once to
/	allow for dump and other diagnostic information. if this
/	is not possible, execution should be terminated if syspr
/	is called following this condition.
/
/	sysrd -- read record from standard input file
/
	.globl	sysrd		/ define external entry point
/
/	sysrd is used to read a record from the standard input
/	file following a call to sysrl. the buffer provided is an
/	scblk for a string of length set from the sysrl call.
/	if the actual length read is less than this, the length
/	field of the scblk must be modified before returning.
/
/	(xr)		pointer to buffer (scblk ptr)
/	jsr	pc,sysrd      call to read line
/	.word	loc	return here if end of file
/	(xl,wa,wb,wc)	destroyed
/
/	sysrl -- get read length
/
	.globl	sysrl		/ define external entry point
/
/	sysrl is used to get the length of the next input record
/	from the standard input file. the length returned is used
/	to establish a buffer for a subsequent sysrd call.
/
/	(wa)		value xxx from most recent -inxxx
/	jsr	pc,sysrl      call to get read length
/	(wa)		record length
/
/	the value xxx may be used to set maximum size of record
/	to be read if desired.
/	no harm is done if the value returned is too long since
/	unused space will be reclaimed after the sysrd call.
/
/	sysrw -- rewind file
/
	.globl	sysrw		/ define external entry point
/
/	sysrw is used to rewind a file i.e. reposition the file
/	at the start before the first record. the file should be
/	closed and the next read or write call will open the
/	file at the start.
/
/	(wa)		ptr to fcblk or zero
/	(xr)		file arg1
/	jsr	pc,sysrw      call to rewind file
/	.word	loc	return here if file does not exist
/	.word	loc	return here if rewind not allowed
/	.word	loc	return here if i/o error
/
/	systm -- get execution time so far
/
	.globl	systm		/ define external entry point
/
/	systm is used to obtain the amount of execution time
/	used so far since spitbol was given control. the units
/	are described as milliseconds in the spitbol output, but
/	the exact meaning is system dependent. where appropriate,
/	this value should relate to processor rather than clock
/	timing values.
/
/	jsr	pc,systm      call to get timer value
/	(ia)		time so far in milliseconds
/
/	systt -- trace toggle
/
	.globl	systt		/ define external entry point
/
/	called by spitbol function trace() with no args to
/	toggle the system trace switch. this permits tracing of
/	labels in spitbol code to be turned on or off.
/
/	jsr	pc,systt      call to toggle trace switch
/
/	sysul -- unload external function
/
	.globl	sysul		/ define external entry point
/
/	sysul is used to unload a function previously
/	loaded with a call to sysld.
/
/	(xr)		ptr to control block (efblk)
/	jsr	pc,sysul      call to unload function
/
/	the function cannot be called following a sysul call
/	until another sysld call is made for the same function.
/
/	the efblk contains the function code pointer and also a
/	pointer to the vrblk containing the function name (see
/	definitions and data structures section).
/
/	sysxi -- exit to produce load module
/
	.globl	sysxi		/ define external entry point
/
/	sysxi is called with an argument in xr of --
/
/	-1 to create if possible a load module containing only
/	the impure area of memory.
/
/	0  to create if possible a load module from all of memory
/
/	+1 merely to exit to jcl command level if possible,with
/	the effect being system dependent.
/
/	a string giving the character name of a program.
/	if possible, sysxi is to terminate spitbol, then load
/	and enter the named program.
/
/	(xl)		zero/strg length if n is int./strg
/	(xr)		argument n to exit(n)
/	jsr	pc,sysxi      call to exit
/	.word	loc	requested action not possible
/	.word	loc	action caused irrecoverable error
/
/	loading and running the load module or returning from
/	jcl command level causes execution to resume at the point
/	after the error returns which follow the call of sysxi.
/	no return from sysxi is possible if another program
/	is loaded and entered.
/
/	this section contains all symbol definitions and also
/	pictures of all data structures used in the system.
/
	/sec			/ start of definitions section
/
/	definitions of machine parameters
/
cfpza	=	256.		/ number of characters in alphabet
/
cfpzb	=	2		/ bytes/word addressing factor
/
cfpzc	=	2		/ number of characters per word
/
cfpze	=	2		/ maximum digits in real exponent
/
cfpzi	=	1		/ number of words in integer constant
/
cfpzu	=	2048.		/ param (formerly cfpzl) not in use
/
cfpzm	=	65535		/ max positive integer in one word
/
cfpzn	=	16.		/ number of bits in one word
/
cfpzr	=	2		/ number of words in real constant
/
cfpzs	=	5		/ number of sig digs for real output
/
/	define string constant offset
/
/	all string manipulations are performed with respect to
/	a pseudo-address two words behind the start of the string
/	see description of scblk (string constant) to see why.
/
cwofs	=	2		/ offset for string pointers
/
/	definitions of codes for letters
/
chzla	=	'a		/ letter a
chzlb	=	'b		/ letter b
chzlc	=	'c		/ letter c
chzld	=	'd		/ letter d
chzle	=	'e		/ letter e
chzlf	=	'f		/ letter f
chzlg	=	'g		/ letter g
chzlh	=	'h		/ letter h
chzli	=	'i		/ letter i
chzlj	=	'j		/ letter j
chzlk	=	'k		/ letter k
chzll	=	'l		/ letter l
chzlm	=	'm		/ letter m
chzln	=	'n		/ letter n
chzlo	=	'o		/ letter o
chzlp	=	'p		/ letter p
chzlq	=	'q		/ letter q
chzlr	=	'r		/ letter r
chzls	=	's		/ letter s
chzlt	=	't		/ letter t
chzlu	=	'u		/ letter u
chzlv	=	'v		/ letter v
chzlw	=	'w		/ letter w
chzlx	=	'x		/ letter x
chzly	=	'y		/ letter y
chzlz	=	'z		/ letter z
/
/	definitions of codes for digits
/
chzd0	=	'0		/ digit 0
chzd1	=	'1		/ digit 1
chzd2	=	'2		/ digit 2
chzd3	=	'3		/ digit 3
chzd4	=	'4		/ digit 4
chzd5	=	'5		/ digit 5
chzd6	=	'6		/ digit 6
chzd7	=	'7		/ digit 7
chzd8	=	'8		/ digit 8
chzd9	=	'9		/ digit 9
/
/	definitions of codes for special characters
/
/	the names of these characters are related to their
/	original representation in the ebcdic set corresponding
/	to the description in standard snobol4 manuals and texts.
/
chzam	=	'&		/ keyword operator (ampersand)
chzas	=	'*		/ multiplication symbol (asterisk)
chzat	=	'@		/ cursor position operator (at)
chzbb	=	'<		/ left array bracket (less than)
chzbl	=	040		/ blank
chzbr	=	'|		/ alternation operator (vertical bar)
chzcl	=	':		/ goto symbol (colon)
chzcm	=	',		/ comma
chzdl	=	'$		/ indirection operator (dollar)
chzdt	=	'.		/ name operator (dot)
chzdq	=	'"		/ double quote
chzeq	=	'=		/ equal sign
chzex	=	'!		/ exponentiation operator (exclm)
chzmn	=	'-		/ minus sign
chznm	=	'#		/ number sign
chznt	=	'~		/ negation operator (not)
chzpc	=	'%		/ percent
chzpl	=	'+		/ plus sign
chzpp	=	'(		/ left parenthesis
chzrb	=	'>		/ right array bracket (grtr than)
chzrp	=	')		/ right parenthesis
chzqu	=	'?		/ interrogation operator (question)
chzsl	=	'/		/ slash
chzsm	=	';		/ semicolon
chzsq	=	''		/ single quote
chzun	=	'_		/ special identifier char (underline)
chzob	=	'[		/ opening bracket
chzcb	=	']		/ closing bracket
/
/	remaining chars are optional additions to the standards.
/
/	tab characters - syntactically equivalent to blank
/
chzht	=	011		/ horizontal tab
/
/	lower case or shifted case alphabetic chars
/
chzza	=	'A		/ shifted a
chzzb	=	'B		/ shifted b
chzzc	=	'C		/ shifted c
chzzd	=	'D		/ shifted d
chzze	=	'E		/ shifted e
chzzf	=	'F		/ shifted f
chzzg	=	'G		/ shifted g
chzzh	=	'H		/ shifted h
chzzi	=	'I		/ shifted i
chzzj	=	'J		/ shifted j
chzzk	=	'K		/ shifted k
chzzl	=	'L		/ shifted l
chzzm	=	'M		/ shifted m
chzzn	=	'N		/ shifted n
chzzo	=	'O		/ shifted o
chzzp	=	'P		/ shifted p
chzzq	=	'Q		/ shifted q
chzzr	=	'R		/ shifted r
chzzs	=	'S		/ shifted s
chzzt	=	'T		/ shifted t
chzzu	=	'U		/ shifted u
chzzv	=	'V		/ shifted v
chzzw	=	'W		/ shifted w
chzzx	=	'X		/ shifted x
chzzy	=	'Y		/ shifted y
chzzz	=	'Z		/ shifted z
/
/	definitions of implementation dependent values
/
mxdgs	=	cfpze+cfpzs	/ max digits in real number
/
nstmx	=	mxdgs+5		/ max space for real (for +0.e+)
/
/	envi