;;;	/ p o p / u s r / l i b / p o l y . p
;;;	aaron sloman	dec 1977
;;;	the main thing is the operation poly, which uses function
;;;	polyspi.
;;;	see also /pop/lib/poly.p

vars usingpoly; true ->usingpoly;
	;;; controls printing when lib graphic is compiled.

;;;     set origin to be near centre of screen, but not exactly the same point
;;;     each time, to reduce wear on screen:


Uses graphic;
function randnum(num1,num2);
  num1 + random(num2 - num1)
end;
512 + randnum(-20,20) ->gxorigin;
390 + randnum(-15,15) ->gyorigin;

cancel randnum;

1 ->gxscale;
1 ->gyscale;
'origin at centre of screen. scales set to 1\
'.prstring;


function polyspi side inc ang num;
 ;;; draw a polygonal spiral. initial arm length is side. inc is added at each turn.
  ;;; the angle turned (to left) is ang (in degrees). num is the total number of sides.
  ;;; see also operation poly below.
  ;;; in case globals are not right after an interrupt do two jumps
  jumpto(500,500);
 jumpto(0,0); 45 ->heading;
 ;;; move to a location and heading which will cause the centre of the spiral to
  ;;; be near centre of screen (very approximate).
  ;;; but first normalise ang to lie in range 0 to 359
  until ang >= 0 then ang + 360 ->ang close;
  until ang < 360 then ang - 360 ->ang close;
  if ang > 1 then
	jump(side/(2*cos(90 - ang/2)));
  close;
   turn(90 + round(ang/2));
  repeat num times
      draw(side); turn(ang);
      side+inc ->side;
  close;
end;

vars getnumber;		;;;defined below

operation 2 poly;
  ;;; for convenient repeated use of polyspi.
	vars cucharout; gcucharout ->cucharout;
	vars itemin;    incharitem(gcucharin) -> itemin;
	function interrupt;
		vars interrupt; setpop ->interrupt;
		setvdu();
		ppr('\nrestarting poly\n');
		exitto(nonop poly);
	end;

	function errfun;
		syserr();
		interrupt();
	end;
	'type ctrl d when you want to stop'=>
	'Type ctrl x to interrupt and restart poly'=>
   l:
     ;;; enter a function, so that exitto(poly) comes out just before goto l
     lambda;
	  setvdu();
	  polyspi(' initial length	'.getnumber,
		  ' increment		'.getnumber,
		  ' angle to turn		'.getnumber,
		  ' total number of sides '.getnumber,
		  ('thank you' =>),
		  .greset);
	  setvdu();
	  if random(100) > 85 then 'wasnt that pretty ? ' =>
	  elseif random(100) > 80 then 'i preferred your previous effort' =>
	  elseif random(100) > 75 then 'practice makes perfect' =>
	  elseif random(100) > 70 then 'beauty is in the eye of the beholder'=>
	  elseif random(100) > 60 then 'i think ive seen that one before'=>
	  elseif random(100) > 55 then 'beginners luck?' =>
	  elseif random(100) > 60  then  'ugh ' =>
	  close;
     end.apply;
  goto l
end;

function getnumber(string)=>num;
	;;; reads in a number using itemin defined in poly.
	ppr(string);
	until (.itemin ->>num).isnumber then
		if num=termin then
			'bye'=>
			greset(); setvdu(); setpop()
		close;
		ppr('please type a number ')
	close
end;
