/	SUBTITLE	b-prreal.s	Print a real number
/	Written by Steven Hardy on 23rd November 1976
/
sprreal:
	.if	real
	jsr	pc,scheck		/ check conditions
	clr	r1			/ clear pre-point count
	mov	$7.,bprlcnt		/ only eight significant chars!
	mov	(r5)+,r2		/ pop arg to r2
	clr	r3			/ clear -ve flag
	clr	-(sp)			/ mark stack point
	movf	(r2),r0			/ move arg to fr0
	cfcc
	bge	1f			/ br if +ve
	negf	r0			/ negate arg
	inc	r3			/ set -ve flag
1:
	mov	#'0,-(sp)		/ push a leading zero
1:
	cmpf	done,r0			/ is arg > 1.0
	cfcc
	bgt	1f			/ br if so
	divf	dten,r0			/ divide arg by 10.0
	inc	r1			/ increment digit count
	br	1b			/ and loop back
1:
	jsr	pc,4f			/ do pre-point part
	mov	#'.,-(sp)		/ push decimal point
	mov	$6,r1			/ set post-point count
	jsr	pc,4f			/ do post point part
	mov	sp,r1			/ set up for rounding
1:
	cmp	(r1),#'-		/ last digit significant?
	bne	2f			/ br if so
	mov	#'0,(r1)+		/ replace digit by a zero
	br	1b			/ loop back
2:
	cmp	(r1),#'.		/ decimal point?
	bne	1f			/ br if not
	tst	(r1)+
	br	1b			/ ignore decimal point
1:
	mov	(r1),r0			/ last signif digit to r0
	mov	#'0,(r1)+		/ change last digit to zero
	cmp	r0,#'5			/ must we round up?
	blt	3f			/ br if not
1:
	cmp	(r1),#'9		/ current digit a nine?
	bne	2f			/ br if not
	mov	#'0,(r1)+		/ change char to zero
	br	1b			/ continue rounding
2:
	cmp	(r1),#'.		/ current digit decimal point?
	bne	2f			/ br if not
	tst	(r1)+			/ if so ignore it
	br	1b			/ and continue rounding
2:
	add	$2,(r1)			/ increment char
3:
	cmp	(sp),#'0		/ is there a trailing zero?
	bne	1f			/ br if not
	tst	(sp)+			/ remove trailing zero
	br	3b			/ loop back to remove more
1:
	cmp	(sp),#'.		/ stripped to decimal point?
	bne	1f			/ br if not
	mov	#'0,-(sp)		/ add an extra zero then
1:
	clr	-(r5)			/ mark user stack
1:
	mov	(sp)+,-(r5)		/ transfer char from aux to usr stack
	bne	1b			/ loop back if more to go
	tst	(r5)+			/ remove marker
	cmp	(r5),#'0		/ leading zero?
	bne	1f			/ br if not
	cmp	2(r5),#'.		/ next char decimal point?
	beq	1f			/ br if so
	tst	(r5)+			/ remove leading zero
1:
	tst	r3			/ -ve flag set?
	beq	1f			/ br if not
	mov	#'-,-(r5)		/ push minus sign
1:
	tst	(r5)			/ any more chars to print?
	beq	1f			/ br if not
	jsr	pc,sprchar		/ print next char
	br	1b			/ loop back for rest
1:
	tst	(r5)+			/ remove stack marker
	rts	pc			/ and done
4:
	dec	r1			/ decrement count
	bge	1f			/ continue if some to do
	rts	pc			/ othersise return
1:
	modf	dten,r0			/ multiply arg by 10.0 (integer part to r1)
	movfi	r1,r2			/ digit to r2
	add	$'0,r2			/ convert digit to char
	asl	r2			/ convert char to POP11
	inc	r2
	dec	bprlcnt			/ this digit significant?
	bge	1f			/ br if so
	mov	#'-,r2			/ if not replace it by "-"
1:
	mov	(sp),r0			/ control link to r0
	mov	r2,(sp)			/ char onto stack
	mov	r0,-(sp)		/ control link back onto stack
	br	4b			/ loop back if more
	.endif
