/*
 * compile time options
 */

/* #define DUMP */
	/* DUMP is 'normal' debug-on flag */
/* #define DUMPALL */

#ifndef DUMP
#define dump()			/* nothing */
#define	debug_dump()		/* nothing */
#define	dump_line(x,y)		/* nothing */
#define	dump_fake()		/* nothing */
#define	dump_regs()		/* nothing */
#endif

/*
 * incompatibilities between C version 6 and C version 7
 */

#ifdef C7
#define	lnp_cast		(line_t *)
#define gbp_cast		(glob_t *)
#define lbp_cast		(locl_t *)
#define prp_cast		(proc_t *)
#define	iip_cast		(int	*)
#define	chp_cast		(char	*)
#define	int_cast		(int	 )
#endif
#ifndef C7
#define	lnp_cast		/* nothing */
#define	gbp_cast		/* nothing */
#define	lbp_cast		/* nothing */
#define	prp_cast		/* nothing */
#define	iip_cast		/* nothing */
#define	chp_cast		/* nothing */
#define	int_cast		/* nothing */
#endif

#ifdef NC6
#define C7	1
#endif

#ifdef C7
typedef	struct lines		line_t;
typedef	struct loc_label	locl_t;
typedef	struct glob_label	glob_t;
typedef	struct mnems		mnem_t;
typedef	struct procs		proc_t;
typedef	struct fakelt		fake_t;
typedef struct file		FILE;

typedef union {
	int	ad_i;
	locl_t	*ad_lp;
	glob_t	*ad_gp;
	proc_t	*ad_pp;
}	addr_u;

#define	EQ			=
#endif
#ifndef C7
#define	line_t	struct lines
#define	locl_t	struct loc_label
#define	glob_t	struct glob_label
#define	mnem_t	struct mnems
#define	fake_t	struct fakelt
#define	proc_t	struct procs
#define	FILE	struct file

#define addr_u	int
#define	EQ		/* nothing */
#endif

#ifndef CEM
#define	void	int
#endif


#define CCMAGIC		(172|(0<<8))	/* :plain compact code */

#define SAVE_FAKE	(-1)
#define EMPTY_FAKE	ALL
#define ALL		0
#define ANY		(-1)
#define ONLY_REG	(-2)
#define REG_or_STK	(-3)
#define ODD_REG		(-4)
#define FREG		2
#define IREG		1
#define FREE		0
#define ONEFRAME	0
#define TWOFRAMES	1
#define FALSE		0
#define TRUE		1

#define	TEXT		1
#define	DATA		2
#define	BSS		3

#define op_min		0
#define ABSENT		op_nul

/* insert new pdp-opcodes here */
#define	MOV		sp_lmnem+1
#define	TST		sp_lmnem+2
#define	LDCIF		sp_lmnem+3
#define	STCFI		sp_lmnem+4
#define	MOVB		sp_lmnem+5
#define	BIC		sp_lmnem+6
#define	JSR		sp_lmnem+7
#define	CLR		sp_lmnem+8
#define	SOB		sp_lmnem+9
#define	COM		sp_lmnem+10
#define	RTS		sp_lmnem+11
#define	SXT		sp_lmnem+12
#define	ASH		sp_lmnem+13
#define	ASHC		sp_lmnem+14
#define	ASR		sp_lmnem+15
#define	BHI		sp_lmnem+16
#define	BHIS		sp_lmnem+17
#define	BLO		sp_lmnem+18
#define	BLOS		sp_lmnem+19
#define	CFCC		sp_lmnem+20
#define	XOR		sp_lmnem+21
#define	BIS		sp_lmnem+22
#define	ASL		sp_lmnem+23
#define	HALT		sp_lmnem+24
#define	JMP		sp_lmnem+25
#define	BISB		sp_lmnem+26
#define	SETI		sp_lmnem+27
#define	SETL		sp_lmnem+28

#define	REG0		0
#define	REG1		1
#define	REG2		2
#define	MAXFAKE		50
#define	MAXIREG		4
#define	MAXFREG		4
#define	MAXSTRL		18

#define MAXIDENT	8
#define MAXSTRING	200

#define MAXLABEL	701
#define MAXLOCLABEL	301

#define MAXPROC		200
#define MAXROM		1000

#define LOC_PREFIX	'L'
#define GLO_PREFIX	'.'
#define GLO_UNIQUE	'_'
#define PRO_UNIQUE	'_'

struct loc_label {
	int	l_num;
	char	l_status;
	int	l_val;
};

struct glob_label {
	char	g_name[MAXIDENT+1];	/* must be first in structure */
	char	g_status;
/***	int	g_val; */
	int 	*g_rom;
};

/* label status: */
#define DEF		01
#define OCC		02
#define IMP		04
#define EXP		010
#define REL		020
#define	FWD		040

/* glo/loc-lookup requests: */
#define DEFINING	0
#define OCCURRING	1
#define IMPORTING	2
#define EXPORTING	3
#define	FORWARDING	4

struct lines {
	char	instr_num;
	char	type1;
	addr_u	ad;
};

/* type1: */
#define MISSING		0
#define CONST		1
#define PROCNAME	2
#define GLOSYM		3
#define LOCSYM		4
#define PSEUDO		5

struct mnems {
	char	m_name[3];
	char	m_nminis;
	char	m_mbase;
	char	m_nshorties;
	char	m_sbase;
	char	m_obase;
	int	m_flags;
};

/* flagbits of m_flags */
#define MN0		0
#define MNS		01
#define MNL		02
#define MNXYZ		014
#define		MNX	004
#define		MNY	010
#define		MNZ	014
#define MNABCEM		0160
#define		MNA	0020
#define		MNB	0040
#define		MNM	0060
#define		MNC	0100
#define		MNE	0120
#define MNO		0200


struct procs {
	char p_name[MAXIDENT+1];
	char p_status;
/***	int  paramsize;	/* MUST be an int! */
};

/* procs.p_status: */
#define PRO_OCC		0
#define PRO_LCL		1
#define PRO_DFL		2
#define PRO_DFX		3

struct fakelt {	/* definition of the internal fake-frames (pass3) */
	char	type;
	char	flags;
	int	offset;
	int	index;
};

/* flags: */
#define	INT		1
#define	IND		2
#define	OFF 		4	/* indicates: a REG has an offset */
#define	FIC		010
#define	IFC		020
#define	DFC		030
#define	FDC		040
#define	IDC		050
#define	DIC		060
#define	CONV		070

/* type: */
#define	LOCL		1
#define	EXT		2
#define	CONS		4
#define	REG		010
#define	STK		020
#define	ADDREXT		040
#define ADDRLOCL	0100

#define odd(n)		((n)&1)		/* boolean odd function */

#define	NULL		0
#define	EOF		(-1)
#define	BUFSIZ		512

struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};

#ifndef C7
struct {int	ad_i;};
struct {locl_t	*ad_lp;};
struct {glob_t	*ad_gp;};
struct {proc_t	*ad_pp;};
#endif

#define	REALTYPE	float
	/* This program only works for single precision floating point */

#define	LONGTYPE	long
