#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

/*
 * read compact code and fill in tables
 */

int	tabval;

/* These constants are close to sp_cend for fast switches */
#define	INST	256
#define	PSEU	257
#define	ILBX	258
#define	DLBX	259
#define	CSTX	260

int table3(n) int n; {

	switch (n) {
	case sp_ilb1:	tabval = readbyte(); return(ILBX);
	case sp_ilb2:	tabval = readword(); return(ILBX);
	case sp_dlb1:	make_string(readbyte()); return(DLBX);
	case sp_dlb2:	make_string(readword()); return(DLBX);
	case sp_dnam:	inident(); return(DLBX);
	case sp_pnam:	inident(); return(n);
	case sp_cst1:	tabval = readbyte(); return(CSTX);
	case sp_cst2:	tabval = readword(); return(CSTX);
	case sp_cstm:	tabval = -readbyte(); return(CSTX);
	default:	return(n);
	}
}

int table1() {
	register n;

	n = readbyte();
	if ((n <= sp_lmnem) && (n >= sp_fmnem)) {
		tabval = n;
		return(INST);
	}
	if ((n <= sp_lpseu) && (n >= sp_fpseu)) {
		tabval = n;
		return(PSEU);
	}
	if ((n < sp_filb0 + sp_nilb0) && (n >= sp_filb0)) {
		tabval = n - sp_filb0;
		return(ILBX);
	}
	return(table3(n));
}

int table2() {
	register n;

	n = readbyte();
	if ((n < sp_fcst0 + sp_ncst0) && (n >= sp_fcst0)) {
		tabval = n - sp_fcst0;
		return(CSTX);
	}
	return(table3(n));
}

char *inproname() {
	if (table2() != sp_pnam)
		fatal("procname expected");
	return(string);
}

glob_t *getlab(status) {

	if (table2() != DLBX)
		fatal("global label expected");
	return(glolookup(string,status));
}

int getint() {
	if (table2() != CSTX)
		fatal("int expected");
	return(tabval);
}

read_compact() {
	register line_t *lnp,*limit;
	register instr;

	/*
	 * read procedure in compact EM1 code
	 */
	pass = 1;
	end_seen = 0; lnp = line; labelseen = 0;
	limit = &line[oursize->n_lines];
	do {
		last_line = lnp;
		compact_line(lnp);
		/*
		 * process the special cases
		 */
		instr = lnp->instr_num&0377;
		if (instr != op_PSEU) {
			if (instr == op_lin)
				eatlin();
			if((mnemon[instr].m_flags&MNABCEM)==MNB) {
			/* a branch instruction */
				lnp->ad.ad_lp=loclookup(lnp->ad.ad_i,OCCURRING);
				lnp->type1=LOCSYM;
			}
			if (unreachable && lnp->type1!=PSEUDO) {
				lnp->instr_num = ABSENT;
				lnp->type1 = PSEUDO;
			}
			if (instr==op_ret || instr==op_brb || instr == op_brf)
				++unreachable;
		}
		/*
		 * end special cases
		 */
		lnp++;
	} while (!end_seen && lnp < limit);
	if (!end_seen)
		fatal("line table overflow");
	glo2const();
}

compact_line(alnp) line_t *alnp; {
	register line_t *lnp;

	/*
	 * read one "line" of compact code.
	 */

	complines++;
	lnp = alnp;
	curglosym=0;
	switch (table1()) {
	default:
		fatal("unknown instruction byte");	return;
	case INST:
		lnp->instr_num = tabval;
		if ((mnemon[tabval].m_flags&MNXYZ)==MNZ) {
			lnp->type1 = MISSING;
			lnp->ad.ad_i = 0;
			return;
		}
		/*
		 * This instruction should have an opcode, so read it after
		 * this switch.
		 */
		break;
	case DLBX:
		curglosym = glolookup(string,DEFINING);
		even();
		curglosym->g_status =| RELOC;
		curglosym->g_val = databytes+holsize;
		lastglosym = curglosym;
		if (table1() != PSEU)
			fatal("no pseudo after global label");
	case PSEU:
		lnp->instr_num = tabval;
		inpseudo(lnp);
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,DEFINING);
		lnp->type1 = LOCSYM;
		lnp->instr_num = op_lab;
		unreachable = 0;
		++labelseen;
		return;
	}

	/*
	 * Now process argument
	 */

	switch (table2()) {
	default:
		fatal("unknown offset byte");	return;
	case CSTX:
		lnp->ad.ad_i = tabval;
		lnp->type1 = CONST;
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,OCCURRING);
		lnp->type1 = LOCSYM;
		return;
	case DLBX:
		lnp->ad.ad_gp = glolookup(string,OCCURRING);
		lnp->type1 = GLOSYM;
		return;
	case sp_pnam:
		lnp->ad.ad_pp = prolookup(string,OCCURRING);
		lnp->type1 = PROCNAME;
		break;
	}
}

inpseudo(alnp) line_t *alnp; {
	register glob_t *gbp,*gbp1;
	register a;
	proc_t *prptr;
	int b;
	int par1,par2; char *pars;

	/*
	 * get operands of pseudo (if needed) and process it.
	 */

	mark_list(&alnp->ad);
	put_byte_in_list(alnp->instr_num);
	pseumode = 1;
	switch(alnp->instr_num & 0377) {
	case ps_bss:
		a = getint();	/* number of bytes */
		databytes =+ a;
		break;
	case ps_rom:
		++inrom;	/* almost the same as CON */
		if (curglosym && curglosym->g_rom==0)
			curglosym->g_rom = &rom[lastrom];
	case ps_con:
		b = 0;	/* b = stopcondition */
		while(!b) {
			switch(table2()) {
			case CSTX:
				extword(tabval);
				break;
			case ILBX:
				extword(loclookup(tabval,OCCURRING)->l_num);
				break;
			case DLBX:
				extword(glolookup(string,OCCURRING)->g_val);
				break;
			case sp_pnam:
				extword(prolookup(string,OCCURRING)-procdesc);
				break;
			case sp_scon:
				datastring();
				break;
			case sp_rcon:
				datareal();
				break;
			case sp_lcon:
				datalong();
				break;
			case sp_cend:
				b = 1;	/* exit */
				break;
			}
		}
		break;
	case ps_end:
		++end_seen;
		break;
	case ps_eof:
		++end_seen;++eof_seen;
		break;
	case ps_mes:
		switch(getint()) {
		case 0:	ertrap();	break;
		case 1: optimizing = 0;	break;
		case 3: if (regp>=&regvar[MAXREG]) {
				printf("Opt warning: no space for register variable\n");
				regp=regvar;
			}
			outbyte(ps_mes);
			pr_int(3,outbyte);
			pr_int(*regp++ = getint(), outbyte);
			pr_int(getint(),outbyte);
			outbyte(sp_cend);
			end_list();
			alnp->instr_num = ABSENT;
			alnp->type1 = PSEUDO;
			alnp->ad.ad_i = 0;
			pseumode = 0;
			while(table2() != sp_cend)
				;
			return;
		}
		while (table2() != sp_cend)
			;
		break;
	case ps_exc:
		par1 = getint();
		par2 = getint();
		end_list();
		if (par1 == 0 || par2 == 0)
			break;
		if (alnp+par1 >= &line[oursize->n_lines])
			fatal("no room for exchange");
		bmove(chp_cast (alnp-(par1+par2)),
			chp_cast alnp,
			par1 * sizeof *line);
		bmove(chp_cast (alnp-par2),
			chp_cast (alnp-(par1+par2)),
			(par1+par2) * sizeof *line);
		alnp->instr_num = ABSENT;
		alnp->type1 = PSEUDO;
		alnp->ad.ad_i = 0;
		pseumode = 0;
		return;
	case ps_exd:
		gbp = getlab(EXPORT);
		break;
	case ps_ima:
	case ps_imc:
	case ps_fwa:
	case ps_fwc:
		gbp = getlab(IMPORT);
		break;
	case ps_hol:
		holsize = getint();
		for (gbp = &globlabel[oursize->n_glab-1];gbp>=globlabel;gbp--)
			if (gbp->g_status&RELOC)
				gbp->g_val =+ holsize;
		break;
	case ps_let:
		gbp = getlab(DEFINING);
		switch(table2()) {
		default:
			fatal("illegal second parameter of LET");
		case DLBX:
			gbp1=glolookup(string,OCCURRING);
			if (gbp1->g_status&DEFINED)
				tabval=gbp1->g_val;
			else
				error("undefined global in LET",0);
			if (gbp1->g_status&RELOC)
				gbp->g_status =| RELOC;
		case CSTX:
			break;
		}
		gbp->g_val=tabval;
		break;
	case ps_pro:
		pars = inproname();
		par1 = getint();
		par2 = getint();
		prptr = prolookup(pars,DEFINING);
		strcpy(module,prptr->p_name);
		if (makelib && par2) {
			if (write(libfil,"p",1) < 0);
			if (write(libfil,pars,MAXIDENT) < 0);
		}
		unreachable = 0;
		break;
	case ps_fwp:
		prptr = prolookup(inproname(),OCCURRING);
		break;
	default:
		fatal("unknown pseudo");
	}
	alnp->instr_num = op_PSEU;
	alnp->type1=PSEUDO;
	end_list();
	pseumode = 0;
}

make_string(n) {
	string[0] = 255;
	string[1] = (n>>8)|0200;
	string[2] = n&0377;
	string[3] = 0;
}

instring() {
	register a;
	register char *p;

	a=readbyte();
	if(a==255)
		a=readword();
	if(a>MAXSTRING)
		fatal("string too long");
	strlngth=a;
	for(p=string;a--; ) {
		*p++ = readbyte();
	}
	*p++=0;
}

inident() {
	instring();
	string[MAXIDENT] = '\0';
}

datastring() {
	/*
	 * generate data for a string.
	 */
	instring();
	databytes =+ strlngth;
}

datareal() {
	register i;

	/*
	 * copy the string of characters representing a real
	 */
	instring();
	databytes =+ REALSIZE;
}

datalong() {

	instring();
	databytes =+ LONGSIZE;
}
