#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"
#include	"../h/em1.h"
/*
** Determine the exact instruction length & format where possible, and the 
** the upper and lower limits otherwise. Enter limits in labeltable
*/
pass_3()
{
	register line_t	*lnp;
	register locl_t *lbp;
	int	min_l, max_l, format, min_loc, max_loc;
	register mnem_t *mnp;

	pass = 3;
	line_num = 1;
	min_loc = max_loc = 0;
	mrkdepth = 0;
	for (lnp = &line[0] ; lnp <= last_line ; lnp++,line_num++) {
		mnp = &mnemon[lnp->instr_num&0377];
		if (lnp->type1==CONST)
			switch(mnp->m_flags&MNABCEM) {
			case MNB:
				lnp->type1=LOCSYM;
				lnp->ad.ad_lp=loclookup(lnp->ad.ad_i,OCCURRING);
				break;
			case MNE:
				if (holbase != 0)
					if (lnp->ad.ad_i < holsize)
						lnp->ad.ad_i =+ holbase;
					else error("address too big",0);
				break;
		}
		if ((lnp->instr_num&0377) == op_lab) {
			lbp = lnp->ad.ad_lp;
			lbp->l_min = min_loc;
			lbp->l_max = max_loc;
		} else
			lbp = 0;

		determine_props(lnp,&format, &min_l, &max_l);

		if (mrkdepth > 0 && fosterok) {
			if (lbp) fosterok = 0;
			else if ((mnp->m_flags&MNABCEM)==MNB) fosterok = 0;
			else if ((mnp->m_flags&MNABCEM)!=MNM) {
				if (min_l != max_l)
					fatal("Format not known in pass 3");
				switch(format) {
				default:	fatal("Bad format in pass 3");
				case FEN:
				case FES:
				case FEL:	if (ESC>=cutoff) fosterok = 0;
						break;
				case FNN:
				case FNL:	if ((mnp->m_obase&0377)>=cutoff)
							fosterok = 0;
						break;
				case FNS:	if ((mnp->m_sbase&0377)>=cutoff)
							fosterok = 0;
						break;
				case FNM:	if ((mnp->m_mbase&0377)>=cutoff)
							fosterok = 0;
				case F00:	break;
				}
			}
		}

		if(lnp->instr_num!= op_nul && lnp->instr_num!= op_lab) {
			min_loc =+ min_l; max_loc =+ max_l;
			if (min_l == max_l)
			{
				lnp->format = format; lnp->length = min_l;
			}
		} else {
			lnp->format = F00; lnp->length = 0;
		}
	}
	max_bytes = max_loc;
	if (mrkdepth!=0)
		error("more mrk's then cal's",0);
}


/*
** Determine the format that should be used for each instruction,
** depending on its offsets
*/

determine_props(lnp,format, min_len, max_len)
	line_t *lnp;
	int	*format, *min_len, *max_len;
{
	register addr,l;
	int f;
	register mnem_t *mnem;
	char mini,shortie;
	char defined;
	line_t *prevmark;
	int max;

	addr=offset(lnp,&defined);
	if ((l=(lnp->instr_num&0377)) == op_nul) {
		*min_len = *max_len = 0;
		*format = F00;
		return;
	}
	mnem = &mnemon[l];
	switch(mnem->m_flags&MNXYZ) {
	case MN0:	break;
	case MNX:	addr =>> 1;
			break;
	case MNY:	if (addr==1) 
				addr = 0;
			else
				addr =>> 1;
			break;
	case MNZ:	if (mnem->m_flags&MNS) {
				*min_len = *max_len = 2; *format = FEN;
			} else {
				*min_len = *max_len = 1; *format = FNN;
			}
			if (l==op_cas) {
				prevmark=mrkhistory[--mrkdepth];
				if (fosterok && pass==3) {
					if((prevmark->instr_num&0377)==op_mrk)
						prevmark->instr_num=op_mrx;
					else
						prevmark->instr_num=op_mxs;
					fosterok=0;
				}
			} else if (l==op_mrs) {
				if (mrkdepth>=MRKDEPTH)
					fatal("mark nested too deep");
				mrkhistory[mrkdepth++]=lnp;
				fosterok=1;
			}
			return;
	}
	if (mnem->m_flags&MNO)
		mini = (addr >  0 && addr <= mnem->m_nminis);
	else
		mini = (addr >= 0 && addr <  mnem->m_nminis);
	shortie = (addr >= 0 && addr < 256*mnem->m_nshorties);
	switch (mnem->m_flags&MNABCEM) {
	case MN0:
	caseMN0:
	case MNE:
		if (!defined)
			fatal("undefined operand");
		if (mini) {
			l = 1; f = FNM;
		} else if (shortie) {
			if (mnem->m_flags&MNS) {
				l = 3; f = FES;
			} else {
				l = 2; f = FNS;
			}
		} else if (mnem->m_flags&MNL) {
			l = 4; f = FEL;
		} else {
			l = 3; f = FNL;
		}
		break;
	case MNM:
	case MNA:
		if (mrkdepth>=MRKDEPTH)
			fatal("mark nested too deep");
		mrkhistory[mrkdepth++]=lnp;
		fosterok=1;
		goto caseMN0;
	case MNC:
		prevmark=mrkhistory[--mrkdepth];
		if (fosterok && pass==3 && addr<calminis) {
			if ((prevmark->instr_num&0377)==op_mrk)
				prevmark->instr_num=op_mrx;
			else
				prevmark->instr_num=op_mxs;
			fosterok=0;
			f=FNM;l=1;
			break;
		} else
			if (shortie)
				if(mnem->m_flags&MNS) {
					f=FES;l=3;
				} else {
					f=FNS;l=2;
				}
			else
				if(mnem->m_flags&MNL) {
					f=FEL;l=4;
				} else {
					f=FNL;l=3;
				}
		break;
	case MNB:
		if(!defined) {
			/* guess */
			max = abs(lnp - lnp->ad.ad_lp->l_defl)*4;
			/* maximum offset is distance in lines times 4 */
			if (max<mnem->m_nminis) {
				l=1;f=FNM;break;
			} else if(max<mnem->m_nshorties*256) {
				*min_len= (mnem->m_nminis ? 1 : 2);
				*max_len=(mnem->m_flags&MNS ? 3 : 2);
				*format=FNS;
				return;
			} else {
				*min_len= (mnem->m_nminis ? 1 : 2);
				*max_len=(mnem->m_flags&MNL ? 4 : 3);
				*format=FNS;
				return;
			}
		} else
			goto caseMN0;
	}
	*min_len= *max_len= l;
	*format = f;
}


/*
** return estimation of offset
*/
int offset(lnp,defined)
	line_t *lnp;
	char *defined;
{
	register int	type;
	register locl_t	*lbp;
	register glob_t *gbp;

	*defined = 1;
	type = lnp->type1;
	switch(type) {
		default: error("bad type during offset",0);
			 break;
		case CONST:
			return(lnp->ad.ad_i);
		case GLOSYM:
			gbp = lnp->ad.ad_gp;
			if(gbp->g_status&DEF)
				return(gbp->g_val);
			else {
				*defined = 2;	/* extern */
				return(-1);
			}
		case LOCSYM:
			lbp = lnp->ad.ad_lp;
			if(lbp->l_defined)
			switch(pass) {
			default:error("bad pass in offset",0);
			case 3: *defined = 0;
				break;
			case 4:	if(lbp->l_defined == REVERSE)
					return(lbp->l_val-rev_loc);
				return(max_bytes + rev_loc - lbp->l_min);
			case 5:	return(lbp->l_val);
			}
			*defined = 0;
			break;
		case PSEUDO:
			*defined = 0;
			break;
		case PROCNAME:
			return(lnp->ad.ad_pp->p_num);
		case MISSING:
			break;
	}
	return(0);
}
