#

/*
 *	WINDOW VIEWPORT MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

window(xc, yc, xs, ys)
	double xc, yc, xs, ys;
	{

	Gwcx = xc;
	Gwcy = yc;
	Gwsx = xs;
	Gwsy = ys;
	Gwx_left = xc-xs;
	Gwx_right = xc+xs;
	Gwy_bottom = yc-ys;
	Gwy_top = yc+ys;
	Gwv_const();
	GOOD_RETURN;
	}


viewport(xc, yc,xs, ys)
	int xc,yc, xs, ys;
	{

	if(xc-xs >= 0 && xc+xs <= Gvx_right && yc-ys >= 0
				&& yc+ys <= Gvy_top)
		{
		Gvcx = xc;
		Gvcy = yc;
		Gvsx = xs;
		Gvsy = ys;
		Gwv_const();
		}
	   else
		return(Gerror(INVAL_VIEW, xc, yc, xs, ys));
	GOOD_RETURN;
	}


Gwv_const()
	{

	Gsx = Gvsx/Gwsx;
	Gsy = Gvsy/Gwsy;
	Gwvx = -Gwcx*Gsx+Gvcx;
	Gwvy = -Gwcy*Gsy+Gvcy;
	Gwv_mod++;
	}
