#

/*
 *	MEMORY MANAGEMENT MODULE
 */

#include "../gpac.h"
#include "../error_codes.h"


#define SLOP 8

struct blk
	{
	int size;
	struct blk *fptr;
	struct blk *bkptr;
	} Gavail { 0100000, 0, 0};

Ginit_mem(cstart, csize)
	int *cstart;
	int csize;
	{
	register struct blk *first;

	Gavail.fptr = Gavail.bkptr = first = cstart+1;
	first->size = *(cstart+csize-2) = -(csize-2);
	*(cstart) = 0;
	*(cstart+csize-1) = 0;
	first->fptr = first->bkptr = &Gavail;
	Gmem_status = CORE_AVAILABLE;
	}


Gget_blk()
	{
	register struct blk *bblk;
	register *i;

	if((bblk = Gavail.fptr) == &Gavail)
		{
		if(Gmem_status == CORE_FULL)
			ERROR_RETURN;
		Gmem_status = CORE_FULL;
		Gcontrol_status =| SC_FLAG;
		return(Gerror(CORE_FULL_ERR));
		}
	Gavail.fptr = bblk->fptr;
	(bblk->fptr)->bkptr = &Gavail;
	bblk->size = -bblk->size;
	i = bblk;
	*(i+bblk->size-1) = bblk->size;
	return(bblk);
	}


Grel_blk(baddr)
	int *baddr;
	{
	register *ba;
	register struct blk *p;
	register merge;

	ba = baddr;
	merge = 0;
	if(*(ba-1) < 0)		/*  merge to lower area  */
		{
		p = ba+*(ba-1);
		p->size =- *ba;
		ba = p;
		merge++;
		}
	   else
		*ba = -*ba;
	p = ba-(*ba);	/*  -'ve since size already negative  */
	if(p->size < 0)
		{
		if(merge)
			{
			(p->bkptr)->fptr = p->fptr;
			(p->fptr)->bkptr = p->bkptr;
			}
		   else
			{
			(p->bkptr)->fptr = ba;
			(p->fptr)->bkptr = ba;
			ba->fptr = p->fptr;
			ba->bkptr = p->bkptr;
			merge++;
			}
		ba->size =+ p->size;
		}
	if(!merge)
		Gaddbottom(ba);
	Gsortup(ba);
	Gmem_status = CORE_AVAILABLE;
	}

Gsortup(bptr)
	struct blk *bptr;
	{
	register struct blk *bp;
	register struct blk *nbp;
	register *i;

	bp = nbp = bptr;
	while((nbp = nbp->bkptr)->size > bp->size);
	if(nbp != bp->bkptr)
		{
		(bp->bkptr)->fptr = bp->fptr;	/*  unlink bp  */
		(bp->fptr)->bkptr = bp->bkptr;
		bp->fptr = nbp->fptr;		/*  link after nbp  */
		bp->bkptr = nbp;
		nbp->fptr = bp;
		(bp->fptr)->bkptr = bp;
		}
	i = bp;
	*(i-bp->size-1) = bp->size;
	}


Gtrimblk(baddr, wused)
	int *baddr;
	int wused;
	{
	register struct blk *bp;
	register *ba;
	register left;

	ba = bp = baddr;
	if(wused < SLOP)
		wused = SLOP;
	if((left = bp->size-wused) < SLOP)
		return;
	bp->size = wused+2;
	*(ba+bp->size-1) = bp->size;
	bp = ba = ba+bp->size;
	bp->size = -(left-2);
	Gaddbottom(ba);
	Gsortup(ba);
	}


Gaddbottom(bptr)
	struct blk *bptr;
	{
	register struct blk *bp;

	bp = bptr;
	(Gavail.bkptr)->fptr = bp;
	bp->bkptr = Gavail.bkptr;
	bp->fptr = &Gavail;
	Gavail.bkptr = bp;
	}
