#

	/*
	 * CONTROL MODULE FOR GPAC
	 */

#include "../gpac.h"
#include "../error_codes.h"

init(df_size, ink_size, max_segs, font)
	int df_size, ink_size, max_segs;
	char *font;
	{
	register i;
	register *ptr;

	if(Ginit(df_size, ink_size, max_segs, font))
		ERROR_RETURN;
	Gfont = font;
	Ginit_mem(Gfil_start, Gfil_size);
	Gx_beg = Gy_beg  = 0.0;
	Gtransx_beg = Gtransy_beg = 0.0;
	Gx_abs = Gy_abs = 0;
	Gcontrol_status = ERR_FLAG;

	if((i = alloc((max_segs+1)* 6)) == -1)	/*  6 - size of segment table entry  */
		{
		Gerror(ALLOC_ERR, "init");
		exit();
		}
	Gseg_table = i;
	ptr = i;
	for(i = 0; i < 3*(max_segs+1); i++)
		*ptr++ = 0;
	Gmax_segs = max_segs;
	Gcur_start = Gopenseg();
	Gdummy_seg();
	Gfil_start = Gseg_table[0].start_address =
					Gcur_start;
	Gseg_table[0].end_address = Gfil_end =
			Gseg_table[0].back_address =
				Gcloseseg();
	Gstart();
	GOOD_RETURN;
	}


gopen(n)
	int n;
	{

	valid_segment;
	if(Gcontrol_status & SEG_OPEN)
		return(Gerror(MUL_SEGERR, "gopen", n));
	Gcur_seg = n;
	if((Gcur_start = Gopenseg()) != ERROR)
		{
		Gcontrol_status =| SEG_OPEN;
		Gadd_queue(BPOINT, Gx_abs, Gy_abs);	/*  Ensure a moveto at beginning */
		intens(Gintensity);
		colour(Gcolour);
		lwidth(Glwidth);
		GOOD_RETURN;
		}
	   else
		ERROR_RETURN;
	}




gclose()
	{
	register int *end, *addr;
	register struct segment *segp;

	if(Gcontrol_status & SEG_OPEN)
		{
		if(Gfill)
			fillend();
		Gcontrol_status =& ~(SEG_OPEN | SC_FLAG);
		if(Gmem_status & CORE_FULL)
			{
			if(Gcur_start == ERROR)
				return;
			   else
				Gsave_seg();
			}
		   else
			Ggenerate(Gq_ptr);
		if(Gcontrol_status & APPEND_FLAG)
			{
			Gcontrol_status =& ~APPEND_FLAG;
			if(Gseg_table[Gcur_seg].start_address)
				{
				addr = Gnxt_seg(Gseg_table[Gcur_seg].end_address);
				for(segp = Gseg_table; segp <= &Gseg_table[Gmax_segs]; segp++)
					if(segp->start_address == addr)
						break;
				end = Gappendseg(&Gseg_table[Gcur_seg], segp);
				if(Gfil_end == Gseg_table[Gcur_seg].end_address)
					Gfil_end = end;
				segp->back_address = Gseg_table[Gcur_seg].end_address = end;
				GOOD_RETURN;
				}
			   else
				return(Gerror(NOEXIST_ERR, "gclose of append", Gcur_seg));
			}
		   else
			{
			if(Gseg_table[Gcur_seg].start_address)
				delete(Gcur_seg);
			segp = &Gseg_table[Gcur_seg].start_address;
			segp->end_address = Gcloseseg();
			segp->start_address = Gcur_start;
			segp->back_address = Gfil_end;
			Gset_nxtblk(Gfil_end, Gcur_start);
			Gseg_table[0].back_address = Gfil_end = segp->end_address;
			}
		}
	}


delete(n)
	int n;
	{
	register *addr, *naddr;
	register struct segment *segp;
	int *eaddr;

	valid_segment;
	if(Gseg_table[n].start_address == 0)
		return(Gerror(NOEXIST_ERR, "delete", n));
	addr = Gnxt_seg(Gseg_table[n].end_address);
	Gset_nxtblk(Gseg_table[n].back_address, addr);
	for(segp = Gseg_table; segp <= &Gseg_table[Gmax_segs]; segp++)
		if(segp->start_address == addr)
			break;
	segp->back_address = Gseg_table[n].back_address;
	if(Gfil_end == Gseg_table[n].end_address)
		Gfil_end = segp->back_address;

	Gwaitstop();
	eaddr = Gnxt_seg(Gseg_table[n].end_address);
	addr = Gseg_table[n].start_address;
	do
		{
		naddr = Gnxt_blk(addr);
		Grel_blk(addr-1);	/*  get back to start of block  */
		} while((addr = naddr) != eaddr);
	Gseg_table[n].start_address = 0;
	Gcontrol_status =| CLEAR_SCREEN;
	GOOD_RETURN;
	}




finish()
	{

	Gfinish();
	free(Gseg_table);
	}


