#

	/*
	 *	GPAC GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "gw.h"

post(n)
	int n;
	{
	register *addr, i;

	valid_segment;
	if((Gcontrol_status & SEG_OPEN) && (Gcur_seg == n))
		gclose();
	if(Gseg_table[n].start_address)
		{
		addr = i = Gseg_table[n].start_address;
		*addr = gw_xqt | (i+4);
		}
	   else
		return(Gerror(NOEXIST_ERR, "post", n));
	GOOD_RETURN;
	}


unpost(n)
	int n;
	{

	valid_segment;
	if(Gseg_table[n].start_address)
		Gset_nxtblk(Gseg_table[n].start_address, Gseg_table[n].end_address);
	   else
		return(Gerror(NOEXIST_ERR, "unpost", n));
	GOOD_RETURN;
	}
