#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

Gdissa_ink()
	{
	int npts, ncurves, x, y, format, i;
	register *dfptr, *bptr, *vptr;

	if(Gtablet.edge_vec != 0)
		{
		free(Gtablet.edge_vec);
		free(Gtablet.bptr);
		}
	npts = 0;
	ncurves = 0;
	for(dfptr = Gtablet.buf_addr; *dfptr != GW_TERM ; dfptr++)
		switch(*dfptr)
			{
			case GW_SETXY :
				npts++;
				ncurves++;
				dfptr =+ 2;
				break;
			case GW_LONG_FORMAT :
				format = LONG;
				break;
			case GW_MED_FORMAT :
				format = MED;
				break;
			default :
				npts++;
				if(format == LONG)
					dfptr++;
			}
	if((i = alloc((ncurves+1)<<1)) == -1)
		return(Gerror(ALLOC_ERR, "inking"));
	vptr =  Gtablet.edge_vec = i;
	*vptr++ = ncurves;
	if((i = alloc((ncurves+(npts<<1))<<1)) == -1)
		return(Gerror(ALLOC_ERR, "inking"));
	bptr = Gtablet.bptr = i;
	ncurves = 0;
	npts = 0;
	for(dfptr = Gtablet.buf_addr; *dfptr != GW_TERM; dfptr++)
		switch(*dfptr)
			{
			case GW_SETXY :
				if(ncurves != 0)
					*(bptr-2*npts-1) = npts;
				*vptr++ = bptr;
				bptr++;
				ncurves++;
				npts = 1;
				*bptr++ = x = (*++dfptr)+512;
				*bptr++ = y = (*++dfptr)+512;
				break;
			case GW_LONG_FORMAT :
				format = LONG;
				break;
			case GW_MED_FORMAT :
				format = MED;
				break;
			default :
				if(format == LONG)
					{
					x =+ dfptr->ldx;
					y =+ dfptr->ldy;
					dfptr++;
					}
				   else
					{
					x =+ dfptr->mdx;
					y =+ dfptr->mdy;
					}
				*bptr++ = x;
				*bptr++ = y;
				npts++;
			}
	if(ncurves != 0)
		*(bptr-2*npts-1) = npts;
	Gevent.ink_ptr = Gtablet.edge_vec;
	GOOD_RETURN;
	}
