#
/*
 | DU-11 Synchronous interface
 | Now has more modem control. Mainly to xmit sets the RTSend and
 | waits for CR2Send.
 */

#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../buf.h"

int	*DUADDR[]	{0160010, 0};
/* device registers */
struct {
	int	durcsr;	/* receiver status and control */
	char	durbuf;	/* receiver buffer (r) */
	char	durcst;	/* receiver errors */
	int	dutcsr;	/* transmit status register */
	char	dutbuf;	/* transmitter buffer */
};
struct {
	int filler;
	int dupsr;	/* du parameters set register */
};

/*
 | Receiver control & status
 */
#define CLR2SND	 020000
#define CARRIER	 010000
#define RCVACT	  04000
#define STRPSYN	   0400
#define DSIENABL    040
#define SRCHSYN     020
#define RQ2SEND      04
#define DTREADY	     02
#define BUSY	(RCVACT|RQ2SEND)
/*
 | DU 11 options
 */
#define INTSYN	030000	/*060*/
#define B7	04000
#define B8	06000
#define ODDPAR	01000
/*
 | transmit
 */
#define DNA	0100000
#define MSTRST	0400
#define DNAINT	040
#define SEND    020
#define HDUPLX  010
#define IENABLE	0100

#define SYN	026	/* sync character */

/*
 | common stuff of the du11 & ut200
 */
struct du {
	char	du_state;
	char	du_flags;
	char	du_timer;
	char	du_chksm;
	char	*du_ptr;
	int	du_cnt;
	int	du_ccnt;
	int	*du_addr;
	int	du_filler;
	char	*b_addr;
};
/*
 | states
 */
#define IDLE	0
#define READ	1
#define WRITE	2

/*
 | flags
 */
#define TIMO	02	/* timed out */
#define WANT	04	/* req to wake-up */
#define WSND	010	/* waiting to send */
#define WAIT	020	/* another waiting flag */
#define DONE	0200	/* receiver done */


#define DUBSIZE	1202
#define NDU11	1	/* number of DUs */

#define DUPRI	5

char du_buf[NDU11][DUBSIZE];
struct du du11[NDU11];

/*
 | odd parity, SYNC char not presented to the user on receive.
 | Fails if no carrier is present.
 */
duopen(dev) {
	register d, *addr;
	register struct du *du;
	int dutimeout();

	if((d = dev.d_minor & 03) >= NDU11) {
		u.u_error = EIO;
		return;
	}
	du = &du11[d];
	if(du->du_flags) {
		u.u_error = EIO;
		return;
	}
	du->b_addr = du_buf[d];
	du->du_state = IDLE;
	du->du_flags = 0;
	du->du_ptr = du->b_addr;
	addr = DUADDR[d];
	du->du_addr = addr;
	if((addr->durcsr & CARRIER) == 0) {
		u.u_error = EIO;
		return;
	}
	addr->dutcsr= MSTRST;
	addr->dutcsr= HDUPLX;
	addr->dupsr = INTSYN|B7|ODDPAR|SYN;
	addr->durcsr= IENABLE|SRCHSYN|DTREADY|STRPSYN;
	du->du_timer = HZ;
	timeout(dutimeout, du, HZ);
}

/*
 */
duclose(dev) {
	register *addr, d;
	register struct du *du;

	if((d = dev.d_minor & 03) >= NDU11) {
		u.u_error = EIO;
		return;
	}
	du = &du11[d];
	addr = du->du_addr;
	addr->durcsr = 0;
	addr->dutcsr = 0;
	du->du_timer = 0;
	du->du_state = 0;
	du->du_flags = 0;
}

/*
 | waits till a full message is received, or
 | we time out waiting for one.
 | used by non ut200 users.
 */
duread(dev) {
	register struct du *du;
	register d;

	if((d = dev.d_minor & 03) >= NDU11) {
		u.u_error = EIO;
		return;
	}
	du = &du11[d];
	duwait(du);
	if(d = (du->du_ptr - du->b_addr))
		iomove(du, 0, d, B_READ);
}

duwait(adu)
struct du *adu; {
	register struct du *du;

	du = adu;
	spl5();
	if(du->du_state != READ)
	while(du->du_state == WRITE) {
		du->du_flags =| WANT;
		sleep(du, DUPRI);
	}
	du->du_flags =| WAIT;
	spl0();
	while((du->du_flags & (DONE|TIMO)) == 0)
		sleep(du, DUPRI);
	duidle(du);
}

duidle(adu)
struct du *adu; {
	register struct du *du;
	register *addr;

	du = adu;
	addr = du->du_addr;
	spl6();
	du->du_state = IDLE;
	if(du->du_flags & WSND) {
		du->du_flags =^ WSND;
		wakeup(du);
		spl0();
		return;
	}
	du->du_flags =& ~(TIMO|DONE|WAIT);
	addr->durcsr =| SRCHSYN;
	spl0();
}
/*
 */
duwrite(dev) {
	register struct du *du;
	register *addr, d;

	if((d = dev.d_minor & 03) >= NDU11) {
		u.u_error = EIO;
		return;
	}
	du = &du11[d];
	addr = du->du_addr;
	spl5();
	while(du->du_state != IDLE) {
		du->du_flags =| WSND;
		sleep(du, DUPRI);
	}
	du->du_state = WRITE;
	addr->durcsr =| RQ2SEND;
	while((addr->durcsr & CLR2SND) == 0);
	addr->dutcsr =| SEND;
	spl0();
	du->du_ptr = du->b_addr;
	du->du_cnt = min(u.u_count, DUBSIZE);
	iomove(du, 0, du->du_cnt, B_WRITE);
	addr->dutcsr =| IENABLE;
}


/*
 */
durint(dev) {
	register c, *addr;
	register struct du *du;

	du = &du11[dev.d_minor];
	addr = du->du_addr;
	if((addr->durcsr & CARRIER) == 0) {
		du->du_flags =| TIMO;
		wakeup(du);
		return;
	}
	if(du->du_state == IDLE) {
		du->du_state = READ;
		du->du_ptr = du->b_addr;
		du->du_flags =& ~(DONE|TIMO);
	}
	c = addr->durbuf & 0177;
	if(addr->durcst < 0)
		c =| 0200;
	if(c == 0 || (c == 0177)) {
		du->du_flags =| DONE|WANT;
		addr->durcsr =^ SRCHSYN;
	} else
	if(du->du_ptr < &du->b_addr[DUBSIZE])
		*du->du_ptr++ = c;
	if(du->du_flags & WANT) {
		du->du_flags =& ~WANT;
		wakeup(du);
	}
}

/*
 */
duxint(dev)
{
	register struct du *du;
	register addr;

	du = &du11[dev.d_minor];
	addr = du->du_addr;
	if((addr->dutcsr & DNA) && (du->du_cnt))
		if(SW->integ & 010000)
			printf("du dna %o\n", du->du_cnt);
	dustart(du);
}

/*
 | called by the xmitr interrupt routine.
 | sends the next character to be transmitted, or
 | if we have finished, changes the state to idle.
 */
dustart(adu)
struct du *adu; {
	register struct du *du;
	register *addr, c;

	du = adu;
	addr = du->du_addr;
	if(du->du_cnt--) {
		c = *du->du_ptr++;
		if(du->du_cnt == 0) {	/* last char */
			addr->dutcsr =& ~IENABLE;
			addr->dutcsr =| DNAINT;
		}
		addr->dutbuf = c & 0177;
	}
	else {
		addr->dutcsr =& ~DNAINT;
		du->du_cnt = 0;
		addr->dutcsr =& ~SEND;
		addr->durcsr =& ~RQ2SEND;
		duidle(du);
	}
}
/*
 | Count down the DU timer (once per second)
 | if it runs out, it means the other station
 | won't speak.
 */
dutimeout(du)
struct du *du; {
	register *addr;

	addr = du->du_addr;
	if (du->du_timer==0)
		return;
	if(!(addr->durcsr & BUSY) && --du->du_timer == 0) {
		du->du_timer = 10;
		if((du->du_flags & TIMO) == 0) {
			du->du_flags =| TIMO;
			if(du->du_flags & WAIT)
				wakeup(du); else
				duidle(du);
		}
	}
	/*
	 | come back in 1 sec.
	 */
	timeout(dutimeout, du, HZ);
}
