#include	"link.h"
char	*fortlib	"/lib/f4";
char	odtfile[]	"/lib/odt.obj";
char	fdtfile[]	"/lib/fdt.obj";
char	lib[]		"/usr/lib/xxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
char	*digits		"0123456789";
char			*getcore();

main(argc,argv)
int	argc;
char	*argv[];
{
	register int i,j;
	register char *p;
	char *np,c;


	/* establish free core */

	memhigh = (memlow = sbrk(GOBBLE)) + GOBBLE;
	if(memlow == -1)
		ferror("Core exceeded.");


	/* treat initial switches */

	for(i=1;i<argc;i++) {
		p = argv[i];
		if(*p++ != '-')
			break;
		j = *p++;
		j =+ *p++<<8;

		switch(j) {
		
		case 'ls':	flags =| LS;
				break;
		case 'wr':	flags =| WR;
				break;
		case 'no':	flags =| NO;
				break;
		case 'p1':	flags =| P1;
				flags =& ~ID;
				break;
		case 'ns':	flags =| NS;
				break;
		case 'go':	flags =| GO;
				break;
		case 'o=':	objyes = p;
				break;
		case 'm=':	mapyes = p;
				flags =| LS;
				break;
		case 'cr':	flags =| CR | LS;
				crefstr = p;
				break;
		case 'id':	flags =| ID;
				flags =& ~P1;
				break;
		case 'nl':	flags =| NL;
				break;
		case 'od':	flags =| OD | P1;
				break;
		case 'ov':	flags =| OV | GO;
/*-------------------------------------------------??-----------*/
				break;
		default:	goto out;

		}
	}


	/* stash rest of args */

out:
	if ((flags & (OV|ID)) == (OV|ID))
		ferror("Illegal combination of switches");
	filec = argc - i;
	filev = &argv[i];
	for(i = 0; i < filec; i++) 
		if(*filev[i] != '-') {
			firstfile = filev[i];
			if (flags & OV)
				/*
				 * increment to enable comparison with wfile
				 * in opn_next()
				 *
				 * also, if not overlay, 0 can't match
				 */
				odfno = i+1;
			break;
		}
	if(firstfile == NIL)
		exit(0);

	nreg = 1;
	nseg = 1;
	if (flags & OV) {
		if ((odf = open(ext(firstfile, ".odf"), 0)) < 0)
			if ((odf = open(firstfile, 0)) < 0)
				ferror("Can't open odf");
		/*
		 * check syntax of odf;
		 * find number of segments and regions
		 */
		checkodf();

		/* allocate tables etc. */

		if (nreg > 1) {
			(*psrtable) = getcore((nreg-1) * SREG);
			(*psstable) = getcore((nseg-1) * SSEG);
			(*segtadr) = ovslcode;
			(*auttadr) = ovslcode + (nseg-1)*SSEG;
		}
	}
	(*segwk) = getcore(nseg * (sizeof (*segwk)[0]));

	list_init();
	/* linker proper */

	pass1();
	pass++;
	pass2();
	load_map();
	flush();

	/*
	 *	if cross reference, close pipe to cref-er,
	 * then wait for it to complete
	 */

	if(flags&CR) {
		close(crfile);
		wait(&crfile);
	}

	if(errcnt) {
		if(flags & LS) {
			printf("Errors detected: %d\n",errcnt);
			flush();
			close(fout);
		}
		fout = 2;
		printf("Errors detected: %d\n",errcnt);
	}
	flush();
	exit(errcnt != 0);
}


list_init()
{
	register int outchan;
	register int i;
	int pargs[2];
	char *ss1,*ss2;

	ss1 = "x";
	ss2 = "x";

	fout = 1;
	if(flags&LS) {
		outchan = mapyes ? (*mapyes ? creat(mapyes,0600) : dup(1) ) : creat(ext(firstfile,".map"),0600);
		if(outchan == -1)
			ferror("Cannot create map file.");
		fout = outchan;
	}

	if(flags&CR) {
		if((i = pipe(pargs)) == -1) {
			printf("Unable to cref?\n");
			flags =& ~CR;
			return;
		}
		switch(fork()) {

		case 0:	crfile = pargs[1];
			close(pargs[0]);
			break;
		
		case -1:	
			printf("Unable to fork?\n");
			flags =& ~CR;
			return;
	
		default:
			close(pargs[1]);
			*ss1 = digits[pargs[0]];
			*ss2 = digits[outchan];
			execl("/bin/crefer","-",crefstr,ss1,ss2,0);
			exit(2);
		}
	}
}

char *ext(s1,s2)
char *s1,*s2;
{
	register char *r1,*r2,*r3;
	static char ss[60];
	char *w;

	w = NIL; r1 = s1; r2 = s2; r3 = ss;
	while(*r3 = *r1++) {
		if(*r3 == '/') w = NIL;
		if(*r3++ == '.') w = r3;
	}
	if(w) {r3 = w; --r3;}
	while(*r3++ = *r2++);
	return(ss);
}
ferror(s)
char *s;
{
	flush();
	close(fout);
	fout = 2;
	printf("%s\n",s);
	flush();
	exit(1);
}

/* pass 1 -
 *	read in all files, analyzing only the GSD sections
 *	set up library searches
 *	At the end of the pass, address are assigned.
 *************************????????????????????
 *	Also, since overlays are not implemented, the
 *	gbl/lcl distinction is ignored
 */

pass1()
{
	register int t;
	register *rr1,*rr2;
	int	libflag;
	int	radbuf[2];
	int	islib;
	unsigned int	j;


	libpnt = libuse;
	libflag = 0;
	islib = 0;

	init_in();

	(*segwk)[0].segreg = 0;		/* initialised to this anyway! */

	while(t=getrec())
	switch(t) {

	/* end of gsd.  skip file to EMOD,  and reset library flag */
	case ESD:
		slewto(EMOD);
		libflag = 0;
		break;

	/* library indicator. the remainder of the record is a list of
 	 * radix 50 names which this module claims to declare. If any of
	 * them are undefined,  the module is read in. Otherwise, it is
	 * skipped. 
	 */

	case LMOD:
		libflag++;
		islib++;
		while(t=movbyte(radbuf,4)) {
			rr2 = gsearch(radbuf);
			if(rr2 != NIL && (rr2->gflags&(DEF|EXC)) == 0)
				break;
		}
		if(t==0)
			break;
		libflag = 0;
		*libpnt++ = 1;
		slewto(GSD);

	/* fall through to GSD processor.  This is the main job during
	 * this pass. Each module has a string of psects which it
	 * declares. Each of these has a low limit and high limit for
	 * relocation purposes during pass ; right now the low-limit 
	 * is set to the offset from the start of the base psect,
	 * and the high limit to the size of the psect (in bytes).
	 * Each psect also has an associated string of global symbols
	 * which it declares. A list of undefined globals is also
	 * set up for library search.  Perhaps this list will eventually
	 * be optimized for a better search.
	 */

	case GSD:
		if(libflag) {
			libflag = 0;
			slewto(EMOD);
			*libpnt++ = 0;
			break;
		}

		while((t=getgsd())>=0)
		switch(t) {

		case MDN:
			rr1 = getcore(SMOD);
			if(curmod == NIL)
				(*segwk)[segment].segmod = rr1;
			else
				curmod->mpnt = rr1;
			curmod = rr1;

			rr1->mname[0] = gsdent.nm[0]; rr1->mname[1] = gsdent.nm[1];
			rr1->mversion[0] = 0; rr1->mversion[1] = 0;
			rr1->mislib = islib;
			islib = 0;
			break;

		case PVI:
			curmod->mversion[0] = gsdent.nm[0];
			curmod->mversion[1] = gsdent.nm[1];
			break;

		case CSN:
			if(gsdent.fbyte & REL) {
				if(gsdent.nm[0] == 0)
					gsdent.fbyte = DEF | REL;
				else
					gsdent.fbyte = DEF | REL | OVR | GBL;
			} else
				gsdent.fbyte = DEF | OVR | GBL;

			/* the default attributes have been set up.
			 * Now fall through & treat it as a psect
			 */

		case PSN:
			gsdent.val = (gsdent.val + 1) & ~1;
			if (segment>0 && !(gsdent.fbyte & (OVR|COM))) {
				gsdent.fbyte =& ~(SHR|INS|BSS);
				psectq = &(*segwk)[segment].segpsect;
			} else
				psectq = &psecthead;
			rr1 = psearch(gsdent.nm);
			if(rr1 == NIL) {
				rr1 = getcore(SPSECT);
				rr1->pname[0] = gsdent.nm[0];
				rr1->pname[1] = gsdent.nm[1];
				rr1->pflags = gsdent.fbyte & 0377;
/* rr1	psect	*/
/* rr2	psectl	*/
				if (psectq != &psecthead) {
					rr1->pflags =| OVLY;
					if (psecte == NIL)
						*psectq = rr1;
					else
						psecte->ppnt = rr1;
					psecte = rr1;
				} else {
				if(psecttail == NIL)
					psecthead = rr1;
				else
					psecttail->ppnt = rr1;
				psecttail = rr1;
				}
			}
			else if (t = (gsdent.fbyte ^ rr1->pflags) & (INS|BSS|REL|OVR)) {
				printf("Warning: psect attributes vary in module <");
				radout(curmod->mname);
				printf(">, psect <");
				radout(rr1->pname);
				printf(">\n");
			}
			
			/* check for name already existing. If it is
			 * found, just fix length 
			 */
	
			for(rr2 = curmod->mpsl;rr2 != NIL;rr2 = rr2->pll)
				if(rr2->plp == rr1 ) 
					goto psn1;
	
			rr2 = curmod->mpsl;

			if(rr2 == NIL)
				rr2 = curmod->mpsl = getcore(SPSL);
			else {
				while(rr2->pll != NIL )
					rr2 = rr2->pll;
				rr2 = rr2->pll = getcore(SPSL);
			}
			rr2->plp = rr1;
		psn1:	if(rr1->pflags & OVR) {
				rr2->llimlow = 0;
				rr1->plimlow = max(rr1->plimlow,gsdent.val);
			} else {
				rr2->llimlow = rr1->plimlow;
				rr1->plimlow =+ gsdent.val;
			}
			if((rr1->pflags & BSS) && !(gsdent.fbyte & BSS))
				rr1->pflags =& ~BSS;
			rr1->pflags =| (gsdent.fbyte & COM);
			rr2->llimhigh = gsdent.val;
			cursec = rr2;
			break;

		case TRA:
			if (!(gsdent.val & 1)) {
				psectq = &psecthead;
				if (trmod != NIL) {
					if (odtyes) {
						odpsect = psearch(gsdent.nm);
						odadrs = gsdent.val;
						odmod = curmod;
						break;
					}
					printf("Mult. start address in <");
					radout(trmod->mname);
					printf("> & <");
					radout(curmod->mname);
					printf(">\n");
					errcnt++;
					break;		/* ignore it */
				}
				trpsect = psearch(gsdent.nm);
				tradrs = gsdent.val;
				trmod = curmod;
			}
			break;

		case GSN:
			rr2 = getglo(gsdent.nm);
			if( !(gsdent.fbyte & DEF)) {
				crefout(gsdent.nm,0);
				if (nseg > 1) {
					if (rr2->gflags & DEF) {
						if (rr2->gsegment!=0 && rr2->gsegment!=segment)
							autovec(rr2);
					} else if (rr2->gsegment == 0)
						rr2->gsegment = segment==0 ? -1 : segment;
					else if (rr2->gsegment != segment)
						rr2->gsegment = -1;
				}
				break;
			}
			if(rr2->gflags & DEF)
				if(!(gsdent.fbyte & COM)) if(
				(rr2->gpsectl->plp != cursec->plp ||
				 (rr2->gflags & REL) != (gsdent.fbyte & REL) ||
				 (rr2->gflags & REL) ?
					rr2->gvalue + rr2->gpsectl->llimlow != gsdent.val + cursec->llimlow :
					rr2->gvalue != gsdent.val)) {
				printf("Mult. def : <");
				radout(gsdent.nm);
				printf("> in <");
				radout(cursec->plp->pname);
				printf("> in <");
				radout(curmod->mname);
				printf(">\n");
				errcnt++;
				break;		/* ignore it */
			}
			if((rr2->gflags & DEF) && (gsdent.fbyte & COM))
				break;
			crefout(gsdent.nm,1);
			rr2->gflags = gsdent.fbyte & 0377;
			rr2->gvalue = gsdent.val;
			rr2->gpsectl = cursec;
			if (nseg > 1) {
				if (rr2->gflags & REL) {
					if (segment>0 && rr2->gsegment!=0 && rr2->gsegment!=segment)
						autovec(rr2);
					rr2->gsegment = segment;
				} else
					rr2->gsegment = 0;
			}
			rr1 = getcore(SGLOBL);
			rr1->gglp = cursec->plg;
			cursec->plg = rr1;
			rr1->glp = rr2;
		
		}	/* end of GSD type switch */
	}		/* end of RECORD type switch */

	if (!(flags & NS))
		msym = nsym;	/* get it before "end" etc. get added */

	/*
	 * The root segment is actually segment 0, so
	 * make the listhead show it.
	 */
	(*segwk)[0].segpsect = psecthead;

	if (nseg > 1) {
		/*
		 * Allocate the auto-load vector
		 */
		(*autotab) = getcore(nauto * SLINK);

		/*
		 * Position overlay startup and $load code
		 * at bottom of text region; also place the
		 * runtime segment table there.
		 */
		txtsize = ovslcode + ((nseg-1)*SSEG) + (nauto*SLINK);
	}

	/* a pass is now made through core resident
	 * data to define all addresses
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt) {
		if((rr1->pflags & COM) && getglo(rr1->pname)->gpsectl->plp != rr1) {
			rr1->pflags =| CMX;
			rr1->plimlow = 0;
		}
		if(rr1->pflags&SHR) {
			t = rr1->plimlow;
			rr1->plimlow = txtsize;
			txtsize =+ t;
			rr1->plimhigh = txtsize;
			if (rr1->plimhigh < rr1->plimlow)
				ferror("Text area overflow");
		}
	}

	/* if there is no shareable segment,  the
	 * data segment begins at zero.  If the P1
	 * option is in effect,  the shr segment is
	 * really private,  and is immediately followed
	 * by data. Otherwise, the data segment is rounded
	 * up to the next 8K byte boundary
	 */

	if((flags&P1) || txtsize == 0)
		datstart = txtsize;
	else
		datstart = (txtsize + 017777) & ~017777;
	if(flags & ID)
		datstart = 0;

	if (nseg > 1)
		/*
		 * Position the r/w part of the overlay startup
		 * and $load code at bottom of data region.
		 */
		datsize = ovplcode;
	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags&(BSS|SHR|REL))==REL) {
			t = rr1->plimlow;
			rr1->plimlow = datstart + datsize;
			datsize =+ t;
			rr1->plimhigh = datstart + datsize;
			if (rr1->plimhigh < rr1->plimlow)
				ferror("Data area overflow");
		}

	ovrstart = datstart + datsize;

	if (nseg > 1)
		/*
		 * Relocate the overlay region part of the overlay
		 * segments.
		 */
		calcov1();

	bssstart = ovrstart + ovrsize;

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags)&BSS) {
			t = rr1->plimlow;
			rr1->plimlow = bssstart + bsssize;
			bsssize =+ t;
			rr1->plimhigh = bssstart + bsssize;
			if (rr1->plimhigh < rr1->plimlow)
				ferror("BSS area overflow");
		}

	/* Now the psectl list is searched,  and the sub-psects
	 * are relocated.  Also,  absolute values are given
	 * to all relocatable global symbols
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if(rr1->pflags & CMX) {
			rr2 = getglo(rr1->pname);
			rr1->pflags = (rr2->gpsectl->plp->pflags & (SHR|INS|BSS|DEF|REL)) | OVR | COM;
			rr1->plimhigh = rr1->plimlow = rr1->gflags & REL ?
				rr1->gvalue + rr1->gpsectl->llimlow :
				rr1->gvalue;
		}
	for (j = 0; j < nseg; j++)
	for (t = (*segwk)[j].segmod; t != NIL; t = t->mpnt)
		for(rr2 = t->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr2->llimlow =+ rr2->plp->plimlow;
			rr2->llimhigh =+ rr2->llimlow;
			for(rr1 = rr2->plg; rr1 != NIL; rr1 = rr1->gglp)
				if(rr1->glp->gflags&REL)
					rr1->glp->gvalue =+ rr2->llimlow;
		}
	if (trmod != NIL)
		for (rr1 = trmod->mpsl; rr1 != NIL; rr1 = rr1->pll)
			if (rr1->plp == trpsect) {
				tradrs =+ rr1->llimlow;
				break;
			}
	if (odtyes) {
		for (rr1 = odmod->mpsl; rr1 != NIL; rr1 = rr1->pll)
			if (rr1->plp == odpsect) {
				odadrs =+ rr1->llimlow;
				break;
			}
		radixin("o.link", radbuf);
		rr1 = getglo(radbuf);
		rr1->gflags = GBL|DEF;
		rr1->gvalue = tradrs;
		tradrs = odadrs;
	}

	radixin("end", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = bssstart + bsssize;
		rr1->gflags =| DEF;
	}
	radixin("etext", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = txtsize;
		rr1->gflags =| DEF;
	}
	radixin("edata", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = datstart + datsize;
		rr1->gflags =| DEF;
	}

	if (nseg > 1) {
		/*
		 * Relocate the overlay routines and calculate
		 * the entry point address
		 */
		if (tradrs == 0)
			tradrs = ovslcode + ((nseg-1)*SSEG) + (nauto*SLINK);
		setovcode(0, datstart, tradrs);
		tradrs = 0;

		/*
		 * Fix up the auto-load table
		 */
		calcov2();
	}
}			/* end of pass1 */

/*
 * Enter another entry-point into the auto-load
 * list.
 */
autovec(gp)
register struct global	*gp;
{
	struct globall		*autn;

	if (!(gp->gflags & AUTO)) {
		gp->gflags =| AUTO;
		autn = getcore(SGLOBL);
		autn->glp = gp;
		autn->gglp = autolist;
		autolist = autn;
		nauto++;
	}
}

/*
 * Performs all calculations for addressing the overlay
 * regions: link time relocation; link time file addressing;
 * and runtime addressing.
 */
calcov1()
{
	register unsigned int		i;
	register struct psect		*pp;
	char				*base;
	unsigned int			bigseg;
	unsigned int			len;
	unsigned int			mlen;
	unsigned int			mmlen;
	unsigned int			l;
	unsigned int			regn;
	unsigned int			fofset;
	long				lfofset;
	extern long			itol();

	/*
	 * Find length of all overlay segments
	 * and maximum length of regions.
	 * Find size of overlay area of memory.
	 * Relocate all overlaid psects.
	 * Also, the number of the largest region.
	 */
	regn = 0;
	bigseg = 0;
	base = ovrstart;
	mlen = 0;
	mmlen = 0;
	for (i = 1; i < nseg; i++) {
		if ((*segwk)[i].segreg != regn) {
			base =+ mlen;
			ovrsize =+ mlen;
			mlen = 0;
			regn = (*segwk)[i].segreg;
			(*psrtable)[regn-1] = base;
		}
		len = 2;	/* leave room for segment table pointer */
		for (pp = (*segwk)[i].segpsect; pp != NIL; pp = pp->ppnt) {
			l = pp->plimlow;
			pp->plimlow = base + len;
			len =+ l;
			pp->plimhigh = base + len;
			if (pp->plimhigh < pp->plimlow)
				ferror("Overlay area overflow");
		}
		(*psstable)[i-1].segsiz = len;
		if (len > mlen) {
			mlen = len;
			if (len > mmlen) {
				mmlen = len;
				bigseg = i;
			}
		}
	}
	ovrsize =+ mlen;

	/*
	 * Calculate the file addresses of the overlay
	 * segments; all offsets are rounded up to the
	 * next (2**ROUND) byte boundary and then divided
	 * by (2**ROUND).
	 */
	lfofset = 16;	/* size of header */
	lfofset =+ txtsize;
	lfofset =+ datsize;
	if (!(flags & NS))
		lfofset =+ msym*12;
	lfofset =+ ROUNDX;
	fofset = lfofset>>ROUND;
	for (i = 1; i < nseg; i++)
		if (i != bigseg) {
			(*psstable)[i-1].segfadr = fofset;
			fofset =+ ((*psstable)[i-1].segsiz + ROUNDX)>>ROUND;
		}
	/*
	 * Place largest segment last in file so as to
	 * reduce likelyhood of not being able to seek
	 * the beginning of any segment.
	 */
	(*psstable)[bigseg-1].segfadr = fofset;
	flast = fofset + (((*psstable)[bigseg-1].segsiz - 1) >> ROUND);
}

/*
 * Fix the auto-load vector table.
 */
calcov2()
{
	unsigned int		i;
	struct globall		*glp;
	struct global		*gp;
	struct link		*lnkp;

	for (i = 0, lnkp = (*autotab), glp = autolist; i < nauto; i++, lnkp++, glp = glp->gglp) {
		gp = glp->glp;
		lnkp->kjsr[0] = 04537;	/* jsr r5,*$x */
		lnkp->kjsr[1] = ovlink;	/* $load entry point */
		/* region */
		lnkp->kregadr = (*psrtable)[(*segwk)[gp->gsegment].segreg - 1];
		/* segment table entry */
		lnkp->ksegptr = &(*segtadr)[gp->gsegment-1];
		lnkp->kentry = gp->gvalue;	/* get value */
		gp->gvalue = i;
	}
}

radout(p)
int *p;
{
	char rasc[6];
	radcon(p,rasc);
	printf("%.6s",rasc);
}

max(a1,a2)
char *a1,*a2;
{
	return(a1 > a2 ? a1 : a2);
}
radixin(s,p)
char *s;
int *p;
{
	register int r50,cc;
	register char c;
	int w;
	w = 2;
	do {
		r50 = 0;
		cc = 3;
		do {
			if(c = *s)
				s++;
			r50 =* 050;
			if(c == ' ' || c == 0)
				continue;
			if(c >= 'a' && c <= 'z') {
				r50 =+ c - 'a' + 1;
				continue;
			}
			if(c == '$') {
				r50 =+ 27;
				continue;
			}
			if(c == '.') {
				r50 =+ 28;
				continue;
			}
			if (c>='A' && c<='Z') {
				r50 =+ c - 'A' + 1;
				continue;
			}
			if (c == '_') {
				r50 =+ 29;
				continue;
			}
			if (c>='0' && c<='9') {
				r50 =+ c - '0' + 30;
				continue;
			}
			printf("illegal radix50 character : %c\n", c);
		} while(--cc);
		*p++ = r50;
	} while(--w);
	if (*s != '\0')
		printf("Warning: radix50 string too long\n");
/*	s is a load of rubbish at this point!! */
}


char *getcore(n)
int n;
{
	register char *w;
	while(memhigh - memlow <= n) {
		if(sbrk(GOBBLE) == -1)
			ferror("Core exceeded.");
		memhigh =+ GOBBLE;
	}
	w = memlow;
	memlow =+ n;
	return(w);
}



/* initialize input; called from both passes */

init_in()
{
	if (flags & OV) {
		seek(odf, 0, 0);
		peekc = 0;
	}
	region = 0;
	segment = 0;
	wfile = 0;
	opn_next();
}


getgsd()
{
	if(movbyte(&gsdent,sizeof gsdent))
		return(gsdent.gtype);
	return(-1);
}



struct psect *psearch(s)
int *s;
{
	register struct psect *rp;

	for (rp = *psectq; rp != NIL; rp = rp->ppnt)
		if(rp->pname[0] == s[0] && rp->pname[1] == s[1])
			return(rp);
	return(NIL);
}

load_map()
{
	register char *rr1,*rr2,*rr3;
	int ff, fg;
	long tvec;
	extern long time();
	unsigned int	j;
	long	lwork;

	if((flags&LS) == 0)
		return;

	tvec = time();
	printf("\n\nLoad map UNIX linker	%s\n",ctime(tvec));
	if(flags & ID)
		printf("I/D space separated\n");
	else if((flags&P1)|| (txtsize==0))
		printf("No shareable segment\n");

	printf("text limit: %6.6o",txtsize);
	if((flags & ID) == 0)
		printf(" (%6.6o)",datstart);
	printf("\n");
	printf("data limit: %6.6o\n", ovrstart);
	if (nseg > 1)
		printf("ovly limit: %6.6o\n", bssstart);
	printf("bss  limit: %6.6o\n", bssstart+bsssize);
	if (nseg > 1) {
		printf("Overlay information:\tAddress\tSize\n");
		printf("  r/o handler\t\t%6.6o\t%6.6o\n", 0, ovslcode);
		printf("  r/w handler\t\t%6.6o\t%6.6o\n", datstart, ovplcode);
		printf("  Segment table\t\t%6.6o\t%6.6o\n", (*segtadr), (nseg-1)*SSEG);
		printf("  autoload vectors\t%6.6o\t%6.6o\n\n", (*auttadr), nauto*SLINK);
	}


	for (j = 0; j < nseg; j++) {
		if (j > 0) {
			printf("<<<<<<<<<<<<<<<<<<<< Region %u., Segment %u. >>>>>>>>>>>>>>>>>>>>\n", (*segwk)[j].segreg, j);
			lwork = (*psstable)[j-1].segfadr;
			lwork =<< ROUND;
			printf("  [ File offset %D.; Size %u. ]\n", lwork, (*psstable)[j-1].segsiz);
		}
	for (rr1 = (*segwk)[j].segmod; rr1 != NIL; rr1 = rr1->mpnt)
	if(((flags&NL)==0) || (rr1->mislib == 0)) {
		printf("**********\nModule\t");
		radout(rr1->mname);
		putchar('\t');
		radout(rr1->mversion);
		putchar('\n');
		printf("Section\t\tAddress\tSize\n");
		for(rr2 = rr1->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr3 = rr2->plp;
			putchar('<');
			radout(rr3->pname);
			printf(">\t%6.6o\t%6.6o\t",rr2->llimlow,rr2->llimhigh - rr2->llimlow);
			rr3 = rr3->pflags;
			if (rr3 & OVLY)
				printf("[overlay] ");
			printf("%s,%s,%s,%s\n",
				(rr3&SHR) ? "shr" : (rr3&BSS) ? "bss" : "prv" ,
				(rr3&REL) ? "rel" : "abs",
				(rr3&OVR) ? "ovr" : "con",
				(rr3&GBL) ? "gbl" : "lcl");
			ff = 3;
			for(rr3 = rr2->plg; rr3 != NIL; rr3 = rr3->gglp) {
				putchar('\t');
				radout(rr3->glp->gname);
				if (rr3->glp->gflags & AUTO) {
					fg = rr3->glp->gvalue;
					printf("\t%6.1o(%.1o)", &(*auttadr)[fg], (*autotab)[fg].kentry);
				} else
				printf("\t%6.6o\t",rr3->glp->gvalue);
				if(--ff == 0) {
					ff = 3;
					printf("\n");
				}
			}
			if(ff != 3)
				printf("\n");
		}
	}
	}
}


opn_next()
{
	register char *rp,*rq;
	register int j;
	char c;
	int k;
	char symnmm[6];
	char	*suf;

	objbuf.fildes = -1;
opn1:	if (wfile > filec)
		return(0);
	if (wfile == filec)
		if (flags & OD) {
			rp = odtfile;
			wfile++;
			odtyes = 1;
			goto opn2;
		} else
			return(0);
	rp = rq = filev[wfile++];
	k = 0;
	suf = ".obj";
	if(*rq++ == '-') 
	switch(*rq++) {
	
	case 'f':	rp = fortlib;
			if (*rq == 'd')
				/* -fd[t] */
				rp = fdtfile;
			break;
	case 'e':	k = 1;
	case 'i':	if(*rq++ == ':') {
				j = 6;
				rp = symnmm;
				while(j && (c = *rq++)) {
					*rp++ = c;
					j--;
				}
				if(j)
					*rp++ = 0;
				radixin(symnmm,gsdent.nm);
				rp = getglo(gsdent.nm);
				if(k)
					rp->gflags =| EXC;
				else
					rp->gflags =& ~EXC;
				goto opn1;
			}
			goto dflt;
	case 'l':	if (*rq++ == ':') {
				for (rp = &lib[9]; (*rp++ = *rq++) != '\0';);
				suf = ".olb";
				rp = &lib[4];
				break;
			}
	dflt:
	default:	ferror("Bad switch");

	}
	else if (wfile == odfno) {
		/* get next argument from odf if any left */
		if ((rq = getnext()) != NIL) {
			wfile--;
			rp = rq;
		} else
			goto opn1;	/* none left */
	}

opn2:
	objbuf.fildes = open(ext(rp,suf),0);
	if(objbuf.fildes == -1) {
		objbuf.fildes = open(rp,0);
		if(objbuf.fildes == -1) {
			if (rp == &lib[4]) {
				rp = lib;
				goto opn2;
			}
			printf(rp);
			ferror(" : cannot open object file.");
		}
	}
	objbuf.nonused = read(objbuf.fildes,objbuf.buff,512);
	if (objbuf.buff[0] != 1) {
		printf(rp);
		ferror(" : illegal format object file.");
	}
	objbuf.nxtfree = objbuf.buff;
	return(1);
}

/*
 * checks syntax of odf - fatal error if not ok
 */
checkodf()
{
	register int	i;
	register char	*s;

	/* check first line is .root */
	s = getname();
	if (strcmp(s, ".root")!=0 || peekc!='\n')
		badodf();
	if (checkline() != 0)
		badodf();	/* no root segment */
	i = checkline();
	while (i > 0) {
		nreg++;		/* another region */
		for (;;) {
			i = checkline();
			if (i != 0)
				break;
			nseg++;		/* another segment */
		}
	}
	if (i >= 0)
		badodf();	/* didn't get ".end" */
}

/*
 * read until '\n' - check for valid filenames
 */
checkline()
{
	register char	*s;

	s = getname();
	if (*s == '.') {
		if (peekc != '\n')
			badodf();	/* all keywords must be by themselves */
		if (strcmp(s, ".region") == 0)
			return(1);
		if (strcmp(s, ".end") == 0)
			return(-1);
		/* unknown keyword */
		badodf();
	}
	for (;;) {
		if (*s=='.' || *s=='\0')
			/* null filenames not acceptable */
			/* only commands may commence with '.' */
			badodf();
		if (peekc == '\n')
			return(0);
		s = getname();
	}
}


/*
 * reads one char from odf
 */
readc()
{
	static char	c;

	if (read(odf, &c, 1) <= 0)
		badodf();
	return(c);
}

badodf()
{
	ferror("bad overlay descriptor file.");
}

/*
 * Gets next file name from overlay descriptor file.
 * Returns pointer to filename if successful; NIL if no more.
 * Updates region and segment numbers.
 */
getnext()
{
	register char	*s;
	register char	c;

	c = peekc;
	s = getname();
	if (c == '-')
		/* still in same segment and region */
		return(s);

	psecte = NIL;
	if (c == '\n') {
		segment++;
		if (*s != '.') {
			/* 1st file in new segment */
			curmod = NIL;
			(*segwk)[segment].segreg = region;
			return(s);
		}
		if (region == 0)
			reroot = curmod;	/* save current position in list */
		if (s[1] == 'e') {
			/* .end */
			/* reset to 1st segment (root!) */
			region = 0;
			segment = 0;
			curmod = reroot;
			return(NIL);
		}
		/* must be .region */
		region++;
		curmod = NIL;
		(*segwk)[segment].segreg = region;
	}
		/* else must be .root */
	return(getname());
}

/*
 * Reads a filename from odf.
 * Acceptable characters for filenames are: a-z, A-Z, 0-9, '.' and '_'.
 * Blanks and tabs between filenames are ignored.
 * The only other characters accepted are '-' and '\n' which
 * are left in peekc after reading the name.
 */
getname()
{
	register char	c;
	register char	*s;
	static char	fname[50];

	s = fname;
	/* skip blanks and tabs */
	do {
		c = readc();
	} while (c==' ' || c=='\t' || c=='\n');
	for (;;) {
		if ((c<'a' || c>'z') && (c<'A' || c>'Z'))
			if (c<'0' || c>'9')
				if (c!='.' && c!='_')
					/* invalid character for name */
					break;
		*s++ = c;
		c = readc();
	}
	while (c==' ' || c=='\t')
		c = readc();
	if (c!='-' && c!='\n')
		badodf();
	peekc = c;
	*s = '\0';
	return(fname);
}

crefout(name,flag)
int	*name;
{
	register int *r1;
	int crstuff[5];

	if( (flags&CR) && ( ((flags&NL)==0) || (curmod->mislib==0 ))) {
		r1 = crstuff;
		*r1++ = name[0];
		*r1++ = name[1];
		*r1++ = curmod->mname[0];
		*r1++ = curmod->mname[1];
		*r1 = flag;
		write(crfile, crstuff, 10);
	}
}
