/*
 ***********************************************************************
 *                                                                     *
 *                X    X   XXXX   XXXXX    XXXX			       *
 *                XX  XX  X    X  X    X  X			       *
 *                X XX X  X    X  X    X   XXXX			       *
 *                X    X  X    X  X    X       X		       *
 *                X    X  X    X  X    X  X    X		       *
 *                X    X   XXXX   XXXXX    XXXX			       *
 *                                                                     *
 *	The following defines represent certain improvements and       *
 *	enhancements to the unix 'op sys'. To negate the effect of     *
 *	these changes just delete the define by commenting it out.     *
 *	Corrections of obvious deficiencies and so on are not to be    *
 *	`ifdefed' since they will always be required. See FIXES below  *
 *                                                                     *
 *	For those who intend to alter the 'op sys' please bear the     *
 *	following points in mind:                                      *
 *                                                                     *
 *	1. please indicate   time - date - who                         *
 *                                                                     *
 *	2. why was mod needed.  what was done.  how it was done.       *
 *	   which source modules were altered.  etc . . .	       *
 *                                                                     *
 *	3. any other information which may be considered helpful       *
 *	     for a person following your alterations.                  *
 *                                                                     *
 *						Ian J.		       *
 *                                                                     *
 ***********************************************************************
								       */

/*
#define	_1170
       /*
	*	bio.c once.c m70.s l70.s trap.c user.h
	*	rdwri.c sys1.c
	*
	*	includes stuff specific to 70 cpu's.
	*	such as UNIBUS MAP etc...
	*	Use JNR m70.s which handles floating point properly,
	*	handles an 11/70 cpu as an 11/70 cpu - that is to
	*	say uses the ERROR registers properly etc...
	*	This entails altering 'trap' ,user.h and l.s
	*/

#define	_1145
       /*
	*	bio.c once.c m45.s l45.s trap.c user.h
	*	rdwri.c sys1.c
	*
	*	includes stuff specific to 45 cpu's.
	*	Use JNR m45.s which handles floating point properly,
	*	handles an 11/45 cpu as an 11/45 cpu - that is to
	*	say uses the ERROR registers properly etc...
	*	This entails altering 'trap' ,user.h and l.s
	*/

/*
#define	_1140
       /*
	*	clock.c param.h slp.c
	*
	*	includes stuff specific to 40 cpu's.
	*/

#define	FPU
       /*
	*	user.h	m70.s	m45.s
	*
	*	FP11-b or FP11-c installed 
	*/

/*
#define	RH70
       /*
	*	rdwri.c
	*
	*	include code for rh70 type controllers
	*/

/*
#define	PROG_CLOCK
       /*
	*	clock.c once.c
	*
	*	if you have a programmable clock only
	*	saves some code ...
	*/

#define	SHARED_DATA
       /*
	*	Ian Johnstone	FEBRUARY '76	
	*
	*	sig.c slp.c sys4.c sysent.c trap.c user.h
	*	sys1.c	text.c	text.h  once.c param.h
	*
	*	New special a.out magic number 0412 signifies shared data
	*	segment (r/w text area).  Must be swapped out on last use
	*	not just abandoned.  Swap synchronization initially a problem,
	*	definitive solution made AUG 77 in conjunction with 
	*	LOWER_TEXT_SWAPS alteration.
	*	`x_spid' and word 6 of A.OUT header contain shared data
	*	identification field - inode pointer not good enough (not unique),
	*	since shared data segments are shared between any number
	*	of co-operating processes.
	*	Initially implemented to support UNSW batch system.
	*	P and V system calls implemented to allow process
	*	synchronization.  LKED does the linking needed for
	*	creation of 412 a.outs.
	*	db4.s needs to be altered to define text,data,stack size
	*	displacements in user.h. cdb,ddt too.
	*/

#define	ZOMBIE
       /*
	*	Chris Maltby	MARCH 77
	*
	*	sys1.c	proc.h	sys4.c	slp.c	clock.c
	*
	*	Several variables in the proc structure are used to store
	*	post-mortem information about processes.  This avoids the swap
	*	out & in of previous version for exit & wait.  Process
	*	terminations (exit&wait) go substantially faster.
	*	Alternative process structure pz_* contains definition of
	*	process area for dead processes.  A few of the scheduling
	*	routines have been altered so that no attempts are made
	*	to alter the process area of `dead'ns'.
	*/

#define	INIT_FIX
       /*
	*	Chris Maltby	MARCH 77
	*
	*	sys1.c
	*
	*	/etc/init (process one) only woken up when required.
	*	Previously every process termination in the system woke
	*	the init process. This is only necessary if the parent
	*	of the dying process is already dead. ``the whole piece
	*	of code that deals with this is still a mess''.
	*	PS needs to know of this alteration.
	*
	*	Piers Lauder	AUGUST 77
	*
	*	The whole thing re-written using a single scan of the
	*	proc array (up to 4 previously). MORE efficient. 
	*	Now the code is understandable.
	*
	*/

#define	TIME_LIMITS
       /*
	*	Chris Maltby	MARCH 77
	*
	*	clock.c	param.h	user.h sys4.c sysent.c sig.c proc.h
	*
	*	User area variables 'u.u_cpusec' and 'u.u_tix' contain
	*	seconds and clock ticks left before time limit expiry.
	*	A signal SIGCPULT is generated when
	*	cpusec becomes zero.  A process with a limit of zero is
	*	not restricted - this is normal state.
	*	Limit passed to children so that if `n' seconds
	*	to go before expiry before fork, after
	*	fork each process will have `n' seconds to go!!
	*
	*	Ian Johnstone	AUGUST 77
	*
	*	sys4.c sysent.c user.h
	*
	*	New system call "clktim" is implemented by these changes.
	*	Allows user to request a signal SIGTIMEOUT in `n' seconds(real)
	*	`n' is passed in r0. If p_rtl is non-zero then a real
	*	time limit has been set. When a limit has been set
	*	the clock interrupt routine decrements p_rtl once a second
	*	until zero when the signal is sent. This involves little extra
	*	cost to the system as the whole proc array is scanned each
	*	second anyway. Main cost is extra word in process table entry.
	*	Limit passed to children so that if 'n' seconds
	*	to go before expiry before fork, after fork each process
	*	will have 'n' seconds before being signalled.
	*/

#define	GPROCS
       /*
	*	received JUNE 77 second mailing (Rand)
	*
	*	sys1.c	sysent.c
	*
	*	Returns system proc array to user. Returns also the number of
	*	process slots.
	*	PS modified to use this - makes PS go faster
	*/

#define	BETTER_EXIT
       /*
	*	john lions class of '76
	*
	*	sys1.c
	*
	*	Shrink process to USIZE on entry to exit.
	*/

#define	BETTER_TIME
       /*
	*	Ian Johnstone & Andrew Hume SEPTEMBER 76
	*
	*	alloc.c
	*
	*	update() always updates on root file system super block.
	*	After booting time more likely to be correct.  Also allows
	*	knowledge of when a system crashed to within 30 seconds.
	*	Omitting to set date at BOOT of system less likley
	*	to cause havoc with incremental dumps.
	*/

#define EP_ADDRESS
       /*
	*	Craig McGregor	AUGUST 76
	*
	*	sys1.c	user.h
	*
	*	Implement entry point address as described in programmers
	*	manual.
	*
	*	db4.s needs to be altered to define text,data,stack size
	*	displacements in user.h. ps,cdb,ddt too.
	*/

#ifdef	_1140
#define	BIG_UNIX
#endif
       /*
	*	Jeff Rottman	jul 77
	*
	*	once.c m40.s user.h
	*
	*	This mod is a means of expanding the available addressing
	*	space for the resident operating system on pdp-11/40 style
	*	memory-management UNIX systems. A new linker `sysld' is
	*	used to generate such a system - A sysld command file specifies
	*	the division of the resident system into _s_e_g_m_e_n_t_s, one of
	*	which, the _r_o_o_t segment, is always addressable using
	*	segmentation pages 0 through 4. All the other segments
	*	share page 5, and are addressable only when running. Page
	*	6, as is usual, is reserved for the _U-table addressing, and
	*	page 7 for the I/O page.
	*
	*/

#define	VICAR
       /*
	*	Chris Maltby JUNE 77	Ian Johnstone AUGUST 77
	*
	*	systm.h user.h ( with side effects in tty.c )
	*
	*	Utilize `u.u_heap' as scratch area for erase and delete
	*	processing.  Eliminates canonb[] from systm.h.
	*	Saves space.
	*/

#define	NEW_TIMEOUT
       /*
	*	Piers Lauder	AUGUST 77
	*
	*	m40.s m45.s clock.c param.h systm.h
	*
	*	New timeout function utilises blocks off the clist
	*	for increased efficiency.
	*/

/*
#ifdef	NEW_TIMEOUT
#define	UN_TIMEOUT
#endif
       /*
	*	Piers Lauder	AUGUST 77
	*
	*	clock.c
	*
	*	Allows cancellation of the effect of a previous call
	*	to timeout.
	*/

/*
#define	SETPSW
       /*
	*	clock.c sys4.c sysent.c trap.c m40.s m45.s
	*/

/*
#define CBLOCK_16
       /*
	*	Piers Lauder   AUGUST 77
	*
	*	m70.s m40.s m45.s once.c tty.c
	*
	*	Allow larger cblocks. PUTC,GETC re-written to be 15% faster,
	*	as well as being parametric.
	*/

#define TTY_TRUE_RAW
       /*
	*	Piers Lauder	AUGUST 77
	*
	*	tty.c tty.h & all tty drivers
	*
	*	Allows the use of full 8 bit data
	*	on tty lines iff RAW flag set
	*	and other flags except HUPCL are reset.
	*/

#define	TTY_HISPEED
       /*
	*	Piers Lauder	AUGUST 77
	*
	*	tty.c tty.h & all tty drivers
	*
	*	Provides suitable water marks for high speed terminals.
	*/

/*
#define	TTY_FLOW_CONTROL
       /*
	*	Piers Lauder	AUGUST 77
	*
	*	tty.c tty.h & getty stty
	*
	*	Allows tty.c to drive DIABLO type terminals
	*	at high baud rates ( >= 1200 )
	*/

#define	STACK_LIMIT
       /*
	*	Peter Hewitt & Dave Horsfall & Craig McGregor  	MAY 77
	*
	*	once.c param.h
	*
	*	Implement stack limit register.
	*/

#define	SMDATE
       /*
	*	UNIX version 6 with mod by Ian Johnstone AUGUST 77
	*
	*	sys4.c sysent.c
	*
	*	Enable smdate from level 6 system distribution.
	*	This call was originally commented out because of
	*	problems with incremental dumps - pseudo old
	*	files not dumped.  Smdate as implemented
	*	now only allows super-user to modify the access date
	*	hopefully super users know what they are doing.
	*/

#define	NEW_SLEEP
       /*
	*	Piers Lauder + Ian Johnstone	AUGUST 77
	*
	*	proc.h sys2.c clock.c systm.h param.h sys4.c
	*
	*	Sleep system calls now do unique sleeps
	*	( avoiding thrashing on wakeups of TOUT )
	*	
	*	Each proc entry has one additional word p_stl
	*	which when non-zero indicates that a sleep is in progress
	*	once a second the clock interrupt routine decrements this
	*	count, when reaches zero process woken up.  This involves
	*	little extra overhead as the proc array is already scanned
	*	once a second for other purposes.
	*/

#ifdef	 BIG_UNIX
#define	ONCE
       /*
	*	Ian Johnstone AUGUST 77
	*
	*	once.c(main.c) slp.c tty.c bio.c alloc.c c.c
	*
	*	Normally this change only in effect when BIG_UNIX is in effect
	*	however there exists no reason why ONCE can not be used without
	*	BIG_UNIX.  main.c renamed once.c.  The initialization routines
	*	cinit,binit,iinit are moved to once.c from tty.c,bio.c and
	*	alloc.c respectively by this change.  Also estabur,nseg,sureg
	*	are moved from once.c to slp.c.  Buffer allocation(declaration)
	*	is moved to c.c (in conf).
	*/
#endif

#ifdef	_1170
#define CRASH_TRACE
       /*
	*	Ian Johnstone AUGUST 77
	*
	*	trap.c param.h
	*
	*	When system panics print out contents
	*	of cpu error registers.
	*/
#endif

/*
#define MALLOC_CHECK
       /*
	*	Ian Johnstone + Andrew Hume  AUGUST 77
	*
	*	malloc.c
	*
	*	Introduce means of gathering statistics of memory
	*	and swap space allocation under unix.
	*	Statistics gathered from this change instigated the
	*	LOWER_TEXT_SWAPS mod below.
	*/

#define	RAW_BUFFER_POOL
#define	NRAWBUFS	10
       /*
	*	Ian Johnstone	SEPTEMBER 77
	*
	*	once.c bio.c and others disk/tape raw i/o interfaces as reqd.
	*
	*	In order to improve system performance allocate 'NRAWBUFS'
	*	buffer headers - these headers to be used for swapping and
	*	general raw i/o. Instead if using 'swbuf' for all swap
	*	i/o in the system, allocate from the raw buffer pool.
	*	If 'physio' is passed a null buffer pointer then
	*	it will allocate a buffer for the i/o and free it on completion
	*	of the i/o.  Current raw i/o interfaces then do not have to be
	*	altered unless desired.  The main benefit to these interfaces
	*	will be that on multiple devices overlapped seeks will
	*	possible, also ordered queueing of raw
	*	i/o requests can also be done. (assuming a clever driver)
	*	Improves swapping.  'NRAWBUFS' should be 2 greater
	*	than the expected number of simultaneous raw i/o operations
	*	to prevent lockout of swap i/o.
	*
	*/

#define SLOSHED
       /*
	*	Chris Maltby	SEPTEMBER 77
	*
	*	tty.c
	*
	*	Change to canon to allow erases to delete kills
	*	In the process rewrote it to be more
	*	deterministic (and better).
	*	Handles \ erase-char properly. ie. doesnt assume '#' & '@'
	*	For penny-pinchers this change costs 44 bytes
	*
	*/

#define	LOWER_TEXT_SWAPS
       /*
	*	Chris Maltby	SEPTEMBER 77
	*
	*	slp.c text.c text.h
	*
	*	This alteration drastically reduces the number of swaps
	*	undertaken by UNIX. For example on Ian J's 11/70 swapping
	*	was reduced by about 85%. What more can I say !!
	*	When attaching to a shared text segment that was not
	*	already core resident the following procedure was
	*	followed:
	*		1. If in swap space goto 6
	*		2. Expand process size to enable read of
	*		   text from the a.out.
	*		3. Read text segment.
	*		4. Allocate swap space for text segment
	*		   and swap the segment out 
	*		5. Expand process size to USIZE.
	*		6. Swap out process!!
	*		7. Call sched.
	*	When the process is swapped back in to core
	*	all will magically be taken care of.
	*
	*	This is a little inefficient to say the least and
	*	47 % of all swaps counted were for 1024 bytes.
	*
	*	The new scheme:
	*		1. if in swap space goto 6
	*		2. Expand process size to enable read of
	*		   text from the a.out.
	*		3. Read text segment.
	*		4. Separate User Per Process area and text Segment
	*		   and install text segment in core. Mark it as not yet
	*		   swapped.
	*		5. Continue execution of process
	*		6. Swap in text segment.
	*		7. goto 5
	*	Note that only if required will the shared text segment now
	*	be swapped. It is now possible to run a shared
	*	text program that will cause no swapping if
	*	the program is not "sticky bit"ed.
	*
	*		AND all this only costs 98 bytes...
	*/

#define	B_AGE
       /*
	*	Jeff Rottman	Sep 77
	*
	*	buf.h bio.c
	*
	*	Allow proper handling of write behind blocks
	*	on freelist. Put at head of free queue those blocks
	*	that have to be written.
	*/

/*
#define SLOW_CONSOLE
       /*
	*	ian johnstone	oct 77
	*
	*	prf.c
	*
	*	enable the generation of filler characters
	*	by system putchar routine - if '\r' output
	*/

#define	LARGE_FILE_REFERENCES
	/*
	 *	Ian Johnstone	Nov '77
	 *
	 *	user.h fio.c sys1.c sys3.c
	 *
	 *	Allows > 127 references to a file structure,
	 *	up to maximum of 255 with ENREF error if exceeded.
	 *	Previously this condition would cause (catastophic)
	 *	errors.
	 */

/*
#define	GROUP_ACCESS
       /*
	*	so well established no known author !!
	*
	*	fio.c	sysent.c	sys4.c
	*
	*	allow groups access checking etc.
	*	by defing this symbol will allow unix so
	*	generated to support groups as distributed
	*	by BELL - yuk.
	*/

/*
#define	ERROR_LOG
	/*
	 *	Piers Lauder	Nov '77
	 *
	 *	prf.c	c.c
	 *
	 *	change putchar to allow system program "errlogger"
	 *	to record "printf" messages instead of console.
	 *	Implements device "/dev/errlog".
	 *	see /usr/source/s1/errlog.c for error logger code.
	 */

#define	NICE_PUTCHAR
	/*
	 *	Piers Lauder	Nov '77
	 *
	 *	prf.c
	 *
	 *	change putchar to use tty driver for non-panic
	 *	messages;
	 */

/*
#define	TTY_INVCASE
	/*
	 *	Piers Lauder	Nov '77
	 *
	 *	tty.h tty.c
	 *
	 *	handle inverted case terminals
	 *	yes - they exist.
	 */

#define	COOL_NO_SPACE
	/*
	 *	Piers Lauder	Nov '77
	 *
	 *	alloc.c
	 *
	 *	Since most programs ignore errors on write,
	 *	attempt to be a little less enthusiastic
	 *	with "no space" messages. The change is a
	 *	call to sleep on "lbolt", the effect is to
	 *	slow up programs doing repeated write calls
	 *	after no space error.
	 */

/*
#define	ILLEGAL_C
	/*
	 *	Piers Lauder	Nov '77
	 *
	 *	partab.c	bx.c
	 *
	 *	Enhance the table to know about communication
	 *	bytes which are illegal in a 7-bit + parity
	 *	protocol.
	 */

#define	UPRINTS
	/*
	 *	Piers Lauder	Jan '78
	 *
	 *	prf.c
	 *
	 *	This includes code implementing the routine "uprints"
	 *	which will print a system message on the tty
	 *	associated with the current process.
	 */

#define	DELAY
	/*
	 *	Piers Lauder	Jan '78
	 *
	 *	clock.c
	 *
	 *	this includes code implementing the routine "delay"
	 *	which will delay the caller for a period using a
	 *	"timeout - sleep - wakeup" sequence.
	 */

#define	MAX_PROC
	/*
	 *	Ian Johnstone	Jan '78
	 *
	 *	clock.c	sig.c	slp.c	sys1.c	sys4.c	proc.h
	 *
	 *	Keep track of which slot in the proc table is the last one
	 *	in use, and when searching the proc table only go up to maxproc
	 *	rather than &proc[NPROC].  This does speed things up a little.
	 *	Ken Thompson is also supposed to have found that the
	 *	system spends most of its time scanning the proc array.
	 *	For example ps is now many times faster less to transfer less to scan.
	 *	For example consider a system with NPROC=200 and 5 active processes
	 *	ZOMBIE defined - WITHOUT MAX_PROC time for executing wait was 1.18ms
	 *	- WITH MAX_PROC time for executing wait was 0.34ms - thus the benefits
	 *	are obvious in those parts of the system that search the proc table.
	 *	NOTE:	time == elapsed time == user time + system time
	 *	These values obtained on AGSM's 11/70
	 */
#ifdef	MAX_PROC
#define	HIGH_PROC
	/*
	 *	Ian Johnstone	Jan '78
	 *
	 *	proc.h	slp.c
	 *
	 *	Enable code to keep proc high water mark in high_proc.
	 */
#endif

#define	LRU_INODE
	/*
	 *	UNKNOWN HACKER -- university of toronto
	 *	Improved debugged installed Ian Johnstone Jan 78
	 *
	 *	inode.h	iget.c	clock.c	sys3.c	sys4.c
	 *
	 *	Incore inode structures are allocated on an LRU basis, and
	 *	if a requested Inode is still in core, it is not read in
	 *	again.  This seems to dramatically speed up pathname
	 *	searches, which do an awful lot of iget's and iput's.
	 *	For example a stat of a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a
	 *	previously took 1.1 seconds (avg) per call this change
	 *	reduces this to 0.07 seconds (avg) !!!!
	 *	These tests carried out on AGSM 11/70 (1 RP04)
	 */


/*
 ***********************************************************************
 *                                                                     *
 *	        XXXXXX     X    X    X  XXXXXX   XXXX		       *
 *	        X          X     X  X   X       X		       *
 *	        XXXXX      X      XX    XXXXX    XXXX		       *
 *	        X          X      XX    X            X		       *
 *	        X          X     X  X   X       X    X		       *
 *	        X          X    X    X  XXXXXX   XXXX		       *
 *                                                                     *
 *	Please document all necessary fixes (fix obvious bugs) to the  *
 *	'op sys' here. no defines etc just documentation. Same plea    *
 *	with respect to documenting mods apply.			       *
 *	To indicate a fix in source code just put a comment on altered *
 *	lines referencing 'fixnnn' and document it here.	       *
 *                                                                     *
 ***********************************************************************
								       */
/*
 *	fix000
 *		Ian Johnstone	AUGUST 77
 *
 *		bio.c	file.h	filsys.h	ino.h	inode.h
 *		alloc.c	clock.c	fio.c	iget.c	nami.c	once.c
 *		pipe.c	rdwri.c	sig.c	subr.c	sys1.c	sys2.c
 *		sys4.c	text.c	proc.h	systm.h	user.h
 *
 *		These alterations mainly concerned with
 *		utilizing the facilities of the latest C compiler.
 *		All char * and int * which really were of unsigned type
 *		have been altered.
 *		Register arguments to procedures declared where noted
 *		Ian Johnstone	early 77
 *		All int [2] type whose purpose was to implement 32-bit
 *		arithmetic have been declared long - code altered as required
 *		to cope with new declarations.
 *		Ian Johnstone et al 77
 *		Correctly declare pointers. for example if a pointer
 *		is a pointer to an inode structure then declare it thus
 */


/*
 *	fix001
 *		Jeff Rottman	JUNE 77
 *
 *		bio.c	rdwri.c	
 *
 *		It has been suggested that `read ahead' on small systems
 *		(only a few buffers) causes deadly embraces. dmr/bio.c
 *		can be modded to stop read ahead if desied. It is not clear
 *		if a problem really exists. Certainly though large systems
 *		should have no problems (none !!)
 */

/*
 *	fix002
 *		Dave Horsfall	APRIL 77
 *
 *		bio.c
 *
 *		There appears to be a race condition in swap() whereby
 *		the same priority (PSWP) was used to wait for completion of
 *		i/o and for the buffer. A lower priority now used for
 *		buffer allocation sleep.  See bio.c
 */

/*
 *	fix003
 *		John Lions `op sys' class 76
 *
 *		sig.c
 *
 *		No limit to priority because of typo.
 *		See sig.c
 */

/*
 *	fix004
 *		UNSW
 *
 *		text.c
 *
 *		No swap error panic given ?
 */

/*
 *	fix005
 *		UNSW
 *
 *		trap.c
 *
 *		Partial fix to overlaying which signal is being
 *		processed.
 *		******* withdrawn *********
 */

/*
 *	fix006
 *
 *		George Goble purdue university JUNE 77
 *
 *		sys2.c
 *
 *		Chdir sys call could leave free "leaves"
 *			chdir /tmp
 *			mkdir a; chdir a
 *			rmdir /tmp
 *			cp /null orphan
 *			chdir /null
 */

/*
 *	fix007
 *		Piers Lauder	AUGUST 77
 *
 *		tty.c
 *
 *		Get tty.c to echo nl to cr on half duplex terminals
 *		with CRMOD set.
 */

/*
 *	fix008
 *		Piers Lauder	AUGUST 77
 *
 *		tty.c
 *
 *		Fix tty.c not to call device start routine
 *		if timing out.
 */

/*
 *	fix009
 *		**************************
 *		fix made unnecessary by
 *		SLOSHED modification
 *	 	**************************
 *
 *		Piers Lauder AUGUST 77
 *
 *		Maptab.c changed to allow other escaped
 *		characters e.g.	'\b'.
 *
 */

/*
 *	fix010
 *
 *		Piers Lauder	AUGUST 77
 *
 *		Cret in m40.s & m45.s changed to allow long values
 *		to be returned.
 */

/*
 *	fix011
 *		Piers Lauder	AUGUST 77
 *
 *		once.c
 *
 *		Console start up printout "mem =" altered to give Kb.
 */

/*
 *	fix012
 *		1976
 *
 *		once.c(main.c)
 *
 *		Saves time at initialisation.
 *		The author hereby declares that no infringement
 *		of Western Electric copyrights is intended.
 */

/*
 *	fix013
 *		Chris Maltby	SEPTEMBER 77
 *
 *		fio.c
 *
 *		Super user can now change to zero
 *		mode directories.  (fio.c)
 */

/*
 *	fix014
 *		P A Hardie	uni of saskatchewan
 *
 *		tty.c
 *
 *		"lost characters fix"
 *		Ttwrite in tty.c - the mod stops ttstart being interrupted
 *		and losing the character it was about to output.
 */

/*	fix015
 *		Greg Rose & Chris Maltby	UNSW
 *
 *		trap.c m40-45-70.s
 *
 *		make system do t bit tracing properly.
 *		Rti's are done from all traps except
 *		t or bpt traps.
 */


/*	fix016
 *		Piers Lauder	Nov '77
 *
 *		prf.c
 *
 *		always output panic messages
 *		even if switches down
 */

/*	fix017
 *		Piers Lauder	Nov '77
 *
 *		bio.c
 *
 *		ensure b-resid always zero - drivers may not always
 *		do this
 */

/*
 * tunable variables
 */

#define	NBUF	25		/* size of buffer cache */
#define	NINODE	100		/* number of in core inodes */
#define	NFILE	250		/* number of in core file structures */
#define	NMOUNT	4		/* number of mountable file systems */
#define	NEXEC	2		/* number of simultaneous exec's */
#define	MAXMEM	(64*32)		/* max core per process - first # is Kw */
#define	SSIZE	20		/* initial stack size (*64 bytes) */
#define	SINCR	20		/* increment of stack (*64 bytes) */
#define	NOFILE	15		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	CMAPSIZ	100		/* size of core allocation area */
#define	SMAPSIZ	200		/* size of swap allocation area */
#ifndef NEW_SLEEP
#define	NCALL	50		/* max simultaneous time callouts */
#endif
#ifdef NEW_SLEEP
#define	NCALL	20		/* max simultaneous time callouts */
#endif
#define	NPROC	100		/* max number of processes */
#define	NTEXT	30		/* max number of pure texts */
#ifndef	CBLOCK_16
#define	NCLIST	300		/* max total clist size */
				/* 300* 6 = 1800 chars available */
#endif
#ifdef	CBLOCK_16
#define	NCLIST	150		/* max total clist size */
				/* 150*14 = 2100 chars available */
#endif
#define	HZ	50		/**** Ticks/second of the clock ****/
#ifdef	NEW_TIMEOUT
#define NTFREE	2		/* no. of spare blocks in timeout freelist */
#endif

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	-100
#define	PINOD	-90
#define	PRIBIO	-50
#ifdef	DELAY
#define	PDELAY	-1
#endif
#define	PPIPE	1
#define	PWAIT	40
#ifdef	SHARED_DATA
#define	PPV	40		/* pp & vv sleep priority */
#endif
#define	PSLEP	90
#define	PUSER	100

/*
 * signals
 * dont change
 */

#define	NSIG	20
#define		SIGHUP		1	/* hangup */
#define		SIGINT		2	/* interrupt (rubout) */
#define		SIGQIT		3	/* quit (FS) */
#define		SIGINS		4	/* illegal instruction */
#define		SIGTRC		5	/* trace or breakpoint */
#define		SIGIOT		6	/* iot */
#define		SIGEMT		7	/* emt */
#define		SIGFPT		8	/* floating exception */
#define		SIGKIL		9	/* kill */
#define		SIGBUS		10	/* bus error */
#define		SIGSEG		11	/* segmentation violation */
#define		SIGSYS		12	/* sys */
#define		SIGPIPE		13	/* end of pipe */
#define		SIGTERMINATE	14	/* terminate - send this signal when system about to close down  */
#ifdef	TIME_LIMITS
#define		SIGTIMEOUT	15	/* real time limit  */
#define		SIGCPUTL	16	/* cpu time limit  */
#endif

/*
 * fundamental constants
 * cannot be changed
 */

#define	USIZE	16		/* size of user block (*64) */
#define	NULL	0
#define	NODEV	(-1)
#define	ROOTINO	1		/* i number of all roots */
#define	DIRSIZ	14		/* max characters per directory */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
	char	lobyte;
	char	hibyte;
};

/*
 * structure to access an integer
 */
struct
{
	int	integ;
};
/*
 * structure to access anything as bytes
 */
struct
{
	char	byt[];
};
/*
 * structure to access an unsigned integer
 */
struct
{
	unsigned unsignd;
};
/*
 * structure to access a long
 */
struct
{
	int	hiint;
	int	loint;
};

/*
 * Certain processor registers
 */
#define PS	0177776
#define KL	0177560
#define SW	0177570
#ifdef	STACK_LIMIT
#define	SLR	0177774		/* stack limit register */
#endif

#ifdef CRASH_TRACE
#define	CPUEREG		0177772
#define	MEMEREG		0177744
#define	MEMHIGHA	0177742
#define	MEMLOWA		0177740
#endif
