.TH "AUTH_CREDCHECK" 3 "29-Dec-86" "Xerox (WRC)"
.\" $Header: authcredcheck.n,v 1.1 87/01/15 16:48:03 ed Exp $
.SH NAME
Auth_CredCheck
\- Check user supplied credentials and verifier with a network Authentication 
service
.SH SYNOPSIS
.PP
.nf
.B "#include <sys/types.h>"
.B "#include <netns/ns.h>"
.B "#include <xnscourier/Authentication2.h>"
.B "#include <xnscourier/courier.h>"
.PP
.B "Boolean Auth_CredCheck(creds, verifier)"
.B "	Authentication2_Credentials creds;"
.B "	Authentication2_Verifier verifier;"
.f
.PP
Link with
.IR "-lcourier" .
.SH DESCRIPTION
The routine
.I Auth_CredCheck
returns TRUE or FALSE depending upon whether the supplied credentials and
verifier are valid as determined by a network Authentication service. The
credentials and verifier supplied in the arguments
.I credentials
and 
.I verifier
must be of type simple. If another type is supplied, FALSE will be returned.
If
.I credentials
specifies 
.I nullCredentials
TRUE will be returned.
.PP
.I AuthGetFirstAuth
is used to locate a network Authentication service where the credentials and
verifier may be validated. If no service can be located or a connection 
established, the return value will also be FALSE.
.SH NOTES
Currently only the simple flavor of credentials and verifiers are supported.
.SH FILES
/usr/local/lib/libcourier.a		-lcourier library.
.SH SEE ALSO
Auth_GetFirstAuth(3N), xnsbfs(1N)
.br
``XNS Courier Under Unix''
.br
Authentication Protocol, \s8XSIS\s0 098404 (April 1984).
.SH AUTHOR
Ed Flint

