.TH "FILINGSUBSET1D" 1 "30-Dec-86" "Xerox (WRC)"
.\" $Header: FilingSubset1d.n,v 1.2 87/04/01 13:54:48 ed Exp $
.SH NAME
FilingSubset1d - XNS FilingSubset version 1 service
.SH DESCRIPTION
.I FilingSubset1d
is a service for the XNS Courier FilingSubset protocol version 1.
The implementation adheres to the guidelines for implementations 
documented in the FilingSubset Implementor's Guide.
.PP
The service is forked from the XNS courier daemon,
.IR xnscourierd , 
upon connection requests for version 1 of the FilingSubset Protocol.
.SH "PROCEDURE SUPPORT"
The Filing Protocol defined procedures 
.IR Logon , 
.IR Logoff , 
.IR Continue , 
.IR Open , 
.IR Close ,
.IR List , 
.IR Delete ,
.I Store 
and 
.I Retrieve
are supported. The extent of support is
consistent with the implementation of the FilingSubset Protocol as
described in the FilingSubset Implementor's Guide.
.SH "ATTRIBUTE SUPPORT"
Attribute support within the service is also consistent with the FilingSubset
Protocol. All attributes defined as mandatory in the FilingSubset Protocol
are supported (\fIcreatedOn\fR, 
.IR dataSize , 
.IR isDirectory , 
.IR modifiedOn , 
.IR pathname, 
.IR type ).
.PP
.I FilingSubset1d
supports several file types. The FilingSubset defined types, 
.IR tDirectory , 
.I tText
and
.I tUnspecified
are allowed as well as the additional Viewpoint types, 
Interpress and VPCanvas (RES). The latter two are supported only for 
interoperability and are treated the same as 
.I tUnspecified
files during file transfer. 
Since the service does not maintain the file types explicitly within the Unix
file system
.I FilingSubset1d
will make an educated guess of the file type based on the contents of the
file, when a client requests the type of a file.
.SH "FILE TRANSFERS"
.I FilingSubset1d
currently makes a distinction between  
.I tText 
and other file types for use during file transfer. Files of type
.I
tText
undergo a translation of contents for compatibility with existing Filing
implementations; Unix EOL characters
(\\n) are translated to and from Xerox EOL characters (\\r), Xerox left
arrow characters are translated to underscore, etc.
All other files are treated as a binary stream with no translation incurred.
.SH AUTHENTICATION
The Filing Protocol allows clients to specify both primary and secondary
credentials.
.I FilingSubset1d
allows specific combinations of these credentials and accompanying verifier
and performs the authentication based on the type supplied. Clients may
specify 
.IR simple ,
.I strong
or
.I nullCredentials
as the primary credentials. If
.I simple 
credentials are supplied, the credentials and verifier will be validated with
a network Authentication service. 
.I nullCredentials
and 
.I strong
credentials will effectively be allowed with no network authentication.
.PP
Regardless of the type of primary credentials, clients are required to
supply a set of 
.I simple
secondary credentials consisting of the types
.I userName
and
.IR userPassword .
These will contain the user's Unix user name and password and are used by
.I Filing6d
to validate the user on the host system. Failure to supply these will result
in an Authentication error being returned to the client.
.SH "SEE ALSO"
Filing4d(1N), Filing5d(1N), Filing6d(1N), ViewpointFiles(5N)
.br
Filing Protocol, \s8XNSS\s0 108605 (May 1986)
.br
FilingSubset Implementor's Guide, \s8XNSG\s0 098609 (September 1986)
.SH NOTES
Some FilingSubset defined implied attributes are not currently supported.
These include 
.IR accessList , 
.IR defaultAccessList .
.PP
.I tAsciiText
files are currently not implemented. Files of this type are currently 
transferred as 
.I tText 
files with the translation specified above used to insure compatibility with
existing Filing implementations.
.SH BUGS
Like all other server implementations in the Unix/XNS environment
a single Filing session is not allowed to exist over multiple transport (SPP)
connection.
.SH AUTHOR
Ed Flint

