.\"	gremlin user's manual
.\"	print by: "grn g.man | ditroff -me"
.de GS	\"	redefined for right justify
.nr g7 (\\n(.lu-\\n(g1u)/2u
.if "\\$1"L" .nr g7 \\n(.iu
.if "\\$1"R" .nr g7 \\n(.lu
.in \\n(g7u
.nr g7 \\n(.u
.ls 1
.nf
.ie "\\$1"R" .ne \\n(g2u+2v
.el .ne \\n(g2u
..
.de GE
.ls
.in
.if \\n(g7 .fi
.if t .sp .6
..
.de $0 
.(x
\\$2  \\$1
.)x
..
.de HU
\\f3\\$1\\fP
.(x
.ta 1.2i
.ti 0.6i
\\$1
.)x
.in 0.5i
..
.if "\*(.T"ip" .po +0.25
.tp
.sp 2.0i
.b
.ps 24
.ce 3
The Gremlin Picture Editor
.sp 0.2i
.ps 18
.i
User Manual
.sp 0.1i
.ps 10
(Version 2.3 - 1982)
.sp 0.3i
.i
.ce 1
Barry Roitblat
.r
.sp 1
.ce 2
University of California, Berkeley
Berkeley, California 94720
.he 'gremlin users manual''%'
.bp
.sp 0.5i
.b
.ps 24
.ce 1
The Gremlin Picture Editor
.sp 0.3i
.i
.ps
.ce 1
Barry Roitblat
.r
.sp 1
.ce 2
University of California, Berkeley
Berkeley, California 94720
.ta 2.2i
.ll 6.0i
.sp 3
.sh 1 "Introduction."
     \fIGremlin\fR (\fBGr\fRaphic \fBE\fRditor for \fBM\fRaking \fBLin\fRe 
drawings) is an interactive graphics editor for the production
of quality line drawings for use in papers, presentations, etc.  Included
are a variety of commands for drawing simple elements such as polygons, curves,
and lines. 
These elements can be grouped into sets which can then be manipulated 
as units.
     All the figures in this paper were drawn using \fIgremlin\fR.  Figure 1
demonstrates some of \fIgremlin\fR's capabilities and includes samples of all the
default fonts and line styles.
     The current hardware configuration supported by \fIgremlin\fR consists of an
AED-512 color graphics terminal, a standard text terminal, and a digitizer
pad.  Commands are entered by menu item selection from the digitizer
(cursor) or from the text terminal keyboard.
     Although it shouldn't happen, the AED512 may
occasionally get itself into a mode where \fIgremlin\fR cannot run.
If this happens, then type the "reset" key on the AED keyboard twice
(its a black key at the top left), after which you should
hear a beep and see the screen go blank.  You may also need
to hit the rubout key so that Unix resets terminal characteristics,
and you may need to type breaks until the baud rate is set
correctly.  Run \fIgremlin\fR again;  it
should work this time.  It may be necessary to log a job in on the
AED display (At Berkeley, log in a job under the name "sleeper".  No
password is required.  To kill the sleeper job, type two control-backslash
characters in a row.)
     The resolution of the graphics display is much more limited (approx. 512 x 512) than that of the Varian or the Versatec output devices
therefore it is not possible to represent 
everything on the display exactly as it appears in the hardcopy form.  In
particular, bold lines, if they were to be drawn by simply using more pixels,
would soon obliterate the entire picture area.  In addition, it is not practical
to provide for all the fonts that the user may want to use.  It is still    
necessary, however, to be able to depict the differences in lines or fonts.  \fIGremlin\fR uses
colors to represent these differences.
.sp 2
.sh 2 Points.
     Most commands are accomplished by specifying 1 or more temporary
points and
performing some action on the points.  If the user puts down more points
than are used by the command, 
the excess points are discarded.  Associated with each element is
a set of \fIreference points\fR.  Reference points are used for selecting elements
and are determined by the type of picture element.  
     As an example, if the user wishes to draw a closed polygon, he would
first lay down a set of points (the last coinciding with the first) and, using
the cursor or keyboard, invoke the vector command.  All the
points specified would be reference points.
.sp 2
.sh 2 "Picture Elements."
     Commands are used in \fIgremlin\fR to create picture elements.  Elements are
defined simply as any group of lines or symbols created by a single command.
Elements are the basic units manipulated in \fIgremlin\fR.
.sp 2
.sh 2 "Current Set."
    In addition to the point paradigm, there is the notion of the \fIcurrent
set\fR.  An element becomes the current set when it is created.  The current
set may also be formed by selecting elements already in the picture. The 
current set is highlighted in a blue-green color so it can be easily distinguished
from the rest of the picture.
The current set can be copied
to other places in the picture, transformed in various ways, and stored in
set buffers for later use.  
     All lines and curves are drawn using the \fIcurrent brush\fR, and text is entered
in the \fIcurrent font\fR and \fIcurrent size\fR.  The current brush
and font are highlighted in the graphics menu by the display of a square
drawn around the appropriate symbol in the menu.  In addition, the 
information is displayed on the top of the text screen.  
.sp 2
.sh 2 "Set Buffers."
     Users may store elements or sets in temporary buffers.
These buffers are represented by an area of the menu and may be later retrieved
into the picture at specified points by selecting the buffer as you would 
select a command.
.sp 2
.sh 2 "Operation."
     The picture editor is invoked by typing  \fIgremlin [options] filename\fR 
(filename optional) to the
Unix shell.  \fIGremlin\fR will respond by resetting the graphics terminal and 
displaying the menu.  \fIGremlin\fR will then look, first in the HOME 
directory and then in the current directory for a '.gremlinrc' start-up file and
execute it, if found.  The start-up file can contain any valid gremlin
commands which are entered the same as they would be during normal execution
(including a ':' for long commands) except that there must be only a single
command per line.  Line length is limited to 200 characters.  
     If \fIfilename\fR is specified but does not exist the following message
will appear on the bottom line of the screen:
.sp 2
          \fI(creating new picture)\fR
.sp 2
     Otherwise, \fIgremlin\fR will retrieve the picture in \fIfilename\fR.

     The following options are available as switches on the command line:
.sp 2
.in +1.0i
.ll -1i
.ti -.5i
-g display
.br
specifies the graphics terminal which gremlin is to use for displaying the picture.  If
not given, \fIgremlin\fR selects a the display it believes to be appropriate.

.ti -.5i
-p path
.br
specifies the path to be used by \fIgremlin\fR for file look-ups (see the path
command for a discussion of paths).  If the -p switch isn't specified, then a
default path of '.' is used.

.ti -.5i
.ti -.5i
-h
.br
specifies the drawing area is to be horizontal (default
is vertical) with the menu displayed across the top.

.ti -.5i
-v 
.br
specifies a vertical (default) orientation for the
drawing area with the menu displayed along the left
hand side.

.in -1.0i
.ll +1i

.sh 1 "The Cursor."
     The cursor is used for positioning elements and points within the
picture area and for selecting commands from the menu.
The cursor is controlled by the 'mouse' or stylus of the digitizer.
As the mouse is moved across the graphics tablet, a cross-hair is moved
across the screen.
The stylus includes 4 buttons arranged in a
diamond pattern on its back (see figure 2).  Each of these buttons has
a particular function in \fIgremlin\fR as described below.

     The right button (green) is used to deposit points at the current cursor location.
A point will appear as a green "+" followed by an integer.  The integer
is the number of the point.  An alternate point display is available for
more detailed work.  This 'littlepoint' uses a smaller "+" and does not
display a number.
     The left button (white) is used to delete points.  The last remaining
point is deleted from the picture area.  Note that this differs from undo
in that consecutive uses of this button will delete additional points.

     The top button (yellow) is used to select or invoke commands,
depending on the cursor location at the time it is pressed.  If the cursor
is in the menu area, pressing this button will select the nearest
command, execute it, and cause it to become associated with that cursor button.
(Once associated, the command can be executed again simply by pressing the
button, while outside the menu area.  The association
remains in effect until a new command is selected.)
     The bottom button (blue) is used to undo previous commands.  Hitting this
button will undo the last command.  The undo command can, itself, be 'undone'
and cannot be used to undo any more than the last command.

.sh  1 "Selecting Commands."
     Commands are entered by menu selection or from the keyboard.
Menu selection is accomplished by placing the cursor on or near the icon
associated with the desired command and pressing the command button (yellow).
See figure 3 for a depiction of the menu.
     Text commands may be either short, single character commands or longer
commands which must be preceded by a ':'.  The characters for the short
commands are not necessarily mnemonic and were selected for convenience of
typing.  With a few exceptions, all of the short commands lie under
the left hand during normal typing.  Many of the text commands duplicate
functions available from the menu.  In fact, all menu commands are available
from the keyboard.
     Long commands are infrequently used or keyboard 
intensive commands.  The full names of these commands are listed
in this manual, but the commands, or any parameter keywords, may be 
stated by any unique abbreviation.
Long commands are terminated by a carriage return.
Some of these long commands require parameters which are entered
separated by spaces or commas.  
     The text screen displays the names of each of
the long commands and the character and a brief explanation for each of the
short commands.  The text screen is shown in figure 4.

.sh  1 "Commands."
     Following is a list of the commands available under \fIgremlin\fR and an
explanation of their use.  For each command, a header line is stated with the
keyboard sequence to invoke the command on the left followed 
by a brief description in the center, and the menu symbol, if any, along
the right hand side.
The commands are roughly organized into sections by overall function.
In many cases, a 'before' and 'after' picture is presented as an example.  In
these cases, the points are still displayed in the 'after' figure even though,
in practice, they would not remain.

.ll -.5i
.in +.5i
.ti -.5i
.sh 2 "Defining Objects."
.br
.GS R
file icon.vector
.GE
.sp -1
.ti -.5i
.HU "v 	Draw Vectors."
.sp 1
     Connects each of the points laid down, in the order specified, with 
straight lines to form an open or closed polygon.
     Example: Using the tablet cursor, lay down the following points in the
picture area:
.(b
.GS
f ex1.g
h 2
.GE
.)b
Next, move the cursor over the draw vector symbol in
the menu area and press the command button.  This action will cause the picture
below to appear.  In addition, the draw polygon command will be associated 
with the cursor button until replaced by another command.
.(b
.GS
f ex2.g
h 2
.GE
.)b
     Example 2: Put down the following points in the picture area (note that
point 5 actually coincides with point 0 and would be displayed that way
on the screen).
.(b
.GS
f ex3.g	
h 1.5
.GE
.)b
     Invoking the command results in:
.(b
.GS
f ex4.g	
h 1.5
.GE
.)b
     Each point used in defining a polygon is stored as a reference point.
.br
.GS R
file icon.arc
.GE
.sp -1
.ti -.5i
.HU "a 	Draw Arc."
.sp 1
     The command uses 3 points to define an arc.  The first point determines
the center of a circle.  The second defines a radius and, thus, is a point on
the circle.  The third point is optional and, if specified, determines a 
counter-clockwise angle from the second point which is the extent of the arc.
If the third point is omitted, or the angle is 0, a full circle is drawn.
     Example:  Assume the following points have been defined:
.(b
.GS
f ex5.g	
h 1.5
.GE
.)b
The arc drawn would appear as:
.(b
.GS
f ex6.g	
h 1.5
.GE
.)b
     Reference points on an arc are its center and endpoints.  For a full 
circle, the reference points are in the center and on the circumference at 
12:00, 3:00, 6:00, and 9:00.
.br
.GS R
file icon.curve
.GE
.sp -1
.ti -.5i
.HU "b 	Draw curve."
.sp 1
     A curve is defined by a number of points (knots) distributed along its
trajectory.  Two knots yield a straight line.  The more points specified, 
the smoother the curve is likely to be although it is usually unnecessary 
to specify many points.  Sharper bends require
more points and in the extreme case, 2 points on top of each other form a
cusp.  <ore than 2 consecutive points on top of each other will generate
an error.  If the first and last points of a curve are the same, a 
smooth closed figure will be drawn.
      For each of the examples below, the points shown at left 
would define the curve at right.
.(b
.GS
f ex7a.g	
w 6
.GE
.)b
.sp 2
.(b
.GS
f ex7b.g	
w 6
.GE
.)b
     All the points specified comprise the curve's reference points.
.br
.GS R
file icon.box
.GE
.sp -1
.ti -.5i
.HU "x 	Draw box"
.sp 1
     This command uses two points defining the endpoints of the diagonal
of a rectangle and draws that rectangle.  Boxes are stored internally as
vector elements and therefore, once created, have no special properties.
.br
.GS R
file icon.arrow
.GE
.sp -1
.ti -.5i
.HU "w 	Draw arrowhead."
.sp 1
     This command uses two points.
The first point represents
the point in the picture where the tip of the arrowhead is to be drawn. 
The second point indicates the direction the arrow points from.  This allows
arrowheads to be easily positioned at the end of lines already drawn.
     Example:  The two points at left yield the picture at right 
if the arrowhead command is invoked. 
.(b
.GS
f ex8.g
w 4
.GE
.)b
     Arrowheads are stored internally as vector elements.

.ti -.5i
.HU ":text string		Insert Text "
.sp 1
     Text can be positioned on one or 2 points.  If more than 1 point is
specified, the text is positioned on the point at the locus of the first
2 points.  Text entered will be stored in the current font and size, and 
positioned
according to the current justification.  Text is entered following the 
command (but preceded by a space) and is terminated by a carriage return.
The reference points, for text, are the respective outside, lower corners of
the first and last characters and the center of the string.

.ti -.5i
.sh  2 "Fonts and Brushes."
.sp 1
     The user has a choice of fonts and brushes available for drawing.
Fonts and brushes can be selected from the menu or the keyboard.  Character
size, however, is selected only from the keyboard.
.br
.GS R
f brushes.g
.GE
.sp -1
.ti -.5i
.HU ":brush n   	Select brush n."
.sp 1
     Currently, there are 6 brush types available called 'dotted', 'broken', 
\0'thick', 'dashed', 'narrow', and 'medium'.  The brushes may also be selected
by a number, 1-6, in the above order.
.br
.GS R
f fonts.g
.GE
.sp -1
.ti -.5i
.HU ":font n   	Select font n."
.sp 1
     The fonts are selected by name of Roman, Italics, Bold,
or Special fonts respectively.  Names may be shortened to any unique
abbreviation (in this case a single letter), and the first letter may
be upper or lower case.  Fonts may also be specified by an integer
between 1 and 4 according to the above order.

.ti -.5i
.HU ":justify mode   	Select justification mode."
.sp 1
.B ":justify - Text justification mode"
     This command specifies the current text justification mode.  Text can
be justified at the bottom, center, or top vertically and at the left, center,
or right horizontally.  The justification is specified as a 2 character code
representing the horizontal and vertical justification mode.  The characters
can be entered in either order, upper or lower case, but should not be 
separated by spaces.  
     Example: To justify a string at the left and bottom, the 
justification code could be entered as 'BL', 'bl', 'LB', or 'lb'.

.ti -.5i
.HU ":size n   	Select size n."
.sp 1
     This command chooses the size of the  current font.  The user has
a choice of 4 sizes designated by integers 1 though 4.  By convention, size 1
is usually the smallest and 4, the largest, but it is not necessary that they
be printed that way when hard copy is produced.


.ti -.5i
.sh 2 "Drawing Aids."
.sp 1
.GS R
file icon.horizontal
.GE
.sp -0.5
.ti -.5i
.HU ":hadjust   	Horizontal Adjust."
.sp 1
     This mode is toggled (on or off) each time the command is invoked.  
When on, horizontal adjustment forces each point laid down to
lie on a horizontal line from the previous point (i.e. only horizontal     
displacement of the cursor is used).  This mode can be useful for drawing
rectangles, etc.  When on, the menu symbol is highlighted by a box drawn around
it.  The current adjustment mode  is also indicated on the text screen.
.br
.GS R
file icon.vertical
.GE
.sp -1
.ti -.5i
.HU ":vadjust   	Vertical Adjust."
.sp 1
     This command is similar to horizontal adjust except that points are forced
vertical from their predecessors.  
.br
.GS R
file icon.horvert
.GE
.sp -1
.ti -.5i
.HU "z 	Manhattan Adjust."
.sp 1
     This command combines horizontal and vertical adjustment 
to automatically force a point to be directly horizontal or 
vertical with respect to the previous point, whichever it is closer to.
.br
.GS R
file icon.gravity
.GE
.sp -1
.ti -0.5i
.HU "g   	Gravity."
.sp 1
     This command toggles each time the command is invoked.
When on, gravity forces a point to coincide with the nearest
existing point or reference point.  Gravity will only take effect, however,
if the point is near enough to an element to be gravitated to it.
The gravity command icon is
highlighted when this mode is in effect and the gravity mode is also indicated
on the text screen.

.ti -0.5i
.HU ":align n  	Alignment."
.sp 1
     This command forces points to be aligned on pixel boundaries
as specified by the parameter (i.e. if alignment is 10, all points will
fall at pixels with addresses evenly divisible by 10).

.B
NOTE: If multiple modifiers are in effect for point positioning, the 
precedence is as follows:  Gravity will override alignment 
(cancelling the former's effect).  Adjustment will be applied to the point
to which the point has been gravitated.
.R
.br
.GS R
file icon.grid
.GE
.sp -1
.ti -0.5i
.HU "q   	Display Grid."
.sp 1
     This command also toggles each time it is invoked.  The
display grid command causes a grid to appear on the graphic
screen.  The grid spacing is 16 pixels.

.ti -0.5i
.HU ":orient   	Orientation."
.sp 1
     This command toggles orientation of the work area between horizontal
and vertical.

.ti -0.5i
.HU ":showpoints	Display reference points."
.sp 1
     This command causes all reference points of elements in the current
set to be displayed. This is useful for modifying reference points or
locating them to use in selection (e.g. on a curve).

.ti -0.5i
.sh 2 "Defining Sets."
.sp 1
.GS R
file icon.include
.GE
.sp -1
.ti -0.5i
.HU "d   	Define Current Set."
.sp 1
     This command uses points to select elements for the current set.
The points should be near, or touching, the reference points of the desired
elements. (gravity can be used to aid when laying down the points).  If no
points are specified, the entire picture becomes the current set.  The previous
contents of the current set are no longer selected.
The current set is highlighted in a blue-green color.
     Example:  If points are selected on a picture as shown below
.(b
.GS
f ex9.g
w 3
.GE
.)b
the current set would be defined as this:
.(b
.GS
f ex10.g
w 3
.GE
.)b
.br
.GS R
file icon.boxinc
.GE
.sp -1
.ti -0.5i
.HU "f  	Select Area for Current Set"
.sp 1
     Two points are used to define a rectangle (the points are the endpoints
of the diagonal of the rectangle).  All elements which lie \fBentirely\fR within the
rectangle are selected to define the current set.  The previous elements of
the current set are no longer selected.  The rectangle is not displayed.
     Example:  If the picture currently appears as below with points defined
as shown, the current set would become the picture at right.
.(b
.GS
f ex11.g
w 3
.GE
.)b

.ti -0.5i
.HU ":includeset	Include in Current Set"

     The selected elements are added to the current set along with whatever
elements currently comprise the set.
 
.ti -0.5i
.HU ":read filename  	Read Picture file"

     The symbol defined in file \fIfilename\fR is read into the picture
as the current set.  A point may be specified to position the file in the
picture.

.ti -0.5i
.HU "1,2,3,4  	Store current set in set buffer."

     The current set is copied into the specified set buffer
for possible later retrieval.  An optional positioning point may be specified
for for use in positioning the symbol when it is later copied into the
picture.  If no positioning point is specified, a point is selected from
among the reference points of the current set.
.br
.GS R
file icon.buffer
.GE
.sp -1
.ti -0.5i
.HU ":buffer n 	Retrieve set buffer."
.sp 1
     This command provides a means for selecting the sets, stored in 
buffers, from the keyboard.  The buffers are numbered top to bottom, 
left to right. 
This command requires one or more positioning points to indicate where in
the picture the buffer is to be copied, and a copy of the buffer is made at
each point.


.ti -0.5i
.sh 2 "Modifying Sets."
     In some of the transformations below (rotate, scale, mirror) text is
handled differently than other elements.  In those cases, the \fBposition\fR of
the text is appropriately transformed although the strings themselves will
remain upright, horizontal, and unchanged in size.
.br
.GS R
file icon.erase
.GE
.sp -1
.ti -0.5i
.HU "e 	Erase Current Set."
.sp 1
     This command erases elements in the current set.  
.br
.GS R
file icon.move
.GE
.sp -1
.ti -0.5i
.HU "t   	Translate (move) Current Set."
.sp 1
     To move requires 2 points.  The translation is through the relative 
distance between the points such that a portion of the picture at the 
first point will be moved to the second point.
.br
.GS R
file icon.copy
.GE
.sp -1
.ti -0.5i
.HU "c   	Copy Current Set."
.sp 1
     Copying uses 2 or more points.  A copy of the current set is made and
translated to by a relative distance between the first and each additional
point.  The last copy becomes the new current set.
.br
.GS R
file icon.scale
.GE
.sp -1
.ti -0.5i
.HU "s   	Scale Current Set."
.sp 1
     Scaling uses three points to define a transformation.  The set is scaled
by the ratio of the distances between the first and second and the first and 
third points.
     Scaling is most commonly used in one of two ways.  In the first,
the first and second points are used to delimit the current size of the
set while the first and third mark the desired size.  This is useful if 
the set must be scaled to fit within a given area.  Another way to view
scaling, which could be used to obtain a specific scale factor, is to specify
the desired reduction or enlargement (possibly using the grid as an aid) by
mapping out a distance between the first and second points and the desired
fraction of that distance between the first and third.

     Example: For the pictures below, the left drawing is before and
the right drawing is after the transformation was invoked.
.(b
.GS
f ex12.g
.GE
.)b
.sp 2
.(b
.GS
f ex13.g
.GE
.)b
.br
.GS R
file icon.rotate
.GE
.sp -1
.ti -0.5i
.HU "r  	Rotate Current Set"
.sp 1
     Three points are used to define a rotation.  The rotation is performed,
relative to the first point, through an angle formed by the lines 
between points 1 and 2 and points 1 and 3 respectively.
     Example:
.(b
.GS
f ex14.g
w 3.5
.GE
.)b
.br
.GS R
file icon.mirror
.GE
.sp -1
.ti -0.5i
.HU ":mirror   	mirror current set."
.sp 1
     Three points are also used to define a mirroring.  The mirroring takes
place about the x and/or y axes respectively if the third point is on the
opposite side of the first from the second in the x or y direction.
     Consider the following example:
.(b
.GS
f ex15.g
w 6.5i
.GE
.)b

.ti -0.5i
.HU ":mbrush brush   	Modify brush."
.sp 1
     This command causes the picture elements in the current set to be redrawn 
with a new brush. 
Brush names are the same as used
in the \fIbrush\fR command.

.ti -0.5i
.HU ":mfont font   	Modify font."
.sp 1
     This command causes any text picture elements in the current set to be 
redisplayed in a new font.  Font names are the same as used in the
\fIfont\fR command.

.ti -0.5i
.HU ":mtext string   	Modify text."
.sp 1
     This command causes any strings in the current set to be 
replaced by the specified string. 

.ti -0.5i
.HU ":msize size   	Modify size."
.sp 1
     This command causes any text picture elements in the current set to be 
redisplayed in a new character size.

.ti -0.5i
.HU ":mpoint   	Move point."
.sp 1
     This command uses one or more points and causes the element of the current
set which  contains the point closest to the first of these points to be
redrawn with that point replaced with the remaining points (deleted if there 
is only one point).
     Example:  If the current set is as shown on the left with the indicated
points specified, the new picture would look like that on the right.
.(b
.GS
f ex16.g
w 6.5
.GE
.)b

.ti -0.5i
.sh 2 "Other Commands."

.ti -.5i
.HU ":undo	Undo last command."
.sp 1
     This command undoes the last command which modified the picture as does
the blue mouse button.

.ti -.5i
.HU ":point x y  	Place point. "
.sp 1
     This command is used as a means for placing points in the picture area
from the text terminal.  \fIX\fR and \fIy\fR are the coordinates of the
point to be placed.  The origin of the coordinate system is in the lower
left hand corner and extends to 511 addressable points in the x direction
and 483 in the y direction.  Larger numbers will be wrapped around.

.ti -.5i
.HU ":deletepoint	Delete point. "
.sp 1
     This command erases the last point specified (same as the delete point
button on the cursor).

.ti -0.5i
.HU ":clearpoints   	Clear points."
.sp 1
     The \fB:clearpoints\fR command is used to clear (remove) the 
unused points on the screen.

.ti -0.5i
.HU ":littlepoint	Point size control"
.sp 1
     This command toggles the point display between the standard "+" followed
by an integer and a smaller "+" with no number.

.ti -0.5i
.HU ":path string   	Set path."
.sp 1
     \fIGremlin\fR implements a search path mechanism that makes it easier
to read in parts of the picture that are spread over several directories
or from a library.  The search path contains the names of one or more 
directories that \fIgremlin\fR will examine in order when opening files
for reading, it searches for the file in each of the directories in the
path until the open succeeds.  If no directory in the path contains the
file, one more attempt will be made to read the file from the gremlin
library 'gremlib' usually kept as a sub directory of the same directory
that the gremlin executable is kept (/usr/local/gremlib at Berkeley).
If the original file name begins with a "~" or "/" then the path mechanism
is bypassed and \fIgremlin\fR searches only in one place.
      \fIString\fR contains one or more directory names separated by colons
(":").  Directories may be specified using the "~" notation and "::" is 
equiavlent to ":.:".  If \fIstring\fR is not specified, the current search
path is printed at the text terminal.  The search path mechanism is used 
only for reading files.

.ti -0.5i
.HU ":edit   	Edit file."
.sp 1
     This command causes a new file to be opened for editing.  Any sets defined
in the set buffers are preserved across edits.  If the command
is issued before executing a write command (unless the picture has not been
modified), \fIgremlin\fR will complain with the following warning:

            \fINo write \fR

     Typing \fB:edit!\fR will override the warning condition and begin 
editing the new picture.

.ti -0.5i
.HU ":write filename  	Write picture to filename."
.sp 1
     Write out the picture to the current or specified edit file.
An optional positioning point may be specified to aid in positioning the
picture if it is later read in as part of another picture.  If no positioning
point is specified, one is selected from among the reference points of the 
picture.  If an existing file is specified on the command line as the target
for the write, \fIgremlin\fR will forgo the write and issue the following warning:

            \fIfile already exists\fR

     Typing \fB:write!\fR will cause the file to be written regardless.

.ti -0.5i
.HU ":saveset filename 	Write current set to filename."
.sp 1
     Similar to write except that the current set is written instead of
the entire picture.  Also, filename must be specified.

.ti -0.5i
.HU ":quit   	Quit."
.sp 1
     Quit ends the edit session and is entered only from the terminal keyboard.
If no write has been performed since the last time the picture was modified,
quit is not executed and instead the following warning is issued:

        \fINo write \fR

\fB:quit!\fR will override the warning and terminate execution.

.ti -0.5i
.HU "^L   	Update Screen."
.sp 1
     The delete command may leave blank spots on the screen where objects 
overlapped.  These blank spots do not actually exist in the picture and can
be properly observed by updating the screen.

.ti -0.5i
.HU "l  	update text screen."
.sp 1
     Occasionally, the text screen may become garbled (as the result
of a system broadcast message, for example).  This command causes the
text screen to be cleared and redisplayed.

.ti -0.5i
.HU "!   	Shell escape."
.sp 1
     This command interprets the remainder of the line on which it is typed
as a command to the UNIX shell.

.ti -0.5i
.HU ":gripe  	Leave a message."
.sp 1
     This command is included to leave a message for the person maintaining
the \fIgremlin\fR picture editor.  A temporary exit is taken to mail a complaint
to a predefined destination.  Use this feature to report
bugs, make suggestions for improvement or even pass along a few words of 
encouragement.

.in 0
.ll 6i
.sh 1 "Obtaining hard copy."
     There are two main methods for printing gremlin pictures.  \fIGrn\fR
is used for pictures inside a document (see the man pages for grn(l))
     \fIGremlin\fR picture files may be printed using the \fBgprint\fR program.
Gprint allows the user to associate specific fonts, sizes, and brush 
thicknesses with the symbolic drawing parameters specified when the picture 
was created.  Gprint is invoked as follows:

       gprint [options] filenames

     The options available are:

.in +1.0i
.ll -1i
.ti -.5i
-W
.br
Direct output to the wide (versatec) output device.

.ti -.5i
-V
.br
Direct output to the varian (default).

.ti -.5i
-x scale
.br
Scale picture by \fIscale\fR in x and y directions.

.ti -.5i
-R font
.br
Define Roman font to be \fIfont\fR.  The font name should
correspond to the font file name from /usr/lib/vfont without
the size indication and its preceding dot.  Default is "R".

.ti -.5i
-I font
.br
Define Italic font to be \fIfont\fR.  Default is "I".

.ti -.5i
-B font
.br
Define Bold font to be \fIfont\fR.  Default is "B".

.ti -.5i
-S font
.br
Define Special font to be \fIfont\fR.  Default is "S".

.ti -.5i
-1 size
.br
Define font size 1 to be \fIsize\fR.  Size is the point size from
the vfonts and care must be taken to assure that the fonts which use
it are available in this size.  As an example, if the user
desires to print using the Old English font in 14 point size 
(/usr/lib/vfont/oldenglish.14), the R font could be defined as "oldenglish" 
and size 1 as "14" (note no '.').  Default for size 1 is "10".

.ti -.5i
-2 size
.br
Define font size 2 to be \fIsize\fR.  Default is "14".

.ti -.5i
-3 size
.br
Define font size 3 to be \fIsize\fR.  Default is "24".

.ti -.5i
-4 size
.br
Define font size 4 to be \fIsize\fR.  Default is "36 ".

.ti -.5i
-N size
.br
Define narrow brush size to be \fIsize\fR.  The default narrow
line thickness is 1 pixel.  This is used for the narrow solid line and
the broken lines.  
For best results, an odd number of pixels of thickness is recommended.

.ti -.5i
-M size
.br
Define medium line size to be \fIsize\fR pixels.  Default is 5.

.ti -.5i
-T size
.br
Define thick line size to be \fIsize\fR pixels.  Default is 9.

.ti -.5i
-p
.br
Prompt for fonts and sizes.  Since there would be a large number of 
options specified if the user wished to reassign all of the fonts and
sizes, this option will cause gprint to prompt for each font and
size individually.  If nothing is specified to a given prompt (<cr>)
the parameter remains unchanged.

.ti -.5i
-t
.br
Direct the picture to the standard output instead of the Varian or Versatec.
This is useful for saving raster images or piping them over the network.
Pictures can then be printed using the gdump program.
.in -1.0i
.ll +1i
.hx
.bp
.tp
.sp 3i
.uh Acknowledgements.
.br
     I'd like to thank John Ousterhout for guidance and suggestions throughout
this project, for the numerous lines of Caesar code I plagiarized, and for
using the system to help find errors that existed.  I would also like to 
thank Dave Patterson, Linda Patterson, and Bob Roitblat for using earlier
versions of the system, locating errors and suggesting improvements.  Any
deficiencies which may still exist, however, are purely the fault of the 
author.
.hx
.bp
.b
.ce 1
Table of Contents.
.sp 2
.hx
.r
.xp
.bp
.ft CW
.nf
     font 1   size 1    brush 6    gravity OFF    align   4    NO ADJUSTMENT 
Editing: picture1                                            Text Mode: BL 
-------------------------------------------------------------------------------
    Long Commands:          |         Short Commands:
                            |
   Align          MSize     |   a - draw arc         ! - shell escape
   BRush          MText     |   b - draw curve*      . - repeat last command
   BUffer         Orient    |   c - copy set        ^L - redraw picture
   Clearpoints    Point     |   d - define set       l - redisplay text screen
   Deletepoint    Quit<!>   |   e - erase      1,2,3,4 - store set buffer
   Edit<!>        Read      |   f - define area 
   Font           Size      |   g - gravity
   Gripe          Text      |   q - grid
   Hadjust        Undo      |   r - rotate set
   Includeset     Vadjust   |   s - scale set
   Justify        Write<!>  |   t - translate set
   Littlepoint              |   v - draw vectors
   MBrush                   |   w - draw arrow 
   MFont                    |   x - draw box
   MIrror                   |   z - manhattan adjust
   MPoint                   |   

        Gremlin - Version 2.3 (1982)

                                            \fIFigure 1.\fP
.sp 1
.sp 1
.GS
narrow 3
medium 7
thick 11
height 4
f cursor.g
.GE
.bp
.pp
\0
.sp 1i
.po 0
.in 0
.ll 8.5i
.GS
width 7.8
f sample.g
.GE
