
/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *  
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */
#include "gremlin.h"

extern OpaqueFrame FrameList[];
extern CGRID;

Vertex v[100];

GRDisplayGrid()
{
	int x,y;
	if(CGRID<=16)
		/*
		 *  use an X pattern.
		 */
		GRDoGrid(0);
	else
		for(x=CGRID;x<FrameList[PAGE_WIN].width;x+=CGRID)
		{
			for(y=CGRID;y<FrameList[PAGE_WIN].height;y+=CGRID)
				XPixSet(FrameList[PAGE_WIN].self,x,y,1,1,BlackPixel);
			XSync(0);
		}
}  /* end DisplayGrid */

GRBlankGrid()
{
	int x,y;
	if(CGRID<=16)
		GRDoGrid(1);
	else
		for(x=CGRID;x<FrameList[PAGE_WIN].width;x+=CGRID)
		{
			for(y=CGRID;y<FrameList[PAGE_WIN].height;y+=CGRID)
				XPixSet(FrameList[PAGE_WIN].self,x,y,1,1,WhitePixel);
			XSync(0);
		}
}  /* end BlankGrid */

GRDoGrid(color)
int color;
{
	Pattern p;
	Window w;
	int i;

	p = XMakePattern(1<<(CGRID-1),CGRID,1);
	for (i=CGRID;i<FrameList[PAGE_WIN].width;i+=CGRID) {
		v[0].x = i;
		v[0].y = 0;
		v[0].flags = 0;
		v[1].x = i;
		v[1].y = FrameList[PAGE_WIN].height;
		v[1].flags = 0;
		XDrawDashed(FrameList[PAGE_WIN].self,v,2,1,1,color?WhitePixel:BlackPixel,p,GXcopy,AllPlanes);
	}
	XFlush();
}

