/*
 ******************************************************************************
 *
 * Module: bb_server.c
 *
 * Functions: 
 *	    main()		- The main routine, mostly generated by rpcgen
 *	    bb_server_init()	- Initialize all of the data structures.
 *	    bb_get_ip()		- Get the IP address of the calling function.
 *	    billboard_prog_1()	- The dispatch routine, generated by rpcgen.
 *
 *
 ******************************************************************************
 */

/*
 ******************************************************************************
 * Include Files
 ******************************************************************************
 */
#include <stdio.h>
#include <syslog.h>
#include <rpc/rpc.h>
#include "common.h"
#include "protocol.h"
#include "server.h"

static void billboard_prog_1();
char	*itoa();



/*************************************************************************
**									**
**  main() - The main server routine.  This was generated by rpcgen.	**
**  It was cut out of the rpcgen'ed code because there needs to be	**
**  initialization done inside of main.					**
**									**
*************************************************************************/
main()
{
	register SVCXPRT *transp;

	(void) pmap_unset(BILLBOARD_PROG, BILLBOARD_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, BILLBOARD_PROG, BILLBOARD_VERS, billboard_prog_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (BILLBOARD_PROG, BILLBOARD_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, BILLBOARD_PROG, BILLBOARD_VERS, billboard_prog_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (BILLBOARD_PROG, BILLBOARD_VERS, tcp).");
		exit(1);
	}

	/*
	**  Initialize the server.  Read all of the data structures and
	**  create the files that do not exist.  
	*/
	if ( bb_server_init() != BB_SUCCESS )
	{
	    fprintf( stderr, "ABORTING: Unable to init server database.\n");
	    return BB_FAILURE;
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}



/*************************************************************************
**									**
**  bb_server_init() - Initialize the servers database structures.	**
**  Setup or create the files if they do not exist.  Most errors with	**
**  the files will cause an abort.					**
**									**
*************************************************************************/
int
bb_server_init()
{

    if ( bb_read_companies() != BB_SUCCESS )
    {
	fprintf( stderr, "Unable to read company data file.\n");
	return BB_FAILURE;
    }

    if ( bb_read_passwords() != BB_SUCCESS )
    {
	fprintf( stderr, "Unable to read password file.\n");
	return BB_FAILURE;
    }

    if ( bb_read_phases() != BB_SUCCESS )
    {
	fprintf( stderr, "Unable to read phases file.\n");
	return BB_FAILURE;
    }

    if ( bb_read_board() != BB_SUCCESS )
    {
	fprintf( stderr, "Unable to read board file.\n");
	return BB_FAILURE;
    }
    
    return BB_SUCCESS;
}


/*************************************************************************
**									**
**  bb_get_ip() - From the transport structure of the caller copy the	**
**  IP address into an IP structure.					**
**									**
*************************************************************************/
static SVCXPRT	*bb_xprt;	/* The xport struct of the request.	*/

void
bb_get_ip( ip)
  BB_ip		ip;		/* Pointer to an ip for output.		*/
{
    char	line[20];	/* Just some space for an ip number.	*/

    (void)memset( (char *)ip, (int)0, (int)BB_IP_ADDR_LEN);
    sprintf( line, "%u.", bb_xprt->xp_raddr.sin_addr.S_un.S_un_b.s_b1);
    strncpy( ip, line, 4);
    sprintf( line, "%u.", bb_xprt->xp_raddr.sin_addr.S_un.S_un_b.s_b2);
    strncat( ip, line, 4);
    sprintf( line, "%u.", bb_xprt->xp_raddr.sin_addr.S_un.S_un_b.s_b3);
    strncat( ip, line, 4);
    sprintf( line, "%u", bb_xprt->xp_raddr.sin_addr.S_un.S_un_b.s_b4);
    strncat( ip, line, 3);
}


static void
billboard_prog_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		BB_set_in bb_set_1_arg;
		BB_set_in bb_unset_1_arg;
		BB_list_in bb_alist_1_arg;
		BB_list_in bb_blist_1_arg;
		BB_list_in bb_clist_1_arg;
		BB_list_in bb_dlist_1_arg;
		BB_passwd_in bb_passwd_set_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	/*
	**  This was added after rpcgen.
	*/
	bb_xprt = transp;


	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case BB_SET:
		xdr_argument = xdr_BB_set_in;
		xdr_result = xdr_BB_set_out;
		local = (char *(*)()) bb_set_1;
		break;

	case BB_UNSET:
		xdr_argument = xdr_BB_set_in;
		xdr_result = xdr_BB_set_out;
		local = (char *(*)()) bb_unset_1;
		break;

	case BB_ALIST:
		xdr_argument = xdr_BB_list_in;
		xdr_result = xdr_BB_list_out;
		local = (char *(*)()) bb_alist_1;
		break;

	case BB_BLIST:
		xdr_argument = xdr_BB_list_in;
		xdr_result = xdr_BB_list_out;
		local = (char *(*)()) bb_blist_1;
		break;

	case BB_CLIST:
		xdr_argument = xdr_BB_list_in;
		xdr_result = xdr_BB_list_out;
		local = (char *(*)()) bb_clist_1;
		break;

	case BB_DLIST:
		xdr_argument = xdr_BB_list_in;
		xdr_result = xdr_BB_list_out;
		local = (char *(*)()) bb_dlist_1;
		break;

	case BB_PASSWD_SET:
		xdr_argument = xdr_BB_passwd_in;
		xdr_result = xdr_int;
		local = (char *(*)()) bb_passwd_set_1;
		break;

	case BB_GRID:
		xdr_argument = xdr_void;
		xdr_result = xdr_BB_grid;
		local = (char *(*)()) bb_grid_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
