.ds X X
.ds Y Y
.ds Z Z
.TL
An Introduction to the Berkeley Network
.AU
Eric Schmidt
.AI
Computer Science Division
Department of Electrical Engineering and Computer Science
University of California, Berkeley
Berkeley, California 94720
.AB
This document describes the use of a network
between a number of
.UX
machines on the Berkeley campus.
This network can execute commands on other machines,
including file transfers, sending and receiving mail,
remote printing, and shell-scripts.
.PP
The network operates in a batch-request mode.
Network requests are queued up at the source and sent in shortest-first
order to the destination machine.
To do this, the requests are forwarded through a network
of inter-connected machines until they arrive at their destination
where they are executed.
The time this requires depends on system load, inter-machine transfer speed,
and quantity of data being sent.
.PP
The network enforces normal
.UX
security and
demands a remote account with a password for most commands.
Information can be returned to the user in files, for later
processing, or on the terminal for immediate viewing.
.AE
.SH
Introduction
.PP
A network between a number of
.UX
machines
on the Berkeley campus has been implemented.
This document is a brief introduction to the use of this network.
Information which is specific to the local network has been
gathered into Appendix A.
The new user should read both this introduction and Appendix A in order
to learn to use the network effectively.
.PP
This document is subdivided into the following sections:
.ds c Copying Files over the Network
.ds d Listing Requests in the Network Queue
.ds e Removing Requests from the Network Queue
.ds f Sending Mail over the Network
.ds g Reading Mail over the Network
.ds h Using the Lineprinter over the Network
.DS
Use of the Network
	1) \*c
	2) \*d
	3) \*e
	4) \*f
	5) \*g
	6) \*h
	7) Net Prototype Command
Setting Up Defaults
Appendix A: The Network at Berkeley
Appendix B: Getting Started \(em An Example
.DE
.PP
This manual is written in terms of three mythical machines,
named \*X, \*Y, and \*Z.
Specific names at Berkeley are in Appendix A,
along with more local information.
.SH
Use of the Network
.PP
The network provides facilities for issuing a command on one
machine (the
.I local
machine) which is to be executed on another (the
.I remote
machine).
Network commands are available to transfer files from one machine
to another, to send mail to a user on a remote machine,
to retrieve one's mail from a remote account,
or to print a file on a remote lineprinter.
These commands are described below, as is the more general
.I net
command which allows users to specify the name of some command
or shell script to be executed on a remote machine.
Network requests are queued on the local machine and sent to the remote
machine, forwarded through intermediate machines if necessary.
.PP
Most of the network commands require that you have an account on
the remote machine.
If a remote account is not needed for a particular command,
it will be noted in the following discussion.
The first example introduces procedures and responses which are applicable
to all network commands.
.sp 1.5
.NH
\*c
.PP
Suppose that you have accounts on both the \*X and \*Y machines and that you are
presently logged into the \*X machine.
If you want to copy a file named `file1' from your current
directory on machine \*X to machine \*Y (the
.I remote
machine), use the command:
.DS
% netcp file1 \*Y:file1
.DE
The net will make a copy of `file1' in your login directory
on the \*Y machine.
(The `\*Y:' will not be part of the filename on the \*Y machine.)
In order to verify your permission to write into the \*Y account, the
.I netcp
command will prompt you with:
.DS
Name (your-name):
.DE
You should respond with your login name on the Y machine,
followed by a carriage-return.
If you have the same login name on both machines, just type a carriage-return.
Next a password will be requested:
.DS
Password (remote-name):
.DE
Now type in your password followed by a carriage-return.
The
.I netcp
command will make a copy of your `file1' in a queue destined
for the \*Y machine, and will then return you to the shell.
.PP
Likewise if you wanted to transfer a file named `scan.p' from \*Y to \*X,
.DS
% netcp \*Y:scan.p scan.p
.DE
would place that file in your current directory on \*X.
.PP
The network will ``write'' you when it has executed
your request (if you are still logged in),
or will ``mail'' you a message (if you are not).
You may use the
.I mesg
(I) command to disallow the interruption and thus force mail to be sent.
A typical message might look like this:
.DS
Message from your-name on \*Y Machine
(command: netcp file1 \*Y:file1, sent April 1 18:03, took 10 min 3 sec)
-------
.DE
The message includes the time you sent the command on machine \*X.
.PP
The network response will tell you if it was unable to execute the
remote command successfully by returning an error message some time later.
If, for example, you type the wrong password, you will get the response
.DS
Message from your-name on \*Y Machine
Error: Cmd: netcp file1 \*Y:file1 Message: bad login/password your-name
------
.DE
.PP
The
.I netcp
command is actually a generalization of the
.UX
.I cp
command, similar to
.I uucp\fP\(dg.
.FS
\(dg See the
.UX
Programmers Manual (Version 7 only).
.FE
Its syntax is:
.DS
\fBnetcp\fR [\fB\-l\fI login\fR] [\fB\-p\fI password\fR] [\fB\-n\fR] [\fB\-f\fR] \fIfromfile tofile\fR
.DE
where
.I fromfile
and
.I tofile
can be local or remote files
(if both are remote, they must be on the same machine).
A filename which is not a full pathname
is either from the current directory on the local machine
or your login directory on the remote machine.
The
.B
\-l
.R
and
.B
\-p
.R
options may be used to specify your remote login name and password
on the command line.
If the password contains shell meta-characters, it must be in quotes.
(These options are useful in shell scripts,
but be sure to make the shell script readable only
by yourself if you've got passwords in it!)
The
.B
\-n
.R
option prevents any confirmation or error messages from being returned.
The
.B
\-f
.R
option forces prompting for a remote user name and password,
even if they are set by other options or are in the ``.netrc'' file
(see ``Setting Defaults'' below).
.PP
Transferred files may or may not have the correct file protection mode;
use the
.I chmod
(I) command to reset it.
When files are to be brought from a remote machine,
they are created zero-length at the time the command is issued;
when they arrive, they assume their true length.
.LP
Examples:
.RS
.TS
l l.
% netcp\ \ file1\ \ \*Y:file1	copy `file1' from the current directory to \*Y
% netcp\ \ \*Y:file1\ \ file1	copy `file1' from \*Y to the current directory
% netcp\ \ \*Z:file1\ \ \*Z:file2	\fIcp\fP command on remote machine
% netcp\ \ \*X:lex.c\ \ \*Y:lex.c	copy from \*X to \*Y (one of \*X or \*Y must be local)
% netcp\ \ \*Y:subdir/file1\ \ file1	copy from a sub-directory
% netcp\ \ file1\ \ file2	an error\(em use the \fIcp\fP command
.TE
.RE
.sp 1.5
.NH
\*d
.PP
To see where your command is in the queue, type
.DS
% netq
.DE
A typical output of which looks like:
.DS L
.cs R 23
 LocalName(Remote) Mach Length Code    Time         Command
yourname(yourname) \*Y       100 b99999  Mar 23 18:05  netcp file1 \*Y:file1
.cs R
.DE
The format is similar to that of the
.I lpq
command.
The files are sent one at a time, in the order listed.
If
.I netq
tells you the queue is empty, your request has been sent already.
The queues for different destinations are totally separate.
.DS
% netq \*Y
.DE
will list just the queue destined for the \*Y machine.
.I Netq
summarizes requests from other users.
The command
.DS
% netq \-a
.DE
will print the requests from all users.
.sp 1.5
.NH
\*e
.PP
If you want to cancel your net request, and ``b99999''
(see the
.I netq
example above) is your ``Code,'' use the command
.DS
% netrm b99999
.DE
which will remove the request (if it hasn't already been sent).
Furthermore,
.DS
% netrm \-
.DE
will remove all your net requests in the queues on the local machine
(you must have made the request in order to remove it).
.sp 1.5
.NH
\*f
.PP
To send mail to remote machines, use the
.I mail
command with the remote account prefixed by the destination machine's
name and a `:'.
``\*Y:schmidt'', for example, refers to an account ``schmidt'' on the \*Y machine.
The full sequence is illustrated below:
.DS
% mail \*Y:schmidt
\ \ \ \ {your message to user ``schmidt'' }
{control-d}
.DE
This will send to user ``schmidt'' on the \*Y machine the text you type in.
As with intra-machine mail, the message is terminated by a control-d.
.PP
You do not need an account on a remote machine to send mail to a user there.
.ne 9v
.sp 1.5
.NH
\*g
.PP
It is also possible to read your mail on remote machines.
From the \*X machine, the command
.DS
% netmail \*Y
.DE
copies your mail on the \*Y machine to a file ``mbox.\*Y''
in your login directory on the \*X machine.
The previous contents of ``mbox.\*Y'' are lost.
Readmail has
\fB\-l\fP, \fB\-p\fP, \fB\-n\fP and \fB\-f\fP options just like
.I netcp.
If a machine is not specified, the default machine\(dg is used.
.FS
\(dg (see ``Setting Defaults'' below)
.FE
When you login on the remote machine, the mail will still be there,
as if it was never read.
.sp 1.5
.NH
\*h
.PP
Remote lineprinters can be used with the
.I netlpr
command:
.DS
\fBnetlpr\fR [\fB\-m\fI machine\fR] \fIfile1 file2 ... filen\fR
.DE
which sends the files its arguments represent to the lineprinter on
.I machine.
It will prompt you for an account and password.
The \fB\-l\fR, \fB\-p\fR, \fB\-n\fR and \fB\-f\fR options may be supplied,
as in the
.I netcp
command.
Copies of the files are not made in the remote account.
.sp 1.5
.NH
Net Prototype Command
.PP
The above commands all use one more general command\(emthe
.I net
command which has the following form:
.DS
.ds a \fR[\fP
.ds b \fR]\fP
\fBnet \*a\-m\fI machine\*b \*a\fB\-l\fI login\*b \*a\fB\-p\fI password\*b \*a\fB\-r\fI file\*b \*a\fB\-\*b \*a\-n\*b \*a\-f\*b\fI command\fR
.DE
.I Net
sends the given command to a remote machine.
The machine may be specified either with the
.B
\-m
.R
option or in the ``.netrc'' file
(for the specific names, see Appendix A).
If not specified, a default is used.
\fB\-l\fP, \fB\-p\fP, \fB\-n\fP and \fB\-f\fP are as explained above for the
.I netcp
command.
The \fB\-r\fP option indicates the local
.I file
which will receive the output (the standard output and standard error files) of
.I command
when it is executed on the remote machine.
By default this output is written or mailed to you.
Thus, for example, to find out who is on the \*Y machine when you are
logged in on the \*X machine,
execute the following command:
.DS
% net \-m \*Y "who"
.DE
which will run the
.I who
command on the \*Y machine;
the response will be written or mailed to you.
Similarly,
.DS
% net \-m \*Y \-r resp "who"
.DE
will take the output (result)
and return it to you in file `resp' on the local machine.
If instead you want the result of the
.I who
command to remain on the \*Y machine the command
.DS
% net \-m \*Y "who >resp"
.DE
will create a file `resp' in your login directory on the \*Y machine.
It is a good idea to put the command in quotes, and it
.I must
be in quotes if I/O redirection (<, >, etc.) is used.
.PP
If you do not specify the remote machine explicitly (or in the ``.netrc''
file, explained below), the default machine will be used (see Appendix A).
.PP
The
.B
\-
.R
option indicates that standard input from the
local machine is to be supplied to the command executing remotely
as standard input, thus if defaults for the login name and password
are set up correctly as described below,
.DS
% net \-m \*Y \- "mail ripper"
\ \ \ \ { message to ripper }
{control-d}
.DE
is equivalent to
.DS
% mail \*Y:ripper
\ \ \ \ { message to ripper }
{control-d}
.DE
.PP
The net command also has other options not documented here.
See the
.UX
Programmer's Manual sections for more details.
.SH
Setting Defaults
.PP
Instead of repeatedly typing frequently-needed options
for every invocation of the various network commands, the user may supply
in his login directory a file ``.netrc'', which contains the repeated
information.
The ``.netrc'' file is typically used to specify login names
on remote machines, as well as other options.
An example of such a file is given below:
.DS
default \*Y
machine \*Y, login dracula
machine \*Z login dracula
.DE
.LP
This example sets the default machine to \*Y
so that for net commands where a remote machine is not explicitly specified
the command will the executed on the \*Y machine.
The second and third lines indicate
for the \*Y and \*Z machines a login name of ``dracula''
should be used to network commands.
The complete list of options that may follow the machine indication is:
.sp 1
.TS
center box;
cB s s s
l l l l.
 .netrc options for each machine
Option	Parameter	Default	Comment
_
\fBlogin\fP	name	localname	login name for remote machine
\fBpassword\fP	password	(none)	password for remote login name
\fBcommand\fP	command	(none)	default command to be executed
\fBwrite\fP	yes/no	yes	if possible, write to user
\fBforce\fP	yes/no	no	always prompt for name and password
.TE
.sp 1
.PP
In setting up the ``.netrc'' file, if the ``default'' option is present,
it must be the first line of the file.
The information for each machine starts with the word
``machine'' and the machine name and continues
one or more lines up to another machine indication
(or the end of the file).
Input is free-format.
Multiple spaces, tabs, newlines, and commas
serve as separators between words.
Double quotes (") must surround passwords with blanks or special
characters in them.
.PP
If your ``.netrc'' file has a password in it, the file should be set
mode 0600 with the
.I chmod
(I) command to prevent other people from reading it.
The system managers do not recommend putting the passwords
in the ``.netrc'' file
or in shell-scripts with the \fB\-p\fP option (even with mode 0600)
as an illicit super-user could read your ``.netrc'' file
and gain direct access to all your remote accounts.
If you put a remote password in a file, you must be prepared to change
.I ALL
your passwords if a security breach occurs on any net machine.
Instead of placing passwords in files,
if you are using a shell which allows shell variables,
you may define a variable to be your password and use the
.B
\-p
.R
option at the command level.
.SH
Log File
.PP
The file ``/usr/net/logfile'' has a trace of the most recent
requests and responses, each line of which is dated.
Lines indicating ``send'' show the file name sent;
lines indicating ``rcv'' show commands executed on the local machine (C: ),
their return code (R: ), and their originator.
For example, on the \*Y machine, the logfile:
.DS
.cs R 23
Feb 28 10:29: rcv \*X: neil (neil) R: 0 C: netcp design \*Y:design
Feb 28 10:43: sent to \*Z: tuck (z00466, 136 bytes, wait 2 min 3 sec)
Feb 28 11:05: rcv \*X: bill (bill) R: 0 C: netcp structures \*Y:structures
.cs R
.DE
shows three entries.
In this example, there are two
.I netcp
commands sending files from the \*X machine to \*Y, each from a different user.
The single command sent was originated here by ``tuck'' and is 136 bytes long;
the command that was sent is not listed.
The command
.DS
% netlog
.DE
will print the last few lines of this file.
Its prototype is
.DS
\fBnetlog \-\fInum\fR
.DE
where
.I num
is an integer will print the last
.I num
lines from the file.
.SH
Acknowledgements
.PP
Special thanks go to
Bob Fabry, Bill Joy, Vance Vaughan, Ed Gould, Robyn Allsman,
Bob Kridle, Jeff Schriebman and Ricki Blau of Berkeley,
and Dave Boggs of X\s-2EROX\s0 P\s-2ARC\s0
for their help in making this network possible.
.bp
.ce
.I "Appendix A"
.sp 2
.ce
The Network at Berkeley
.sp 2
.NH 0
The Configuration (May 1, 1979)
.sp
.R
.TS
center box;
cB s s s
l l l l l.
               The Current State of the Berkeley \s-2UNIX\s0 Network
Machine	Internal	Connected	Baud	Default
Name	Name	To	Rate	Machine
_
A	A	C	1200	C
C	C	A, D, E, Cory	1200	A
D	D	C, SRC	1200	C
E	E	C	1200	C
SRC	S	D	1200	D
VAX	V	Cory	1200	Cory
Cory	Y	C, VAX	1200	VAX
.TE
.de bo			\" a few box macros
.sp -1
\L'\\$1v'\
\l'\\$2n\(ul'\
\L'-\\$1v'\
\l'-\\$2n\(ul'
..
.de zt		\"generate up to 4 lines of centered text.
.ll \\$2n+\\n(.iu \"$2 is width of field in n's
.sp \\$1	\"$3,$4,$5,$6 are text lines
.ce 4		\"$1 is prespace amount in V's
\\$3
\\$4
\\$5
\\$6
.ce 0
.ll
.sp -4-\\$1
..
.KS
.LP
.nf
.sp
.nr v 4			\" vertical dimesion of box (in v's)
.nr h 14		\" horizontal dimenstion of box (in n's)
.in (\n(.lu/2u)-10n
.bo \nv \nh
.zt 1.5 \nh A
.in +7n
.in -\w'|'u/2u
.sp +3v
\L'4v'
.sp +4v
.in +\w'|'u/2u
.in -35n
.bo \nv \nh
.zt 1.5 \nh Cory
.in +14n
.sp +1
\l'14n\(ul'
.in +14n
.sp -2
.bo \nv \nh
.zt 1.5 \nh C
.in +14n
.sp +1
\l'14n\(ul'
.in +14n
.sp -2v
.bo \nv \nh
.zt 1.5 \nh D
.in -56n		\" back to start on left, draw boxes
.sp +8v
.bo \nv \nh
.zt 1.5 \nh VAX
.in +28n
.bo \nv \nh
.zt 1.5 \nh E
.in +28n
.bo \nv \nh
.zt 1.5 \nh SRC
.sp -8v
.in -56n		\" back to start on left, draw vert lines
.in +7n			\" next vert Cory-VAX
.in -\w'|'u/2u
.sp +3
\L'4v'
.sp +4
.in +\w'|'u/2u
.in -7n
.sp -8v
.in +28n		\" next vert C-E
.in +7n
.in -\w'|'u/2u
.sp +3
\L'4v'
.sp +4
.in +\w'|'u/2u
.in -7n
.sp -8v
.in +28n		\" next vert C-SRC
.in +7n
.in -\w'|'u/2u
.sp +3
\L'4v'
.sp +4
.in +\w'|'u/2u
.sp 5
.in 0
.fi
.KE
.LP
If a path exists from the local machine to the requested remote
machine, the network will forward the request to the correct machine.
Thus Cory users may communicate with A, D, E, and SRC,
as well as C and VAX (with a degradation in speed
because of the intermediate machine).
.NH
Documentation
.PP
The network commands
.I
(net, netq, netrm, netlog, netcp, netmail, netlpr)
.R
are all documented in the
.UX
Programmers Manual under UCB on the VAX,
and in Section VI on the Cory and Computer Center machines.
For example,
.DS L
	% man ucb netq	{on VAX}
or
	% man 6 netq	{on Cory and CC machines}
.DE
will print the
.I netq
manual section.
.PP
There are two more documents available:
.DS
Network System Manual
System Description \- Berkeley Net
.DE
The Manual is intended for the systems staff who will maintain the network.
The Description details
the history of the project, discusses the design, and lists future plans.
.PP
There is an up-to-date news file:
.DS L
	% news net		{on Cory and VAX machines}
or
	% help net			{on CC machines}
.DE
which prints news about the network, dated and with the most recent news first.
.PP
The
.UX
Programmer's Manual, section I, has information on the
.I
chmod, cp, mail, mesg, who,
.R
and
.I write
commands mentioned in the text.
Also, the
.I help
command has information about file protections:
.DS L
	% news access		{on the Cory machine}
or
	% help permissions	{on the CC machines}
.DE
.NH
Features at Berkeley
.IP a)
There is a built-in character limit
of 100,000 characters per single transmission, which cannot be overridden.
Longer files must be split into smaller ones in order to be sent.
.IP b)
The 1200 Baud links (over which the network sends requests) seldom transmit
any faster than 50 characters per second,
and can slow to a fraction of that in peak system loading periods.
This is due to an expansion of
the data packets to accomodate a seven-bit data path,
wakeup time on the machines, and the packet sent in acknowledgement.
Heavy file transfer is faster by magnetic tape.
.IP c)
On the VAX the net commands are all in `/usr/ucb'.
Your search path on the VAX should be set to include the directory `/usr/ucb';
otherwise you will have to prefix all net commands by `/usr/ucb',
as in `/usr/ucb/netcp'.
.IP d)
Limited Free Commands
.RS
.PP
Users who do not have accounts on remote machines may still execute
certain commands by giving a remote login name of ``network'',
and no remote password.
The commands currently allowed are:
.KS
.TS
l l l l.
finger	ps	rcslog	who
lpq	pstat	trq	whom
netlog	rcs	w	write
netq	rcsq	where	yank
.TE	
.KE
.LP
Also,
.I mail
to remote machines and
.I netlpr
between Computer Center machines do not require a remote account.
.RE
.IP e)
Instead of placing passwords in ``.netrc'' files, it is possible
to use the ``alias'' feature of the C shell (/bin/csh)
to specify a login name and password to the net commands, with
almost no execution speed penalty.
For example, the command
.DS
% alias netcp netcp -l godzilla -p passwd
.DE
will instruct the C shell to insert the specified login name
and password in the
.I netcp
command automatically.
.IP f)
If no machine name specification is in the front of a full path name,
the first four characters are checked and the machine
is inferred from that if possible.
In the command
.DS
netcp file1 /ca/schmidt/file1
.DE
the second file name is equivalent to ``C:file1'', if you are ``schmidt''
on the C machine.
.IP g)
The network can only send files in one direction at a time.
Thus confirmations can slow down heavy file transfer.
If you regularly use a shell script to transfer a set of files, the
.B
\-n
.R
option to
.I netcp
will improve transfer time.
.IP h)
There is a file ``VAX:/usr/net/net.users'' of users who
will get mail specifically about the network.
If you would like to be on it, send mail to ``VAX:schmidt''.
.IP i)
The network creates a heavy load on the system and thus is expensive to
run. If general user throughput is adversely affected, a charge will be
implemented on the Computer Center machines.
.IP j)
When transferring files, quota overflow will result in a partial copy,
so you should check the space requirements of the file being sent.
.NH
Bugs in systems at Berkeley (As of May 1, 1979)
.IP a)
On the Computer Center machines,
if the ``mail'' command prints an error message such as ``Can't send to ...'',
try using the ``sendmail'' command in place of ``mail'' with the
same arguments.
.IP b)
If you are on the Computer Center machines
using obsolete shells (/usr/pascal/sh, /usr/pascal/nsh)
and have a ``.profile'' or ``.shrc'' file to change your
shell prompt, you must make sure that you don't turn on ``prompting''
for non-interactive shells.
This will interfere with
.I netcp.
You should use this shell command to change your prompt:
.DS
${prompt?prompt=P}
.DE
where ``P'' is the prompt desired.
This will avoid the problem.
.IP c)
On the Computer Center machines, you may not
.I netrm
net queue files created by
.I netlpr
or the remote versions of
.I troff
and
.I trrm.
.IP d)
The file mode should be preserved by
.I netcp.
.IP e)
The
.B
\-n
.R
option to
.I
netcp, netmail, netlpr
.R
and
.I net
should not prevent error messages from being returned.
Also,
.I mail
(1) should accept the
.B
\-n
.R
option.
.IP f)
Comments and bug discoveries are encouraged and can be sent by
local or remote mail to ``schmidt'' on the VAX machine.
.bp
.ce
.I "Appendix B"
.sp 2
.ce
Getting Started \(em An Example
.sp
.LP
The best way to start out is to follow this example.
Suppose you're a Cory user, and you have accounts on the A and VAX machines.
.IP 1)
Add a file ``.netrc'' (mode 600) to your login directory, as in
the following example:
.DS L
default VAX
machine A login \fIyourNameOnA\fP
machine VAX login \fIyourNameOnVax\fP
.DE
(If ``default'' occurs, it must be the first line of the file.)
.IP 2)
Make sure that
.RS
.IP a)
if you are on the VAX, you have in your search path the directory `/usr/ucb'.
Otherwise, on the VAX you will have to prefix all commands by `/usr/ucb/'
(e.g. `/usr/ucb/netcp').
.IP b)
on the Computer Center machines, if you choose to set your shell prompt,
you have done so correctly (details in Appendix A).
.RE
.IP 3)
Then type
.DS L
% net w
% netq
.DE
which will send a
.I w
command to the VAX;
some undetermined time later you will
have written (or mailed) to you the output from the command
executed on the VAX machine.
.IP
The adventuresome may try:
.DS L
% net \-m A w
.DE
with the effect of being routed more slowly through an intermediate link in the
net.
