/* (-lgl
 *	Coherent 386 release 4.2
 *	Copyright (c) 1982, 1993 by Mark Williams Company.
 *	All rights reserved. May not be copied without permission.
 *	For copying permission and licensing info, write licensing@mwc.com
 -lgl) */

#ifndef	__COMMON__SIZE_H__
#define	__COMMON__SIZE_H__

/*
 * This internal header file is intended as the sole point of definition for
 * the ISO C data type "size_t".  To support cross-compilation environments,
 * this header file uses a variety of feature tests to avoid conflict with
 * definitions provided elsewhere by a translator's headers.
 *
 * To support efficiency hacks where the fundamental type on which a "size_t"
 * is based needs to be known at preprocessing time, we also supply that data
 * from the underlying definition.  Caveat utilitor.
 */

#include <common/feature.h>
#include <common/__size.h>

#if	__BORLANDC__ || __COHERENT__

/*
 * Note that Borland want to use _SIZE_T to prevent multiple definition of
 * "size_t", which is fine by us.  We overload this for our own purposes by
 * giving it a non-empty definition, however.
 */

# ifndef	_SIZE_T
typedef	__size_t	size_t;
# else
#  undef	_SIZE_T
# endif

#define	_SIZE_T		___SIZE_T

#elif	__GNUDOS__

/*
 * For DJCC v1.09, you will have to modify <stddef.h> to prevent multiple
 * definitions of "size_t". The headers in DJCC are totally hosed.  In
 * addition, GCC mandates "unsigned long" for reasons connected to built-in
 * versions of library functions.
 */

# ifndef	_SIZE_T
typedef	__size_t	size_t;
# else
#  undef	_SIZE_T
# endif

#define	_SIZE_T		___SIZE_T

#else

#error	size_t not known for this system

#endif

#endif	/* ! defined (__COMMON__SIZE_H__) */
