/* filename	: parted.c
 * purpose	: display partition info
 * author	: Randy Wright
 * Copyright	: ((C)) Copyright 1993 Randy Wright
 *
 * $LOG$
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/fdisk.h>
#include <fcntl.h>
#include <errno.h>

main(argc,argv)
int argc;
char **argv;
{
char xdev[80];
int i, fd;
HDISK_S hd;
FDISK_S *fptr;

if( argc < 2 )
	{
	printf( "Xdevice : "); fflush(stdout);
	gets(xdev);
	}
else
	{
	strncpy(xdev, argv[1], 80 );
	}

if( (fd = open( xdev, O_RDONLY)) < 0 )
	{
	printf( "Can't open %s\n", xdev );
	exit(1);
	}

if( (lseek( fd, 0L, 0 )) < 0 )
	{
	printf( "can't lseek to begining of drive %s\n", xdev );
	close(fd);
	exit(1);
	}

if( (read(fd, &hd, 512)) != 512 )
	{
	printf( "bad read of %s\n", xdev );
	perror("");
	close(fd);
	exit(1);
	}

printf( "signature : %d\n", hd.hd_sig );
printf( "n boot\tbhd\tbsec\tbcyl\tsys\tehd\tesec\tecyl\tbase\tblks\n");
for( i=0, fptr = &hd.hd_partn[0]; i < 4;  i++, fptr++ )
	{
printf( "%d %d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%u\t%u\n",
i, fptr->p_boot, bhd(fptr), bsec(fptr), bcyl(fptr), fptr->p_sys, ehd(fptr),
esec(fptr), ecyl(fptr), fptr->p_base, fptr->p_size );
	}

close(fd);
exit(0);
}
