/* rename - change the name of file
 * 91.11.02 by Tomohiro Ishikawa (ishikawa@gaia.cow.melco.CO.JP)
 * 92.01.20 little modified (added #ifdef) by Masaru Oki
 */

#ifdef NOFTRUNCATE
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/stat.h>

int
rename(from, to)
char *from, *to;
{
	struct	stat s1,s2;
	extern	int errno;

	if (stat(from, &s1) < 0)
		return(-1);
	    /* is 'FROM' file a directory? */
	if ((s1.st_mode & S_IFMT) == S_IFDIR){
		errno = ENOTDIR;
		return(-1);
	}
	if (stat(to, &s2) >= 0) { /* 'TO' exists! */
		/* is 'TO' file a directory? */
		if ((s2.st_mode & S_IFMT) == S_IFDIR){
			errno=EISDIR;
			return(-1);
		}
		if (unlink(to) < 0)
			return(-1);
	}
	if (link(from, to) < 0)
		return(-1);
	if (unlink(from) < 0)
		return(-1);
	return(0);
}
#endif /* NOFTRUNCATE */
