/*
   Copyright (c) 1994 by Harry Pulley.

   May be freely distributed and modified provided that this copyright notice
   is not removed.  I am not responsible for any damages caused in any way,
   shape or form.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <poll.h>
#include <sys/sbioctl.h>

unsigned long swapper();

unsigned char tconst;
unsigned short samplespersec;
unsigned long buflen;
FILE *fp;
char magic[5];
unsigned long datalen,hdr_size,encoding,channels;
struct pollfd sbpoll[1];

int sb_fd,delay;

unsigned char *aligned0,*aligned1;
struct sb_ioctl sbis;
unsigned char sb_status;

void main ( argc, argv )
int argc;
char **argv;
{
    int num=0;

    unsigned long count;

    if(argc<2)
    {
        printf("Usage: %s <infile>.\n",argv[0]);

        exit(0);
    }

    sb_fd=open("/dev/sb",O_RDWR);

    if (sb_fd<0)
    {
	printf("Unable to open SB driver.\n");

	exit(1);
    }

    sbpoll[0].fd=sb_fd;
    sbpoll[0].events=POLLOUT;

    if((fp=fopen(argv[1],"r"))==0)
    {
        printf("Unable to open %s for reading.\n",argv[1]);

        exit(1);
    }

#if 0
    printf("file: %s.\n",argv[1]);
#endif
    sbmalloc();

    fread(magic,1,4,fp);

    magic[4]=0;

#if 0
    printf("%s\n",magic);
#endif

    if (strcmp(magic,".snd"))
    {
	printf("Not a .au file.\n");
	exit(2);
    }

    fread(&hdr_size,1,4,fp);
    fread(&datalen,1,4,fp);
    fread(&encoding,1,4,fp);
    fread(&samplespersec,1,4,fp);
    fread(&channels,1,4,fp);

    hdr_size=swapper(hdr_size);
    datalen=swapper(datalen);
    encoding=swapper(encoding);
    samplespersec=swapper(samplespersec);
    if (samplespersec==0)
	samplespersec=8000;
    channels=swapper(channels);

    if (datalen=0xffffffff)
    {
	fseek(fp,0,2);
	datalen=ftell(fp)-hdr_size;
    }

#if 0
    printf("hdrlen %X datalen %X encod %X samp %X chan %X\n",hdr_size,datalen,encoding,samplespersec,channels);
#endif

    delay=1000*(BUF_SIZE)/samplespersec;
    delay-=delay%10;

#if 0
    printf("Delay: %d.\n",delay);
#endif

    tconst=time_const(samplespersec);
#if 0
    printf("Time Constant %u.\n",tconst);
#endif

    sbsettconst(tconst);

    sbspkon();
    sbplay(1,num);
    sbspkoff();
    sbspkon();

    if(datalen>(BUF_SIZE)) buflen=(BUF_SIZE); else buflen=datalen;
    datalen-=buflen;
    
    fseek(fp,hdr_size,0);

    fread(aligned0,1,buflen,fp);

    for (count=0;count<buflen;count++)
	aligned0[count]=aligned0[count]>>2;

    while(1)
    {
	sbplay(buflen,num);

        num=(num==1)?0:1;

#if 0
	delay=1000*buflen/samplespersec;
        delay-=delay%10;
#endif

	if (datalen==0)
	{
		poll(sbpoll,1,-1);

		break;
	}
	else
	{
        	if(datalen>(BUF_SIZE)) buflen=(BUF_SIZE); else buflen=datalen;
        	datalen-=buflen;
		fread((num==1)?aligned1:aligned0,1,buflen,fp);

		if (num==0)
    			for (count=0;count<buflen;count++)
				aligned0[count]=aligned0[count]>>2;
		else
    			for (count=0;count<buflen;count++)
				aligned1[count]=aligned1[count]>>1;

		poll(sbpoll,1,-1);
	}
    }
    sbspkoff();

    close(sb_fd);
}

sbmalloc()
{
	aligned0=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned0==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned0)%PAGE_SIZE)
		aligned0+=PAGE_SIZE-(((unsigned long)aligned0)%PAGE_SIZE);

	aligned1=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned1==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned1)%PAGE_SIZE)
		aligned1+=PAGE_SIZE-(((unsigned long)aligned1)%PAGE_SIZE);

	sbis.buffer_addr=aligned0;
	sbis.buffer_len=BUF_SIZE;

	errno=0;

	ioctl(sb_fd,MAP_BUFFER0,&sbis);

	if (errno)
	{
		printf("Error %d on map 0.\n",errno);

		exit(5);
	}

	sbis.buffer_addr=aligned1;
	
	errno=0;

	ioctl(sb_fd,MAP_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d on map 1.\n",errno);

		exit(5);
	}
}

sbsettconst(val)
unsigned char val;
{
	sbis.parameter=val;

	ioctl(sb_fd,SET_TIMECONST,&sbis);
}

sbspkon()
{
	ioctl(sb_fd,SPKR_ON,&sbis);
}

sbspkoff()
{
	ioctl(sb_fd,SPKR_OFF,&sbis);
}

sbhaltdma()
{
	ioctl(sb_fd,DMA_HALT,&sbis);
}

sbplay(len,bufnum)
unsigned long len;
int bufnum;
{
	sbis.buffer_len=len;

	/* printf("len %ld\n",len); */

	errno=0;

	ioctl(sb_fd,(bufnum==0)?PLAY_BUFFER0:PLAY_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d playing %d.\n",errno,bufnum);

		sbspkoff();

		exit(5);
	}
}

dmastatus()
{
	sbis.status=&sb_status;

	ioctl(sb_fd,DMA_STATUS,&sbis);

	printf("%d\n",sb_status&2);

	return (sb_status&2);
}

unsigned long swapper(in)
unsigned long in;
{
	unsigned long temp=0;

	temp|=(in&0xff000000)>>24;
	temp|=(in&0x00ff0000)>>8;
	temp|=(in&0x0000ff00)<<8;
	temp|=(in&0x000000ff)<<24;

	return temp;
}
