#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/reg.h"
#include "../h/inode.h"
#include "../h/acct.h"
#include "../h/signal.h"
#include "../h/370.h"
#include "../h/bitmap.h"
#include "../h/text.h"

/*
 * exec system call, with and without environments.
 */
struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

exec()
{
	((struct execa *)u.u_ap)->envp = NULL;
	exece();
}

exece()
{
	register nc;
	register char *cp;
	register struct execa *uap;
	int na, ne, ucp, ap, c;
	struct inode *ip;
	caddr_t p = NULL;

	if ((ip = namei(uchar, 0)) == NULL)
		return;
	if(access(ip, IEXEC))
		goto bad;
	if((ip->i_mode & IFMT) != IFREG ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) {
		u.u_error = EACCES;
		goto bad;
	}
	/*
	 * Collect arguments on "file" in swap space.
	 */
	na = 0;
	ne = 0;
	nc = 0;
	uap = (struct execa *)u.u_ap;
	cp = p = getpage();
	if (uap->argp) for (;;) {
		ap = NULL;
		if (uap->argp) {
			ap = fuword((caddr_t)uap->argp);
			uap->argp++;
		}
		if (ap==NULL && uap->envp) {
			uap->argp = NULL;
			if ((ap = fuword((caddr_t)uap->envp)) == NULL)
				break;
			uap->envp++;
			ne++;
		}
		if (ap==NULL)
			break;
		na++;
		if(ap == -1)
			u.u_error = EFAULT;
		do {
			if (nc >= NCARGS-1)
				u.u_error = E2BIG;
			if ((c = fubyte((caddr_t)ap++)) < 0)
				u.u_error = EFAULT;
			if (u.u_error)
				goto bad;
			nc++;
			*cp++ = c;
		} while (c>0);
	}
	nc = (nc + NBPW-1) & ~(NBPW-1);
	if (getxfile(ip, nc) || u.u_error)
		goto bad;

	/*
	 * copy back arglist
	 */

	ucp = -nc - NBPW;
	ap = ucp - na*NBPW - 3*NBPW;
	u.u_ar0[R13] = ap;
	grow(ap);
	suword((caddr_t)ap, na-ne);
	cp = p;
	nc = 0;
	for (;;) {
		ap += NBPW;
		if (na==ne) {
			suword((caddr_t)ap, 0);
			ap += NBPW;
		}
		if (--na < 0)
			break;
		suword((caddr_t)ap, ucp);
		do {
			subyte((caddr_t)ucp++, (c = *cp++));
			nc++;
		} while(c&0377);
	}
	suword((caddr_t)ap, 0);
	suword((caddr_t)ucp, 0);
	setregs();
bad:
	if (p)
		freepag(p);
	iput(ip);
}

/*
 * Read in and set up memory for executed file.
 * Zero return is normal;
 * non-zero means only the text is being replaced
 */
getxfile(ip, nargc)
register struct inode *ip;
{
	register int ts, ds;
	register overlay;
	struct text *xp, *xcheck();

	/*
	 * read in first few bytes
	 * of file for segment
	 * sizes:
	 * ux_mag = 407/410/411/405
	 *  407 is plain executable
	 *  410 is RO text
	 *  411 is separated ID (same as RO text for 470)
	 *  405 is overlaid text
	 */

	if (xp = xcheck(ip))
		u.u_exdata = xp->x_exdata;
	else {
	        u.u_base = (caddr_t) &u.u_exdata;
	        u.u_count = sizeof (u.u_exdata);
	        u.u_offset = 0;
	        u.u_segflg = 1;
	        readi(ip);
	        u.u_segflg = 0;
	        if (u.u_error)
		        goto bad;
	        if (u.u_count!=0) {
		        u.u_error = ENOEXEC;
		        goto bad;
	        }
	}
	overlay = 0;
	if(u.u_exdata.ux_mag == 0407) {
		u.u_exdata.ux_dsize += u.u_exdata.ux_tsize;
		u.u_exdata.ux_tsize = 0;
	} else if (u.u_exdata.ux_mag == 0405)
		overlay++;
	else if (u.u_exdata.ux_mag != 0410 && u.u_exdata.ux_mag != 0411) {
		u.u_error = ENOEXEC;
		goto bad;
	}
	if(u.u_exdata.ux_tsize!=0 && (ip->i_flag&ITEXT)==0 && ip->i_count!=1) {
		u.u_error = ETXTBSY;
		goto bad;
	}

	/*
	 * find text and data sizes
	 * try them out for possible
	 * overflow of max sizes
	 */
	ts = btoc(u.u_exdata.ux_tsize);
	ds = btoc(u.u_exdata.ux_dsize + u.u_exdata.ux_bsize);
	if ((ts+ds+SSIZE)-(u.u_tseg.u_size+u.u_dseg.u_size+u.u_sseg.u_size) >= pagecnt-PAGSLOP
	      || ts+ds+SSIZE > maxmem) {
		u.u_error = ENOMEM;
		goto bad;
	}
	if (overlay) {
		if (ctos(ts) != ctos(u.u_tseg.u_size) || nargc) {
			u.u_error = ENOMEM;
			goto bad;
		}
		xfree();
		xalloc(ip);
		u.u_ar0[RPC] = (u.u_exdata.ux_entloc & ~01) & PCMASK;
	} else {
		/*
		 * at this point, we are committed
		 * to the new image
		 */
	
		xfree();
		freesgs(&u.u_dseg);
		freesgs(&u.u_sseg);
		xalloc(ip);
		sbreak1(ds, &u.u_dseg);
		grow1(SSIZE, &u.u_sseg);
	        mkstab(&u, 1);
	
		/*
		 * read in data segment
		 */
	
		if (xp || (xp = xcheck(ip)))
			copysgs(&xp->x_dseg, &u.u_dseg);
		else {
		        u.u_base = (caddr_t) ctob(stoc(ctos(ts)));
		        u.u_offset = sizeof(u.u_exdata)+u.u_exdata.ux_tsize;
		        u.u_count = u.u_exdata.ux_dsize;
		        readi(ip);
		}
		/*
		 * set SUID/SGID protections, if no tracing
		 */
		if ((u.u_procp->p_flag&STRC)==0) {
			if(ip->i_mode&ISUID)
				if(u.u_uid != 0) {
					u.u_uid = ip->i_uid;
					u.u_procp->p_uid = ip->i_uid;
				}
			if(ip->i_mode&ISGID)
				u.u_gid = ip->i_gid;
		} else if(btst(u.u_sigtr, SIGEXEC))
			psignal(u.u_procp, SIGEXEC);
	}
bad:
	return(overlay);
}

/*
 * Clear registers on exec
 */
setregs()
{
	register int *rp;
	register i;
	extern char regloc[];

	for(rp = &u.u_signal[0]; rp < &u.u_signal[NSIG]; rp++)
		if((*rp & 1) == 0)
			*rp = 0;
	for(i=0; i<13; i++)
		u.u_ar0[regloc[i]] = 0;
	u.u_ar0[R14] = u.u_ar0[R15] = 0;
	u.u_ar0[RPC] = (u.u_exdata.ux_entloc & ~01) & PCMASK;
	for(rp = &u.u_ar0[FR0]; rp <= &u.u_ar0[FR6+1];)
		*rp++ = 0;
	for(i=0; i<NOFILE; i++) {
		if (u.u_pofile[i]&EXCLOSE) {
			closef(u.u_ofile[i]);
			u.u_ofile[i] = NULL;
			u.u_pofile[i] &= ~EXCLOSE;
		}
	}
	/*
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	bcopy((caddr_t)u.u_dbuf, (caddr_t)u.u_comm, DIRSIZ);
}

/*
 * exit system call:
 * pass back caller's arg
 */
rexit()
{
	register struct a {
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit(rv)
{
	register int i;
	register struct proc *p, *q;
	register struct file *f;

	p = u.u_procp;
	if (p->p_pid == 1) {
		printf("Process 1 dying with exit status %x\n", rv);
		panic("Process 1 died.");
	}
	p->p_flag &= ~(STRC|SULOCK);
	p->p_clktim = 0;
	for(i=0; i<NSIG; i++)
		u.u_signal[i] = 1;
	for(i=0; i<NOFILE; i++) {
		f = u.u_ofile[i];
		u.u_ofile[i] = NULL;
		closef(f);
	}
	plock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir) {
		plock(u.u_rdir);
		iput(u.u_rdir);
	}
	xfree();
	acct();
	freesgs(&u.u_dseg);
	freesgs(&u.u_sseg);
	frestab(u.u_segtab);
	p->p_stat = SZOMB;
	((struct xproc *)p)->xp_xstat = rv;
	((struct xproc *)p)->xp_utime = u.u_cutime + u.u_utime;
	((struct xproc *)p)->xp_stime = u.u_cstime + u.u_stime;
	for(q = &proc[0]; q < &proc[NPROC]; q++)
		if(q->p_ppid == p->p_pid) {
			wakeup((caddr_t)&proc[1]);
			q->p_ppid = 1;
			if (q->p_stat==SSTOP)
				setrun(q);
		}
	for(q = &proc[0]; q < &proc[NPROC]; q++)
		if(p->p_ppid == q->p_pid) {
			wakeup((caddr_t)q);
			swtch();
			/* no return */
		}
	swtch();
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
	register f;
	register struct proc *p;
	int i;

	f = 0;

loop:
	for(p = &proc[0]; p < &proc[NPROC]; p++)
	if(p->p_ppid == u.u_procp->p_pid) {
		f++;
		if(p->p_stat == SZOMB) {
			u.u_r.r_val1 = p->p_pid;
			u.u_r.r_val2 = ((struct xproc *)p)->xp_xstat;
			u.u_cutime += ((struct xproc *)p)->xp_utime;
			u.u_cstime += ((struct xproc *)p)->xp_stime;
			p->p_pid = 0;
			p->p_ppid = 0;
			p->p_pgrp = 0;
			for(i=0; i<sizeof p->p_sig; i++) p->p_sig[i] = 0;
			p->p_flag = 0;
			p->p_wchan = 0;
			p->p_stat = NULL;
			return;
		}
		if(p->p_stat == SSTOP) {
			if((p->p_flag&SWTED) == 0) {
				p->p_flag |= SWTED;
				u.u_r.r_val1 = p->p_pid;
				u.u_r.r_val2 = (p->p_addr->u_ps.ps_sig<<8) | 0177;
				return;
			}
			continue;
		}
	}
	if(f) {
		sleep((caddr_t)u.u_procp, PWAIT);
		goto loop;
	}
	u.u_error = ECHILD;
}

/*
 * fork system call.
 */
fork()
{
	register struct proc *p1, *p2;
	register a;

	/*
	 * Make sure there's enough memory for the new process
	 */
	if (u.u_dseg.u_size+u.u_sseg.u_size >= pagecnt-PAGSLOP) {
		u.u_error = ENOMEM;
		goto out;
	}
	a = 0;
	p2 = NULL;
	for(p1 = &proc[0]; p1 < &proc[NPROC]; p1++) {
		if (p1->p_stat==NULL && p2==NULL)
			p2 = p1;
		else {
			if (p1->p_uid==u.u_uid && p1->p_stat!=NULL)
				a++;
		}
	}
	/*
	 * Disallow if
	 *  No processes at all;
	 *  not su and too many procs owned; or
	 *  not su and would take last slot.
	 */
	if (p2==NULL || (u.u_uid!=0 && (p2==&proc[NPROC-1] || a>MAXUPRC))) {
		u.u_error = EAGAIN;
		goto out;
	}
	p1 = u.u_procp;
	if(newproc()) {
		u.u_r.r_val1 = p1->p_pid;
		u.u_start = time;
		u.u_cstime = 0;
		u.u_stime = 0;
		u.u_cutime = 0;
		u.u_utime = 0;
		u.u_rdwr = 0;
		u.u_acflag = AFORK;
	        u.u_ps.ps_tslice = T_SLICE;
		for(a = 0; a < sizeof u.u_sigtr; a++)
			u.u_sigtr[a] = 0;
		return;
	}
	u.u_r.r_val1 = p2->p_pid;

out:
	u.u_ar0[RPC] += NBPW;
}

/*
 * break system call.
 *  -- bad planning: "break" is a dirty word in C.
 */
sbreak()
{
	struct a {
		char	*nsiz;
	};
	register n, d;

	/*
	 * set n to new data size
	 * set d to new-old
	 */

	n = btoc((int)((struct a *)u.u_ap)->nsiz);
	n -= ctos(u.u_tseg.u_size) * stoc(1);
	if(n < 0) {
		u.u_error = EFAULT;
		return;
	}
	d = n - u.u_dseg.u_size;
	if(d >= pagecnt || (d+u.u_tseg.u_size+u.u_dseg.u_size+u.u_sseg.u_size > maxmem)) {
		u.u_error = ENOMEM;
		return;
	}
	sbreak1(d, &u.u_dseg);
	mkstab(&u, d < 0);
}
