%term PRINTOP SYMBOL LSYMBOL NUMBER PREG PPSW
%term DIVIDE DOTDOT CNTLREG PCNTLREG REG
%term BRKP BRKPCNT GO CONT SS BREAKS CLEAR
%term CMD COMMENT
%term IF MACRO ENTER EXIT
%term NE EQ LE GE AND OR
%term INC DEC
%term LEXERR
%term PSW CSW CAW PCSW PCAW TRACE
%term INT EXT SSS
%term IO PGM MCK RESTART
%term DVIRT
%binary ','
%binary ':'
%right '='
%left OR
%left AND
%left EQ NE
%left '<' LE '>' GE
%left '+' '-'
%right '~'
%left '*' DIVIDE
%left INDIR
%left '[' '.'
%{
#include "omak.h"
#define BUMPDOWN (PRINST ? (dotdot -= instlen) : (dot -= prtlen))
#define BUMPUP (PRINST ? (dotdot += instlen) : (dot += prtlen))
#define BUMPDOT (PRINST ? tnode(DOTDOT, 0, 0, 0) : &dotnode)
#define SPECIAL 0x7980

static struct tnode dotnode { '.', 0, 0, 0 };
static int ifflg = 0;
static int pugserr = 0;
static int left_br = 0;
static int apterr = 0;
static int goflg = 0;
struct tnode *special;
%}
%%
%{
BP *bpp ;
%}
input:
	input req '\n'          ={ if ($2) {
                                            if (!apterr) doreq($2, 0);
                                              else  drain();
                                           }
                                   apterr = 0;
                                   tnodecnt = 0;
                                 }
|	input '\n'		={ prtval(BUMPUP, 0); }
|	empty
;
req:
	exp prtop		={ $$ = tnode(PRINTOP, $2, $1, 0); }
|	PRINTOP			={ $$ = tnode(PRINTOP, $1, &dotnode, 0); }
|	'+' exp prtop		={ $$ = tnode(PRINTOP, $3,
					tnode('+', 0, BUMPDOT, $2), 0); }
|	'-' exp prtop		={ $$ = tnode(PRINTOP, $3,
					tnode('-', 0, BUMPDOT, $2), 0); }
|	'-' prtop		={ $$ = tnode(PRINTOP, $2,
					tnode(DEC, 0, 0, 0), 0); }
|       exp ':' exp prtop       ={ $$ = tnode(':',$4, $1, $3); }
|       exp ',' exp prtop       ={ $$ = tnode(',',$4, $1, $3); }
|	id '=' exp		={ $$ = tnode('=', NUMBER, $1, $3); }
|	SYMBOL '=' exp		={ $$ = tnode('=', SYMBOL, $1, $3); }
|       LSYMBOL '=' exp         ={ $$ = tnode('=', LSYMBOL, $1, $3); }
|	REG '=' exp		={ $$ = tnode('=', REG, $1, $3); }
|       CNTLREG '=' exp         ={ $$ = tnode('=', CNTLREG, $1, $3); }
|       PPSW '=' id id          ={ $$ = tnode(PSW, PPSW, $3, $4); }
|       PCSW  '=' id id         ={ $$ = tnode(CSW, PCSW, $3, $4); }
|       PCAW  '=' exp           ={ $$ = tnode('=', CAW, $1, $3); }
|	IF '(' exp ')' req	={ $$ = tnode(IF, 0, $3, $5); }
|	'?' prtop		={ $$ = tnode('?', $2, 0, 0); }
|       '?' exp prtop           ={ $$ = tnode('?', $3, $2, 0); }
|	'*' prtop		={ $$ = tnode(PRINTOP, $2,
				       tnode(INDIR, 0, &dotnode, 0), 0); }
|	PREG prtop		={ $$ = tnode(PREG, $2, 0, 0); }
|       PCNTLREG prtop          ={ $$ = tnode(PCNTLREG, $2, 0, 0); }
|       CNTLREG                 ={ $$ = tnode(CNTLREG, $1, 0, 0); }
|       PPSW prtop              ={ $$ = tnode(PPSW, $2, 0, 0); }
|       PCSW prtop              ={ $$ = tnode(PCSW, $2, 0, 0); }
|       PCAW prtop              ={ $$ = tnode(PCAW, $2, 0, 0); }
|	BRKP exp mreq comment	={ $$ = tnode(BRKP, $4, $2, $3); }
|	BRKP exp comment	={ $$ = tnode(BRKP, $3, $2, 0); }
|       BRKP                    ={ $$ = tnode(BREAKS, 0, 0, 0); }
|       BRKPCNT id exp mreq     ={ $$ = tnode(BRKPCNT, $2, $3, $4); }
|       BRKPCNT id exp          ={ $$ = tnode(BRKPCNT, $2, $3, 0); }
|       INT  inttype            ={ $$ = tnode(INT, 0, $2, 0); }
|       GO                      ={ $$ = tnode(GO,   0, 0, 0);
                                        goflg++; special = $$;}
|       CONT                    ={ $$ = tnode(CONT, 0, 0, 0);
                                        goflg++; special = $$;}
|       TRACE                   ={ $$ = tnode(TRACE, 0, 0, 0); }
|       SS                      ={ $$ = tnode(SS, 0, 0, 0); }
|	SS mreq			={ $$ = tnode(SS, 0, 0, $2); }
|       SS id                   ={ $$ = tnode(SS, 0, $2, 0); }
|       SS id mreq              ={ $$ = tnode(SS, 0, $2, $3); }
|	BREAKS			={ $$ = tnode(BREAKS, 0, 0, 0); }
|	CLEAR exp		={ $$ = tnode(CLEAR, 0, $2, 0); }
|	CLEAR			={ $$ = tnode(CLEAR, 0, 0, 0); }
|       DVIRT exp prtop         ={ $$ = tnode(DVIRT, $3, $2, 0); }
|       DVIRT exp ',' id prtop  ={ $$ = tnode(DVIRT, $5, $2, $4); }
|       mreq
|       error                   ={ synerr(); drain(); $$=0; pugserr = 0;}
|       error LEXERR            ={ drain(); pugserr=1; apterr = 1; $$=0; }
|       LEXERR                  ={ drain(); pugserr=1; apterr = 1; $$=0; }
;
prtop:
	PRINTOP			={ $$ = $1; }
|	empty			={ $$ = 0; }
;
mreq:
      leftbr reqlist '}'         ={ $$ = $2;
                                    if (pugserr) $$=0;
                                    left_br = 0;
                                    pugserr=0; }
|     leftbr reqlist ';' '}'     ={ $$ = $2;
                                    if (pugserr) $$=0;
                                    left_br = 0;
                                    pugserr=0; }
;
leftbr:
      '{'                        ={ left_br = 1; pugserr = 0; }
;
reqlist:
	reqlist ';' req		={ $$ = tnode(';', 0, $1, $3); }
|	req
;
comment:
	COMMENT
|	empty			={ $$ = 0; }
;
exp:
	id
|	SYMBOL			={ $$ = tnode(SYMBOL, $1, 0, 0); }
|       LSYMBOL                 ={ $$ = tnode(LSYMBOL, $1, 0, 0); }
|       REG                     ={ $$ = tnode(REG, $1, 0, 0); }
|	exp '+' exp		={ $$ = tnode('+', 0, $1, $3); }
|	exp '-' exp		={ $$ = tnode('-', 0, $1, $3); }
|	exp '*' exp		={ $$ = tnode('*', 0, $1, $3); }
|	exp DIVIDE exp		={ $$ = tnode(DIVIDE, 0, $1, $3); }
|	exp EQ exp		={ $$ = tnode(EQ, 0, $1, $3); }
|	exp NE exp		={ $$ = tnode(NE, 0, $1, $3); }
|	'~' exp			={ $$ = tnode('~', 0, $2, 0); }
|	exp '<' exp		={ $$ = tnode('<', 0, $1, $3); }
|	exp LE exp		={ $$ = tnode(LE, 0, $1, $3); }
|	exp '>' exp		={ $$ = tnode('>', 0, $1, $3); }
|	exp GE exp		={ $$ = tnode(GE, 0, $1, $3); }
|	exp AND exp		={ $$ = tnode(AND, 0, $1, $3); }
|	exp OR exp		={ $$ = tnode(OR, 0, $1, $3); }
|	exp '.' id		={ $$ = tnode('+', 0, $1, $3); }
|	exp '[' exp ']'		={ $$ = tnode('+', 0, $1, $3); }
|	'*' exp %prec INDIR	={ $$ = tnode(INDIR, 0, $2, 0); }
|	'(' exp ')'		={ $$ = $2; }
;
id:
	NUMBER			={ $$ = tnode(NUMBER, $1, 0, 0); }
|	'.'			={ $$ = &dotnode; }
|	DOTDOT			={ $$ = tnode(DOTDOT, 0, 0, 0); }
|	ENTER SYMBOL ')'	={ $$ = tnode(ENTER, $2, 0, 0); }
;
inttype:
        EXT   NUMBER ')'        ={ $$ = tnode(NUMBER, $2, EXT, 0); }
|       IO    NUMBER ')'        ={ $$ = tnode(NUMBER, $2, IO, 0); }
|       MCK   NUMBER ')'        ={ $$ = tnode(NUMBER, $2, MCK, 0); }
|       PGM   NUMBER ')'        ={ $$ = tnode(NUMBER, $2, PGM, 0); }
|       RESTART                 ={ $$ = tnode(RESTART,$1, RESTART, 0); }
|       SSS   NUMBER ')'        ={ $$ = tnode(NUMBER, $2, SSS, 0); }
;
empty:  ;
%%
yyerror(s) char *s; { }

/*
 * synerr - report a syntax error
 *	the basic error recovery is gobble tokens until a newline,
 *	assuming of course that the token being choked on (yychar) is not
 *	a newline.  The statements "yyclearin" and "yyerrok" are special
 *	YACC commands.  Basically, "yyclearin" says forget about the
 *	current input token, and "yyerrok" says parse as though no error
 *	had occurred.
 */

synerr(){
        apterr = 1;
        if (pugserr) {  yyerrok;
                        return;
                     }
        if(yychar == '}') {  yyerrok; yyclearin;
                             return; }
	aptstr(aptout,"syntax error%s",blankchr);
	aptio(aptout,0);
        if(yychar != '\n') {  gobble(0);
                            }
        if (left_br) {
                         gobble(1);
                         left_br = 0;
                     }

        yyclearin;
        yyerrok;
	}


/*
 * process the '=' operation of assignment, i.e. target = source
 * there are 6 cases
 *	(1) the target is a NUMBER which is the address where the source goes
 *	(2) the target is a SYMBOL, i.e. a symbol table pointer
 *	    there are 3 different types of symbols which must be handled
 *		a debugger symbol (beginning with '#')
 *		a symbol for a register variable
 *		anything else (has value of a memory address)
 *	(3) the target is explicitly a register (i.e. ;r10 = 0)
 *      (4) the target is explicitly the psw (i.e. ;psw = 0 0211)
 *      (5) the target is explicitly the csw (i.e. ;csw = 0 0211)
 *      (6) the target is explicitly the caw (i.e. ;caw = 0b0de )
 */

  assign(t1, v, t, savflag)
  struct tnode *t1;
  int v, t, savflag;{

         register SYM *s;
         int  *pugs;
	 int *i;
         struct optab *pop;
         struct op470 w,x;

         switch(t) {
                 case SYMBOL:
                         s = t1;
                         if (s->name[0] == '#')
                                 return(s->val = v);
                         pugs = s->val;
                         *pugs = v;
                         return(s->val);

                 case NUMBER:
                         pugs = doreq(t1, savflag);
                         if (pugs > MEMTEST) {
                                           aptstr(aptout,"address > 6m%s",
                                                       blankchr);
                                            aptio(aptout,0);
                                            return(v); }
                         *pugs = v;
                         return(v);
                 case REG:
                         t = t1;
                         gpr_ptr[t] = v;
                         return(v);
                 case CNTLREG:
                         t = t1;
                         creg_ptr[t] = v;
                         return(v);
                 case CAW:
                        if (v > MEMTEST) { aptstr(aptout,"address > 6m%s",
                                                       blankchr);
                                            aptio(aptout,0);
                                            return(0); }
                         caw_ptr[0] = v;
                         return(v);
                 case PCSW:
                         if (v > MEMTEST) {aptstr(aptout,"address > 6m%s",
				                          blankchr);
                                            aptio(aptout,0);
                                            return(0); }
                         csw_ptr[0] = t1;
                         csw_ptr[1] = v;
                         return(v);
                 case PPSW:
                     if (v > MEMTEST) { aptstr(aptout,"address > 6m%s",
				                          blankchr);
                                        aptio(aptout,0);
                                        return(0); }
		     i = v;
		     w = *(struct op470 *)i;
		     if ((pop = oplookup(w.opcode)) == NULL)
		          if (w.sopcode > 0xff) pop = oplookup(w.sopcode);
	             if (pop == NULL) {
                        aptstr(aptout,
                             "psw set to illegal instruction, not set%s",
					blankchr);
                        aptio(aptout,0);
		        return(-1);
		       }
                      psw_ptr[0] = t1;
                      psw_ptr[1] = v;
                      lastbp = psw_ptr[1]; /* kludge it up */
		      return(v);
                 }
          }


struct tnode *tnode(o, v, l, r)
int o, v;
struct tnode *l, *r;{

	register struct tnode *p;

	if ((p = apalloc()) == NULL) {
		aptstr(aptout,"out of memory for tree%s",blankchr);
                aptio(aptout,0); }
	p->t_op = o;
	p->t_val = v;
	p->t_left = l;
	p->t_right = r;
        tnodelist[tnodecnt++] = p;
	return(p);
	}

apalloc() {
                register int i;

		for (i=0; i<40; i++)  {
			if (freelist[i] == 0) {
				freelist[i] = 1;
				return(&tree[i]);
                           }
                }
             return(NULL);
          }

apfree(p,q)
       int p,q; {
                register int i;
                struct tnode *kill;

                kill = p;
		for (i=0; i<40; i++)  {
                      if (&tree[i] == p) {

                        if (!q) {
                                if (kill->t_left)
                                         apfree(kill->t_left,0);
                                if (kill->t_right)
                                         apfree(kill->t_right,0);
                                }
			freelist[i] = 0;
			return;
                       }
                 }
          }

drain() {
          register int i,j;

          for (i=0; i < tnodecnt; i++) {
		for (j=0; j<40; j++)  {
                         if (&tree[j] == tnodelist[i]) {
				freelist[j] = 0;
                                break;
                           }
                   }
            }
        tnodecnt = 0;
        }

bralloc() {
                register int i;

		for (i=0; i<16; i++)  {
			if (brlist[i] == 0) {
				brlist[i] = 1;
				return(&brkpts[i]);
                           }
                }
             return(NULL);
          }

brfree(p) int p; {
                register int i;

		for (i=0; i<16; i++)  {
                         if (&brkpts[i] == p) {
				brlist[i] = 0;
                                p->bp_comment[0] = '\0';
				return;
                           }
                 }
        }  /* end brfree */

/*
 * doreq - execute a request that is stored in a tree
 *	savflag is set if the caller does not want his tree discarded
 *	after use, e.g. bp_cmd must be retained until the bp is cleared
 */

doreq(p, savflag)
struct tnode *p;
int savflag;{

	register int v;
	register struct tnode *t1, *t2;
	int r, v1, v2;
	BP *bpp;
        int *apt;
        short int *sapt;
        int i; char *j;
        int tdot;

	v = p->t_val;
	t1 = p->t_left;
	t2 = p->t_right;
	r = 0;
        pa1key = 0;      /* just to be sure the pa1 key hasn't been hit */

	switch(p->t_op) {
		case PRINTOP:
			setpr(v);
                        if (t1->t_op == REG) { prtreg(t1->t_val); break; }
                        if ((i = doreq(t1, savflag)) > MEMTEST)
                          { aptstr(aptout,"address > 6m%s",blankchr);
                            aptio(aptout,0);
                            break; }
                         else prtval(i,0);
			break;

		case DVIRT:
			setpr(v);
                        v1 = doreq(t1, savflag);
                        if (t2) {
                              v2 = doreq(t2,savflag);
                              if ((i = omakreal(v1)) < 0) {
                                aptstr(aptout,
                                      "lra, may not be a virtual addr%s",
					           blankchr);
                                aptio(aptout,0);
                                break; }
                              printlist(i,i+aptnum);
                              break;
                             }
                        if ((i = omakreal(v1)) < 0) {
                               aptstr(aptout,
                                      "lra, may not be a virtual addr%s",
					          blankchr);
                                aptio(aptout,0);
                               break; }
		        prtval(i,0);
			break;

		case ',':
			setpr(v);
                        if ((v1 = doreq(t1, savflag)) > MEMTEST)
                          { aptstr(aptout,"address > 6m%s",blankchr);
                            aptio(aptout,0);
                            break; }
                        v2 = doreq(t2, savflag);
		        printlist(v1,v1+aptnum);
			break;

		case ':':
			setpr(v);
                        if ((v1 = doreq(t1, savflag)) > MEMTEST)
                          { aptstr(aptout,"address > 6m%s",blankchr);
                            aptio(aptout,0);
                            break; }
                        if ((v2 = doreq(t2, savflag)) > MEMTEST)
                          { aptstr(aptout,"address > 6m%s",blankchr);
                            aptio(aptout,0);
                            break; }
			if ((v2 - v1) >= 0) { printlist(v1,v2);
                                              break; }
		       aptstr(aptout,
                              "syntax error, addr 2 < addr 1%s",blankchr);
			aptio(aptout,0);
			break;

		case '=':
		        v2 = doreq(t2, savflag);
		        r = assign(t1, v2, v, savflag);
			break;

		case PSW:
                case CSW:
		        v2 = doreq(t2, savflag);
		        v1 = doreq(t1, savflag);
		        r = assign(v1, v2, v, savflag);
			break;

	/*
	 * some fudging must be done here using "ifflg"
	 * because in an if-expression you want the value of
	 * a symbol, rather than the normal address
	 */
		case IF:
		        ifflg++;
		        v = doreq(t1, savflag);
		        --ifflg;
		        if (v) doreq(t2, savflag);
			break;

		case '?':
		      /*  setpr(v);*/
                        if (t1) v1 = doreq(t1,savflag);
                          else v1 = 0;
		        printstack(v1);
			break;

		case PREG:
			printregs("gpr",gpr_ptr);
			break;

		case PCNTLREG:
                        printregs("xr",creg_ptr);
			break;

		case PPSW:
                        aptstr(aptout, "psw   %08x %08x",
                                           psw_ptr[0],psw_ptr[1]);
			aptio(aptout,0);
			break;

		case PCSW:
                        aptstr(aptout, "csw   %08x %08x",
                                           csw_ptr[0],csw_ptr[1]);
			aptio(aptout,0);
			break;

		case PCAW:
                        aptstr(aptout, "caw   %08x",
                                           caw_ptr[0]);
			aptio(aptout,0);
			break;

		case BRKP:
                        if ((bpp = qbp(doreq(t1, savflag))) == -1) {
                                        aptstr(aptout,
                                                  "16 break points set%s",
						    blankchr);
                                        aptio(aptout,0);
                                        break;
                                       }
		        if (bpp != NULL) {
		                bpp->bp_cmd = t2;
		                if (t2)
                                      {
				        j = &multcomm;
				        for (i=0; *j != '\0' ; i++)
                                             {
                                                  bpp->bp_comment[i] = *j;
					          j++;
                                             }
                                         if (goflg) {
                                                special->t_op = 0x7980;
						goflg=0;
				                }
				       }
		                }
			break;

		case BRKPCNT:
                        if ((bpp = qbp(doreq(t1, savflag))) == -1) {
                                        aptstr(aptout,
                                                "16 break points set%s",
							blankchr);
                                        aptio(aptout,0);
                                        break;
                                       }
		        if (bpp != NULL) {
		                bpp->bp_cmd = t2;
                                t2 = v;
                                v1 = doreq(t2,0);
			        aptstr(aptout,"%x",v1);
                                v1 = tobinary(aptout,10);
		                bpp->bp_count = v1;
		                }
			break;

		case INT:
                        v2 = t1->t_left;
                        v1 = doreq(t1, 0);

                        switch(v2)    {
                            case EXT: /* give Au an external */
       /*  still need to check the external int code for legality
        */
                                     apt = 24; /* ext old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     sapt = 134; /* ext int code */
                                     *sapt = v1; /* this is a halfword */
                                     apt = 88; /* ext new psw */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            case SSS:
                                     if ((v1 < 0) || (v1 > 255))
                                         { aptstr(aptout,
                                                     "illegal svc code%s",
							blankchr);
                                           aptio(aptout,0);
                                           break; }
                                     apt = 32; /* svc old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     apt = 136; /* svc code */
                                     *apt = v1;
                                     apt = 160; /* svc new psw, where omak
                                                   put Au's */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            case IO:
                                     if ((v1 < 0) && (v1 > 16))
                                         { aptstr(aptout,
                                                   "illegal i/o device%s",
                                                      blankchr);
                                           aptio(aptout,0);
                                           break; }
                                     apt = 56; /* i/o old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     apt = 184; /* device address */
                                     *apt = v1;
                                     apt = 120; /* i/o new psw */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            case PGM:
                                     if ((v1 < 0) && (v1 > 19) &&
                                         (v1 != 64) && (v1 != 128))
                                        { aptstr(aptout,
                                                "illegal pgm int code%s",
							blankchr);
                                           aptio(aptout,0);
                                           break; }
                                     apt = 40; /* pgm old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     apt = 140; /* pgm int code */
                                     *apt = v1;
                                     apt = 104; /* pgm new psw */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            case MCK:
                                     if ((v1 < 0) && (v1 > 71))
                                       { aptstr(aptout,
                                                "illegal machine check%s",
							blankchr);
                                         aptio(aptout,0);
                                           break; }
                                     apt = 48; /* mck old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     apt = 232; /* mck int code */
                                     *apt = v1;
                                     apt = 112; /* mck new psw */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            case RESTART:
                                     apt = 8; /* restart old psw */
                                     apt[0] = psw_ptr[0];
                                     apt[1] = psw_ptr[1];
                                     apt = 0; /* restart new psw */
                                     psw_ptr[0] = apt[0];
                                     psw_ptr[1] = apt[1];
                                     lastbp = psw_ptr[1];
                                     cont(lastbp);
			             break;
                            default:
                                   aptstr(aptout,
                                         "real trouble if we get here%s",
						blankchr);
                                   aptio(aptout,0);
			             break;
                           }
			break;

                case RESTART:
                        r = 0;
                        break;

		case GO:
		case CONT:
		        cont(lastbp);
			break;

                case TRACE:
			aptstr(aptout,"got the TRACE%s",blankchr);
			aptio(aptout,0);
			break;

                case SS:
                   if (t1) { v1 = doreq(t1,0);
                             v1 = aptnum; }
                     else v1 = 1 ;
                   for (i = 0; i < v1 && !pa1key; i++) {
                           if (ss(lastbp) != 0) break;
                             else
                              {
                               if ( psw_ptr[0] & 0x04000000) {
                                  if ( (tdot = omakreal(dotdot)) < 0) {
                                        aptstr(aptout,
                                               "in cmd.y with bad lra%s",
						blankchr);
                                        aptio(aptout,0);
                                    }
                                 }
                                 else
				       tdot = dotdot;

                                prinst(tdot,0);
                                if ((bpp = bplook(dotdot)) != NULL) {
                                        aptstr(aptout,"  (break point)%s",
							blankchr);
                                         aptio(aptout,0);
                                         if (bpp->bp_comment[0] != '\0') {
                                           aptstr(aptout," %s ",
                                                         bpp->bp_comment);
                                           aptio(aptout,0);  }
                                     lastbp = dotdot;
                                     break;
                                   }
                           }
                           lastbp = dotdot;
                         }
                        if (t2) doreq(t2, savflag);
                        pa1key = 0; /* reset the pa1 key if hit or not */
			break;

		case BREAKS:
		        dbrks();
			break;

		case CLEAR:
                        if (t1) bpclear(doreq(t1, savflag));
                        else {
                               /* free all bp_cmd nodes from tnode tree */

			       for (bpp = bptail; bpp != NULL; bpp = bpp->bp_next)
                                 if (bpp->bp_cmd) apfree(bpp->bp_cmd,0);
                               bptail = NULL;
                              }
			break;

		case ';':
		        doreq(t1, savflag);
		        doreq(t2, savflag);
			break;

		case NUMBER:
			r = v;
			break;

		case SYMBOL:
		         r = apt = v->val;
	                 if (ifflg) r = *apt;
			break;

		case LSYMBOL:
			aptio("LSYMBOL case ",0);
		  /*    r = lsymval(v); */
		  /*    if (ifflg) r = peek(map(r)); */
			break;

	/*
	 * a little hanky-panky here, we "switch" the prtlen
	 * so registers look like everybody else
	 * this is a kludge but so is the 470!
	 */
		case REG:
                        r = gpr_ptr[v];
			break;

		case CNTLREG:
                        prtcreg(v);
			break;

		case ENTER:
	   /*           r = ((SYM *) v)->val ;          */
	                r = ((SYM *) v)->val + PROLOG;
			break;

		case '+':
		case '-':
		case '*':
		case DIVIDE:
		case EQ:
		case NE:
		case '~':
		case '<':
		case LE:
		case '>':
		case GE:
		case AND:
		case OR:
		case INDIR:
		        r = calc(p->t_op, t1, t2, savflag);
			break;

		case DOTDOT:
		        r = dotdot;
			break;

	/*
	 * NB:  this case does a RETURN instead of a BREAK
	 * This is because we don't want to cfree(&dotnode).
	 */
		case '.':
			return(dot);

		case DEC:
			aptstr(aptout,"DEC case%s",blankchr);
			aptio(aptout,0);
		   /*   if (PRINST) r = dotdot -= instlen;*/
		   /*   else r = dot -= prtlen;*/
			break;

                case SPECIAL:
                         /* this is for the case when ;go is used in  *
                          * a multiple request, prevents using up the *
                          * stack too quickly                         */
                        specialflg++;
			break;

		default:
			aptstr(aptout,"unknown request%s",blankchr);
			aptio(aptout,0);
		}
	if (savflag == 0) apfree(p,1);
	return(r);
	}

calc(op, t1, t2, savflag)
  int op;
  struct tnode *t1, *t2;
  int savflag;{

         register int v1, v2;
         int gotareg;
         int *curt;

         gotareg = 0;
         if (t1->t_op == REG) gotareg++;
         v1 = doreq(t1, savflag);
         if (t2) v2 = doreq(t2, savflag);
         switch(op) {
                 case '+':
                         return(v1+v2);
                 case '-':
                        return(v1-v2);
                case '*':
                        return(v1*v2);
                case DIVIDE:
                        return(v1/v2);
                case EQ:
                        return(v1 == v2);
                case NE:
                        return(v1 != v2);
                case '~':
                        return(!v1);
                case '<':
                        return(v1 < v2);
                case LE:
                        return(v1 <= v2);
                case '>':
                        return(v1 > v2);
                case GE:
                        return(v1 >= v2);
                case AND:
                        return(v1 && v2);
                case OR:
                        return(v1 || v2);
                case INDIR:
                        if (gotareg) { gotareg = 0;
                                       return(v1 & STACKTOP);
                                     }
                        curt = v1 & STACKTOP;
                        return(*curt);
                default:
                        aptstr(aptout,"unknown op in calc %d", op);
                        aptio(aptout,0);
                }
        }

