/*
 * The user structure.
 * One allocated per process.
 * The user block is one page long,
 * is pointed to by the external variable uptr,
 * contains the system stack per user,
 * and is cross-referenced with the proc structure.
 */

#define	EXCLOSE	01

struct	user
{
	struct proc *u_procp;		/* pointer to proc structure */
	/* previous must be first in user struct: see zero.s */
	label_t	u_rsav;			/* save info when exchanging stacks */
	char	u_segflg;		/* IO flag: 0:user D; 1:system; 2:user I */
	char	u_error;		/* return error code */
	short	u_uid;			/* effective user id */
	short	u_gid;			/* effective group id */
	short	u_ruid;			/* real user id */
	short	u_rgid;			/* real group id */
	int	*u_ap;			/* pointer to arglist */
	union {				/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		};
		off_t	r_off;
		time_t	r_time;
	} u_r;
	caddr_t	u_base;			/* base address for IO */
	unsigned int u_count;           /* bytes remaining for IO */
	off_t	u_offset;		/* offset in file for IO */
	struct inode *u_cdir;		/* pointer to inode of current directory */
	struct inode *u_rdir;		/* root directory of current process */
	char	u_dbuf[DIRSIZ];		/* current pathname component */
	caddr_t	u_dirp;			/* pathname pointer */
	struct direct u_dent;		/* current directory entry */
	struct inode *u_pdir;		/* inode of parent directory of dirp */
	struct file *u_ofile[NOFILE];	/* pointers to file structures of open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_arg[5];		/* arguments to current system call */
	label_t	u_qsav;			/* label variable for quits and interrupts */
	int	u_signal[NSIG];		/* disposition of signals */
	cpu_t   u_utime;                /* this process user time */
	cpu_t 	u_stime;		/* this process system time */
	cpu_t 	u_cutime;		/* sum of childs' utimes */
	cpu_t 	u_cstime;		/* sum of childs' stimes */
	int	*u_ar0;			/* address of users saved R0 */
	char	u_intflg;		/* catch intr from sys */
	char	u_sep;			/* flag for I and D separation */
	struct tty *u_ttyp;		/* controlling tty pointer */
	dev_t	u_ttyd;			/* controlling tty dev */
	struct  u_header {              /* header of executable file */
		int	ux_mag;		/* magic number */
		unsigned ux_tsize;	/* text size */
		unsigned ux_dsize;	/* data size */
		unsigned ux_bsize;	/* bss size */
		unsigned ux_ssize;	/* symbol table size */
		unsigned ux_entloc;	/* entry location */
		unsigned ux_unused;
		unsigned ux_relflg;
	} u_exdata;
	char	u_comm[DIRSIZ];
	time_t	u_start;
	char	u_acflag;
	short	u_cmask;		/* mask for file creation */
	struct {                        /* program state vector */
		int     ps_sig;         /* signal being processed */
		int     ps_cr8;         /* control register 8 */
		int     ps_cr9;         /* control register 9 */
		int     ps_cr10;        /* control register 10 */
		int     ps_cr11;        /* control register 11 */
		int     ps_svc;         /* svc code (loc 136) */
		int     ps_pgm;         /* pgm code (loc 140) */
		int     ps_trans;       /* translation exception address (loc 144) */
		int     ps_moncl;       /* monitor class (loc 148, 2 bytes) */
		int     ps_per;         /* PER code (loc 150, 2 bytes) */
		int     ps_perad;       /* PER address (loc 152) */
		int     ps_moncd;       /* monitor code (loc 156) */
		cpu_t   ps_tslice;      /* time slice */
	} u_ps;
	char    u_sig[(NSIG+8)/8];      /* signals received so far */
	char    u_sigtr[(NSIG+8)/8];    /* signals being traced */
	struct u_pgtb {                 /* structure for page tables */
		struct pagetab *u_pages;/* pointer to page tables */
		short u_size;           /* number of pages */
	} u_tseg, u_dseg, u_sseg;       /* for text, data and stack segments */
        union   segtab *u_segtab;       /* segment table pointer */
	char    u_chreg;                /* flag for updated user registers */
	char    u_issig;                /* flag for existence of signal in u_sig */
        int     u_rdwr;                 /* read/write count */
        char    u_info[INFSIZE];        /* user info */
	int	u_stack[1];
					/* kernel stack per user
					 * extends from u + PAGSIZE
					 * backward not to reach here
					 */
};

struct user *uptr;
#define u (*uptr)

/* u_error codes */
#define	EPERM	1
#define	ENOENT	2
#define	ESRCH	3
#define	EINTR	4
#define	EIO	5
#define	ENXIO	6
#define	E2BIG	7
#define	ENOEXEC	8
#define	EBADF	9
#define	ECHILD	10
#define	EAGAIN	11
#define	ENOMEM	12
#define	EACCES	13
#define	EFAULT	14
#define	ENOTBLK	15
#define	EBUSY	16
#define	EEXIST	17
#define	EXDEV	18
#define	ENODEV	19
#define	ENOTDIR	20
#define	EISDIR	21
#define	EINVAL	22
#define	ENFILE	23
#define	EMFILE	24
#define	ENOTTY	25
#define	ETXTBSY	26
#define	EFBIG	27
#define	ENOSPC	28
#define	ESPIPE	29
#define	EROFS	30
#define	EMLINK	31
#define	EPIPE	32
#define	EDOM	33
#define	ERANGE	34
