/*
 * Random set of variables
 * used by more than one
 * routine.
 */
char	canonb[CANBSIZ];	/* buffer for erase and kill (#@) */
struct  inode *rootdir;         /* pointer to inode of root directory */
struct  proc *runq;             /* head of linked list of running processes */
time_t	time;			/* time in sec from 1970 */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int	nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/tty.c
 */
int	nchrdev;

int	mpid;			/* generic for unique process id's */
char	runrun;			/* scheduling flag */
char	curpri;			/* more scheduling */
int	maxmem;			/* actual max memory per process */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
char	msgbuf[MSGBUFS];	/* saved "printf" characters */
dev_t	rootdev;		/* device of the root */
dev_t	pipedev;		/* pipe device */
char    pipedevf;               /* pipe device mounted flag */
char    vm;                     /* running under VM */
int     pagecnt;                /* number of free pages */
int     memlim;                 /* highest address in machine */
extern	int	icode[];	/* user init code */
extern	int	szicode;	/* its size */

/* bits in 'vm' */
#define ISVM    01
#define SEPP    02
#define BSEPP   04

/* VM (SEPP) accounting interface area */
struct vmai {
	cpu_t   ai_vtime;
	tod_t   ai_toddsp;
	cpu_t   ai_cptime;      /* only at Amdahl */
} vmai;

dev_t getmdev();
daddr_t	bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *geteblk();
struct buf *bread();
struct buf *breada();
struct filsys *getfs();
struct file *getf();
struct file *falloc();
int	uchar();
caddr_t getpage();
struct pagetab *getptab();
union segtab *getstab();
caddr_t ldreal();
/*
 * Instrumentation
 */

/*
 * Structure of the system-entry table
 */
extern struct sysent {
	char	sy_narg;		/* total number of arguments */
	int	(*sy_call)();		/* handler */
} sysent[];
int nsysent;                            /* number of system calls */
