
#
/*
 *  C compiler
 */

#include "c1.h"

max(a, b)
{
	if (a>b)
		return(a);
	return(b);
}

degree(at)
struct tnode *at;
{
	register struct tnode *t, *t1;

	if ((t=at)==0 || t->op==0)
		return(0);
	if (t->op == CON)
		return(-3);
	if (t->op == AMPER)
		return(-2);
	if (t->op==ITOL) {
		if ((t1 = isconstant(t)) && (t1->value>=0 || t1->type==UNSIGN))
			return(-2);
		if ((t1=t->tr1)->type==UNSIGN && opdope[t1->op]&LEAF)
			return(-1);
	}
	if ((opdope[t->op] & LEAF) != 0) {
		if (t->type==CHAR || t->type==FLOAT)
			return(1);
		return(0);
	}
	if (t->op == STAR)
	        return(t->degree+1);
	else
	        return(t->degree);
}

pname(ap, flag)
struct tnode *ap;
{
	register i;
	register struct tnode *p;
	struct { int intx[2]; };

	p = ap;
/*
 * this compiler is rapidly becoming as kludgy as the old one
 */
	if (p->op == STAR || p->op == ITOS || p->op == ITOUS) p = p->tr1;
loop:
	switch(p->op) {

	case LCON:
		printf("=f'%d'", flag>10? p->lvalue.intx[1]:p->lvalue.intx[0]);
		return;

	case SFCON:
		printf("=xl8'%8x%8x'", p->fvalue);
		return;

	case CON:
		printf("=f'%d'", p->value);
		return;

	case FCON:
		printf("%cS%d", TMPLAB, (p->value>0? p->value: -p->value));
		return;

	case NAME:
		i = p->offset;
		if (flag>10)
			i =+ 4;
		if (i) {
			printf("%d", i);
			if (p->class!=OFFS)
				putchar('+');
			if (p->class==REG)
				regerr();
		}
		else if (p->class == OFFS) putchar('0');
		switch(p->class) {

		case SOFFS:
		case XOFFS:
			pbase(p);

		case OFFS:
/*
 * this is sort of kludgy
 */
			if (p->regno == STKP){
				if (dropsize) printf("+%d", dropsize);
				printf("+$len%d", fnum);
			}
			if (flag == -1)
				/*
				 * character to character assignment -
				 * produce length for 'mvc' operator
				 */
			        printf("(1, %d)", p->regno);
			else
			        printf("(%d)", p->regno);
			return;

		case EXTERN:
			/*
			 * adjustment for the Norway C compiler
			 */
			printf("=a(");
			pbase(p);
			putchar(')');
			return;

		case STATIC:
			pbase(p);
			return;

		case REG:
			printf("%d", p->nloc);
			return;

		}
		error("Compiler error: pname, class %d", p->class);
		return;

	}
	error("pname called illegally: %d", p->op);
}

regerr()
{
	error("Illegal use of register");
}

pbase(ap)
struct tnode *ap;
{
	register struct tnode *p;

	p = ap;
	if (p->class==SOFFS || p->class==STATIC)
		printf("%cS%d", TMPLAB, p->nloc);
	else
		printf("%.8s", &(p->nloc));
}

xdcalc(ap, nrleft)
struct tnode *ap;
{
	register struct tnode *p;
	register d;

	p = ap;
	d = dcalc(p, nrleft);
	if (d<DEASY && p->type==CHAR) {
/*
 *
		if (nrleft>=1)
			d = DEASY;
		else
 *
 */
			d = DDEF;
	}
	return(d);
}

dcalc(ap, nrleft)
struct tnode *ap;
{
	register struct tnode *p, *p1;

	if ((p=ap)==0)
		return(0);
	switch (p->op) {

	case NAME:
		if (p->class==REG)
			return(DREG);
		else return(DINT);

	case LCON:
		return(DLON);

	case FCON:
		return(DINT);

	case CON:
		if (p->value==0)
			return(DZERO);
		if (p->value==1)
			return(DCON1);
		return(DCON);

	case SFCON:
		if (p->fvalue==0.0)
			return(DZERO);
		if (p->fvalue==1.0)
			return(DCON1);
/*
 * on 470, constants are a pain
 */
		return(DCON);
	}
	if (p->type==LONG || p->type==UNLNG)
		nrleft--;
/*
 * used to be <=
 */
	return(p->degree <= nrleft? DEASY: DDEF);
}

notcompat(ap, ast, op)
struct tnode *ap;
{
	register at, st;
	register struct tnode *p;

	p = ap;
	at = p->type;
	st = ast;

/*
 * Dennis may have said this shouldn't happen
 * ... but it does
 */
	if ((at&TYPE)==STRUCT) at =& (~TYPE);
	if (st==0)              /* word, byte */
		return(at!=CHAR && at!=INT && at!=SHORT && at!=UNSIGN && at!=UNSHRT && at<PTR);
	if (st==1)              /* word */
		return(at!=INT && at!=UNSIGN && at<PTR);
	st =- 2;
	if ((at&(~(TYPE+XTYPE))) != 0)
		at = 020;
	if ((at&(~TYPE)) != 0)
		at = at&TYPE | 020;
	if (st==DOUBLE && at==FLOAT)
		at = DOUBLE;
	return(st != at);
}

prins(op, type, c, itable)
struct instab *itable;
{
	register struct instab *insp;
	register char *ip;

	for (insp=itable; insp->op != 0; insp++) {
		if (insp->op == op) {
			ip = c? insp->str2: insp->str1;
			if (ip==0)
				break;
			if (type==UNLNG) {
			        if (op==LDIV || op==LASDIV)
			                printf("=v(_ulldiv)");
			        else if (op==LMOD || op==LASMOD)
			                printf("=v(_ullrem)");
			        else
			                printf("%s", ip);
			}
		        else
		                printf("%s", ip);
			return;
		}
	}
	error("No match for op %d", op);
}

collcon(ap)
struct tnode *ap;
{
	register op;
	register struct tnode *p;

	p = ap;
	if (p->op==PLUS) {
		op = p->tr2->op;
		if (op==CON && p->tr2->value >= 0 && p->tr2->value < 4096)
			return(1);
	}
	return(0);
}

isfloat(at)
struct tnode *at;
{
	register struct tnode *t;

	t = at;
	if ((opdope[t->op]&RELAT)!=0)
		t = t->tr1;
	if (t->type==FLOAT) {
		nfloat = 1;
		return(FLOATNAME);
	}
	if (t->type==DOUBLE) {
		nfloat = 1;
		return(DOUBLENAME);
	}
	return(0);
}

oddreg(t, areg)
struct tnode *t;
{
	register reg;

	reg = areg;
	if (!isfloat(t))
		switch(t->op) {
		case LLSHIFT:
		case ASLSHL:
			return((reg+1)&~01);

		case DIVIDE:
		case MOD:
		case PTOI:
		case ASDIV:
		case ASMOD:
			reg++;
			return(reg & 0776);

		case TIMES:
		case ASTIMES:
			reg++;
			return(reg|1);
		}
	return(reg);
}

arlength(t)
{
	if (t>=PTR)
		return(BPP);
	switch(t) {

	case INT:
	case CHAR:
	case UNSIGN:
	case UNSHRT:
	case SHORT:
		return(BPW);

	case UNLNG:
	case LONG:
		return(BPL);

	case FLOAT:
	case DOUBLE:
		return(BPD);
	}
	return(1024);
}

/*
 * Strings for switch code.
 */

char    dirsw[] {"\
lr      1,0\n\
s       1,=f'%d'\n\
cl      1,=f'%d'\n\
bh      %c%d\n\
sla     1,2\n\
l       1,%c%d(1)\n\
b       0(1)\n\
%c%d:\n\
" };

char    simpsw[] {"\
sr      1,1\n\
st      0,%c%d\n\
%c%d:\n\
c       0,%c%d(1)\n\
be      %c%d\n\
a       1,=f'4'\n\
b       %c%d\n\
%c%d:\n\
l       1,4+%c%d(1)\n\
b       0(1)\n\
.data\n\
%c%d:\n\
"};

/*
 * adjustment for the Norway C compiler
 */

char    hashsw[] {"\
lr      1,0\n\
sr      0,0\n\
d       0,=f'%d'\n\
lr      2,0\n\
lr      0,1\n\
lr      1,2\n\
sla     1,2\n\
a       1,=a(%c%d)\n\
l       2,0(1)\n\
st      0,0(2)\n\
a       1,=f'4'\n\
l       1,0(1)\n\
%c%d:\n\
s       1,=f'4'\n\
c       0,0(1)\n\
bne     %c%d\n\
la      2,%c%d\n\
s       2,=a(%c%d)\n\
l       1,0(1,2)\n\
b       0(1)\n\
.data\n\
%c%d:\n\
"};


pswitch(afp, alp, deflab)
struct swtab *afp, *alp;
{
        extern dammit;
	int ncase, i, j, k, tabs, worst, best, range;
	register struct swtab *swp, *fp, *lp;
	int *poctab;

	fp = afp;
	lp = alp;
	if (fp==lp) {
		printf("b\t%c%d\n", TMPLAB, deflab);
		return;
	}
	isn++;
	if (sort(fp, lp))
		return;
	ncase = lp-fp;
	lp--;
	range = lp->swval - fp->swval;
	/* direct switch */
	if (range>0 && range <= 8*ncase) {
		printf(dirsw, fp->swval, range, TMPLAB, deflab, TMPLAB,
		       isn, TMPLAB, isn);
		isn++;
		for (i=fp->swval; i<=lp->swval; i++) {
			if (i==fp->swval) {
				printf("dc a(%c%d)\n", TMPLAB, fp->swlab);
				fp++;
			} else
				printf("dc a(%c%d)\n", TMPLAB, deflab);
		}
		goto esw;
	}
	/* simple switch */
	if (ncase<8) {
		i = isn++;
		j = isn++;
		k = isn++;
		printf(simpsw, TMPLAB, j, TMPLAB, k, TMPLAB, i, TMPLAB,
		       isn, TMPLAB, k, TMPLAB, isn, TMPLAB, j, TMPLAB,
		       i);
		isn++;
		for (; fp<=lp; fp++)
			printf("dc f'%d'\n", fp->swval);
		printf("%c%d:\ndc f'0'\n", TMPLAB, j);
		for (fp = afp; fp<=lp; fp++)
			printf("dc a(%c%d)\n", TMPLAB, fp->swlab);
		printf("dc a(%c%d)\n", TMPLAB, deflab);
		goto esw;
	}
	/* hash switch */
	best = 077777;
	poctab = getblk(((ncase+2)/2) * sizeof(*poctab));
	for (i=ncase/4; i<=ncase/2; i++) {
		for (j=0; j<i; j++)
			poctab[j] = 0;
		for (swp=fp; swp<=lp; swp++)
			poctab[lrem(0, swp->swval, i)]++;
		worst = 0;
		for (j=0; j<i; j++)
			if (poctab[j]>worst)
				worst = poctab[j];
		if (i*worst < best) {
			tabs = i;
			best = i*worst;
		}
	}
	i = isn++;

	/*
	 * adjustment for the Norway C compiler
	 */
	printf(hashsw, tabs, TMPLAB, isn, TMPLAB, i, TMPLAB, i, TMPLAB,
	        isn+tabs+1, TMPLAB, isn+1, TMPLAB, isn);
	isn++;
	for (i=0; i<=tabs; i++)
		printf("dc a(%c%d)\n", TMPLAB, isn+i);
	for (i=0; i<tabs; i++) {
		printf("%c%d:\ndc f'0'\n", TMPLAB, isn++);
		for (swp=fp; swp<=lp; swp++)
                        if (lrem(0, swp->swval, tabs) == i)
				printf("dc f'%d'\n", ldiv(0, swp->swval, tabs));
	}
	printf("%c%d:\n", TMPLAB, isn++);
	for (i=0; i<tabs; i++) {
		printf("dc a(%c%d)\n", TMPLAB, deflab);
		for (swp=fp; swp<=lp; swp++)
			if (lrem(0, swp->swval, tabs) == i)
				printf("dc a(%c%d)\n", TMPLAB, swp->swlab);
	}
esw:
	printf(".text\n");
}

sort(afp, alp)
struct swtab *afp, *alp;
{
	register struct swtab *cp, *fp, *lp;
	int intch, t;

	fp = afp;
	lp = alp;
	while (fp < --lp) {
		intch = 0;
		for (cp=fp; cp<lp; cp++) {
			if (cp->swval == cp[1].swval) {
				error("Duplicate case (%d)", cp->swval);
				return(1);
			}
			if (cp->swval > cp[1].swval) {
				intch++;
				t = cp->swval;
				cp->swval = cp[1].swval;
				cp[1].swval = t;
				t = cp->swlab;
				cp->swlab = cp[1].swlab;
				cp[1].swlab = t;
			}
		}
		if (intch==0)
			break;
	}
	return(0);
}

ispow2(atree)
{
	register int d;
	register struct tnode *tree;

	tree = atree;
	if (!isfloat(tree) && tree->tr2->op==CON) {
		d = tree->tr2->value;
		if (d>1 && (d&(d-1))==0)
			return(d);
	}
	return(0);
}

pow2(atree)
struct tnode *atree;
{
	register int d, i;
	register struct tnode *tree;

	tree = atree;
	if (d = ispow2(tree)) {
		for (i=0; (d=>>1)!=0; i++);
		tree->tr2->value = i;
		switch (tree->op) {

		case TIMES:
			tree->op = LSHIFT;
			break;

		case ASTIMES:
			tree->op = ASLSH;
			break;

		case DIVIDE:
			tree->op = RSHIFT;
			tree->tr2->value = i;
			break;

		case ASDIV:
			tree->op = ASRSH;
			tree->tr2->value = i;
			break;

		case MOD:
			tree->op = AND;
			tree->tr2->value = (1<<i)-1;
			break;

		case ASMOD:
			tree->op = ASAND;
			tree->tr2->value = (1<<i)-1;
			break;

		default:
			error("pow2 botch");
		}
		tree = optim(tree);
	}
	return(tree);
}

cbranch(atree, albl, cond, areg)
struct tnode *atree;
{
	int l1, op;
	register lbl, reg;
	register struct tnode *tree;
	struct tnode lbuf;

	lbl = albl;
	reg = areg;
again:
	if ((tree=atree)==0)
		return;
/*
fprintf(stderr,"cbranch: tree->op = %d\n",tree->op);
fprintf(stderr,"cbranch: tree->tr1->type = %d\n",tree->tr1->type);
fprintf(stderr,"cbranch: tree->tr2->type = %d\n",tree->tr2->type);
*/
	switch(tree->op) {

	case LOGAND:
		if (cond) {
			cbranch(tree->tr1, l1=isn++, 0, reg);
			cbranch(tree->tr2, lbl, 1, reg);
			label(l1, 0);
		} else {
			cbranch(tree->tr1, lbl, 0, reg);
			cbranch(tree->tr2, lbl, 0, reg);
		}
		return;

	case LOGOR:
		if (cond) {
			cbranch(tree->tr1, lbl, 1, reg);
			cbranch(tree->tr2, lbl, 1, reg);
		} else {
			cbranch(tree->tr1, l1=isn++, 1, reg);
			cbranch(tree->tr2, lbl, 0, reg);
			label(l1, 0);
		}
		return;

	case EXCLA:
		cbranch(tree->tr1, lbl, !cond, reg);
		return;

	case SEQNC:
		rcexpr(tree->tr1, efftab, reg);
		atree = tree->tr2;
		goto again;

	case ITOL:
		tree = tree->tr1;
		break;
	}
	op = tree->op;
	if (opdope[op]&RELAT
	 && tree->tr1->op==ITOL && tree->tr2->op==ITOL) {
		tree->tr1 = tree->tr1->tr1;
		tree->tr2 = tree->tr2->tr1;
	}
	if (tree->type==LONG || tree->type==UNLNG ||
	    opdope[op]&RELAT&&(tree->tr1->type==LONG ||
                               tree->tr1->type==UNLNG)) {
		longrel(tree, lbl, cond, reg);
		return;
	}
	if ((opdope[op]&RELAT)==0) {
		lbuf.op = NEQUAL;
		lbuf.type = tree->type;
		lbuf.degree = tree->degree;
		lbuf.tr1 = tree;
		lbuf.tr2 = &czero;
		tree = &lbuf;
	}
	rcexpr(tree, cctab, reg);
	op = tree->op;
	if ((opdope[op]&RELAT)==0)
		op = NEQUAL;
	else {
		l1 = tree->tr2->op;
		if ((l1==CON || l1==SFCON) && tree->tr2->value==0)
			op =+ 200;              /* special for ptr tests */
	}
	branch(lbl, op, !cond);
}

branch(lbl, aop, c)
{
	register op;

	if(op=aop)
		prins(op, -1, c, branchtab);
	else
		printf("b");
	printf("\t%c%d\n", TMPLAB, lbl);
}

longrel(atree, lbl, cond, reg)
struct tnode *atree;
{
	int xl1, xl2, xo, xz, tstreg;
	register int op, isrel;
	register struct tnode *tree;

	reorder(&atree, cctab, reg);
	tree = atree;
	isrel = 0;
	if (opdope[tree->op]&RELAT) {
		isrel++;
		op = tree->op;
	} else
		op = NEQUAL;
	if (!cond)
		op = notrel[op-EQUAL];
	xl1 = xlab1;
	xl2 = xlab2;
	xo = xop;
	xlab1 = lbl;
	xlab2 = 0;
	xop = op;
	xz = xzero;
	xzero = !isrel || tree->tr2->op==ITOL && tree->tr2->tr1->op==CON
		&& tree->tr2->tr1->value==0;
    doitover:
	if (!isrel || cexpr(tree, cctab, reg) < 0) {
		if (isrel) {
			tree->op = MINUS;
			tree->type = LONG;
			tree = optim(tree);
		}
		tstreg = rcexpr(tree, regtab, reg);
		printf("lr\t0,%d\nlr\t1,%d\n", tstreg, tstreg+1);
		printf("slda\t0,0\n");
		branch(xlab1, op, 0);
	}
	xlab1 = xl1;
	xlab2 = xl2;
	xop = xo;
	xzero = xz;
}

/*
 * Tables for finding out how best to do long comparisons.
 * First dimen is whether or not the comparison is with 0.
 * Second is which test: e.g. x > y   ->
 *      l       1,X
 *      c       1,Y
 *      bl      NO              (first)
 *      bp      YES             (second)
 *      l       1,X+
 *      c       1,Y+
 *      bnh     NO              (third)
 *  YES: ...
 * Note some tests may not be needed.
 */
char    lrtab[2][3][6] {
	0,      NEQUAL, LESS,   LESS,   GREAT,  GREAT,
	NEQUAL, 0,      GREAT,  GREAT,  LESS,   LESS,
	EQUAL,  NEQUAL, LESSEQP,LESSP,  GREATQP,GREATP,

	0,      NEQUAL, LESS,   LESS,   GREATEQ,GREAT,
	NEQUAL, 0,      GREAT,  0,      0,      LESS,
	EQUAL,  NEQUAL, EQUAL,  0,      0,      NEQUAL,
};

xlongrel(f)
{
	register int op, bno;

	op = xop;
	if (f==0) {
		if (bno = lrtab[xzero][0][op-EQUAL])
			branch(xlab1, bno, 0);
		if (bno = lrtab[xzero][1][op-EQUAL]) {
			xlab2 = isn++;
			branch(xlab2, bno, 0);
		}
		if (lrtab[xzero][2][op-EQUAL]==0)
			return(1);
	} else {
		branch(xlab1, lrtab[xzero][2][op-EQUAL], 0);
		if (xlab2)
			label(xlab2, 0);
	}
	return(0);
}

label(l, string)
{
	if (string)
	        printf("%cS%d:\n", TMPLAB, l);
	else
	        printf("%c%d:\n", TMPLAB, l);
}

error(s, p1, p2, p3, p4, p5, p6)
{
	nerror++;
	if (filename[0])
		fprintf(stderr, "%s:", filename);
	fprintf(stderr, "%d: ", line);
	fprintf(stderr, s, p1, p2, p3, p4, p5, p6);
	fprintf(stderr, "\n");
}

/*
 * Read in an intermediate file.
 */
#define STKS    20
getree()
{
	struct tnode *expstack[STKS];
	register struct tnode **sp;
	register t, op;
	static char s[9];
	struct swtab *swp;
	char numbuf[64];
	char srcstr[MAXSRC];
	double atof();
	struct tname *np;
	struct xtname *xnp;
	struct ftconst *fp;
	struct lconst *lp;
	struct fasgn *sap;
	int lbl, cond, lbl2, lbl3, t2, tmptype;
	struct {
		unsigned high;
		unsigned low;
	};

	curbase = funcbase;
	sp = expstack;
	for (;;) {
		if (sp >= &expstack[STKS])
			error("Stack overflow botch");
		op = getw(ascfp);
		if ((op&0177400) != 0177000) {
			error("Intermediate file error: %d", op);
			exit(1);
		}
		lbl = 0;
		switch(op =& 0377) {

	case SINIT:
		printf("dc f'%d'\n", getw(ascfp));
		break;

	case EOFC:
		return;

	case BDATA:
		if (getw(ascfp) == 1) {
			printf("dc x'");
			t = 0;
			for (;;)  {
				printf("%2x", getw(ascfp));
				if (getw(ascfp) != 1)
					break;
				if (++t > 30){
					t = 0;
					printf("'\ndc x'");
				}
			}
			printf("'\n");
		}
		break;

	case PROG:
		printf(".text\n");
		break;

	case DATA:
		printf(".data\n");
		break;

	case BSS:
		printf(".bss\n");
		break;

	case SRCSTR:
		op = getw(ascfp);
		outname(srcstr);
		printf("///\t\t\t%4d    ", op);
		{
			int i;
			char *p;

			p = srcstr;
			for(i = 0; *p; i++)
				printf("%c", *p++);
		}
		break;

	case SYMDEF:
		outname(s);
		printf("entry %s\n", s);
		break;


	case RETRN:
		printf("lm\t2,15,8(13)\n");
		printf("br\t14\n");
		break;

	case CSPACE:
		t = outname(s);
		op = getw(ascfp);
		if (op != 0)
		        printf(".comm %s,%d\n", t, op);
		break;

	case SSPACE:
		printf(".=.+%d\n", getw(ascfp));
		break;

	case EVEN:
		printf("ds 0f\n");
		break;

	case DEVEN:
		printf("ds 0d\n");
		break;

	case HEVEN:
		printf("ds 0h\n");
		break;

	case SAVE:
		save(s);
		break;

	case SETSTK:
		t = getw(ascfp);
		printf("$len%d = %d\n", fnum++, (t+SAVEAREA+maxtmp + (BPW-1)) & ~(BPW-1));
		printf("ds 0d\n");
		printf("ltorg\n");
		printf("drop\n");
		break;

   /*
	case PROFIL:
		t = outname(s);
		printf("mov     $L%d,r0\njsr    pc,mcount\n", t);
		printf(".bss\nL%d:.=.+2\n.text\n", t);
		*sp++ = tnode(0, 0, NULL, NULL);
		break;
   */

	case SNAME:
		t = outname(s);
		printf("~%s=%cS%d\n", t, TMPLAB, getw(ascfp));
		break;

	case ANAME:
		t = outname(s);
		printf("~%s=%d\n", t, getw(ascfp));
		break;

	case RNAME:
		t = outname(s);
		printf("~%s=%d\n", t, getw(ascfp));
		break;

	case SWIT:
		t = getw(ascfp);
		line = getw(ascfp);
		curbase = funcbase;
		while ((swp=getblk(sizeof(*swp)))->swlab = getw(ascfp)) {
			swp->swval = getw(ascfp);
		}
		pswitch(funcbase, swp, t);
		break;
	case C3BRANCH:          /* for fortran [sic] */
		lbl = getw(ascfp);
		lbl2 = getw(ascfp);
		lbl3 = getw(ascfp);
		goto xpr;

	case CBRANCH:
		lbl = getw(ascfp);
		cond = getw(ascfp);

	case EXPR:
	xpr:
		line = getw(ascfp);
		if (sp != &expstack[1]) {
			error("Expression input botch");
			exit(1);
		}
		nstack = 0;
		*sp = optim(*--sp);
		if (op==CBRANCH)
			cbranch(*sp, lbl, cond, LOWREG);
		else if (op==EXPR)
			rcexpr(*sp, efftab, LOWREG);
		curbase = funcbase;
		break;

	case NAME:
		t = getw(ascfp);
		if (t==EXTERN) {
			np = getblk(sizeof(*xnp));
			np->type = getw(ascfp);

			/*
			 * adjustment for the Norway C compiler
			 */
			outname(np->name);
		} else {
			np = getblk(sizeof(*np));
			np->type = getw(ascfp);
			np->nloc = getw(ascfp);
		}
		np->op = NAME;
		np->class = t;
		np->regno = 0;
		np->offset = 0;
		*sp++ = np;
		break;

	case CON:
		t = getw(ascfp);   /* type */
		*sp++ = tconst(getw(ascfp), t);
		break;

	case LCON:
		tmptype = getw(ascfp);    /* type */
		t = getw(ascfp);
		op = getw(ascfp);
		lp = getblk(sizeof(*lp));
		lp->op = LCON;
		lp->type = tmptype;
		lp->lvalue.high = t;
		lp->lvalue.low = op;
		*sp++ = lp;
		break;

	case FCON:
		t = getw(ascfp);
		outname(numbuf);
		fp = getblk(sizeof(*fp));
		fp->op = FCON;
		fp->type = t;
		fp->value = isn++;
		fp->fvalue = atof(numbuf);
		*sp++ = fp;
		break;

	case FSEL:
		op = getw(ascfp);
		*sp = tnode(FSEL, op, *--sp, NULL);
		t = getw(ascfp);
		t2 = getw(ascfp);
		if (op == SHORT)
		        t = 8*BPS-t2-t;
		else if (op == CHAR)
		        t = 8*BPC-t2-t;
		else
		        t = 8*BPW-t2-t;
		(*sp++)->tr2 = tnode(COMMA, op, tconst(t2, INT), tconst(t, INT));
		break;

	case STRASG:
		sap = getblk(sizeof(*sap));
		sap->op = STRASG;
		sap->type =getw(ascfp);
		sap->mask = getw(ascfp);
		sap->tr1 = *--sp;
		sap->tr2 = NULL;
		*sp++ = sap;
		break;

	case FILENME:
		outname(filename);
	        break;

	case TEXTBSE:
		textregs = getw(ascfp);
	        break;

	case DATABSE:
		dataregs = getw(ascfp);
	        break;

	case NULLOP:
		*sp++ = tnode(0, 0, NULL, NULL);
		break;

	case LABEL:
		label(getw(ascfp), getw(ascfp));
		break;

	case NLABEL:
		t = outname(s);
		printf("%s:\n", t, t);
		break;


	case RLABEL:
		t = outname(s);
		printf("%s:\n~%s:\n", t, t, t);
		break;

	case BRANCH:
		branch(getw(ascfp), 0);
		break;

	case SETREG:
		nreg = getw(ascfp)-1;
		break;

	default:
		if (opdope[op]&BINARY) {
			if (sp < &expstack[1]) {
				error("Binary expression botch");
				exit(1);
			}
			t = *--sp;
			t2 = *--sp;
			*sp++ = tnode(op, getw(ascfp), t2, t);
		} else {
			sp[-1] = tnode(op, getw(ascfp), sp[-1]);
		}
		break;
	}
	}
}


save(s)
char *s;
{
	register i;

	printf("using\t.,15\n");
	printf("lr\t0,13\n");
	printf("s\t13,2f\n");
	printf("stm\t0,15,0(13)\n");
	printf("st\t0,52(,13)\n");
	switch(textregs+dataregs) {
		case 2:
	                printf("lm\t10,11,0f\n");
			break;
		case 3:
	                printf("lm\t9,11,0f\n");
			break;
		case 4:
	                printf("lm\t8,11,0f\n");
			break;
		case 5:
	                printf("lm\t7,11,0f\n");
			break;
		case 6:
	                printf("lm\t6,11,0f\n");
			break;
		case 7:
	                printf("lm\t5,11,0f\n");
			break;
		case 8:
	                printf("lm\t4,11,0f\n");
			break;
		default:
			error("Compiler error: wrong case for text and data base regs");
	}
	printf("lr\t12,13\n");
	printf("b\t1f\n");
	printf("0:\n");
	switch(dataregs) {
	        case 1:
		        break;
	        case 2:
	                printf("dc a(.data+4096)\n");
		        break;
	        case 3:
	                printf("dc a(.data+8192)\n");
	                printf("dc a(.data+4096)\n");
		        break;
	        case 4:
	                printf("dc a(.data+12288)\n");
	                printf("dc a(.data+8192)\n");
	                printf("dc a(.data+4096)\n");
		        break;
	        case 5:
	                printf("dc a(.data+16384)\n");
	                printf("dc a(.data+12288)\n");
	                printf("dc a(.data+8192)\n");
	                printf("dc a(.data+4096)\n");
		        break;
	        case 6:
	                printf("dc a(.data+20480)\n");
	                printf("dc a(.data+16384)\n");
	                printf("dc a(.data+12288)\n");
	                printf("dc a(.data+8192)\n");
	                printf("dc a(.data+4096)\n");
		        break;
		default:
			error("Compiler error: wrong case for data base regs");
	}
	switch(textregs) {
	        case 1:
		        break;
	        case 2:
	                printf("dc a(%s+4096)\n", s);
		        break;
	        case 3:
	                printf("dc a(%s+8192)\n", s);
	                printf("dc a(%s+4096)\n", s);
		        break;
	        case 4:
	                printf("dc a(%s+12288)\n", s);
	                printf("dc a(%s+8192)\n", s);
	                printf("dc a(%s+4096)\n", s);
		        break;
	        case 5:
	                printf("dc a(%s+16384)\n", s);
	                printf("dc a(%s+12288)\n", s);
	                printf("dc a(%s+8192)\n", s);
	                printf("dc a(%s+4096)\n", s);
		        break;
	        case 6:
	                printf("dc a(%s+20480)\n", s);
	                printf("dc a(%s+16384)\n", s);
	                printf("dc a(%s+12288)\n", s);
	                printf("dc a(%s+8192)\n", s);
	                printf("dc a(%s+4096)\n", s);
		        break;
		default:
			error("Compiler error: wrong case for text base regs");
	}

	printf("dc a(%s)\n", s);
	printf("dc a(.data)\n");
	printf("2:\ndc a($len%d)\n", fnum);

	/*
	 * generate 'using' for text and data base registers
	 *
	 * registers 10 always used for text base
	 * registers 11 always used for data base
	 */
	printf("1:\ndrop\nusing\t%s,10", s);
        for (i = 0; i < textregs-TREGS; i++)
                printf(",%d", (NONFREE+2-1)-i);
        printf("\n");
        printf("using\t.data,11");
        for (i = 0; i < dataregs-DREGS; i++)
                printf(",%d", (NONFREE+2-1)-(textregs-TREGS)-i);
        printf("\n");
}

outname(s)
{
	register char *p, c;
	register n;

	p = s;
	n = 0;
	while (c = getc(ascfp)) {
		*p++ = c;
		n++;
	}
	do {
		*p++ = 0;
	} while (n++ < 8);
	return(s);
}

/*
 * Reduce the degree-of-reference by one.
 * e.g. turn "ptr-to-int" into "int".
 */
decref(at)
{
	register t;

	t = at;
	if ((t & ~TYPE) == 0) {
		error("Illegal indirection");
		return(t);
	}
	return((t>>TYLEN) & ~TYPE | t&TYPE);
}

/*
 * Increase the degree of reference by
 * one; e.g. turn "int" to "ptr-to-int".
 */
incref(t)
{
	return(((t&~TYPE)<<TYLEN) | (t&TYPE) | PTR);
}
