/*
 * IBM track 0 formatter.
 */

#define MAGIC  0407
#define MAXIPL 10000
#define MAXIPLW MAXIPL/sizeof(int)
#define RDDATA 0x06000000
#define NOOP   0x03000000
#define CC     0x40000000
#define SLI    0x20000000

int buf[MAXIPLW];
char volkey[5];
extern char atetab[];

main(argc,argv)
int argc;
char **argv;
{
        int iplfd,spfd,i;
        char *p;
        struct {
                char *buff;
                char *cchhr;
                char *key;
                char flag;
        } wrreq;
        int startloc,iplsize;
        char id[5];

        if (argc != 5)
                errexit("Usage: trk0 special volid file hexloc\n");

        if ((spfd = open(argv[1],1)) < 0)
                errexit("Cannot open %s\n",argv[1]);

        if ((iplfd = open(argv[3],0)) < 0)
                errexit("Cannot open %s\n",argv[3]);

        if (read(iplfd,buf,32)<32)
                errexit("Error reading %s\n",argv[3]);

        if (buf[0] != MAGIC)
                errexit("%s not executable.\n",argv[3]);

        iplsize = buf[1] + buf[2];
        if (iplsize > MAXIPL)
                errexit("%s too large.\n",argv[3]);

        startloc = 0;
        p = argv[4];
        while (*p){
                if (*p >= '0' && *p <='9')
                        startloc = (startloc<<4) + (*p++ - '0');
                else if (*p >= 'a' && *p <= 'f')
                        startloc = (startloc<<4) + (*p++ - 'a' + 10);
                else if (*p >= 'A' && *p <= 'F')
                        startloc = (startloc<<4) + (*p++ - 'A' + 10);
                else errexit("Bad hex location: %s\n",argv[4]);
        }
        buf[0] = 0x000c0000;
        buf[1] = startloc;
        buf[2] = RDDATA | startloc;
        buf[3] = CC | iplsize;
        buf[4] = NOOP;
        buf[5] = SLI | 1;
        id[0] = id[1] = id[2] = id[3] = 0;
        id[4] = 1;
        wrreq.cchhr = id;
        wrreq.buff = buf;
        wrreq.key = 0;
        wrreq.flag = 2;

        if (write(spfd,&wrreq,24) != 24)
                errexit("Error in writing ipl1 record.\n");

        if (read(iplfd,buf,iplsize) < iplsize)
                errexit("ipl file read error\n");

        id[4] = 2;
        if (write(spfd,&wrreq,iplsize) < iplsize)
                errexit("Error in writing ipl2 record.\n");
        p = buf;
        *p++ = volkey[0] = atetab['V'];
        *p++ = volkey[1] = atetab['O'];
        *p++ = volkey[2] = atetab['L'];
        *p++ = volkey[3] = atetab['1'];
        for (i=0;i<6 && argv[2];i++)
                *p++ = atetab[*argv[2]++];
        for (;i<6;i++)
                *p++ = atetab[' '];
        for (i=0;i<5;i++)
                *p++ = 0;
        *p++ = 4;
        for (i=0;i<64;i++)
                *p++ = atetab[' '];
        id[4] = 3;
        wrreq.key = volkey;
        if (write(spfd,&wrreq,80)<80)
                errexit("Error in writing vol1 record.\n");
}
errexit(fmt,str)
char *fmt,*str;
{
        printf(fmt,str);
        exit();
}
