#include        <stdio.h>
#include        <stdioerr.h>
#include        <signal.h>
#include        <sgtty.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	"defs.h"
#include	"dup.h"
#include	"sym.h"
#include        "timeout.h"

char	tmpout[20] = "/tmp/sh-";
static  char    beenhere = FALSE;



main(c, v)
register int     c;
register char    *v[];
{
	register int  rflag = TTYFLG;

	onerror(EINTR, EIGNORE);
	onerror(EIO, EIGNORE);
	onerror(EACCES, EIGNORE);
	stdsigs();
	getenv();
	/*
	 *  Move standard error to a safe place and be sure its
	 *  not inherited.
	 */
        dup2(OSTDERR, NSTDERR);
	fileno(stderr) = NSTDERR;
	ioctl(NSTDERR, FIOCLEX, NULL);
	/*
	 * look for options
	 */
	dolc = options(c, v);
	if (dolc<2) { 
		flags |= STDFLG;
	}
	if ((flags & STDFLG) == 0) {
		dolc--;
	}
	dolv = v + c - dolc;
	dolc--;
        /*
	 *  Return here for shell file execution
	 */
	setjmp(subshell);
	/*
	 *  Set $# and $$ and $IFS
	 */
	assnum(&dolladr, dolc);
	assnum(&pidadr, getpid());
	dfault(&ifsnod, sptbnl);

	settmp();
	cmdadr = dolv[0];

	if ((beenhere++)==FALSE) {	/* ? profile */
		if (*cmdadr=='-'
		   && (cfp = pathopen(homenod.namval, profile)) != NULL) {
			exfile(rflag); 
                        fclose(cfp);
			flags &= ~TTYFLG;
		}
		if (rflag==0) { 
			flags |= RSHFLG;
		}
		/*
		 *  Either read from the standard input, or a shell file
		 */
		if (flags & STDFLG)
			cfp = stdin;
		else {
			if ((cfp = fopen(cmdadr, "r")) == NULL)
				failed(cmdadr, badopen);
                        flin = 0;
		}
	}
	exfile(0);
	fclose(cfp);
	done();
}

exfile(prof)
register char    prof;
{
	register int    mailtime = 0;
	register int    userid;
	register union   node    *t;
	struct   stat   statb;

	userid = getuid();
	/*
	 * decide whether interactive
	 */
	if ((flags & INTFLG) ||
           ((flags & ONEFLG) == 0 && !cflg &&
	     isatty(STDIN) && isatty(STDOUT) && cfp == stdin)) {
		dfault(&ps1nod, (userid? stdprompt: supprompt));
		dfault(&ps2nod, readmsg);
		flags |= TTYFLG|PROMPT;
		ignsig(SIGTERM);
	} else {
		flags |= prof; 
		flags &= ~PROMPT;
	}
	if (setjmp(errshell) && prof) {	
		fclose(cfp);
		return;
	}
	/*
	 *  Error return here
	 */
	loopcnt = breakcnt = peekc = 0;
	iopend = NULL;
	/*
	 * command loop
	 */
	for (;;) {	
		exitset();
		if ((flags & PROMPT) && peekc != EOF) {
                        if (mailnod.namval &&
                            stat(mailnod.namval, &statb) >= 0 &&
			    statb.st_size && statb.st_mtime > mailtime &&
			    mailtime) {
                                fprintf(stderr, "%s", mailmsg);
                        }
                        mailtime = statb.st_mtime;
			fprintf(stderr, "%s", ps1nod.namval); 
			alarm(TIMEOUT); 
			flags |= WAITING;
		}
		trapnote = 0;
		if ((peekc = readc()) == EOF) {
			peekc = 0;
			return;
		}
		alarm(0); 
		flags &= ~WAITING;
		t = cmd(NL, MTFLG);
		execute(t, 0);
		freetree(t);
		if (flags & ONEFLG)
			return;
	}
}

chkpr(eor)
register char    eor;
{
	if ((flags & PROMPT) && eor == NL) {
		fprintf(stderr, "%s", ps2nod.namval);
	}
}

settmp()
{
	serial = 0;
	sprintf(&tmpout[TMPNAM], "%d", getpid());
	tmpnam = &tmpout[TMPNAM] + strlen(&tmpout[TMPNAM]);
}
