/*
 * Error exits from various parts of shell
 */
#define ERROR	1
#define SYNBAD	2
#define SIGFAIL 3
#define SIGFLG	0200
/*
 * Command tree
 */
#define FPRS    020             /* print child's pid */
#define FINT    040             /* turn off SIGINTR and SIGQUIT */
#define FAMP    0100            /* background */
#define FPIN    0400            /* pipe input */
#define FPOU    01000           /* pipe output */
#define FPCL    02000           /* pipe close */
#define COMMSK  017             /* mask for above flags */
/*
 * Types of nodes in the parse tree
 */
#define TCOM    0               /* command */
#define TPAR    1               /* parenthesis: (stmt-list) */
#define TFIL    2               /* filter */
#define TLST    3               /* stmt-list */
#define TIF     4               /* if statement */
#define TWH     5               /* while statement */
#define TUN     6               /* until statement */
#define TSW     7               /* switch or case statement */
#define TAND    8               /* command and: && */
#define TORF    9               /* command or: || */
#define TFORK   10              /* fork */
#define TFOR    11              /* for statement */
/*
 * execute table.  Values for shell commands.
 */
#define SYSSET		1
#define SYSCD		2
#define SYSEXEC		3
#define SYSLOGIN	4
#define SYSTRAP		5
#define SYSEXIT		6
#define SYSSHFT         7
#define SYSWAIT		8
#define SYSCONT         9
#define SYSBREAK	10
#define SYSEVAL         11
#define SYSDOT		12
#define SYSRDONLY	13
#define SYSTIMES	14
#define SYSXPORT	15
#define SYSNULL         16
#define SYSREAD         17
#define SYSTST		18
#define SYSUMASK        19
/*
 * File descriptor values for common files
 */
#define STDIN           0
#define STDOUT          1
#define OSTDERR         2
#define NSTDERR         10              /* moved here for safety */
/*
 * I/o nodes
 */
#define INPIPE  0               /* input from a pipe */
#define OTPIPE  1               /* output to a pipe */
#define USERIO  10              /* user's can't fiddle with 2 digit */
				/* file descriptors */
#define IOUFD   15              /* mask for the following flags */
#define IODOC   020             /* here document */
#define IOPUT   040             /* output of some type */
#define IOAPP   0100            /* append */
#define IOMOV   0200            /* file descriptor move */
#define IORDW   0400            /* read/write.  Not implemented */
#define IOTMP   01000           /* temporary file */

#define SHBUFSIZ        4096    /* shell buffer size */
			        /* this is the same as the */
				/* maximum argument space */
char    buf[SHBUFSIZ];          /* general purpose buffer */

#include        "mac.h"
#include	"mode.h"
/*
 * Result type declarations
 */
char    *catpath();
char	*copyto();
char	*execs();
char	*getpath();
char	*macro();
char	*mactrim();
char	*make();
char    *malloc();
char	*staknam();
char	**scan();
char	**setenv();
struct  dolnod  *freeargs();
struct  dolnod  *useargs();
struct	namnod	*lookup();
union	node    *cmd();
union	node    *makefork();
FILE    *pathopen();
FILE    *chkopen();
FILE    *tmpfil();

#define attrib(n, f)            (n->namflg |= f)
#define closepipe(x)            (close(x[INPIPE]), close(x[OTPIPE]))
#define eq(a, b)                (strcmp(a, b)==0)
/*
 * Temp files and io
 */
int     cflg;                           /* read from cptr, not cfp */
char    *cline;                         /* -c command line */
char    *cptr;                          /* ptr within cline */
FILE    *cfp;                           /* command file pointer */
int     flin;                           /* line number of a shell file */
struct  ionod   *iotemp;                /* files to be deleted sometime */
struct  ionod   *iopend;                /* documents waiting to be read at NL */
/*
 * Substitution
 */
int     dolc;                           /* argc */
char    **dolv;                         /* argv */
struct  dolnod  *argfor;
struct	argnod	*gchain;
/*
 * String constants.
 */
char	atline[];
char	readmsg[];
char	colon[];
char	minus[];
char	nullstr[];
char	sptbnl[];
char	unexpected[];
char	endoffile[];
char	synmsg[];
/*
 * Name tree and words
 */
struct	sysnod  reserved[];
int	wdval;
int	wdnum;
struct	argnod	*wdarg;
int	wdset;
char	reserv;
/*
 * Prompting
 */
char	stdprompt[];
char	supprompt[];
char	profile[];
/*
 *  Built in names
 */
struct  namnod  fngnod;                 /* FILEMATCH */
struct  namnod  ifsnod;                 /* IFS */
struct  namnod  homenod;                /* HOME */
struct  namnod  mailnod;                /* MAIL */
struct  namnod  pathnod;                /* PATH */
struct  namnod  ps1nod;                 /* PS1 */
struct  namnod  ps2nod;                 /* PS2 */
char	mailname[];
char	homename[];
char	pathname[];
char	fngname[];
char	ifsname[];
char	ps1name[];
char	ps2name[];
/*
 * Special names
 */
char	flagadr[];
char	*cmdadr;
char	*exitadr;
char	*dolladr;
char	*pcsadr;
char	*pidadr;
char    defpath[];                      /* default path */
/*
 * Transput
 */
char	tmpout[];
char	*tmpnam;
int	serial;
#define		TMPNAM 7
int	peekc;
char	devnull[];
/*
 * Flags
 */
int	flags;
#define CFLG    'c'             /* -c flag.  Command line args */
#define NOEXEC  01              /* -n flag.  Read only shell */
#define INTFLG  02              /* -i flag.  Interactive shell */
#define PROMPT  04              /* issue a prompt */
#define SETFLG  010             /* -u flag.  Unset variables are errors */
#define ERRFLG  020             /* -e flag.  Exit immediately upon errors */
#define TTYFLG  040
#define FORKED  0100            /* in the forked child */
#define ONEFLG  0200            /* -t flag.  Execute one command only */
#define RSHFLG  0400            /* -r flag.  Restricted shell */
#define WAITING 01000
#define STDFLG  02000           /* -s flag.  Standard shell */
#define EXECPR  04000           /* -x flag.  Print execution trace */
#define READPR  010000          /* -v flag.  Print lines as read */
#define KEYFLG  020000          /* -k flag.  Keyword arguments */
/*
 * Error exits from various parts of shell
 */
#include	<setjmp.h>
jmp_buf		subshell;
jmp_buf		errshell;
/*
 * Fault handling
 */
#define TRAPSET	2
#define SIGSET	4
#define SIGMOD	8
int	fault();
char	trapnote;
char	*trapcom[];
char	trapflg[];
/*
 * Name tree and words
 */
char	**environ;
char	numbuf[];
char	export[];
char	readonly[];
/*
 * Execflgs
 */
int	exitval;
int	execbrk;
int	loopcnt;
int	breakcnt;
/*
 * Messages
 */
char	arglist[];
char	baddir[];
char	badexec[];
char	badfile[];
char	badopt[];
char	badparam[];
char	badshift[];
char	badsub[];
char	badtrap[];
char	badopen[];
char	badnum[];
char    boverflw[];
char	coredump[];
char	execpmsg[];
char	illegal[];
char	mailmsg[];
char	notfound[];
char	notid[];
char	piperr[];
char	restricted[];
char    stringlong[];
char	toobig[];
char	txtbsy[];
char	wtfailed[];

#include	"ctype.h"
