#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "sys/stat.h"

#define NEWLINE         '\n'
#define BLANK           ' '
#define DQUOTE          '"'
#define GRTHAN          '>'
#define LESSTHAN        '<'
#define EOS             '\0'
#define MAXLINE         512
#define LINE            'l'
#define INCLUDE         'i'
#define DIRECTORY       'd'

char    usage[] = "Usage: %s [-i] [-l] [-d dir] file ...\n";
char    incl[] = "include";
char    usrincl[] = "/usr/include";
char    *cmdname;
char    *getname();
char    *idir;
int     inclcnt;
int     lflg;
int     iflg;
int     dflg;

main(argc, argv)
int argc;
char **argv;
{
	char *flg;

	argc--;
	cmdname = *argv++;
	if (argc <= 0)
		error(usage, cmdname);
	while (argc > 0 && **argv == '-') {
		flg = *argv + 1;
		switch(*flg) {
		case LINE:
			lflg++;
			break;
		case INCLUDE:
			iflg++;
			break;
		case DIRECTORY:
			dflg++;
			if (--argc == 0)
				error(usage, cmdname);
			idir = *++argv;
			break;
		default:
                        error(usage, cmdname);
		}
		argc--;
                argv++;
	}
	if (argc <= 0)
		error(usage, cmdname);
	if (!iflg)
                printf("I = /usr/include\n\n");
	while (argc--)
		domake(*argv++);
}
domake(name)
char *name;
{
	char bname[100];                /* basename */
	char suffix[10];
	int len;
	int dot;

	inclcnt = 0;
	len = strlen(name);
	dot = sindex(name, ".");
	strcpy(suffix, &name[dot + 1]);
	strncpy(bname, name, dot);
	bname[dot] = EOS;
	if (lflg) {
		printf("%s.o:", bname);
                wspace(strlen(bname) + 3);
		printf("%s", name);
                wspace(strlen(name));
		includes(name);
		putchar(NEWLINE);
	} else {
                printf("%s:", bname);
                wspace(strlen(bname) + 1);
                printf("%s", name);
                wspace(strlen(name));
                includes(name);
                putchar(NEWLINE);
		onefile(name, bname, suffix);
                if (dflg) {
                        printf("%s/%s:\t%s\n", idir, bname, bname);
                        printf("\t/etc/instcmd %s %s/%s\n\n", bname, idir, bname);
		}
                putchar(NEWLINE);
	}
}
/*
 *  onefile - the program is made up of one source file.
 *  Determine the type of source file and generate the
 *  appropriate commands to make it.
 */
onefile(name, bname, suffix)
char    *name;
char    *bname;
char    *suffix;
{

	switch(suffix[0]) {
	case 's':
	case 'c':
                printf("\tcc -n $(CFLAGS) -o %s %s\n", bname, name);
                break;
	case 'q':
                printf("\tqs -n $(CFLAGS) -o %s %s -lq\n", bname, name);
                break;
	case 'y':
		printf("\tyacc %s\n", name);
		printf("\tcc $(CFLAGS) -o %s y.tab.c -ly\n", bname);
		break;
	case 'l':
		printf("\tlex %s\n", name);
		printf("\tcc $(CFLAGS) -o %s lex.yy.c -ll\n", bname);
		break;
	default:
		if (strcmp(suffix, "tcl") == 0) {
			printf("\ttclpp %s\n", name);
                        printf("\tcc -n $(CFLAGS) -o %s %s.c -ltcl\n", bname, bname);
		} else
			fprintf(stderr, "%s: unrecognized suffix %s\n", cmdname, suffix);
	}
}
/*
 *  wspace - white space
 */
wspace(len)
int     len;
{
	int     i;

	for (i = 16 - len; i > 0; i--)
		putchar(BLANK);
}
/*
 *  includes - list the include files
 *  Search for lines beginning with #include.
 *  Then pull the name of the include file out of double quotes
 *  or angle brackets and see if it exists.
 *  If the name was in double quotes, check in the current directory.
 *  Upon finding an include file, print its name on the standard
 *  output and check it for any nested include files.
 */
includes(name)
char *name;
{
	FILE *fp;
	struct stat statbuf;
	char line[MAXLINE];
	char *bname;
	char *cp;

	if ((fp = fopen(name, "r")) == NULL)
		return;
	while (fgets(line, MAXLINE, fp) != NULL) {
		cp = line;
		if (*cp++ != '#')
			continue;
		while (isspace(*cp))
			cp++;
		if (strncmp(cp, incl, sizeof(incl)-1) != 0)
			continue;
		cp += (sizeof(incl)-1);
		while (isspace(*cp))
			cp++;
		if (*cp == DQUOTE) {
			bname = getname(++cp, DQUOTE);
			if (stat(bname, &statbuf) != -1) {
                                if (++inclcnt >= 4) {
                                        printf("\\\n\t\t\t\t");
					inclcnt = 1;
				}
                                printf("%s ", bname);
                                includes(bname);
			} else
				sysincl(cp, DQUOTE);
                } else if (*cp == LESSTHAN)
			sysincl(++cp, GRTHAN);
	}
	fclose(fp);
}
/*
 *  sysincl - check for system include file
 */
sysincl(cp, endch)
char *cp;
int endch;
{
	char *bname;
	char iname[MAXLINE];
	struct stat statbuf;

	bname = getname(cp, endch);
	strcpy(iname, usrincl);
	strcat(iname, "/");
	strcat(iname, bname);
	if (++inclcnt >= 4) {
                printf("\\\n\t\t\t\t");
                inclcnt = 1;
        }
	if (stat(iname, &statbuf) == -1)
		printf("%s ", bname);
        else {
                printf("$I/%s ", bname);
                includes(iname);
	}
}
/*
 *  getname - get the filename of an include
 *  endch is the terminating character, either a " or >.
 */
char *
getname(cp, endch)
char *cp;
int endch;
{
	static char buf[15];
	char *bp = buf;

	while (*cp != endch && *cp != EOS)
		*bp++ = *cp++ ;
	*bp = EOS;
	return(buf);
}
/*VARARGS1*/
error(args)
char *args;
{
	fprintf(stderr, "%r", &args);
	exit(1);
}
