/*
 * Write a label on a tape.
 *
 * Usage: label [-f] tape_name
 */
#include <stdio.h>
#include <sgtty.h>
#include <ctype.h>

#define writetm(a) ioctl(a, TAPIO, 0x1f)

extern char atetab[];

char cardim[81];
char name[80];

main(argc, argv)
int argc;
char *argv[];
{
	char *labelchk();
	char *cp;
	int fflag = 0;
	int rflag = 0;
	int fd;
	int bk;

	argc--;
	while(**++argv == '-') {
		switch(*++*argv) {
		case 'f' :
			fflag++;
			break;
		case 'r' :
			rflag++;
			break;
		default:
			fprintf(stderr, "Label: Unknown flag '%s'\n", *argv);
			exit(1);
		}
		argc--;
	}
	if (argc > 2 || argc < 1) {
		fprintf(stderr, "Usage: label [-fr] tape [ilabel]\n");
		exit(1);
	}
	if(**argv != '/')
                sprintf(name, "/dev/tape/%s", *argv);
	else
		sprintf(name, "%s", *argv);
	if ((fd = open(name, 0)) == -1) {
		fprintf(stderr, "%s: unable to open\n", name);
		exit(1);
	}
        if (argc == 2)
                argv++;
	cp = labelchk(fd, *argv);
	if (rflag) {
		switch(cp) {
		case NULL :
			fprintf(stdout, "%s\n", *argv);
			break;
		case -1 :
			fprintf(stdout, "No label\n");
			break;
		default:
			fprintf(stdout, "%s\n", cp);
			break;
		}
		exit(0);
        }
	switch(cp) {
	case 0 :
		fprintf(stderr, "Label: Correct label exists\n");
		break;
	default:
                if(!fflag) {
                        fprintf(stderr, "Label: Tape already labeled as '%s'\n", cp);
			exit(2);
		}
	case -1 :
		close(fd);
		fd = open(name, 1);
		if(fd < 0) {
			fprintf(stderr, "Label: Cannot write on tape\n");
			exit(1);
		}
		sprintf(cardim, "VOL1%-76.6s", *argv);
		for(bk=0; bk<10; bk++) {
			if(islower(cardim[bk]))
				cardim[bk] = toupper(cardim[bk]);
			cardim[bk] = atetab[cardim[bk]];
		}
		write(fd, cardim, 80);
		writetm(fd);
		close(fd);
		break;
	}
	exit(0);
}
