#
# include "../370.h"
# include "../param.h"
# include "../systm.h"
# define PGPTABS 102 /* PGSIZE/sizeof pagetab */
# define NULL 0
struct pagetab
{
	struct pagetab *pt_next;
	int pt_info[9];
};

char **ffpage;
struct pagetab *ffptab NULL;

getpage()
{
	char **p;
	if((p=ffpage)==NULL) panic("no pages");
	ffpage = *ffpage;
	--pagecnt;
	return(p);
}

freepag(p)
char **p;
{
	char *q;
	q = p;
	if(q%PGSIZE) panic("bad freepage addr");
	*p = ffpage;
	ffpage = p;
	pagecnt++;
	return(1);
}

getptab()
{
	struct pagetab *p;
	int i;
	if(!ffptab)
	{
		if(p=getpage()){
			ffptab = p;
			while(p+1 < ffptab+PGPTABS)
				p = p->pt_next = p+1;
			p->pt_next = NULL;
		}else return(NULL);
	}
	p = ffptab;
	ffptab = ffptab->pt_next;
	p->pt_next = NULL;
	p->pt_info[0] = 0;
	for(i=1;i<9;i++) p->pt_info[i] = PTINIT;
	return(p);
}

freptab(p)
struct pagetab *p;
{
	p->pt_next = ffptab;
	ffptab = p;
	return(1);
}
