#
/* C compiler     ( file - c00.c )

Copyright 1972 Bell Telephone Laboratories, Inc.

*/

#include "c0h.c"

int	isn1 10000;
int	isn 1;
int	peeksym -1;
int	line 1;
int	assemblycode;

struct kwtab {    /*  key word table  */
	char	*kwname;
	int	kwval;
} kwtab[]
{
	"int",		INT,
	"char",		CHAR,
	"float",	FLOAT, 	/*float is being tested. */
	"double",	DOUBLE,	/* double is being tested.*/
	"struct",	STRUCT,
	"auto",		AUTO,
	"extern",	EXTERN,
	"static",	STATIC,
	"register",	AUTO,
	"goto",		GOTO,
	"return",	RETURN,
	"if",		IF,
	"while",	WHILE,
	"else",		ELSE,
	"switch",	SWITCH,
	"case",		CASE,
	"break",	BREAK,
	"continue",	CONTIN,
	"do",		DO,
	"default",	DEFAULT,
	"for",		FOR,
	"bliss",	BLISS,
	"fortran",	FORTRAN,
	"asm",		ASM,
	"sizeof",	SIZEOF,
	0,		0,
};

main(argc, argv)    /*  main for the entire C compiiler  */
char *argv[];
{
	extern cin, cout;
	int treespace[ossiz];
	register char *sp, *np;
	char *namep;
	register struct kwtab *ip;
	int i,c;

	if ('r' + 1 == 's')
		{machine = UNIX;}
	else
		machine = IBM;
	nerror = 0;

	i=1;
	if(*argv[i]== '-') {

		switch(c=argv[i][1]) {
			default:
				{error("illegal option - %s",c);
	 			i++; break;}

				}
		}

	if((argc-i)<2) {
		error("Arg count");
		cexit(1);
	}
	if((cin=copen(argv[i],'r'))<0) {
		error("Can't find %s", argv[i]);
		cexit(1);
	}
	if ((assemblycode = cout = copen(argv[i+1], 'w', 'e')) < 0) {
		error("Can't create temp");
		cexit(1);
	}
	if ((argc - i)>2)
		proflg++;
	xdflg++;
	for (ip=kwtab; (np = ip->kwname); ip++) { /* Initialize the symbol table by  */
		for (sp = symbuf; sp<symbuf+ncps;)  /* copying keywords into it.  */
			if ((*sp++ = *np++) == '\0')
				np--;
		np = lookup();
		np->hclass = KEYWC;
		np->htype = ip->kwval;
	}
	xdflg = 0;
	treebase = treespace+10;  /*  Treebase is a constant pointing to the base of the syntax tree.  */
	namep=argv[i];
	while (alphanum(*namep)) namep++;
	*namep= '\0';
	printf("%.7s	startup\n", argv[i]);
	while(!eof) {   /*  This is the main loop of the compiler.  It reads all  */
		extdef();  /*  of the input program and calls functions which  */
		blkend();     /*  compile that input.  */
	}
	transvec();	/*  Produce a transfer vector.  */
	hgprloc(hglit);
	printf("	ltorg\n");
	printf("	end	%s\n", mainfile ? "$main$": " ");
	cexit(nerror!=0);
}

error(s, p1, p2, p3, p4, p5, p6)
{
		extern cout;
	cout = 1;	/*  Switch output to ft06f001.  */
	printf("%d: ", line);
	printf(s, p1, p2, p3, p4, p5, p6);
	putchar('\n');
	nerror++;
	cout = assemblycode;	/*  Switch back.  */
}

tree()	/* The expression compiler - returns root node of tree.*/
{
#define	SEOF	200
#define	SSIZE	20
	int *op, opst[SSIZE], *pp, prst[SSIZE];
	register int andflg, o;
	register struct hshtab *cs;
	struct hshtab *p1, *p2;
	int p, ps, os, *np;

	osleft = ossiz;
	space = treebase;
	op = opst;
	pp = prst;
	cp = cmst;
	*op = SEOF;
	*pp = 06;
	andflg = 0;

advanc:
	switch (o=symbol()) {

	case NAME:
		cs = csym;
		if (cs->hclass==0 && cs->htype==0)
			if(nextchar()=='(') {
				/* set function */
				cs->hclass = GXTERN;
				cs->htype = FUNC;
				cs->hflags =| GLOBAL;
			} else if (initflg)
					cs->hclass = EXTERN;
				else {
					/* set label */
					cs->htype = ARRAY;
					if (cs->hoffset==0)
						cs->hoffset = isn++;
				}
		p1 = block(2,NAME,cs->htype,cs->hdimp,
		    cs->hclass,0);
		if (cs->hclass==EXTERN || cs->hclass==GXTERN || cs->hclass==FORTRAN) {
			np = cs->name;
			for (o=0; o<4; o++) {
				pblock(*np);
				if (((*np++)&~0177) == 0)
					break;
			}
		} else
			pblock(cs->hoffset);
		if (p1->op == NAME && (p1->class == GXTERN || p1->class == FORTRAN)) {
			p2 = block(1,STAR,p1->type,p1->dimp,p1);
			p1->type = incref(p1->type);	/*  change N to pointer to N. */
			p1 = p2;
		}
		*cp++ = p1;
		goto tand;

	case SFCON:	/* short floating constant - an optimization for the PDP 11. */
	case FCON:
		if (!initflg) prtflo(1,0);

	case CON:
		*cp++ = block(1,o,(o==CON?INT:DOUBLE),0,cval);
		goto tand;

	/* fake a static char array */
	case STRING:
		if( initflg ) error( "initializer too complicated" );
		hgprloc( hgstring );
		getstr();
		hgprloc( hgcode );
		*cp++ = block(3, NAME, ARRAY+CHAR,0,STATIC,0,cval);

tand:
		if(cp>=cmst+cmsiz) {
			error("Expression overflow");
			cexit(1);
		}
		if (andflg)
			goto syntax;
		andflg = 1;
		goto advanc;

	case INCBEF:	/* increment before */
	case DECBEF:	/* decrement before */
		if (andflg)
			o =+ 2;
		goto oponst;

	case COMPL:	/* complement */
	case EXCLA:	/* exclaimation point */
	case SIZEOF:
		if (andflg)
			goto syntax;
		goto oponst;

	case MINUS:
		if (!andflg)
			o = NEG;
		andflg = 0;
		goto oponst;

	case AND:
	case TIMES:
		if (andflg)
			andflg = 0; else
			if(o==AND)
				o = AMPER;
			else
				o = STAR;
		goto oponst;

	case LPARN:
		if (andflg) {
			o = symbol();
			if (o==RPARN)
				o = MCALL;
			else {
				peeksym = o;
				o = CALL;
				andflg = 0;
			}
		}
		goto oponst;

	case RBRACK:
	case RPARN:
		if (!andflg)
			goto syntax;
		goto oponst;

	case DOT:	
	case ARROW:
		mosflg++;
		break;

	}
	/* binaries */
	if (!andflg)
		goto syntax;
	andflg = 0;

oponst:
	p = (opdope[o]>>9) & 077;
	if ((o==COMMA || o==COLON) && initflg)
		p = 05;
opon1:
	ps = *pp;
	if (p>ps || p==ps && (opdope[o]&RASSOC)!=0) {
		switch (o) {

		case INCAFT:
		case DECAFT:
			p = 37;
			break;
		case LPARN:
		case LBRACK:
		case CALL:
			p = 04;
		}
		if(op>=opst+SSIZE) {
			error("expression overflow");
			cexit(1);
		}
		*++op = o;
		*++pp = p;
		goto advanc;
	}
	--pp;
	switch (os = *op--) {

	case SEOF:	/* see bottom of stack */
		peeksym = o;
		build(0);		/* flush conversions */
		return(*--cp);

	case CALL:	/* ftn call operator eg f(x)  */
		if (o!=RPARN)
			goto syntax;
		build(os);
		goto advanc;

	case MCALL:	/* empty arguement call eg f()  */
		*cp++ = block(0,0,0,0);	/* 0 arg call */
		os = CALL;
		goto fbuild;

	case LPARN:
		if (o!=RPARN)
			goto syntax;
		goto advanc;

	case LBRACK:	/* [ - for subscripts */
		if (o!=RBRACK)
			goto syntax;
		build(LBRACK);
		goto advanc;
	}
fbuild:
	build(os);
	goto opon1;

syntax:
	error("Expression syntax");
	errflush(o);
	return(0);
}	/*  End of the tree function.  */


declare(askw, tkw, offset, elsize)	/* Parses a list of declarators. */
{
	register int o;
	register int skw;
	int corr;
	corr = NO;

	skw = askw;
	mosflg = skw==MOS;
	if (endp == YES)  ndp = 0;
	if ((peeksym = symbol() ) == RPARN)   corr = YES;
	do {
		if (endp == YES) { ndp =+ 1;  }	/* Count nbr of declared parameters. */
		offset =+ decl1(skw, tkw, offset, elsize, YES);
		if (xdflg && skw!=MOS)
			return(offset);
	} while ((o=symbol()) == COMMA);
	if (endp == YES && corr == YES) ndp = 0;
	endp = NO;
	if (o==SEMI || o==RPARN && skw==ARG1)
		return(offset);
	decsyn(o);
	return(offset);
}

decl1(askw, tkw, offset, elsize, declr)
{
	int t1, chkoff;
	register int type, skw;
	register struct hshtab *dsym;
	int predef;
	int savetype;

	skw = askw;
	chkoff = 0;
	mosflg = skw==MOS;
	if ((peeksym=symbol())==SEMI || peeksym==RPARN)
		return(0);
	if ((t1=getype()) < 0)
		goto syntax;
	type = 0;
	do
		type = type<<2 | (t1 & 030);
	while (((t1=(t1>>2)) & 030)!=0);
	type =| tkw;
	dsym = defsym;
	if (dsym->hclass != 0)  predef = YES;  else predef = NO;
	if (!(dsym->hclass==0
	   || (skw==ARG && dsym->hclass==ARG1)
	   || ((skw==EXTERN || skw==GXTERN || skw==FORTRAN) &&
		(dsym->hclass==EXTERN || dsym->hclass==GXTERN || dsym->hclass==FORTRAN) && dsym->htype==type)))
		if (skw==MOS && dsym->hclass==MOS && dsym->htype==type)
			chkoff = 1;
		else {
			redec();
			goto syntax;
		}
	dsym->htype = type;
	if (skw) {
		savetype = dsym->hclass;
		dsym->hclass = skw;
	}
	if ((declr==YES) && (skw==EXTERN)) {
		if (predef == NO) {
			dsym->hclass = GXTERN;
			dsym->hflags =| GLOBAL;
		}  else if (dsym->hflags & PERM)
			dsym->hclass = savetype;
	}
	if (skw==ARG1) {
		if (paraml==0)
			paraml = dsym;
		else
			parame->hoffset = dsym;
		parame = dsym;
	}
	if (elsize) {
		dsym->lenp = dimp;
		dimtab[dimp++] = elsize;
	}
	elsize = 0;
	if (skw==MOS) {
		elsize = length(dsym);
		if (elsize != 1) {
			elsize =+ ((offset + 3) & ~3) - offset;
			offset = ((offset + 3) & ~3);	/* round up to multiple of 4  */
		}
		if (chkoff && dsym->hoffset != offset)
			redec();
		dsym->hoffset = offset;
	}
	if ((dsym->htype&030)==FUNC) {
		if (dsym->hclass!=EXTERN && dsym->hclass!=AUTO && dsym->hclass!=GXTERN && dsym->hclass!=FORTRAN)
			error("Bad function");
		dsym->hclass = dsym->hclass==FORTRAN?FORTRAN:GXTERN;
		dsym->hflags =| GLOBAL;
	}
	if (dsym->hclass==AUTO) {
		dsym->hoffset = autolen;
		autolen =+ rlength(dsym);
	} else if (dsym->hclass==STATIC) {
		dsym->hoffset = isn;
		hgprloc(hgdata);
		printf("$%d	equ	* \n", isn++);
		printf("	dc	%dx'00' \n", rlength(dsym) );
		hgprloc(hgcode);
	} else if (dsym->hclass==REG) {
		if ((type&07)>CHAR && (type&030)==0
		 || (type&030)>PTR || regvar>5)
			error("Bad register %o", type);
		dsym->hoffset = ++regvar;
	}
syntax:
	return(elsize);
}

getype()
{
	register int o, type;
	register struct hshtab *ds;

	switch(o=symbol()) {

	case TIMES:
		return(getype()<<2 | PTR);

	case LPARN:
		type = getype();
		if ((o=symbol()) != RPARN)
			goto syntax;
		ds = defsym;
		goto getf;

	case NAME:
		defsym = ds = csym;
		type = 0;
		ds->ssp = dimp;
	getf:
		switch(o=symbol()) {

		case LPARN:
			if (xdflg) {
				xdflg = 0;
				ds = defsym;
				declare(ARG1, 0, 0, 0);
				defsym = ds;
				xdflg++;
			} else
				if ((o=symbol()) != RPARN)
					goto syntax;
			type = type<<2 | FUNC;
			goto getf;

		case LBRACK:
			if ((o=symbol()) != RBRACK) {
				peeksym = o;
				cval = conexp();
				for (o=ds->ssp; o<dimp; o++)
					dimtab[o] = dimtab[o] * cval;
				dimtab[dimp++] = cval;
				if ((o=symbol())!=RBRACK)
					goto syntax;
			} else
				dimtab[dimp++] = 1;
			type = type<<2 | ARRAY;
			goto getf;
		}
		peeksym = o;
		return(type);
	}
syntax:
	decsyn(o);
	return(-1);
}

decsyn(o)
{
	error("Declaration syntax");
	errflush(o);
}

redec()
{
	error("%.8s redeclared", defsym->name);
}

alphanum(c)
{
switch(c)
	{
	case 'a': case 'b': case 'c': case 'd': case 'e': case 'f': 
	case 'A': case 'B': case 'C': case 'D': case 'E': case 'F': 
	case 'g': case 'h': case 'i': case 'j': case 'k': case 'l': 
	case 'G': case 'H': case 'I': case 'J': case 'K': case 'L': 
	case 'm': case 'n': case 'o': case 'p': case 'q': case 'r': 
	case 'M': case 'N': case 'O': case 'P': case 'Q': case 'R': 
	case 's': case 't': case 'u': case 'v': case 'w': case 'x': case 'y': 
	case 'S': case 'T': case 'U': case 'V': case 'W': case 'X': case 'Y': 
	case 'z': case '0': case '1': case '2': case '3': case '4': 
	case 'Z': case '5': case '6': case '7': case '8': case '9': 
		return(1);
	default:
		return(0);
	}
}
