#include "odbh0.c"
/* all of this segment is from cdb
 * with minor modifications
*/
printtrace()
{
	int tpc, tr5, narg, argp, i;

	putlp(CRLF);
	tpc = users[regtab[7].r_offs];
	tr5 = users[regtab[5].r_offs];
	if (locsr5 &&  (narg = get(locsr5)))
			tr5 = narg;
	callev = 0;
	while (errflg == 0) {
		if (lbp >= linbuf+512)
			linput();
		narg = findroutine(tpc, tr5);
		putdec(callev);
		putlp(": ");
		putlp(symbuf);
		putlp("(");
		if (--narg >= 0)
			putoct(get(tr5+4));
		argp = tr5+4;
		while(--narg >= 0) {
			putlp(",");
			putoct(get(argp =+ 2));
		}
		putlp(")\n\r");
		tpc = get(tr5+2);
		if (callev < 50) {
			entpt[callev] = ssymval;
			callist[callev++] = tr5;
		}
		if ((tr5 = get(tr5)) == 0)
			break;
	}
	linput();
}

setstack()
{
	register int tpc, tr5, i;

	tpc = users[regtab[7].r_offs];
	tr5 = users[regtab[5].r_offs];
	if (locsr5 &&  (i = get(locsr5)))
			tr5 = i;
	callev = 0;
	while (errflg == 0) {
		findroutine(tpc, tr5);
		tpc = get(tr5+2);
		if (callev >= 50)
			break;
		entpt[callev] = ssymval;
		callist[callev++] = tr5;
		if ((tr5 = get(tr5)) == 0)
			break;
	}
	errflg = 0;
}

findroutine(rpc, rr5)
{
	register callpt, inst, narg;

	callpt = get(rr5+2);
	if ((inst=get(callpt-4)) == 04737)	/* jsr pc,*$... */
		narg = 1;
	else if ((inst&~077)==04700)		/* jsr pc,... */
		narg = 0;
	else {
		errflg++;
		return(0);
	}
	inst = vallook((inst==04767?callpt:0) + get(callpt-2));
	if (inst) {
		symbuf[0] = '?';
		symbuf[1] = 0;
		ssymval = 0;
	}
	inst = get(callpt);
	if (inst == 05726)		/* tst (sp)+ */
		return(narg+1);
	if (inst == 022626)		/* cmp (sp)+,(sp)+ */
		return(narg+2);
	if (inst == 062706)		/* add $n,sp */
		return(narg+get(callpt+2)/2);
	return(narg);
}

vallook(vval)
char *vval;
{
	register char *diff;
	int i;
	register int *p, *q;
	char sbuf[12];

	diff = 0177777;
	p = q = &sbuf[10];
	q--;
	seekoff();
	while (getsym(sbuf))
		if (*q&040 && vval-*p<=diff) {
			if (*q==1 && vval!= *p)
				continue;
			diff = vval- *p;
			rmvch(sbuf, *q);
			for(i = 0; i < 12; i++)
				symbuf[i] = sbuf[i];
			ssymval = *p;
		}
	return(diff);
}

symlook(symstr)
char *symstr;
{
	register i;
	register symv;
	int *symval, *symflg;
	char sbuf[12];
	symflg = &sbuf[8];
	symval = &sbuf[10];

	seekoff();
	while (getsym(sbuf)) {
		/* wait for function symbol */
		if (sbuf[0] != '~' || !same(sbuf, symbol))
			continue;
		symv = *symval;
		while (getsym(sbuf)&& sbuf[0]!='~' && *symflg!=037)
			if (same(sbuf, symstr))
				return(localsym(symv, *symflg, *symval));
		return(0);
	}
}

localsym(s, symflg, symval)
{
	register i, xr5;

	/* label, static */
	if (symflg>=2 && symflg<=4) {
		adrval = ssymval = symval;
		return(1);
	}
	/* auto, arg */
	if (symflg==1) {
		for (i=0; i<callev; i++)
			if (entpt[i]==s) {
				adrval = ssymval = symval+callist[i];
				return(1);
			}
		return(0);
	}
	/* register */
	if (symflg==20) {
		for (i=0; i<callev; i++)
			if (entpt[i]==s) {
				if (i==0) {
					return(0); /* temp, no reg lvalue */
				}
			adrval = ssymval = callist[i-1] - 10 + 2*symval;
				return(1);
			}
		return(0);
	}
	return(0);
}

