#include	"odbh0.c"

breakp()

{
	if ( !svalfnd )
		rmvbkp();
	else
		setbkp();
}

setbkp()
{
	register struct list *p,*bl;
	bl = &bkpt[NOOFBP];
	if (valfnd) {
		if (adrval>8)
			error();
		for (p=bkpt; p<bl; p++)
			if (p->badr == tadrval)
				return;
		(bkpt+adrval)->badr = tadrval;
	} else {
		for (p = bkpt; p < bl; p++) {
			if (p->badr == tadrval)
				return;
			if ( p->badr < 0 ) {
				p->badr = tadrval;
				return;
			}
		}
		error();
	}
}

rmvbkp()
{
	register struct list *p;
	p = bkpt+adrval;
	if (!valfnd)
		rmvall();
	else
		if (adrval > 8)
			error();
		else
			if (p->badr >= 0 && pid)
				remove(p);
}

cbplist()
{
	register struct list *p;
	for (p = bkpt; p < &bkpt[NOOFBP]; p++) {
		p->badr = -1;
		p->bcnt = p->bcount = 0;
	}
}

rmvall()
{
	register struct list *p;
	if (pid == 0) {
		cbplist();
		return;
	}
	for (p = bkpt; p < &bkpt[NOOFBP]; p++)
		if (p->badr >= 0)
			remove(p);
}

remove(p)
struct list *p;
{
	register s;
	if (p->badr == savebp) {
				/* it is the one that */
				/* stopped us         */
		savebp = 0;
		s = regtab[8].r_offs;
		ptrace(W_REGS, pid, s<<1, users[s]& ~TBIT);
	}
				/* restore original  */
	ptrace(W_DSPAC, pid, p->badr, p->bcnt);
	p->badr= -1;
	p->bcnt = p->bcount= 0;
}

go()
{
	savebp = 0;
	scflg--;
	if ( pid ) {
		ptrace(FINISH, pid, 0, 0);		/* terminate traced process */
		pid = 0;
	}
	if ((pid=fork()) == 0) {
		ptrace(P_TRACE, 0, 0, 0);		/* trace me ! */
		signal(2,0);
		signal(4,0);
		vexec();
		printf("EXEC ERROR on %s\n",symfil);
		exit(0);
	}
}


vexec()
{
	extern _exectrap;
	register char **vp, *p;
	int inbuf[10];
	char *argve[32];
	register c;
	vp = argve;
	*vp++ = symfil;
	getlin(1);
	p = lp;
	do {
		while (*p == ' ')
				p++;
		if (match(*p, "\n\0"))
				break;
		*vp++ = p;
		while( !match(*p,"\n "))
					p++;
		c = *p;
		*p++ = NUL;
	} while (!match(c,"\n"));
	*vp++ = 0;
	printf("\n");
	_exectrap++;
	if (macfil && tadrval>0) {	/* m11 progs. can start anywhere */
		seek(symin,0,0);
		read(symin,inbuf,020);
		if (inbuf[0] == 0407) {
			seek(symin,10,0);
			write(symin,&tadrval,2);
		}
	}
	execv(symfil, argve);
}


/* restore breakpoints, */
/* save contents, and replace with trap */
bpoint()
{
	register struct list *p,*bl;
	register addr;
	bl = &bkpt[NOOFBP];
	for (p=bkpt; p<bl; p++) {
		addr = p->badr;
		if ( addr>=0 && p->bcnt==0) {
			p->bcnt = ptrace(R_DSPAC, pid, addr, 0);
			ptrace(W_DSPAC, pid, addr, 3);
			if (errno) {
				putlp("\nBreakpoint not possible at ");
				putoct(p->badr);
				putlp("\n");
				linput();
			}
		}
	}
}


/* notify the parent via wait */
waitin()
{
	int setclr();
	register struct regtab *rp;
	int stat;
	register p;
loop:
	signal(2,1);
	while((p=wait(&stat)) != pid && p != -1);
				/* wait until end of child */
	signal(2,setclr);
	if (p == -1) {		/* no children */
		ptrace(FINISH, pid, 0, 0);
		pid = 0;
		putlp("\nWAIT ERROR\n");
		linput();
		setclr();
	}
	if ((stat&0377) != 0177) { 	/* if process terminated */
		if (sign = stat&0177)
			putlp("\n");
			putlp(signam[sign]);
		putlp("\nProcess terminated.\n");
		linput();
		if (pid == p) {
			pid = 0;
			cbplist();
			linput();
			setclr();
		}
		goto loop;
	}
	sign = stat>>8;			/* we have a stoppage */
	for (rp = regtab; rp < &regtab[9]; rp++)
		users[rp->r_offs] = ptrace(R_REGS, pid, rp->r_offs<<1, 0);
	if (macfil == 0)		/* C- programs only */
		setstack(stkflg++);
	if (sign != 5) {
					/* stoppage is not due to bpoint */
		putlp("\n");
		putlp(signam[sign]);
		putlp("\n");
		linput();
		setclr();
	}
}


prosid()
{
	register addr, s;
	register struct list *p;
	s = regtab[8].r_offs;
	if (addr = savebp) {
			/* ignore the signal that caused the interrupt */
		ptrace(CONTIN, pid, 0, 0);
		waitin();
			/* set a trap where last bpoint was */
		ptrace(W_DSPAC, pid, addr, 3);
			/* clear t-bit */
		ptrace(W_REGS, pid, s<<1, users[s]& ~TBIT);
		savebp = 0;
	}
	ptrace(CONTIN, pid, 0, 0);
	waitin();
	addr = users[regtab[7].r_offs] - 2;	/* get addr where bpoint is */
	for (p=bkpt; p< &bkpt[NOOFBP]; p++)
		if (p->badr == addr) {
					/* interrupt due to bpoint */
			if ( tadrval ) {
				p->bcount = tadrval;
				tadrval = 0;
			}
			savebp = addr;	/* save it's address */
					/* restore original contents */
			ptrace(W_DSPAC, pid, addr, p->bcnt);
					/* pc gets that address */
			ptrace(W_REGS, pid, regtab[7].r_offs<<1, addr);
					/* set the t-bit */
			ptrace(W_REGS, pid, s<<1, users[s] | TBIT);
					/* return control to user */
			if (--p->bcount > 0) {
				bpoint();
				prosid();
			}
			p->bcount = 1;
			putlp("\nB");
			*lbp++ = p-bkpt+'0';
			putlp(";");
			goto set;
		}
				/* we have some other type of interrupt */
	putlp("\n");
	putlp(signam[sign]);
	putlp(" at ");
	set:
	putoff(addr);
	linput();
	setclr();
}

setclr()
{
	signal(2, 1);
	if (cfdes > 1)
		close(cfdes);
	reset();
}
