
// Segment TE4

GET "te.hdr"
GET "syshdr.bpl"

// Process UNIX command line

LET UNIX() BE
$( LET LP = 1
   AND EXPANDED = FALSE
   AND PID, SAVINT = ?, ?
   AND CH = ?

   CH := RDCH()
   TEST CH NE '!' THEN     // Read and store command line
   $( UNTIL CH = '*N' \/ CH = ENDSTREAMCH DO
      $( TEST CH = '%' THEN      // Substitute input filename
         $( EXPANDED := TRUE
            FOR I = 1 TO GETBYTE(ITVSS, 0) DO
            $( PUTBYTE(UNIXBUFFER, LP, GETBYTE(ITVSS, I))
               LP := LP + 1
            $)
         $)
         OR
         $( PUTBYTE(UNIXBUFFER, LP, CH)
            LP := LP + 1
         $)
         CH := RDCH()
      $)

      PUTBYTE(UNIXBUFFER, 0, LP - 1)      // Fill in count
   $)
   OR
   $( EXPANDED := TRUE         // Repeat last command line
      CH := RDCH() REPEATUNTIL CH = '*N' \/ CH = ENDSTREAMCH
   $)

   IF EXPANDED THEN     // Echo full line
      WRITEF("!%S*N", UNIXBUFFER)

   IF GETBYTE(UNIXBUFFER, 0) = 0 RETURN     // Null command

   PID := FORK()     // Create new process

   IF PID = 0 THEN       // Child process
   $( LET TV = VEC 3
      AND WV0 = VEC 1
      AND WV1 = VEC 1
      AND PARAMS = VEC 3

      PARAMS!0 := BCSTR("sh", WV0) << 1
      PARAMS!1 := BCSTR("-c", WV1) << 1
      PARAMS!2 := BCSTR(UNIXBUFFER, UNIXBUFFER) << 1
      PARAMS!3 := 0      // Terminator

      SYSCALL(SY.EXEC, BCSTR("/bin/sh", TV) << 1, PARAMS << 1)
      FINISH
   $)

   SAVINT := SYSCALL(SY.SIGNAL, S.SIGINTR, 1)   // Ignore interrupts

   $( LET RPID = (SYSCALL(SY.WAIT))!0   // Wait for child to terminate

      IF RPID < 0 \/ RPID = PID BREAK
   $) REPEAT

   SYSCALL(SY.SIGNAL, S.SIGINTR, SAVINT)    // Allow interrupts
   WRITES("!*N")
$)

// End of file te.bpl
