#include	"mch.c"

char *stkf	"%d()\n";
char *xfm0	"0()\n";
char *xfm1	"1()\n";

subr16(ms, n)
char *ms;
{
	if (n) {
		chkacca(ldaflg);
		stkpsh();
		pusharg();
	}
	printf("\tjbs\t%s16\n", ms);
	return(4);
}

setpargs(nodtyp, ap)
int *ap;
{
	register struct symtab *sp;
	if (nodtyp >= 0)
		nodtyp =& MASK;
	switch(nodtyp) {
		case LCLID :
			chksp();
			lbarg = hbarg = getloff(*(ap+1));
			lfmt = hfmt = stkf;
			if ((ctyp = gidtyp(*ap)))
				++lbarg;
			if (indflg < 0)
				indflg = ctyp;
			break;
		case EXTID :
			lbarg = hbarg = (sp = ap)->s_name;
			hfmt = "%s\n";
			lfmt = "%s+1\n";
			ctyp = gidtyp(sp->s_type);
			if (indflg < 0)
				indflg = ctyp;
			break;
		case CONST :
			lfmt = hfmt = "%%%d\n";
			hbarg = ap;
			lbarg = hbarg & 0377;
			ctyp = cevm;
			hbarg = ctyp ? (hbarg/256) & 0377 : lbarg;
			break;
		case STRING :
			hfmt = "%%L%d/256\n";
			lfmt = "%%L%d\n";
			hbarg = lbarg = ap;
			ctyp = 1;
			break;
		case -1 :
			chksp();
			lfmt = xfm1;
			hfmt = cevm ? xfm0 : lfmt;
			ctyp = 1;
			break;
		case UIND :
			ldindx(ap);
			break;
		case SUBSCR :
			setsubscr(ap);
		case -2 :
			break;
		default :
			finmsg("Compiler error(setpargs)");
	}
}

stkpsh()
{
	ldbflg = ldaflg = 0;
	pshab("ba");
}

stkpul()
{
	printf("	pula\n	pulb\n");
	sp_inc =- 2;
}

ldindx(p)
int *p;
{
	struct symtab *sp;
	int lascevm, sflg;
	register op, *ap, *p1;
	int *p2;
	lascevm = cevm;
	switch(op = *(ap = p)) {
		case LCLID :
			ap = *++ap;
			if ((ctyp = gidtyp(*ap++)) < 2) {
				terror(3);
				return;
			}
			chksp();
			ldxreg(op, *ap);
			break;
		case EXTID :
			if ((ctyp = gidtyp((sp = *++ap)->s_type)) < 2) {
				terror(3);
				return;
			}
			ldxreg(op, *ap);
			break;
		case CONST :
			ctyp = 1;
			code("ldx", "%%%d\n", *++ap);
			break;
		default :
			tmark(ap);
			indflg = -1;
			if ((op = *ap & MASK) >= INCRA && op <= DECRB &&
						terminal(*(ap+1)) ) {
				p1 = *++ap;
				if (op == INCRA || op == DECRA) {
					if (*p1 == EXTID)
						ldindx(*ap);
					outcode(p, *p1, *(p1+1), 0);
					if (*p1 == LCLID) {
						ldindx(*ap);
						putm("dex");
					}
				} else {
					outcode(p, *p1, *(p1+1), 0);
					ldindx(*ap);
				}
				break;
			}
			sflg = 0;
			if (op == PLUS) {
				p1 = *(ap + 1);
				p2 = *(ap + 2);
				if ((*p1 == LCLID || *p1 == EXTID) &&
					(*p2 == CONST &&
					*++p2 >= 0 && *p2 < 256)) {
						ldindx(p1);
						lfmt = hfmt = "%d()\n";
						hbarg = *p2;
						lbarg = hbarg + 1;
						ctyp =& 1;
						cevm = lascevm;
						lastsp = -1;
						return;
				}
			}
			if (ldbflg) {
				stkpsh();
				sflg++;
			}
			if (op == UIND) {
				ldindx(*++ap);
				putm("ldx\t0()");
				break;
			}
			exprnode(ap);
			if (op >= EQ && op <= EQLSH) {
				if (terminal(*++ap))
					ldindx(*ap);
			} else {
				ctyp = indflg;
				ldxreg(1);
			}
			indflg = 0;
			if (sflg)
				stkpul();
	}
	ctyp =& 1;
	cevm = lascevm;
	lastsp = -1;
	lfmt = xfm1;
	hfmt = xfm0;
}

setsubscr(p)
int *p;
{
	register *ap, *exp, i;
	struct symtab *sp;
	int sflg;
	static char buff1[15], buff2[15];
	exp = *((ap = p)+3);
	ap = *++ap;
	switch(*p) {
		case LCLID :
			i = ctyp = gidtyp(*ap);
			if (*exp != CONST)
				break;
			chksp();
			lfmt = hfmt = stkf;
			if (i)
				cevm = i = 1;
			lbarg = hbarg = getloff(*++ap) + (*(exp+1) << i);
			if (ctyp)
				++lbarg;
			return;
		case EXTID :
			i = ctyp = gidtyp((sp=ap)->s_type);
			if (*exp != CONST)
				break;
			if (i)
				cevm = i = 1;
			i = *++exp << 1;
			printf(-1,buff1,"%s+%d\n",sp->s_name,i);
			hfmt = buff1;
			printf(-1,buff2,"%s+%d\n",sp->s_name,++i);
			lfmt = buff2;
			return;
		default :
			finmsg("Compiler error(setsubscr)");
	}
	if (*exp == EXTID && i == 0) {
		ldxreg(*exp, *(exp+1));
		lfmt = hfmt = "%s()\n";
		lbarg = hbarg = sp->s_name;
		return;
	}
	tmark(exp);
	sflg = 0;
	if (ldbflg) {
		stkpsh();
		sflg++;
	}
	cevm = 0;      /*  need byte for indexing   */
	exprnode(exp);
	if (ctyp = i) {
		cevm = 1;		/* *ar[ex] would have cleared cevm */
	}
	if (*p == LCLID) {
		code(ldaa, "%%%d\n", getloff(*++ap) + 2);
		printf("\tjbs\tindx%s\n",ctyp ? "i$" : "c$");
		/* address of indexed item is in a,b  and x   */
		lastsp = -1;
		insert(INDEX);
		lfmt = xfm1;
		hfmt = xfm0;
	} else {
		hbarg = lbarg = sp->s_name;
		hfmt = "%s()\n";
		lfmt = "%s+1()\n";
		if (ctyp) asl16();
		ldxreg(1);


	}
	if (sflg)
		stkpul();
}

ldxreg(op, ap)
{
	register struct symtab *sp;
	register char *frmt;
	register arg;
	frmt = stkf;
	switch(op) {
		case LCLID :
			arg = getloff(ap);
			break;
		case EXTID :
			frmt = "%s\n";
			arg = (sp = ap)->s_name;
			break;
		default :
			chkacca(ldaflg);
			chksp();
			arg = sp_inc;
			code("stab", stkf, arg + 1);
			code("staa", stkf, arg);
	}
	code("ldx", frmt, arg);
	lastsp =  -1;
}

ldadres(optyp, p)
int *p;
{
	register struct symtab *sp;
	switch(optyp) {
		case EXTID :
			lfmt = "%%%s\n";
			hfmt = "%%%s/256\n";
			lbarg = hbarg = (sp = p)->s_name;
			ctyp = 1;
			load(-2);
			return;
		case LCLID :
			ldaflg = 1;
			ontostk(0);
			code(addb, "%%%d\n", getloff(*++p) + 1);
			code(adca, "%%0\n");
			return;
		case SUBSCR :
			ldsubsc(*p, *(p+1), *(p+3));
			return;
		case UIND :
			return;
		default :
			finmsg("Compiler error(ldadres)");
	}
}


ldsubsc(styp, tp, xp)
int *tp;
{
	register struct symtab *sp;
	register *exp, i;
	int sflg;
	exp = xp;
	switch(styp) {
		case EXTID :
			ctyp = gidtyp((sp=tp)->s_type) & 1;
			if (*exp != CONST)
				break;
			i = *++exp << ctyp;
			code(ldab, "%%%s+%d\n", sp->s_name, i);
			code(ldaa, "%%%s+%d/256\n", sp->s_name, i);
			ldbflg = ldaflg = 1;
			return;
		case LCLID :
			ctyp = gidtyp(*tp) & 1;
			if (*exp != CONST)
				break;
			i = getloff(*++tp) + (*(exp+1) << ctyp);
			ldbflg = ldaflg = 1;
			ontostk(0);
			code(addb, "%%%d\n", i+1);
			code(adca, "%%0\n");
			return;
		default :
			finmsg("Compiler error(ldsubsc)");
	}
	i = ctyp;
	tmark(exp);
	sflg = 0;
	if (ldbflg) {
		stkpsh();
		sflg++;
	}
	cevm = 0;     /*  need byte for indexing   */

	exprnode(exp);
	ctyp = 1;
	if (styp == EXTID) {
		putm("clra");
		if (i)   asl16() ;
		code(addb, "%%%s\n", sp->s_name);
		code(adca, "%%%s/256\n", sp->s_name);
	} else {
		code(ldaa, "%%%d\n", getloff(*++tp) + 2);
		printf("\tjbs\tindx%s\n",i ? "i$" : "c$");
		insert(INDEX);
	}
	if (sflg)
		stkpul();
}

ontostk(x)
{
	register *cs;
	chksp();
	code("sts", stkf, sp_inc);
	cs = x ? addb : ldab;
	code(cs, stkf, sp_inc+1);
	cs = x ? adca : ldaa;
	code(cs, stkf, sp_inc);
}
