#include	"mch.c"

talloc(i)
{
	register p;
	if ((p=calloc(1, i)) == -1) {
		printf(fd_e, "\nOut of space\n");
		cexit(1);
	} else
		return(p);
}



node(a)
{
	register *p, *ap, n;
	int *tp;
	n = nargs();
	tp  = p = talloc(n+n);
	ap = &a;
	while(n--)
		*p++ = *ap++;
	return(tp);
}


getlen(t, n)
{
	register struct symtab *sp1;
	sp1 = symp1;
	symp2->s_link = 0;
	while (sp1) {
		if (sp1->s_class != PAR) {
			if (sp1->s_class == LOCAL) {
				if (n) {
					sp1->s_type =| t;
					sp1->s_value = lcloff;
					lcloff =+ length(sp1);
				}
			} else {		/* argument with given type */
				sp1->s_type = (sp1->s_type & ~INT) | t;
				sp1->s_class =- PAR;	/* make it local */
			}
		} else
			if (n)			/* avoid undefined arg */
				sp1->s_flag =| DECL;
		sp1 = sp1->s_link;
	}
	if (n)
		symp1 = 0;
}


length(symn)
struct symtab *symn;
{
	register n, type;
	n = 1;
	type = symn->s_type;
	if ((type & ARRAY) && symn->s_dsiz)
		n = symn->s_dsiz;
	if (chartyp(type))
		return(n);
	return(n+n);
}

chartyp(t)
{
	return((t & CHAR) && !(t & PNTR));
}

arraydec(sn, dimens)
struct symtab *sn;
{
	if (chkdecl(sn))
		if (dimens < 0) {
			mcerror("Incorrect array bounds");
			dimens = 1;
		}
	sn->s_dsiz = dimens;
	sn->s_type =| ARRAY;
}


prodec(type, sn, sladr)
struct symtab *sn;
{
	register struct symtab *sp;
	register class;
	insert(RIPOFF);
	sn->s_class =| EXTERN;
	sn->s_type =| FUNC | type;
	sn->s_value = node(PRDEF, lcloff, noargs, sladr);
	for (sp = symtab; sp < symtab+TABLEN; sp++)
		if (*sp->s_name) {
			class = sp->s_class;
			if (class == 0 && (sp->s_flag & ~KEYW) == 0)
				mcerror("%s not declared", sp->s_name);
			else
			if (class==LABEL) {*sp->s_name= '*'; continue; } else
				if (!(class == LOCAL || class == PAR ))
						continue;
			symcntr--;
			*sp->s_name = '\0';
			sp->s_class = 0;
		}
	symp1 = argoff = lcloff = noargs = 0;
}


terror(n)
{
	register char *cs;
	switch(n) {
		case 1 : 
			cs = "Initialization syntax";
			break;
		case 2 :
			cs = "Identifier not an array";
			break;
		case 3 :
			cs = "Illegal indirection";
	}
	mcerror(cs);
}

mcerror(s, a1, a2, a3)
{
	printf(fd_e, "line  %d :\t", yyline);
	printf(fd_e, s, a1, a2, a3);
	cputc('\n', fd_e);
	errorn++;
}

getasmbl()
{
	register c, *ip;
	register char *cp;
	char *cp1, *c1;
	cp = strbuf;
	cp1 = cp + STRLEN - 2;
	ip = &yylval;
	cntr = *ip = 0;
	if (nextch != -1) {
		if (nextch != SP)
			ungetc(nextch, cin);
		nextch = -1;
	}
	while((c = cgetc(cin)) != '?') {
	  swlab :
		switch(c) {
			case EOF :
				finmsg("Unexpected EOF");
			case LF :
				yyline++;
				if ((c1 = cgetc(cin)) == '*') {
					while((c=cgetc(cin)) != EOF && c != LF);
					goto swlab;
				}
				ungetc(c1, cin);
				break;
			case '\\' :
				if ((c1 = cgetc(cin)) == '?')
					c = c1;
				else
					ungetc(c1, cin);
		}
		*cp++ = c;
		if (cp < cp1)
			continue;
		*cp++ = '\0';
		*ip = talloc(STRLEN+2);
		scopy(*ip, cp = strbuf);
		cntr++;
		ip = *ip + STRLEN;
	}
	if (cp > strbuf) {
		*cp++ = '\0';
		*ip = talloc(cp - strbuf);
		scopy(*ip, strbuf);
		cntr++;
	}
	return(yylval);
}

trytofold(op, lt, rt)
int *lt, *rt;
{
	if (*lt != CONST || *rt != CONST)
		return(node(op, lt, rt, yyline));
	return(node(CONST, fold(op, *++lt, *++rt), yyline));
}


insert(op)
{
	register char *p;
	switch(op) {
		case LSHIFT :
			p = "asl16";
			break;
		case RSHIFT :
			p = "asr16";
			break;
		case MUL :
			p = "mul16";
			break;
		case DIV :
			p = "div16";
			break;
		case MOD :
			p = "mod16";
			break;
		case INDEX	:
		p = "indxx";
			break;
		case RIPOFF	:
			p = "ripxx";
			break;
		default :
			finmsg("Compiler error(insert)");
	}
	scopy(symbuf,p);
	lookup();
	symptr->s_class =| EXTERN;
	symptr->s_type =| FUNC | INT;
}
